/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.mixin.client;

import dev.kikugie.elytratrims.api.ElytraTrimsAPI;
import dev.kikugie.elytratrims.mixin.access.ElytraRotationAccessor;
import dev.kikugie.elytratrims.mixin.access.LivingEntityAccessor;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SmithingScreen.class}, priority=1100)
public class SmithingScreenMixin
implements ElytraRotationAccessor {
    @Unique
    private final Quaternionf dummy = new Quaternionf();
    @Unique
    protected boolean isElytra;
    @Shadow
    @Nullable
    private ArmorStand f_266031_;

    @Inject(method={"setup"}, at={@At(value="TAIL")})
    private void markGuiArmorStand(CallbackInfo ci) {
        if (this.f_266031_ != null) {
            ((LivingEntityAccessor)this.f_266031_).elytratrims$markGui();
        }
    }

    @Inject(method={"equipArmorStand"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isEmpty()Z")}, cancellable=true)
    private void equipElytra(ItemStack stack, CallbackInfo ci) {
        if (this.f_266031_ == null) {
            return;
        }
        if (ElytraTrimsAPI.isProbablyElytra(stack)) {
            this.isElytra = true;
            this.f_266031_.m_8061_(EquipmentSlot.CHEST, stack.m_41777_());
            ci.cancel();
        } else {
            this.isElytra = false;
        }
    }

    @ModifyArg(method={"drawBackground"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/InventoryScreen;drawEntity(Lnet/minecraft/client/gui/DrawContext;IIILorg/joml/Quaternionf;Lorg/joml/Quaternionf;Lnet/minecraft/entity/LivingEntity;)V"), index=4)
    private Quaternionf applyRotation(Quaternionf quaternionf) {
        return this.elytratrims$rotateElytra(quaternionf);
    }

    @Override
    public Quaternionf elytratrims$getVector() {
        return this.dummy;
    }

    @Override
    public boolean elytratrims$isElytra() {
        return this.isElytra;
    }

    @Override
    public void elytratrims$setElytra(boolean value) {
        this.isElytra = value;
    }
}

