package dev.kikugie.elytratrims.mixin.render;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.kikugie.elytratrims.api.render.ETRenderMethod;
import dev.kikugie.elytratrims.api.render.ETRenderParameters;
import dev.kikugie.elytratrims.api.impl.ETRenderingAPIImpl;
import dev.kikugie.elytratrims.api.impl.ETRenderingAPIUtilsKt;
import dev.kikugie.elytratrims.render.ETRendererKt;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_10186;
import net.minecraft.class_10197;
import net.minecraft.class_10394;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;

@MixinEnvironment(type = MixinEnvironment.Env.CLIENT)
@Mixin(class_10197.class)
public class ElytraRendererMixin {
    @Shadow @Final
    private Function<class_10197.class_10198, class_2960> layerTextureLookup;

    @Unique
    private static final String RENDER_METHOD = "renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;" +
        "Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;" +
        "Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V";

    @Unique
    private static final String CANCEL_METHOD =
        /*? if fabric {*/"Lnet/minecraft/client/renderer/entity/layers/EquipmentLayerRenderer;getColorForLayer(Lnet/minecraft/client/resources/model/EquipmentClientInfo$Layer;I)I";
        /*?} else*//*"Lnet/neoforged/neoforge/client/extensions/common/IClientItemExtensions;getArmorLayerTintColor(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/resources/model/EquipmentClientInfo$Layer;II)I";*/

    @Inject(method = RENDER_METHOD, at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;hasFoil()Z"))
    private void invokeETOverrideRenderers(
        class_10186.class_10190 type,
        class_5321<class_10394> asset,
        class_3879 model,
        class_1799 stack,
        class_4587 matrices,
        class_4597 provider,
        int light,
        class_2960 playerTexture,
        CallbackInfo ci,
        @Local List<class_10186.class_10189> layers,
        @Share("parameters") LocalRef<ETRenderParameters> parameters,
        @Share("overridden") LocalBooleanRef overridden) {
        if (type != class_10186.class_10190.field_54127) return;
        var base = layers.getFirst(); // Checked for isEmpty in the source
        class_2960 texture = base.comp_3173() && playerTexture != null
            ? playerTexture : layerTextureLookup.apply(new class_10197.class_10198(type, base));
        ETRenderParameters params = new ETRenderParameters(model, stack, matrices, provider, null, texture, light,
                                                 0xFFFFFFFF, ETRenderingAPIUtilsKt.NEEDS_OVERWRITE);
        parameters.set(params);
        // The result for the pre-render doesn't matter
        ETRenderingAPIImpl.render(params, ETRenderMethod.PRE);
        if (ETRenderingAPIImpl.render(params, ETRenderMethod.OVERRIDE))
            overridden.set(true);
    }

    @ModifyExpressionValue(method = RENDER_METHOD, at = @At(value = "INVOKE", target = CANCEL_METHOD))
    private int cancelDefaultRenderer(int original, @Share("overridden") LocalBooleanRef overridden) {
        return overridden.get() ? 0 : original;
    }

    @Inject(
        method = RENDER_METHOD,
        at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;"),
        cancellable = true
    )
    private void invokeETRenderers(
        class_10186.class_10190 type,
        class_5321<class_10394> asset,
        class_3879 model,
        class_1799 stack,
        class_4587 matrices,
        class_4597 provider,
        int light,
        class_2960 playerTexture,
        CallbackInfo ci,
        @Share("parameters") LocalRef<ETRenderParameters> parameters
    ) {
        if (type != class_10186.class_10190.field_54127) return;
        if (ETRenderingAPIImpl.render(parameters.get(), ETRenderMethod.POST))
            ci.cancel();
    }
}