package dev.kikugie.elytratrims.common.recipe

import dev.kikugie.elytratrims.common.access.FeatureAccess.addAnimationStatus
import dev.kikugie.elytratrims.common.access.FeatureAccess.addCosmicEffect
import dev.kikugie.elytratrims.common.access.FeatureAccess.addGlow
import dev.kikugie.elytratrims.common.access.FeatureAccess.setPatterns
import dev.kikugie.elytratrims.mixin.common.SmithingTransformRecipeAccessor
import net.minecraft.item.ItemStack
import net.minecraft.recipe.Recipe
import net.minecraft.recipe.SmithingRecipe
import net.minecraft.recipe.SmithingTransformRecipe
import net.minecraft.util.Identifier

private inline fun SmithingRecipe.transform(crossinline action: (template: ItemStack, base: ItemStack, addition: ItemStack) -> ItemStack) =
    object : ETSmithingRecipe(this@transform) {
        override fun craft(template: ItemStack, base: ItemStack, addition: ItemStack): ItemStack =
            action(template, base, addition)
    }

private fun matchImpl(id: Identifier, recipe: Recipe<*>): Recipe<*> = when (recipe) {
    is SmithingRecipe -> when(id.toString()) {
        "elytratrims:apply_glow_effect" -> recipe.transform { _, base, _ ->
            base.copy().apply { addGlow() }
        }

        "elytratrims:apply_animation_effect" -> recipe.transform { _, base, _ ->
            base.copy().apply { addAnimationStatus() }
        }

        "elytratrims:apply_gateway_effect" -> recipe.transform { _, base, _ ->
            base.copy().apply { addCosmicEffect() }
        }

        "elytratrims:apply_banner_pattern" -> recipe.transform { template, base, _ ->
            base.copy().apply { setPatterns(template) }
        }

        else -> recipe
    }

    else -> recipe
}

abstract class ETSmithingRecipe(delegate: SmithingRecipe) : SmithingTransformRecipe(
    /*? if <1.20.2 {*//*delegate.id, (delegate as SmithingTransformRecipeAccessor).template, delegate.base, delegate.addition, delegate.result,
    *//*?} else*/(delegate as SmithingTransformRecipeAccessor).template, delegate.base, delegate.addition, delegate.result
) {
    abstract fun craft(template: ItemStack, base: ItemStack, addition: ItemStack): ItemStack

    //? if >=1.21 {
    override fun craft(input: net.minecraft.recipe.input.SmithingRecipeInput, lookup: net.minecraft.registry.RegistryWrapper.WrapperLookup): ItemStack =
        craft(input.template, input.base, input.addition)
    //?} else {
    /*override fun craft(inventory: net.minecraft.inventory.Inventory, lookup: net.minecraft.registry.DynamicRegistryManager): ItemStack =
        craft(inventory.getStack(0), inventory.getStack(1), inventory.getStack(2))
    *///?}

    companion object {
        @JvmStatic fun match(id: Identifier, recipe: Recipe<*>): Recipe<*> =
            matchImpl(id, recipe)
    }
}