package dev.kikugie.elytratrims.mixin.client;

import dev.kikugie.elytratrims.api.ElytraTrimsAPI;
import dev.kikugie.elytratrims.mixin.access.ElytraRotationAccessor;
import dev.kikugie.elytratrims.mixin.access.LivingEntityAccessor;
import dev.kikugie.elytratrims.mixin.constants.Targets;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_4895;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_4895.class, priority = 1100)
public class SmithingScreenMixin implements ElytraRotationAccessor {
    @Unique
    private final Quaternionf dummy = new Quaternionf();
    @Unique
    protected boolean isElytra;
    @Shadow
    @Nullable
    private class_1531 armorStand;

    @Inject(method = "setup", at = @At("TAIL"))
    private void markGuiArmorStand(CallbackInfo ci) {
        if (armorStand != null) ((LivingEntityAccessor) this.armorStand).elytratrims$markGui();
    }

    @Inject(method = "equipArmorStand", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isEmpty()Z"), cancellable = true)
    private void equipElytra(class_1799 stack, CallbackInfo ci) {
        if (armorStand == null) return;
        if (ElytraTrimsAPI.isProbablyElytra(stack)) {
            isElytra = true;
            armorStand.method_5673(class_1304.field_6174, stack.method_7972());
            ci.cancel();
        } else isElytra = false;
    }

    @ModifyArg(method = "drawBackground", at = @At(value = "INVOKE", target = Targets.drawEntity), index = Targets.drawEntityIndex)
    private Quaternionf applyRotation(Quaternionf quaternionf) {
        return elytratrims$rotateElytra(quaternionf);
    }

    @Override
    public Quaternionf elytratrims$getVector() {
        return dummy;
    }

    @Override
    public boolean elytratrims$isElytra() {
        return isElytra;
    }

    @Override
    public void elytratrims$setElytra(boolean value) {
        isElytra = value;
    }
}