/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.mixin.render;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.kikugie.elytratrims.api.item.ETItemFlag;
import dev.kikugie.elytratrims.render.ETRendererKt;
import dev.kikugie.elytratrims.render.SmithingTableRenderData;
import dev.kikugie.elytratrims.resource.ETTags;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SmithingScreen.class})
public class SmithingScreenMixin {
    @Shadow
    @Nullable
    private ArmorStand armorStandPreview;
    @Unique
    private final SmithingTableRenderData renderData = new SmithingTableRenderData();

    @Inject(method={"containerTick"}, at={@At(value="TAIL")})
    private void tickArmorStand(CallbackInfo ci) {
        if (this.armorStandPreview != null) {
            this.armorStandPreview.tick();
        }
    }

    @ModifyExpressionValue(method={"updateArmorStandPreview"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;copy()Lnet/minecraft/world/item/ItemStack;")})
    private ItemStack rotateIfHasElytra(ItemStack stack) {
        this.renderData.update(stack.is(ETTags.ELYTRA_DECORATABLE));
        ETItemFlag.DEBUG.set(stack, true);
        return stack;
    }

    @WrapOperation(method={"renderBg"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/InventoryScreen;renderEntityInInventory(Lnet/minecraft/client/gui/GuiGraphics;IIIIFLorg/joml/Vector3f;Lorg/joml/Quaternionf;Lorg/joml/Quaternionf;Lnet/minecraft/world/entity/LivingEntity;)V")})
    private void renderArmorStand(GuiGraphics gui, int x1, int y1, int x2, int y2, float scale, Vector3f translation, Quaternionf angle, @Nullable Quaternionf ignored, LivingEntity stand, Operation<Void> original, @Local(argsOnly=true) float partial, @Local(argsOnly=true, ordinal=0) int mouseX, @Local(argsOnly=true, ordinal=1) int mouseY) {
        this.renderData.tick(partial);
        ETRendererKt.renderEntityInInventoryFollowsMouse(gui, x1, y1, x2, y2, (int)scale, 0.0f, mouseX, mouseY, stand, this.renderData.getRotation());
    }
}

