package dev.kikugie.elytratrims.mixin.render;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.kikugie.elytratrims.api.render.ETRenderMethod;
import dev.kikugie.elytratrims.api.render.ETRenderParameters;
import dev.kikugie.elytratrims.api.impl.ETRenderingAPIImpl;
import dev.kikugie.elytratrims.api.impl.ETRenderingAPIUtilsKt;
import dev.kikugie.elytratrims.render.ETRendererKt;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.function.Function;

@MixinEnvironment(type = MixinEnvironment.Env.CLIENT)
@Mixin(EquipmentLayerRenderer.class)
public class ElytraRendererMixin {
    @Shadow @Final
    private Function<EquipmentLayerRenderer.LayerTextureKey, ResourceLocation> layerTextureLookup;

    @Unique
    private static final String RENDER_METHOD = "renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;" +
        "Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;" +
        "Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V";

    @Unique
    private static final String CANCEL_METHOD =
        /*? if fabric {*//*"Lnet/minecraft/client/renderer/entity/layers/EquipmentLayerRenderer;getColorForLayer(Lnet/minecraft/client/resources/model/EquipmentClientInfo$Layer;I)I";
        *//*?} else*/"Lnet/neoforged/neoforge/client/extensions/common/IClientItemExtensions;getArmorLayerTintColor(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/resources/model/EquipmentClientInfo$Layer;II)I";

    @Inject(method = RENDER_METHOD, at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;hasFoil()Z"))
    private void invokeETOverrideRenderers(
        EquipmentClientInfo.LayerType type,
        ResourceKey<EquipmentAsset> asset,
        Model model,
        ItemStack stack,
        PoseStack matrices,
        MultiBufferSource provider,
        int light,
        ResourceLocation playerTexture,
        CallbackInfo ci,
        @Local List<EquipmentClientInfo.Layer> layers,
        @Share("parameters") LocalRef<ETRenderParameters> parameters,
        @Share("overridden") LocalBooleanRef overridden) {
        if (type != EquipmentClientInfo.LayerType.WINGS) return;
        var base = layers.getFirst(); // Checked for isEmpty in the source
        ResourceLocation texture = base.usePlayerTexture() && playerTexture != null
            ? playerTexture : layerTextureLookup.apply(new EquipmentLayerRenderer.LayerTextureKey(type, base));
        ETRenderParameters params = new ETRenderParameters(model, stack, matrices, provider, null, texture, light,
                                                 0xFFFFFFFF, ETRenderingAPIUtilsKt.NEEDS_OVERWRITE);
        parameters.set(params);
        // The result for the pre-render doesn't matter
        ETRenderingAPIImpl.render(params, ETRenderMethod.PRE);
        if (ETRenderingAPIImpl.render(params, ETRenderMethod.OVERRIDE))
            overridden.set(true);
    }

    @ModifyExpressionValue(method = RENDER_METHOD, at = @At(value = "INVOKE", target = CANCEL_METHOD))
    private int cancelDefaultRenderer(int original, @Share("overridden") LocalBooleanRef overridden) {
        return overridden.get() ? 0 : original;
    }

    @Inject(
        method = RENDER_METHOD,
        at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;"),
        cancellable = true
    )
    private void invokeETRenderers(
        EquipmentClientInfo.LayerType type,
        ResourceKey<EquipmentAsset> asset,
        Model model,
        ItemStack stack,
        PoseStack matrices,
        MultiBufferSource provider,
        int light,
        ResourceLocation playerTexture,
        CallbackInfo ci,
        @Share("parameters") LocalRef<ETRenderParameters> parameters
    ) {
        if (type != EquipmentClientInfo.LayerType.WINGS) return;
        if (ETRenderingAPIImpl.render(parameters.get(), ETRenderMethod.POST))
            ci.cancel();
    }
}