/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.kikugie.elytratrims.client.ETClient;
import dev.kikugie.elytratrims.client.config.RenderType;
import dev.kikugie.elytratrims.client.render.FeatureRenderer;
import dev.kikugie.elytratrims.client.render.FeatureRendererKt;
import dev.kikugie.elytratrims.client.resource.ImageUtilsKt;
import dev.kikugie.elytratrims.common.access.BannerLayer;
import dev.kikugie.elytratrims.common.access.FeatureAccess;
import dev.kikugie.elytratrims.common.util.ColorKt;
import dev.kikugie.elytratrims.common.util.UtilKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JM\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\n\u0010\u0011\u001a\u00060\u000ej\u0002`\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\u00158\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R&\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\u0004\u0012\u00020\u001d0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Ldev/kikugie/elytratrims/client/render/PatternsOverlayRenderer;", "Ldev/kikugie/elytratrims/client/render/FeatureRenderer;", "<init>", "()V", "Lnet/minecraft/client/model/Model;", "model", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "provider", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "light", "Ldev/kikugie/elytratrims/common/util/ARGB;", "color", "", "render", "(Lnet/minecraft/client/model/Model;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;II)V", "Ldev/kikugie/elytratrims/client/config/RenderType;", "type", "Ldev/kikugie/elytratrims/client/config/RenderType;", "getType", "()Ldev/kikugie/elytratrims/client/config/RenderType;", "Lkotlin/Function1;", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/block/entity/BannerPattern;", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "cache", "Lkotlin/jvm/functions/Function1;", "elytratrims-forge"})
@SourceDebugExtension(value={"SMAP\nFeatureRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureRenderer.kt\ndev/kikugie/elytratrims/client/render/PatternsOverlayRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1863#2,2:251\n1#3:253\n*S KotlinDebug\n*F\n+ 1 FeatureRenderer.kt\ndev/kikugie/elytratrims/client/render/PatternsOverlayRenderer\n*L\n166#1:251,2\n*E\n"})
public final class PatternsOverlayRenderer
implements FeatureRenderer {
    @NotNull
    private final RenderType type = RenderType.PATTERNS;
    @NotNull
    private final Function1<Holder<BannerPattern>, TextureAtlasSprite> cache = UtilKt.memoize(arg_0 -> PatternsOverlayRenderer.cache$lambda$1(this, arg_0));

    @Override
    @NotNull
    public RenderType getType() {
        return this.type;
    }

    @Override
    public void render(@NotNull Model model, @NotNull PoseStack matrices, @NotNull MultiBufferSource provider, @Nullable LivingEntity entity, @NotNull ItemStack stack, int light, int color) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Iterable $this$forEach$iv = FeatureAccess.INSTANCE.getPatterns(stack);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BannerLayer it = (BannerLayer)element$iv;
            boolean bl = false;
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.cache.invoke(it.getPattern());
            if (ImageUtilsKt.getMissing(sprite)) continue;
            FeatureRendererKt.render(model, sprite, matrices, provider, stack, light, ColorKt.toArgb(it.getColor(), ColorKt.alpha(color)));
        }
    }

    @Override
    @NotNull
    public TextureAtlas getAtlas() {
        return FeatureRenderer.DefaultImpls.getAtlas(this);
    }

    private static final TextureAtlasSprite cache$lambda$1(PatternsOverlayRenderer this$0, Holder it) {
        TextureAtlasSprite textureAtlasSprite;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object t = it.m_203543_().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        ResourceKey key = (ResourceKey)t;
        boolean useBanner = ETClient.INSTANCE.getConfig().texture.useBannerTextures;
        ResourceLocation spriteId = useBanner ? Sheets.m_234347_((ResourceKey)key).m_119203_() : Sheets.m_234349_((ResourceKey)key).m_119203_();
        TextureAtlasSprite $this$cache_u24lambda_u241_u24lambda_u240 = textureAtlasSprite = this$0.getAtlas().m_118316_(spriteId);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$cache_u24lambda_u241_u24lambda_u240);
        if (ImageUtilsKt.getMissing($this$cache_u24lambda_u241_u24lambda_u240)) {
            Intrinsics.checkNotNull((Object)spriteId);
            FeatureRendererKt.access$report(spriteId);
        }
        return textureAtlasSprite;
    }
}

