package dev.kikugie.elytratrims.mixin.render;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.kikugie.elytratrims.api.render.ETRenderMethod;
import dev.kikugie.elytratrims.api.render.ETRenderParameters;
import dev.kikugie.elytratrims.api.impl.ETRenderingAPIImpl;
import dev.kikugie.elytratrims.render.ETRendererKt;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_10186;
import net.minecraft.class_10197;
import net.minecraft.class_10394;
import net.minecraft.class_1058;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_5321;

@Debug(export = true)
@MixinEnvironment(type = MixinEnvironment.Env.CLIENT)
@Mixin(class_10197.class)
public class ElytraRendererMixin {
    @Shadow
    @Final
    private Function<class_10197.class_10198, class_2960> layerTextureLookup;

    @Unique
    private static final String RENDER_METHOD =
        //? if >=1.21.9 {
        /*"renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;" +
        "Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lnet/minecraft/world/item/ItemStack;" +
        "Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/resources/ResourceLocation;II)V";
        *///?} else {
        "renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;" +
            "Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;" +
            "Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V";
        //?}

    @Unique
    private static final String CANCEL_METHOD =
        /*? if fabric {*/"Lnet/minecraft/client/renderer/entity/layers/EquipmentLayerRenderer;getColorForLayer(Lnet/minecraft/client/resources/model/EquipmentClientInfo$Layer;I)I";
        /*?} else*///"Lnet/neoforged/neoforge/client/extensions/common/IClientItemExtensions;getArmorLayerTintColor(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/resources/model/EquipmentClientInfo$Layer;II)I";

    @Inject(method = RENDER_METHOD, at = @At(value = "INVOKE", target = "Ljava/util/List;iterator()Ljava/util/Iterator;"))
    //? if >=1.21.9 {
    /*private <S> void invokeETOverrideRenderers(
        EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> resourceKey, Model<? super S> model, S object, ItemStack itemStack,
        PoseStack poseStack, net.minecraft.client.renderer.SubmitNodeCollector submitNodeCollector, int i, ResourceLocation resourceLocation, int j,
        int k, CallbackInfo ci, @Local List<EquipmentClientInfo.Layer> layers, @Local(ordinal = 4) com.llamalad7.mixinextras.sugar.ref.LocalIntRef m,
        @Share("parameters") LocalRef<ETRenderParameters> parameters, @Share("overridden") LocalBooleanRef overridden
    ) {
        if (layerType != EquipmentClientInfo.LayerType.WINGS) return;
        var order = new java.util.concurrent.atomic.AtomicInteger(m.get());
        var texture = !layers.getFirst().usePlayerTexture() || resourceLocation == null
            ? layerTextureLookup.apply(new EquipmentLayerRenderer.LayerTextureKey(layerType, layers.getFirst()))
            : resourceLocation;
        @SuppressWarnings("unchecked") var params = new ETRenderParameters((Model<Object>) model,
            object, itemStack, poseStack, RenderType.armorEntityGlint(),
            null, texture, i, 0xFFFFFFFF, j, k, order);

        parameters.set(params);
        // The result for the pre-render doesn't matter
        ETRenderingAPIImpl.render(params, submitNodeCollector, ETRenderMethod.PRE);
        if (ETRenderingAPIImpl.render(params, submitNodeCollector, ETRenderMethod.OVERRIDE))
            overridden.set(true);
        m.set(order.get());
    }
    *///?} else {
    private void invokeETOverrideRenderers(
        class_10186.class_10190 layerType, class_5321<class_10394> equipmentAsset, class_3879 armorModel,
        class_1799 item, class_4587 poseStack, net.minecraft.class_4597 bufferSource, int packedLight,
        class_2960 playerTexture, CallbackInfo ci, @Local List<class_10186.class_10189> layers,
        @Share("parameters") LocalRef<ETRenderParameters> parameters, @Share("overridden") LocalBooleanRef overridden
    ) {
        if (layerType != class_10186.class_10190.field_54127) return;
        var texture = !layers.getFirst().comp_3173() || playerTexture == null
            ? layerTextureLookup.apply(new class_10197.class_10198(layerType, layers.getFirst()))
            : playerTexture;
        var params = new ETRenderParameters(armorModel,
            null, item, poseStack, class_1921.method_27949(),
            null, texture, packedLight, 0xFFFFFFFF, net.minecraft.class_4608.field_21444, 0, ETRenderParameters.DUMMY);

        parameters.set(params);
        // The result for the pre-render doesn't matter
        ETRenderingAPIImpl.render(params, bufferSource, ETRenderMethod.PRE);
        if (ETRenderingAPIImpl.render(params, bufferSource, ETRenderMethod.OVERRIDE))
            overridden.set(true);
    }
    //?}

    @ModifyExpressionValue(method = RENDER_METHOD, at = @At(value = "INVOKE", target = CANCEL_METHOD))
    private int cancelDefaultRenderer(int original, @Share("overridden") LocalBooleanRef overridden) {
        return overridden.get() ? 0 : original;
    }

    @Inject(
        method = RENDER_METHOD,
        at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;"),
        cancellable = true
    )
    //? if >=1.21.9 {
    /*private <S> void invokeETRenderers(
        EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> resourceKey, Model<? super S> model, S object, ItemStack itemStack,
        PoseStack poseStack, net.minecraft.client.renderer.SubmitNodeCollector submitNodeCollector, int i, ResourceLocation resourceLocation, int j,
        int k, CallbackInfo ci, @Local(ordinal = 4) com.llamalad7.mixinextras.sugar.ref.LocalIntRef m,
        @Share("parameters") LocalRef<ETRenderParameters> parameters
    ) {
        if (parameters.get() == null || layerType != EquipmentClientInfo.LayerType.WINGS)
            return;
        parameters.get().order().set(m.get());
        if (ETRenderingAPIImpl.render(parameters.get(), submitNodeCollector, ETRenderMethod.POST))
            ci.cancel();
        m.set(parameters.get().order().get());
    }
    *///?} else {
    private void invokeETRenderers(
        class_10186.class_10190 layerType, class_5321<class_10394> equipmentAsset, class_3879 armorModel,
        class_1799 item, class_4587 poseStack, net.minecraft.class_4597 bufferSource, int packedLight,
        class_2960 playerTexture, CallbackInfo ci, @Share("parameters") LocalRef<ETRenderParameters> parameters
    ) {
        if (parameters.get() == null || layerType != class_10186.class_10190.field_54127)
            return;
        if (ETRenderingAPIImpl.render(parameters.get(), bufferSource, ETRenderMethod.POST))
            ci.cancel();
    }
    //?}

    @Inject(
        method = RENDER_METHOD,
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/Sheets;armorTrimsSheet(Z)Lnet/minecraft/client/renderer/RenderType;"),
        cancellable = true
    )
    private <S> void cancelMissingTrimRender(CallbackInfo ci, @Local class_1058 sprite) {
        if (ETRendererKt.isMissing(sprite)) ci.cancel();
    }
}