package dev.kikugie.elytratrims.render.impl

import dev.kikugie.elytratrims.*
import dev.kikugie.elytratrims.api.impl.copy
import dev.kikugie.elytratrims.api.impl.getEffectiveLight
import dev.kikugie.elytratrims.api.impl.submitToCollector
import dev.kikugie.elytratrims.api.item.ETItemFlag
import dev.kikugie.elytratrims.api.render.ETDecorator
import dev.kikugie.elytratrims.api.render.ETRenderMethod
import dev.kikugie.elytratrims.api.render.ETRenderParameters
import dev.kikugie.elytratrims.api.render.ETRendererID
import dev.kikugie.elytratrims.render.ElytraRenderLayers
import dev.kikugie.elytratrims.render.RENDER_LOGGER
import dev.kikugie.elytratrims.render.getSprite
import dev.kikugie.elytratrims.render.isMissing
import net.minecraft.client.renderer.Sheets
import net.minecraft.client.renderer.texture.TextureAtlasSprite

object ETBadAppleRenderer : ETDecorator {
    @JvmField val type: ETRendererID = ETRendererID(elytratrims("bad_apple"), ETRenderMethod.POST)
    private val reported = mutableSetOf<Identifier>()
    private val animation: TextureAtlasSprite by memoized {
        // For some reason, it must be in the armor trims atlas, or it will use an invalid texture
        /*? if >=1.21.9 {*/net.minecraft.data.AtlasIds.ARMOR_TRIMS/*?} else*///Sheets.ARMOR_TRIMS_SHEET
            .getSprite(elytratrims("feature/bad_apple"), ::report)
    }
    //? if <1.21.9 {
    /*private val converterImpl: ETRenderParameters.VertexConsumerFactory = ETRenderParameters.VertexConsumerFactory { prm, src ->
        val sprite = checkNotNull(prm.sprite) { "Sprite should be set for bad apple rendering" }
        net.minecraft.client.renderer.entity.ItemRenderer.getArmorFoilBuffer(src, prm.render, prm.stack.hasFoil()).let(sprite::wrap)
    }
    *///?}

    override fun getType(): ETRendererID = type

    override fun prepare(original: ETRenderParameters): ETRenderParameters = with(original) {
        if (!ETItemFlag.BAD_APPLE[stack]) return@with original
        original.copy(
            sprite = animation,
            light = getEffectiveLight(),
            render = ElytraRenderLayers.TRANSLUCENT(Sheets.ARMOR_TRIMS_SHEET),
            /*? if <1.21.9*///argument = converterImpl
        )
    }

    override fun render(parameters: ETRenderParameters, collector: RenderConsumer): Boolean = with(parameters) {
        runIf(ETItemFlag.BAD_APPLE[stack] && (!sprite.isMissing || ETItemFlag.DEBUG[stack])) { submitToCollector(collector) }
    }

    fun report(id: Identifier) {
        if (reported.add(id)) RENDER_LOGGER.warn("Missing pattern texture: $id")
    }

    override fun reset() {
        (::animation.getDelegate() as? MemoizedProperty<*>)?.clear()
    }
}