package dev.kikugie.elytratrims.mixin.render;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.kikugie.elytratrims.api.render.ETRenderMethod;
import dev.kikugie.elytratrims.api.render.ETRenderParameters;
import dev.kikugie.elytratrims.api.impl.ETRenderingAPIImpl;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.lang.ref.Reference;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.class_10186;
import net.minecraft.class_10197;
import net.minecraft.class_10394;
import net.minecraft.class_11659;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_5321;

@MixinEnvironment(type = MixinEnvironment.Env.CLIENT)
@Mixin(class_10197.class)
public class ElytraRendererMixin {
    @Shadow
    @Final
    private Function<class_10197.class_10198, class_2960> layerTextureLookup;

    @Unique
    private static final String RENDER_METHOD = "renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;" +
        "Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lnet/minecraft/world/item/ItemStack;" +
        "Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/resources/ResourceLocation;II)V";

    @Unique
    private static final String CANCEL_METHOD =
        /*? if fabric {*/"Lnet/minecraft/client/renderer/entity/layers/EquipmentLayerRenderer;getColorForLayer(Lnet/minecraft/client/resources/model/EquipmentClientInfo$Layer;I)I";
        /*?} else*//*"Lnet/neoforged/neoforge/client/extensions/common/IClientItemExtensions;getArmorLayerTintColor(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/resources/model/EquipmentClientInfo$Layer;II)I";*/

    @Inject(method = RENDER_METHOD, at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;hasFoil()Z"))
    private <S> void invokeETOverrideRenderers(
        class_10186.class_10190 layerType,
        class_5321<class_10394> resourceKey,
        class_3879<? super S> model,
        S object,
        class_1799 itemStack,
        class_4587 poseStack,
        class_11659 submitNodeCollector,
        int i,
        class_2960 resourceLocation,
        int j,
        int k,
        CallbackInfo ci,
        @Local List<class_10186.class_10189> layers,
        @Local(ordinal = 3) LocalIntRef m,
        @Share("parameters") LocalRef<ETRenderParameters> parameters,
        @Share("overridden") LocalBooleanRef overridden
    ) {
        if (layerType != class_10186.class_10190.field_54127) return;
        var base = layers.getFirst(); // Checked for isEmpty in the source
        class_2960 texture = base.comp_3173() && resourceLocation != null
            ? resourceLocation : layerTextureLookup.apply(new class_10197.class_10198(layerType, base));
        AtomicInteger order = new AtomicInteger(m.get());
        ETRenderParameters params = new ETRenderParameters((class_3879<Object>) model, object, itemStack, poseStack, class_1921.method_27949(), null, texture, i, 0xFFFFFFFF, j, k, order);
        parameters.set(params);
        // The result for the pre-render doesn't matter
        ETRenderingAPIImpl.render(params, submitNodeCollector, ETRenderMethod.PRE);
        if (ETRenderingAPIImpl.render(params, submitNodeCollector, ETRenderMethod.OVERRIDE))
            overridden.set(true);
        m.set(order.get());
    }

    @ModifyExpressionValue(method = RENDER_METHOD, at = @At(value = "INVOKE", target = CANCEL_METHOD))
    private int cancelDefaultRenderer(int original, @Share("overridden") LocalBooleanRef overridden) {
        return overridden.get() ? 0 : original;
    }

    @Inject(
        method = RENDER_METHOD,
        at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;"),
        cancellable = true
    )
    private <S> void invokeETRenderers(
        class_10186.class_10190 layerType,
        class_5321<class_10394> resourceKey,
        class_3879<? super S> model,
        S object,
        class_1799 itemStack,
        class_4587 poseStack,
        class_11659 submitNodeCollector,
        int i,
        class_2960 resourceLocation,
        int j,
        int k,
        CallbackInfo ci,
        @Local(ordinal = 3) LocalIntRef m,
        @Share("parameters") LocalRef<ETRenderParameters> parameters
    ) {
        if (parameters.get() == null) return;
        parameters.get().order().set(m.get());
        if (layerType != class_10186.class_10190.field_54127) return;
        if (ETRenderingAPIImpl.render(parameters.get(), submitNodeCollector, ETRenderMethod.POST))
            ci.cancel();
        m.set(parameters.get().order().get());
    }
}