package dev.kikugie.elytratrims.mixin.client;

import dev.kikugie.elytratrims.api.ElytraTrimsAPI;
import dev.kikugie.elytratrims.client.ETClient;
import dev.kikugie.elytratrims.common.access.FeatureAccess;
import dev.kikugie.elytratrims.common.util.UtilKt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_1746;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Mixin(class_1792.class)
public class ItemMixin {
    @SuppressWarnings("InvalidInjectorMethodSignature")
    @Inject(method = "appendTooltip", at = @At("HEAD"))
    protected void elytratrims$modifyTooltip(
        //? if >=1.21 {
        class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, net.minecraft.class_1836 type
        //?} elif >=1.20.6 {
        /*ItemStack stack, Item.TooltipContext context, List<Text> tooltip, net.minecraft.client.item.TooltipType type
        *///?} else
        /*ItemStack stack, net.minecraft.world.World world, List<Text> tooltip, net.minecraft.client.item.TooltipContext context*/
        , CallbackInfo ci
    ) {
        if (!ElytraTrimsAPI.isProbablyElytra(stack)) return;
        if (FeatureAccess.INSTANCE.hasGlow(stack))
            tooltip.add(class_2561.method_43471("elytratrims.item.glow"));
        class_1746.method_7705(stack, tooltip);
        if (ETClient.INSTANCE.getConfig().texture.useElytraModel && class_437.method_25442()) {
            tooltip.add(class_2561.method_43471("elytratrims.item.model1"));
            tooltip.add(class_2561.method_43471("elytratrims.item.model2"));
        }
    }
}