package dev.kikugie.elytratrims.mixin.compat.render;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.kikugie.elytratrims.api.ElytraTrimsAPI;
import dev.kikugie.elytratrims.mixin.constants.Targets;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_563;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;

@Debug(export = true)
@Pseudo
@SuppressWarnings({"UnresolvedMixinReference", "rawtypes", "InvalidInjectorMethodSignature", "MixinAnnotationTarget"})
@Restriction(require = {@Condition("elytraslot")})
@Mixin(targets = "com.illusivesoulworks.elytraslot.client.ElytraSlotLayer")
public abstract class ElytraSlotMixin extends class_3887 {
    public ElytraSlotMixin(class_3883 context) {
        super(context);
    }

    @ModifyExpressionValue(method = "lambda$render$0", at = @At(value = "INVOKE", target = Targets.isPartVisible))
    private boolean elytraslot$cancelCapeRender(boolean original, @Local(argsOnly = true) class_1309 entity) {
        return ElytraTrimsAPI.shouldShowCape(entity) && original;
    }

    @ModifyExpressionValue(method = "lambda$render$0",
            at = @At(value = "INVOKE",
                    target = "Lcom/illusivesoulworks/elytraslot/client/ElytraRenderResult;stack()Lnet/minecraft/item/ItemStack;"))
    private class_1799 elytraslot$saveItemStack(class_1799 stack, @Share("stack") LocalRef<class_1799> stackRef) {
        stackRef.set(stack);
        return stack;
    }

    @WrapOperation(method = "lambda$render$0", at = @At(value = "INVOKE", target = Targets.renderModelWithColor))
    private void elytraslot$elytraPostRender(
            class_563<?> model,
            class_4587 matrices,
            class_4588 vertices,
            int light,
            int overlay,
            //? if <1.21 {
            /*float red,
            float green,
            float blue,
            float alpha,
            *///?} else
            int color,
            Operation<Void> operation,
            @Local(argsOnly = true) class_4597 provider,
            @Local(argsOnly = true) class_1309 entity,
            @Share("stack") LocalRef<class_1799> stackRef) {
        class_1799 stack = stackRef.get();
        //$ render_call_color {
        operation.call(model, matrices, vertices, light, overlay, color);
        ElytraTrimsAPI.renderFeatures(model, matrices, provider, entity, stack, light, color);//$}
    }
}