/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.mixin.render;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.kikugie.elytratrims.api.impl.ETRenderingAPIImpl;
import dev.kikugie.elytratrims.api.render.ETRenderMethod;
import dev.kikugie.elytratrims.api.render.ETRenderParameters;
import dev.kikugie.elytratrims.render.ETRendererKt;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Mixin(value={EquipmentLayerRenderer.class})
public class ElytraRendererMixin {
    @Shadow
    @Final
    private Function<EquipmentLayerRenderer.LayerTextureKey, ResourceLocation> layerTextureLookup;
    @Unique
    private static final String RENDER_METHOD = "renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V";
    @Unique
    private static final String CANCEL_METHOD = "Lnet/neoforged/neoforge/client/extensions/common/IClientItemExtensions;getArmorLayerTintColor(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/resources/model/EquipmentClientInfo$Layer;II)I";

    @Inject(method={"renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;")})
    private void invokeETOverrideRenderers(EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> equipmentAsset, Model armorModel, ItemStack item, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, ResourceLocation playerTexture, CallbackInfo ci, @Local List<EquipmentClientInfo.Layer> layers, @Share(value="parameters") LocalRef<ETRenderParameters> parameters, @Share(value="overridden") LocalBooleanRef overridden) {
        if (layerType != EquipmentClientInfo.LayerType.WINGS) {
            return;
        }
        ResourceLocation texture = !layers.getFirst().usePlayerTexture() || playerTexture == null ? this.layerTextureLookup.apply(new EquipmentLayerRenderer.LayerTextureKey(layerType, layers.getFirst())) : playerTexture;
        ETRenderParameters params = new ETRenderParameters(armorModel, null, item, poseStack, RenderType.armorEntityGlint(), null, texture, packedLight, -1, OverlayTexture.NO_OVERLAY, 0, ETRenderParameters.DUMMY);
        parameters.set((Object)params);
        ETRenderingAPIImpl.render(params, bufferSource, ETRenderMethod.PRE);
        if (ETRenderingAPIImpl.render(params, bufferSource, ETRenderMethod.OVERRIDE)) {
            overridden.set(true);
        }
    }

    @ModifyExpressionValue(method={"renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/client/extensions/common/IClientItemExtensions;getArmorLayerTintColor(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/resources/model/EquipmentClientInfo$Layer;II)I")})
    private int cancelDefaultRenderer(int original, @Share(value="overridden") LocalBooleanRef overridden) {
        return overridden.get() ? 0 : original;
    }

    @Inject(method={"renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;")}, cancellable=true)
    private void invokeETRenderers(EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> equipmentAsset, Model armorModel, ItemStack item, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, ResourceLocation playerTexture, CallbackInfo ci, @Share(value="parameters") LocalRef<ETRenderParameters> parameters) {
        if (parameters.get() == null || layerType != EquipmentClientInfo.LayerType.WINGS) {
            return;
        }
        if (ETRenderingAPIImpl.render((ETRenderParameters)parameters.get(), bufferSource, ETRenderMethod.POST)) {
            ci.cancel();
        }
    }

    @Inject(method={"renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/Sheets;armorTrimsSheet(Z)Lnet/minecraft/client/renderer/RenderType;")}, cancellable=true)
    private <S> void cancelMissingTrimRender(CallbackInfo ci, @Local TextureAtlasSprite sprite) {
        if (ETRendererKt.isMissing(sprite)) {
            ci.cancel();
        }
    }
}

