/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.recipe.cauldron;

import dev.kikugie.elytratrims.api.impl.ETInteractionAPIImpl;
import dev.kikugie.elytratrims.resource.ETTags;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u00a8\u0006\u0016"}, d2={"Ldev/kikugie/elytratrims/recipe/cauldron/ETCauldronInteraction;", "Lnet/minecraft/core/cauldron/CauldronInteraction;", "<init>", "()V", "register", "", "interact", "Lnet/minecraft/world/InteractionResult;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "stack", "Lnet/minecraft/world/item/ItemStack;", "composeInteractions", "existing", "elytratrims-neoforge"})
public final class ETCauldronInteraction
implements CauldronInteraction {
    @NotNull
    public static final ETCauldronInteraction INSTANCE = new ETCauldronInteraction();

    private ETCauldronInteraction() {
    }

    @JvmStatic
    public static final void register() {
        CauldronInteraction.WATER.map().compute(Items.ELYTRA, (arg_0, arg_1) -> ETCauldronInteraction.register$lambda$1(ETCauldronInteraction::register$lambda$0, arg_0, arg_1));
    }

    @NotNull
    public InteractionResult interact(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack stack) {
        InteractionResult interactionResult;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!stack.is(ETTags.ELYTRA_DECORATABLE)) {
            InteractionResult.Pass pass = InteractionResult.PASS;
            Intrinsics.checkNotNullExpressionValue((Object)pass, (String)"PASS");
            return (InteractionResult)pass;
        }
        ItemStack copy = stack.copy();
        boolean cleaned = false;
        for (dev.kikugie.elytratrims.api.interaction.ETCauldronInteraction it : ETInteractionAPIImpl.INSTANCE.getInteractions()) {
            cleaned = it.removeDecorations(player, hand, copy) || cleaned;
        }
        if (!cleaned) {
            InteractionResult.TryEmptyHandInteraction tryEmptyHandInteraction = InteractionResult.TRY_WITH_EMPTY_HAND;
            Intrinsics.checkNotNullExpressionValue((Object)tryEmptyHandInteraction, (String)"TRY_WITH_EMPTY_HAND");
            interactionResult = (InteractionResult)tryEmptyHandInteraction;
        } else {
            InteractionResult.Success success;
            InteractionResult.Success it = success = InteractionResult.SUCCESS;
            boolean bl = false;
            if (!level.isClientSide) {
                player.setItemInHand(hand, copy);
                player.awardStat(Stats.CLEAN_ARMOR);
                LayeredCauldronBlock.lowerFillLevel((BlockState)state, (Level)level, (BlockPos)pos);
            }
            InteractionResult.Success success2 = success;
            Intrinsics.checkNotNullExpressionValue((Object)success2, (String)"also(...)");
            interactionResult = (InteractionResult)success2;
        }
        return interactionResult;
    }

    private final CauldronInteraction composeInteractions(CauldronInteraction existing) {
        return (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ETCauldronInteraction.composeInteractions$lambda$0(existing, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
    }

    private static final CauldronInteraction register$lambda$0(Item item, CauldronInteraction it) {
        CauldronInteraction cauldronInteraction = it;
        return cauldronInteraction == null ? (CauldronInteraction)INSTANCE : INSTANCE.composeInteractions(cauldronInteraction);
    }

    private static final CauldronInteraction register$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (CauldronInteraction)$tmp0.invoke(p0, p1);
    }

    private static final InteractionResult composeInteractions$lambda$0(CauldronInteraction $existing, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        InteractionResult interactionResult;
        InteractionResult interactionResult2 = $existing.interact(state, world, pos, player, hand, stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult2, (String)"interact(...)");
        InteractionResult result = interactionResult2;
        if (result.consumesAction()) {
            interactionResult = result;
        } else {
            Intrinsics.checkNotNull((Object)state);
            Intrinsics.checkNotNull((Object)world);
            Intrinsics.checkNotNull((Object)pos);
            Intrinsics.checkNotNull((Object)player);
            Intrinsics.checkNotNull((Object)hand);
            Intrinsics.checkNotNull((Object)stack);
            interactionResult = INSTANCE.interact(state, world, pos, player, hand, stack);
        }
        return interactionResult;
    }
}

