/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.render;

import dev.kikugie.elytratrims.CommonsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a2\u0010\u0006\u001a\u00020\u0004*\u00060\u0007j\u0002`\b2\n\u0010\t\u001a\u00060\u0007j\u0002`\b2\u0016\u0010\n\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00020\f0\u000b\u001a^\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\u00020\u0003*\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\u00a8\u0006\u001d"}, d2={"RENDER_LOGGER", "Lorg/slf4j/Logger;", "isMissing", "", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)Z", "getSprite", "Lnet/minecraft/resources/ResourceLocation;", "Ldev/kikugie/elytratrims/Identifier;", "identifier", "reporter", "Lkotlin/Function1;", "", "renderEntityInInventoryFollowsMouse", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "x1", "", "y1", "x2", "y2", "scale", "yOffset", "", "mouseX", "mouseY", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "horizontalAngle", "elytratrims-neoforge"})
@SourceDebugExtension(value={"SMAP\nETRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ETRenderer.kt\ndev/kikugie/elytratrims/render/ETRendererKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class ETRendererKt {
    @JvmField
    @NotNull
    public static final Logger RENDER_LOGGER;

    public static final boolean isMissing(@Nullable TextureAtlasSprite $this$isMissing) {
        return $this$isMissing == null || Intrinsics.areEqual((Object)$this$isMissing.contents().name(), (Object)MissingTextureAtlasSprite.getLocation());
    }

    @NotNull
    public static final TextureAtlasSprite getSprite(@NotNull ResourceLocation $this$getSprite, @NotNull ResourceLocation identifier, @NotNull Function1<? super ResourceLocation, Unit> reporter) {
        TextureAtlasSprite textureAtlasSprite;
        Intrinsics.checkNotNullParameter((Object)$this$getSprite, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        TextureAtlasSprite it = textureAtlasSprite = CommonsKt.getMINECRAFT().getAtlasManager().getAtlasOrThrow($this$getSprite).getSprite(identifier);
        boolean bl = false;
        if (ETRendererKt.isMissing(it)) {
            reporter.invoke((Object)identifier);
        }
        TextureAtlasSprite textureAtlasSprite2 = textureAtlasSprite;
        Intrinsics.checkNotNullExpressionValue((Object)textureAtlasSprite2, (String)"also(...)");
        return textureAtlasSprite2;
    }

    public static final void renderEntityInInventoryFollowsMouse(@NotNull GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int scale, float yOffset, float mouseX, float mouseY, @NotNull LivingEntity entity, float horizontalAngle) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        float centerX = (float)(x1 + x2) / 2.0f;
        float centerY = (float)(y1 + y2) / 2.0f;
        guiGraphics.enableScissor(x1, y1, x2, y2);
        float mouseHorizontalAngle = (float)Math.atan((centerX - mouseX) / 40.0f);
        float mouseVerticalAngle = (float)Math.atan((centerY - mouseY) / 40.0f);
        Quaternionf baseRotation = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf pitchRotation = new Quaternionf().rotateX(mouseVerticalAngle * 20.0f * ((float)Math.PI / 180));
        baseRotation.mul((Quaternionfc)pitchRotation);
        float originalBodyYaw = entity.yBodyRot;
        float originalYaw = entity.getYRot();
        float originalPitch = entity.getXRot();
        float originalHeadYawOld = entity.yHeadRotO;
        float originalHeadYaw = entity.yHeadRot;
        entity.yBodyRot = 180.0f + mouseHorizontalAngle * 20.0f + horizontalAngle;
        entity.setYRot(180.0f + mouseHorizontalAngle * 40.0f + horizontalAngle);
        entity.setXRot(-mouseVerticalAngle * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        float entityScale = entity.getScale();
        Vector3f translationOffset = new Vector3f(0.0f, entity.getBbHeight() / 2.0f + yOffset * entityScale, 0.0f);
        float renderScale = (float)scale / entityScale;
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (int)x1, (int)y1, (int)x2, (int)y2, (float)renderScale, (Vector3f)translationOffset, (Quaternionf)baseRotation, (Quaternionf)pitchRotation, (LivingEntity)entity);
        entity.yBodyRot = originalBodyYaw;
        entity.setYRot(originalYaw);
        entity.setXRot(originalPitch);
        entity.yHeadRotO = originalHeadYawOld;
        entity.yHeadRot = originalHeadYaw;
        guiGraphics.disableScissor();
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"ETRenderer");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        RENDER_LOGGER = logger;
    }
}

