/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.smoothcoasters;

import me.m56738.smoothcoasters.MathUtil;
import net.minecraft.class_2379;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class AnimatedPose {
    private final Quaternionf previous = new Quaternionf();
    private final Quaternionf target = new Quaternionf();
    private final Quaternionf lerp = new Quaternionf();
    private final Quaternionf current = new Quaternionf();
    public class_2379 targetEuler = new class_2379(0.0f, 0.0f, 0.0f);
    private int lerpTicks;
    private boolean first = true;

    public AnimatedPose() {
    }

    public AnimatedPose(class_2379 eulerAngle) {
        this.set(eulerAngle, 0);
    }

    private static boolean isNotIdentity(Quaternionf q) {
        return !q.equals(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public boolean isActive() {
        return AnimatedPose.isNotIdentity(this.previous) || AnimatedPose.isNotIdentity(this.lerp) || AnimatedPose.isNotIdentity(this.target);
    }

    public void set(class_2379 angle, int ticks) {
        this.targetEuler = angle;
        this.target.rotationZYX((float)Math.toRadians(-angle.comp_3778()), (float)Math.toRadians(-angle.comp_3777()), (float)Math.toRadians(angle.comp_3776()));
        this.lerp(ticks);
    }

    public void set(Quaternionfc rotation, int ticks) {
        this.targetEuler = null;
        this.target.set(rotation);
        this.lerp(ticks);
    }

    private void lerp(int ticks) {
        if (ticks < 0) {
            ticks = 1;
        }
        if (ticks == 1) {
            this.lerp.set((Quaternionfc)this.target);
        } else if (ticks == 0) {
            this.lerp.set((Quaternionfc)this.target);
            this.previous.set((Quaternionfc)this.target);
        }
        if (this.first) {
            this.previous.set((Quaternionfc)this.target);
            this.lerp.set((Quaternionfc)this.target);
            this.first = false;
        } else {
            this.lerpTicks = ticks;
        }
    }

    public void tick() {
        this.previous.set((Quaternionfc)this.lerp);
        if (this.lerpTicks > 1) {
            this.lerp.slerp((Quaternionfc)this.target, 1.0f / (float)this.lerpTicks);
            --this.lerpTicks;
        } else {
            if (this.lerpTicks == 0) {
                this.previous.set((Quaternionfc)this.target);
            }
            this.lerp.set((Quaternionfc)this.target);
            this.lerpTicks = 0;
        }
    }

    public void calculate(Quaternionf result, float t) {
        this.previous.slerp((Quaternionfc)this.lerp, t, result);
    }

    public class_2379 calculateEuler(float t) {
        this.previous.slerp((Quaternionfc)this.lerp, t, this.current);
        return MathUtil.getEuler((Quaternionfc)this.current);
    }
}

