/*
 * Decompiled with CFR 0.152.
 */
package me.m56738.smoothcoasters.mixin;

import me.m56738.smoothcoasters.AnimatedPose;
import me.m56738.smoothcoasters.GameRendererMixinInterface;
import me.m56738.smoothcoasters.MathUtil;
import me.m56738.smoothcoasters.SmoothCoasters;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5498;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_9779;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_757.class})
public abstract class GameRendererMixin
implements GameRendererMixinInterface {
    @Unique
    private final AnimatedPose scPose = new AnimatedPose();
    @Unique
    private final Quaternionf scPoseQuaternion = new Quaternionf();
    @Unique
    private final Quaternionf scCameraRotation = new Quaternionf();
    @Unique
    private final Quaternionf scDifference = new Quaternionf();
    @Unique
    private final Vector3d scForward = new Vector3d();
    @Unique
    private final Vector3d scUp = new Vector3d();
    @Shadow
    @Final
    private class_310 field_4015;
    @Unique
    private float scLastYaw;
    @Unique
    private float scYaw;
    @Unique
    private float scPitch;
    @Unique
    private boolean scHasLimit = false;
    @Unique
    private float scMinYaw = -180.0f;
    @Unique
    private float scMaxYaw = 180.0f;
    @Unique
    private float scMinPitch = -90.0f;
    @Unique
    private float scMaxPitch = 90.0f;
    @Unique
    private boolean scSuppressChanges;
    @Unique
    private boolean scActive;
    @Unique
    private boolean scToggle = true;
    @Shadow
    @Final
    private class_4184 field_18765;

    @Override
    public void smoothcoasters$setRotation(Quaternionfc rotation, int ticks) {
        class_746 player;
        this.scPose.set(rotation, ticks);
        this.scPose.calculate(this.scPoseQuaternion, 0.0f);
        boolean bl = this.scActive = this.scToggle && this.scPose.isActive();
        if (this.scActive && ticks == 0 && (player = this.field_4015.field_1724) != null) {
            this.smoothcoasters$updateRotation((class_1297)player);
        }
    }

    @Override
    public void smoothcoasters$setRotationLimit(float minYaw, float maxYaw, float minPitch, float maxPitch) {
        this.scHasLimit = minYaw > -180.0f || maxYaw < 180.0f || minPitch > -90.0f || maxPitch < 90.0f;
        this.scMinYaw = minYaw;
        this.scMaxYaw = maxYaw;
        this.scMinPitch = minPitch;
        this.scMaxPitch = maxPitch;
        this.enforceRotationLimit();
    }

    @Unique
    private void enforceRotationLimit() {
        if (!this.scHasLimit) {
            return;
        }
        this.scYaw = class_3532.method_15393((float)this.scYaw);
        this.scPitch = class_3532.method_15393((float)this.scPitch);
        if (this.scYaw < this.scMinYaw) {
            this.scYaw = this.scMinYaw;
        }
        if (this.scYaw > this.scMaxYaw) {
            this.scYaw = this.scMaxYaw;
        }
        if (this.scPitch < this.scMinPitch) {
            this.scPitch = this.scMinPitch;
        }
        if (this.scPitch > this.scMaxPitch) {
            this.scPitch = this.scMaxPitch;
        }
    }

    @Unique
    private void applyLocalRotation() {
        this.scPose.calculate(this.scPoseQuaternion, this.field_4015.method_61966().method_60637(true));
        class_746 player = this.field_4015.field_1724;
        if (player == null) {
            return;
        }
        this.scCameraRotation.set((Quaternionfc)this.scPoseQuaternion);
        this.scCameraRotation.rotateY(Math.toRadians((float)(-this.scYaw)));
        this.scCameraRotation.rotateX(Math.toRadians((float)this.scPitch));
        this.scCameraRotation.transformUnitPositiveZ(this.scForward);
        this.scCameraRotation.transformUnitPositiveY(this.scUp);
        float yaw = MathUtil.getYaw((Vector3dc)this.scForward, (Vector3dc)this.scUp);
        float pitch = MathUtil.getPitch((Vector3dc)this.scForward);
        while (Math.abs((float)(yaw - this.scLastYaw)) >= 270.0f) {
            if (yaw < this.scLastYaw) {
                yaw += 360.0f;
                continue;
            }
            yaw -= 360.0f;
        }
        this.scLastYaw = yaw;
        this.scSuppressChanges = true;
        player.field_6259 = yaw;
        player.field_5982 = yaw;
        player.field_6004 = pitch;
        player.method_5847(yaw);
        player.method_36456(yaw);
        player.method_36457(pitch);
        this.scSuppressChanges = false;
    }

    @Override
    public void smoothcoasters$updateRotation(class_1297 entity) {
        if (this.scSuppressChanges || !(entity instanceof class_746)) {
            return;
        }
        class_746 player = (class_746)entity;
        this.scPoseQuaternion.conjugate(this.scDifference);
        this.scDifference.rotateY(Math.toRadians((float)(-player.method_36454())));
        this.scDifference.rotateX(Math.toRadians((float)player.method_36455()));
        this.scDifference.transformUnitPositiveZ(this.scForward);
        this.scDifference.transformUnitPositiveY(this.scUp);
        this.scYaw = MathUtil.getYaw((Vector3dc)this.scForward, (Vector3dc)this.scUp);
        this.scPitch = MathUtil.getPitch((Vector3dc)this.scForward);
    }

    @Override
    public void smoothcoasters$loadLocalRotation(class_1297 entity) {
        if (!(entity instanceof class_746) || !this.scActive) {
            return;
        }
        this.scSuppressChanges = true;
        entity.method_36456(this.scYaw);
        entity.method_36457(this.scPitch);
    }

    @Override
    public void smoothcoasters$applyLocalRotation(class_1297 entity) {
        if (!(entity instanceof class_746) || !this.scActive) {
            return;
        }
        this.scYaw = entity.method_36454();
        this.scPitch = entity.method_36455();
        this.enforceRotationLimit();
        this.applyLocalRotation();
    }

    @Override
    public boolean smoothcoasters$getRotationToggle() {
        return this.scToggle;
    }

    @Override
    public void smoothcoasters$setRotationToggle(boolean enabled) {
        class_746 player;
        this.scPose.calculate(this.scPoseQuaternion, 0.0f);
        this.scToggle = enabled;
        boolean bl = this.scActive = this.scToggle && this.scPose.isActive();
        if (this.scActive && (player = this.field_4015.field_1724) != null) {
            this.smoothcoasters$updateRotation((class_1297)player);
        }
    }

    @Inject(method={"method_3203()V"}, at={@At(value="HEAD")})
    private void reset(CallbackInfo info) {
        SmoothCoasters.getInstance().reset();
    }

    @Inject(method={"method_3182()V"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo info) {
        this.scPose.tick();
        this.scActive = this.scToggle && this.scPose.isActive();
    }

    @Inject(method={"method_3192(Lnet/minecraft/class_9779;Z)V"}, at={@At(value="HEAD")})
    private void render(class_9779 tickCounter, boolean tick, CallbackInfo ci) {
        if (!this.scActive) {
            return;
        }
        this.applyLocalRotation();
    }

    @Inject(method={"method_3188(Lnet/minecraft/class_9779;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_4184;method_19321(Lnet/minecraft/class_1922;Lnet/minecraft/class_1297;ZZF)V", shift=At.Shift.AFTER)})
    private void updateCamera(class_9779 renderTickCounter, CallbackInfo ci) {
        if (this.field_18765.method_19331() != this.field_4015.field_1724 || !this.scActive) {
            return;
        }
        Quaternionf rotation = this.field_18765.method_23767();
        rotation.set((Quaternionfc)this.scCameraRotation);
        if (this.field_4015.field_1690.method_31044() != class_5498.field_26666) {
            rotation.mul((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        }
    }
}

