/*
 * Decompiled with CFR 0.152.
 */
package drunkblood.horsecompass.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import drunkblood.horsecompass.HorseCompass;
import drunkblood.horsecompass.HorseTracker;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class HorseCompassAngleState
extends NeedleDirectionHelper {
    public static final MapCodec<HorseCompassAngleState> MAP_CODEC = RecordCodecBuilder.mapCodec(state -> state.group((App)Codec.BOOL.optionalFieldOf("wobble", (Object)true).forGetter(rec$ -> ((HorseCompassAngleState)((Object)((Object)((Object)rec$)))).wobble())).apply((Applicative)state, HorseCompassAngleState::new));
    private final NeedleDirectionHelper.Wobbler wobbler = this.newWobbler(0.8f);
    private final NeedleDirectionHelper.Wobbler noTargetWobbler = this.newWobbler(0.8f);
    private final RandomSource random = RandomSource.create();

    protected HorseCompassAngleState(boolean wobble) {
        super(wobble);
    }

    protected float calculate(@Nonnull ItemStack itemStack, @Nonnull ClientLevel clientLevel, int seed, @Nullable ItemOwner owner) {
        long i = clientLevel.getGameTime();
        if (owner == null) {
            return this.getRandomlySpinningRotation(seed, i);
        }
        HorseTracker tracker = (HorseTracker)itemStack.get(HorseCompass.HORSE_TRACKER);
        if (tracker == null) {
            return this.getRandomlySpinningRotation(seed, i);
        }
        Entity entity = clientLevel.getEntity(tracker.entityId());
        if (entity == null || entity.level().dimension() != owner.level().dimension()) {
            return this.getRandomlySpinningRotation(seed, i);
        }
        return this.getRotationTowardsCompassTarget(owner, i, entity.getEyePosition());
    }

    private float getRandomlySpinningRotation(int seed, long gameTime) {
        if (this.noTargetWobbler.shouldUpdate(gameTime)) {
            this.noTargetWobbler.update(gameTime, this.random.nextFloat());
        }
        float f = this.noTargetWobbler.rotation() + (float)HorseCompassAngleState.hash(seed) / 2.1474836E9f;
        return Mth.positiveModulo((float)f, (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(ItemOwner owner, long gameTime, Vec3 entityEye) {
        Player player;
        float f = (float)HorseCompassAngleState.getAngleFromEntityToPos(owner, entityEye);
        float f1 = HorseCompassAngleState.getWrappedVisualRotationY(owner);
        LivingEntity var9 = owner.asLivingEntity();
        if (var9 instanceof Player && (player = (Player)var9).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            if (this.wobbler.shouldUpdate(gameTime)) {
                this.wobbler.update(gameTime, 0.5f - (f1 - 0.25f));
            }
            float f2 = f + this.wobbler.rotation();
            return Mth.positiveModulo((float)f2, (float)1.0f);
        }
        float f2 = 0.5f - (f1 - 0.25f - f);
        return Mth.positiveModulo((float)f2, (float)1.0f);
    }

    private static double getAngleFromEntityToPos(ItemOwner owner, Vec3 entityEye) {
        Vec3 vec31 = owner.position();
        return Math.atan2(entityEye.z() - vec31.z(), entityEye.x() - vec31.x()) / 6.2831854820251465;
    }

    private static float getWrappedVisualRotationY(ItemOwner owner) {
        return Mth.positiveModulo((float)(owner.getVisualRotationYInDegrees() / 360.0f), (float)1.0f);
    }

    private static int hash(int seed) {
        return seed * 1327217883;
    }
}

