/*
 * Decompiled with CFR 0.152.
 */
package drunkblood.horsecompass.datagen;

import drunkblood.horsecompass.HorseCompass;
import drunkblood.horsecompass.client.HorseCompassAngle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ConditionalItemModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.RangeSelectItemModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.conditional.HasComponent;
import net.minecraft.client.renderer.item.properties.numeric.CompassAngle;
import net.minecraft.client.renderer.item.properties.numeric.CompassAngleState;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class HorseModelProvider
extends ModelProvider {
    public HorseModelProvider(PackOutput output) {
        super(output, "horsecompass");
    }

    protected void registerModels(@Nonnull BlockModelGenerators blockModels, @Nonnull ItemModelGenerators itemModels) {
        for (int i = 0; i < 32; ++i) {
            String suffix = String.format("_%02d", i);
            ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)((Item)HorseCompass.HORSE_COMPASS.get()), (String)suffix), TextureMapping.layer0((ResourceLocation)TextureMapping.getItemTexture((Item)((Item)HorseCompass.HORSE_COMPASS.get()), (String)suffix)), itemModels.modelOutput);
        }
        itemModels.itemModelOutput.accept((Item)HorseCompass.HORSE_COMPASS.get(), (ItemModel.Unbaked)new ConditionalItemModel.Unbaked((ConditionalItemModelProperty)new HasComponent(HorseCompass.HORSE_TRACKER.get(), false), (ItemModel.Unbaked)new RangeSelectItemModel.Unbaked((RangeSelectItemModelProperty)new HorseCompassAngle(true), 32.0f, this.CreateCompassEntries(), Optional.empty()), (ItemModel.Unbaked)new RangeSelectItemModel.Unbaked((RangeSelectItemModelProperty)new CompassAngle(true, CompassAngleState.CompassTarget.NONE), 32.0f, this.CreateCompassEntries(), Optional.empty())));
    }

    private List<RangeSelectItemModel.Entry> CreateCompassEntries() {
        ArrayList<RangeSelectItemModel.Entry> list = new ArrayList<RangeSelectItemModel.Entry>();
        int modelFileCounter = 16;
        list.add(new RangeSelectItemModel.Entry(0.0f, this.CreateCompassModel(modelFileCounter)));
        for (int i = 0; i < 32; ++i) {
            modelFileCounter = (modelFileCounter + 1) % 32;
            list.add(new RangeSelectItemModel.Entry((float)i + 0.5f, this.CreateCompassModel(modelFileCounter)));
        }
        return list;
    }

    private ItemModel.Unbaked CreateCompassModel(int index) {
        ResourceLocation modelLocation = ModelLocationUtils.getModelLocation((Item)((Item)HorseCompass.HORSE_COMPASS.get()), (String)String.format("_%02d", index));
        return new BlockModelWrapper.Unbaked(modelLocation, Collections.emptyList());
    }
}

