/*
 * Decompiled with CFR 0.152.
 */
package carpet.logging;

import carpet.CarpetServer;
import carpet.helpers.HopperCounter;
import carpet.logging.LoggerRegistry;
import carpet.logging.logHelpers.PacketCounter;
import carpet.utils.Messenger;
import carpet.utils.SpawnReporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.level.Level;

public class HUDController {
    private static final List<Consumer<MinecraftServer>> HUDListeners = new ArrayList<Consumer<MinecraftServer>>();
    public static final Map<ServerPlayer, List<Component>> player_huds = new HashMap<ServerPlayer, List<Component>>();
    public static final Map<String, Component> scarpet_headers = new HashMap<String, Component>();
    public static final Map<String, Component> scarpet_footers = new HashMap<String, Component>();

    public static void register(Consumer<MinecraftServer> listener) {
        HUDListeners.add(listener);
    }

    public static void resetScarpetHUDs() {
        scarpet_headers.clear();
        scarpet_footers.clear();
    }

    public static void addMessage(ServerPlayer player, Component hudMessage) {
        if (player == null) {
            return;
        }
        if (!player_huds.containsKey(player)) {
            player_huds.put(player, new ArrayList());
        } else {
            player_huds.get(player).add((Component)Component.literal((String)"\n"));
        }
        player_huds.get(player).add(hudMessage);
    }

    public static void clearPlayer(ServerPlayer player) {
        ClientboundTabListPacket packet = new ClientboundTabListPacket((Component)Component.literal((String)""), (Component)Component.literal((String)""));
        player.connection.send((Packet)packet);
    }

    public static void update_hud(MinecraftServer server, List<ServerPlayer> force) {
        if (server.getTickCount() % 20 != 0 && force == null || CarpetServer.minecraft_server == null) {
            return;
        }
        player_huds.clear();
        server.getPlayerList().getPlayers().forEach(p -> {
            Component scarpetFOoter = scarpet_footers.get(p.getScoreboardName());
            if (scarpetFOoter != null) {
                HUDController.addMessage(p, scarpetFOoter);
            }
        });
        if (LoggerRegistry.__tps) {
            LoggerRegistry.getLogger("tps").log(() -> HUDController.send_tps_display(server));
        }
        if (LoggerRegistry.__mobcaps) {
            LoggerRegistry.getLogger("mobcaps").log((option, player) -> {
                ResourceKey dim = switch (option) {
                    case "overworld" -> Level.OVERWORLD;
                    case "nether" -> Level.NETHER;
                    case "end" -> Level.END;
                    default -> player.level().dimension();
                };
                return new Component[]{SpawnReporter.printMobcapsForDimension(server.getLevel(dim), false).get(0)};
            });
        }
        if (LoggerRegistry.__counter) {
            LoggerRegistry.getLogger("counter").log(option -> HUDController.send_counter_info(server, option));
        }
        if (LoggerRegistry.__packets) {
            LoggerRegistry.getLogger("packets").log(HUDController::packetCounter);
        }
        HUDListeners.forEach(l -> l.accept(server));
        HashSet<ServerPlayer> targets = new HashSet<ServerPlayer>(player_huds.keySet());
        if (force != null) {
            targets.addAll(force);
        }
        for (ServerPlayer player2 : targets) {
            ClientboundTabListPacket packet = new ClientboundTabListPacket(scarpet_headers.getOrDefault(player2.getScoreboardName(), (Component)Component.literal((String)"")), Messenger.c(player_huds.getOrDefault(player2, List.of()).toArray(new Object[0])));
            player2.connection.send((Packet)packet);
        }
    }

    private static Component[] send_tps_display(MinecraftServer server) {
        double MSPT = (double)server.getAverageTickTimeNanos() / (double)TimeUtil.NANOSECONDS_PER_MILLISECOND;
        ServerTickRateManager trm = server.tickRateManager();
        double TPS = 1000.0 / Math.max(trm.isSprinting() ? 0.0 : (double)trm.millisecondsPerTick(), MSPT);
        if (trm.isFrozen()) {
            TPS = 0.0;
        }
        String color = Messenger.heatmap_color(MSPT, trm.millisecondsPerTick());
        return new Component[]{Messenger.c("g TPS: ", String.format(Locale.US, "%s %.1f", color, TPS), "g  MSPT: ", String.format(Locale.US, "%s %.1f", color, MSPT))};
    }

    private static Component[] send_counter_info(MinecraftServer server, String colors) {
        ArrayList<Component> res = new ArrayList<Component>();
        for (String color : colors.split(",")) {
            HopperCounter counter = HopperCounter.getCounter(color);
            if (counter == null) continue;
            res.addAll(counter.format(server, false, true));
        }
        return res.toArray(new Component[0]);
    }

    private static Component[] packetCounter() {
        Component[] ret = new Component[]{Messenger.c("w I/" + PacketCounter.totalIn + " O/" + PacketCounter.totalOut)};
        PacketCounter.reset();
        return ret;
    }
}

