/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.ThreadedAnvilChunkStorageInterface;
import carpet.script.utils.WorldTools;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.RegionFile;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ChunkMap.class})
public abstract class ChunkMap_scarpetChunkCreationMixin
implements ThreadedAnvilChunkStorageInterface {
    @Shadow
    @Final
    private ServerLevel level;
    @Shadow
    @Final
    private Long2ObjectLinkedOpenHashMap<ChunkHolder> updatingChunkMap;
    @Shadow
    private boolean modified;
    @Shadow
    @Final
    private ThreadedLevelLightEngine lightEngine;
    @Shadow
    @Final
    private ChunkTaskPriorityQueueSorter queueSorter;
    @Shadow
    @Final
    private BlockableEventLoop<Runnable> mainThreadExecutor;
    @Shadow
    @Final
    private ChunkProgressListener progressListener;
    @Shadow
    @Final
    private ChunkMap.DistanceManager distanceManager;
    ThreadLocal<Boolean> generated = ThreadLocal.withInitial(() -> null);

    @Shadow
    protected abstract boolean promoteChunkMap();

    @Shadow
    protected abstract Iterable<ChunkHolder> getChunks();

    @Shadow
    protected abstract CompletableFuture<ChunkResult<List<ChunkAccess>>> getChunkRangeFuture(ChunkHolder var1, int var2, IntFunction<ChunkStatus> var3);

    @Unique
    private void addTicket(ChunkPos pos, ChunkStatus status) {
        this.distanceManager.addTicket(TicketType.UNKNOWN, pos, 33 + ChunkLevel.byStatus((ChunkStatus)status), (Object)pos);
    }

    @Unique
    private void addTicket(ChunkPos pos) {
        this.addTicket(pos, ChunkStatus.EMPTY);
    }

    @Unique
    private void tickTicketManager() {
        this.distanceManager.runAllUpdates((ChunkMap)this);
    }

    @Unique
    private Set<ChunkPos> getExistingChunks(Set<ChunkPos> requestedChunks) {
        HashMap<String, RegionFile> regionCache = new HashMap<String, RegionFile>();
        HashSet<ChunkPos> ret = new HashSet<ChunkPos>();
        for (ChunkPos pos : requestedChunks) {
            if (!WorldTools.canHasChunk(this.level, pos, regionCache, true)) continue;
            ret.add(pos);
        }
        return ret;
    }
}

