/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.helpers.HopperCounter;
import carpet.utils.WoolTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HopperBlockEntity.class})
public abstract class HopperBlockEntity_counterMixin
extends RandomizableContainerBlockEntity {
    @Shadow
    private Direction facing;

    protected HopperBlockEntity_counterMixin(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Inject(method={"ejectItems"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onInsert(Level world, BlockPos blockPos, HopperBlockEntity hopperBlockEntity, CallbackInfoReturnable<Boolean> cir) {
        Direction hopperFacing;
        DyeColor woolColor;
        if (CarpetSettings.hopperCounters && (woolColor = WoolTool.getWoolColorAtPosition(world, blockPos.relative(hopperFacing = (Direction)world.getBlockState(blockPos).getValue((Property)HopperBlock.FACING)))) != null) {
            Container inventory = HopperBlockEntity.getContainerAt((Level)world, (BlockPos)blockPos);
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                if (inventory.getItem(i).isEmpty()) continue;
                ItemStack itemstack = inventory.getItem(i);
                HopperCounter.getCounter(woolColor).add(world.getServer(), itemstack);
                inventory.setItem(i, ItemStack.EMPTY);
            }
            cir.setReturnValue((Object)true);
        }
    }
}

