/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.fakes.TntEntityInterface;
import carpet.logging.LoggerRegistry;
import carpet.logging.logHelpers.TNTLogHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PrimedTnt.class})
public abstract class PrimedTntMixin
extends Entity
implements TntEntityInterface {
    private TNTLogHelper logHelper;
    private boolean mergeBool = false;
    private int mergedTNT = 1;

    @Shadow
    public abstract int getFuse();

    public PrimedTntMixin(EntityType<?> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="RETURN")})
    private void modifyTNTAngle(Level world, double x, double y, double z, LivingEntity entity, CallbackInfo ci) {
        if (CarpetSettings.hardcodeTNTangle != -1.0) {
            this.setDeltaMovement(-Math.sin(CarpetSettings.hardcodeTNTangle) * 0.02, 0.2, -Math.cos(CarpetSettings.hardcodeTNTangle) * 0.02);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="RETURN")})
    private void initTNTLoggerPrime(EntityType<? extends PrimedTnt> entityType_1, Level world_1, CallbackInfo ci) {
        if (LoggerRegistry.__tnt && !world_1.isClientSide) {
            this.logHelper = new TNTLogHelper();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void initTracker(CallbackInfo ci) {
        if (LoggerRegistry.__tnt && this.logHelper != null && !this.logHelper.initialized) {
            this.logHelper.onPrimed(this.getX(), this.getY(), this.getZ(), this.getDeltaMovement());
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="RETURN")})
    private void initTNTLogger(Level world_1, double double_1, double double_2, double double_3, LivingEntity livingEntity_1, CallbackInfo ci) {
        if (CarpetSettings.tntPrimerMomentumRemoved) {
            this.setDeltaMovement(new Vec3(0.0, (double)0.2f, 0.0));
        }
    }

    @Inject(method={"explode"}, at={@At(value="HEAD")})
    private void onExplode(CallbackInfo ci) {
        if (LoggerRegistry.__tnt && this.logHelper != null) {
            this.logHelper.onExploded(this.getX(), this.getY(), this.getZ(), this.level().getGameTime());
        }
        if (this.mergedTNT > 1) {
            for (int i = 0; i < this.mergedTNT - 1; ++i) {
                this.level().explode((Entity)this, this.getX(), this.getY() + (double)(this.getBbHeight() / 16.0f), this.getZ(), 4.0f, Level.ExplosionInteraction.TNT);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/PrimedTnt;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=1)})
    private void tryMergeTnt(CallbackInfo ci) {
        if (CarpetSettings.mergeTNT) {
            Vec3 velocity = this.getDeltaMovement();
            if (!this.level().isClientSide && this.mergeBool && velocity.x == 0.0 && velocity.y == 0.0 && velocity.z == 0.0) {
                this.mergeBool = false;
                for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox())) {
                    if (!(entity instanceof PrimedTnt) || entity.isRemoved()) continue;
                    PrimedTnt entityTNTPrimed = (PrimedTnt)entity;
                    Vec3 tntVelocity = entityTNTPrimed.getDeltaMovement();
                    if (tntVelocity.x != 0.0 || tntVelocity.y != 0.0 || tntVelocity.z != 0.0 || this.getX() != entityTNTPrimed.getX() || this.getZ() != entityTNTPrimed.getZ() || this.getY() != entityTNTPrimed.getY() || this.getFuse() != entityTNTPrimed.getFuse()) continue;
                    this.mergedTNT += ((TntEntityInterface)entityTNTPrimed).getMergedTNT();
                    entityTNTPrimed.discard();
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/PrimedTnt;setFuse(I)V")})
    private void setMergeable(CallbackInfo ci) {
        Vec3 velocity = this.getDeltaMovement();
        if (!(this.level().isClientSide || velocity.y == 0.0 && velocity.x == 0.0 && velocity.z == 0.0)) {
            this.mergeBool = true;
        }
    }

    @Override
    public int getMergedTNT() {
        return this.mergedTNT;
    }
}

