/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.CarpetScriptServer;
import carpet.script.external.Carpet;
import carpet.script.external.VanillaClient;
import carpet.script.utils.ShapeDispatcher;
import carpet.script.utils.shapes.ShapeDirection;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class ShapesRenderer {
    private final Map<ResourceKey<Level>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> shapes;
    private final Map<ResourceKey<Level>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> labels;
    private final Minecraft client;
    private final Map<String, BiFunction<Minecraft, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> renderedShapes = new HashMap<String, BiFunction<Minecraft, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>(){
        {
            this.put("line", RenderedLine::new);
            this.put("box", RenderedBox::new);
            this.put("sphere", RenderedSphere::new);
            this.put("cylinder", RenderedCylinder::new);
            this.put("label", RenderedText::new);
            this.put("polygon", RenderedPolyface::new);
            this.put("block", (c, s) -> new RenderedSprite((Minecraft)c, (ShapeDispatcher.ExpiringShape)s, false));
            this.put("item", (c, s) -> new RenderedSprite((Minecraft)c, (ShapeDispatcher.ExpiringShape)s, true));
        }
    };

    public static void rotatePoseStackByShapeDirection(PoseStack poseStack, ShapeDirection shapeDirection, Camera camera, Vec3 objectPos) {
        switch (shapeDirection) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case UP: {
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case DOWN: {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case CAMERA: {
                poseStack.mulPose(camera.rotation());
                break;
            }
            case PLAYER: {
                Vec3 vector = objectPos.subtract(camera.getPosition());
                double x = vector.x;
                double y = vector.y;
                double z = vector.z;
                double d = Math.sqrt(x * x + z * z);
                float rotX = (float)Math.atan2(x, z);
                float rotY = (float)Math.atan2(y, d);
                poseStack.mulPose(Axis.YP.rotation(rotX));
                poseStack.mulPose(Axis.XP.rotation(-rotY));
            }
        }
    }

    public ShapesRenderer(Minecraft minecraftClient) {
        this.client = minecraftClient;
        this.shapes = new HashMap<ResourceKey<Level>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>();
        this.labels = new HashMap<ResourceKey<Level>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>();
    }

    public void render(Matrix4f modelViewMatrix, Camera camera, float partialTick) {
        Runnable token = Carpet.startProfilerSection("Scarpet client");
        PoseStack matrices = new PoseStack();
        ClientLevel iWorld = this.client.level;
        ResourceKey dimensionType = iWorld.dimension();
        if ((this.shapes.get(dimensionType) == null || this.shapes.get(dimensionType).isEmpty()) && (this.labels.get(dimensionType) == null || this.labels.get(dimensionType).isEmpty())) {
            return;
        }
        long currentTime = this.client.level.getGameTime();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        Tesselator tesselator = Tesselator.getInstance();
        double cameraX = camera.getPosition().x;
        double cameraY = camera.getPosition().y;
        double cameraZ = camera.getPosition().z;
        boolean entityBoxes = this.client.getEntityRenderDispatcher().shouldRenderHitBoxes();
        if (!this.shapes.isEmpty()) {
            this.shapes.get(dimensionType).long2ObjectEntrySet().removeIf(entry -> ((RenderedShape)entry.getValue()).isExpired(currentTime));
            Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
            matrixStack.pushMatrix();
            matrixStack.mul((Matrix4fc)matrices.last().pose());
            RenderSystem.applyModelViewMatrix();
            RenderSystem.lineWidth((float)0.5f);
            this.shapes.get(dimensionType).values().forEach(s -> {
                if ((!((ShapeDispatcher.ExpiringShape)s.shape).debug || entityBoxes) && s.shouldRender((ResourceKey<Level>)dimensionType)) {
                    s.renderLines(matrices, tesselator, cameraX, cameraY, cameraZ, partialTick);
                }
            });
            RenderSystem.lineWidth((float)0.1f);
            this.shapes.get(dimensionType).values().forEach(s -> {
                if ((!((ShapeDispatcher.ExpiringShape)s.shape).debug || entityBoxes) && s.shouldRender((ResourceKey<Level>)dimensionType)) {
                    s.renderFaces(tesselator, cameraX, cameraY, cameraZ, partialTick);
                }
            });
            RenderSystem.lineWidth((float)1.0f);
            matrixStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
        if (!this.labels.isEmpty()) {
            this.labels.get(dimensionType).long2ObjectEntrySet().removeIf(entry -> ((RenderedShape)entry.getValue()).isExpired(currentTime));
            this.labels.get(dimensionType).values().forEach(s -> {
                if ((!((ShapeDispatcher.ExpiringShape)s.shape).debug || entityBoxes) && s.shouldRender((ResourceKey<Level>)dimensionType)) {
                    s.renderLines(matrices, tesselator, cameraX, cameraY, cameraZ, partialTick);
                }
            });
        }
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        token.run();
    }

    public void addShapes(ListTag tag) {
        Runnable token = Carpet.startProfilerSection("Scarpet client");
        int count = tag.size();
        for (int i = 0; i < count; ++i) {
            this.addShape(tag.getCompound(i));
        }
        token.run();
    }

    public void addShape(CompoundTag tag) {
        ShapeDispatcher.ExpiringShape shape = ShapeDispatcher.fromTag(tag, (Level)this.client.level);
        if (shape == null) {
            return;
        }
        BiFunction<Minecraft, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>> shapeFactory = this.renderedShapes.get(tag.getString("shape"));
        if (shapeFactory == null) {
            CarpetScriptServer.LOG.info("Unrecognized shape: " + tag.getString("shape"));
        } else {
            RenderedShape<? extends ShapeDispatcher.ExpiringShape> rshape = shapeFactory.apply(this.client, shape);
            ResourceKey<Level> dim = shape.shapeDimension;
            long key = rshape.key();
            Map<ResourceKey<Level>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> container = rshape.stageDeux() ? this.labels : this.shapes;
            RenderedShape existing = (RenderedShape)container.computeIfAbsent(dim, d -> new Long2ObjectOpenHashMap()).get(key);
            if (existing != null) {
                existing.promoteWith(rshape);
            } else {
                container.get(dim).put(key, rshape);
            }
        }
    }

    public void reset() {
        this.shapes.values().forEach(Long2ObjectOpenHashMap::clear);
        this.labels.values().forEach(Long2ObjectOpenHashMap::clear);
    }

    public void renewShapes() {
        Runnable token = Carpet.startProfilerSection("Scarpet client");
        this.shapes.values().forEach(el -> el.values().forEach(shape -> ++shape.expiryTick));
        this.labels.values().forEach(el -> el.values().forEach(shape -> ++shape.expiryTick));
        token.run();
    }

    public static void drawLine(Tesselator tesselator, float x1, float y1, float z1, float x2, float y2, float z2, float red1, float grn1, float blu1, float alpha) {
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(x1, y1, z1).setColor(red1, grn1, blu1, alpha);
        builder.addVertex(x2, y2, z2).setColor(red1, grn1, blu1, alpha);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void drawBoxWireGLLines(Tesselator tesselator, float x1, float y1, float z1, float x2, float y2, float z2, boolean xthick, boolean ythick, boolean zthick, float red1, float grn1, float blu1, float alpha, float red2, float grn2, float blu2) {
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        if (xthick) {
            builder.addVertex(x1, y1, z1).setColor(red1, grn2, blu2, alpha);
            builder.addVertex(x2, y1, z1).setColor(red1, grn2, blu2, alpha);
            builder.addVertex(x2, y2, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x1, y2, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x1, y1, z2).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y1, z2).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x1, y2, z2).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y2, z2).setColor(red1, grn1, blu1, alpha);
        }
        if (ythick) {
            builder.addVertex(x1, y1, z1).setColor(red2, grn1, blu2, alpha);
            builder.addVertex(x1, y2, z1).setColor(red2, grn1, blu2, alpha);
            builder.addVertex(x2, y1, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y2, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x1, y2, z2).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x1, y1, z2).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y1, z2).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y2, z2).setColor(red1, grn1, blu1, alpha);
        }
        if (zthick) {
            builder.addVertex(x1, y1, z1).setColor(red2, grn2, blu1, alpha);
            builder.addVertex(x1, y1, z2).setColor(red2, grn2, blu1, alpha);
            builder.addVertex(x1, y2, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x1, y2, z2).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y1, z2).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y1, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y2, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y2, z2).setColor(red1, grn1, blu1, alpha);
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void drawBoxFaces(Tesselator tesselator, float x1, float y1, float z1, float x2, float y2, float z2, boolean xthick, boolean ythick, boolean zthick, float red1, float grn1, float blu1, float alpha) {
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        if (xthick && ythick) {
            builder.addVertex(x1, y1, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y1, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y2, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x1, y2, z1).setColor(red1, grn1, blu1, alpha);
            if (zthick) {
                builder.addVertex(x1, y1, z2).setColor(red1, grn1, blu1, alpha);
                builder.addVertex(x1, y2, z2).setColor(red1, grn1, blu1, alpha);
                builder.addVertex(x2, y2, z2).setColor(red1, grn1, blu1, alpha);
                builder.addVertex(x2, y1, z2).setColor(red1, grn1, blu1, alpha);
            }
        }
        if (zthick && ythick) {
            builder.addVertex(x1, y1, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x1, y2, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x1, y2, z2).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x1, y1, z2).setColor(red1, grn1, blu1, alpha);
            if (xthick) {
                builder.addVertex(x2, y1, z1).setColor(red1, grn1, blu1, alpha);
                builder.addVertex(x2, y1, z2).setColor(red1, grn1, blu1, alpha);
                builder.addVertex(x2, y2, z2).setColor(red1, grn1, blu1, alpha);
                builder.addVertex(x2, y2, z1).setColor(red1, grn1, blu1, alpha);
            }
        }
        if (zthick && xthick) {
            builder.addVertex(x1, y1, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y1, z1).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x2, y1, z2).setColor(red1, grn1, blu1, alpha);
            builder.addVertex(x1, y1, z2).setColor(red1, grn1, blu1, alpha);
            if (ythick) {
                builder.addVertex(x1, y2, z1).setColor(red1, grn1, blu1, alpha);
                builder.addVertex(x2, y2, z1).setColor(red1, grn1, blu1, alpha);
                builder.addVertex(x2, y2, z2).setColor(red1, grn1, blu1, alpha);
                builder.addVertex(x1, y2, z2).setColor(red1, grn1, blu1, alpha);
            }
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void drawCylinderWireframe(Tesselator tesselator, float cx, float cy, float cz, float r, float h, Direction.Axis axis, int subd, boolean isFlat, float red, float grn, float blu, float alpha) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step);
        int hsteps = 1;
        float hstep = 1.0f;
        if (!isFlat) {
            hsteps = (int)Math.ceil(Mth.abs((float)h) / (step * r)) + 1;
            hstep = h / (float)(hsteps - 1);
        }
        if (axis == Direction.Axis.Y) {
            for (int dh = 0; dh < hsteps; ++dh) {
                float hh = (float)dh * hstep;
                BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
                for (int i = 0; i <= num_steps360 + 1; ++i) {
                    float theta = step * (float)i;
                    float x = r * Mth.cos((float)theta);
                    float y = hh;
                    float z = r * Mth.sin((float)theta);
                    builder.addVertex(x + cx, y + cy, z + cz).setColor(red, grn, blu, alpha);
                }
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            }
            if (!isFlat) {
                for (int i = 0; i <= num_steps180; ++i) {
                    BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
                    float theta = step * (float)i;
                    float x = r * Mth.cos((float)theta);
                    z = r * Mth.sin((float)theta);
                    builder.addVertex(cx - x, cy + 0.0f, cz + z).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx + x, cy + 0.0f, cz - z).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx + x, cy + h, cz - z).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx - x, cy + h, cz + z).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx - x, cy + 0.0f, cz + z).setColor(red, grn, blu, alpha);
                    BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
                }
            } else {
                BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
                for (int i = 0; i <= num_steps180; ++i) {
                    float theta = step * (float)i;
                    float x = r * Mth.cos((float)theta);
                    z = r * Mth.sin((float)theta);
                    builder.addVertex(cx - x, cy, cz + z).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx + x, cy, cz - z).setColor(red, grn, blu, alpha);
                }
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            }
        } else if (axis == Direction.Axis.X) {
            for (int dh = 0; dh < hsteps; ++dh) {
                float hh = (float)dh * hstep;
                BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
                for (int i = 0; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float z = r * Mth.cos((float)theta);
                    float x = hh;
                    float y = r * Mth.sin((float)theta);
                    builder.addVertex(x + cx, y + cy, z + cz).setColor(red, grn, blu, alpha);
                }
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            }
            if (!isFlat) {
                for (int i = 0; i <= num_steps180; ++i) {
                    BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
                    float theta = step * (float)i;
                    float y = r * Mth.cos((float)theta);
                    z = r * Mth.sin((float)theta);
                    builder.addVertex(cx + 0.0f, cy - y, cz + z).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx + 0.0f, cy + y, cz - z).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx + h, cy + y, cz - z).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx + h, cy - y, cz + z).setColor(red, grn, blu, alpha);
                    BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
                }
            } else {
                BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
                for (int i = 0; i <= num_steps180; ++i) {
                    float theta = step * (float)i;
                    float y = r * Mth.cos((float)theta);
                    z = r * Mth.sin((float)theta);
                    builder.addVertex(cx, cy - y, cz + z).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx, cy + y, cz - z).setColor(red, grn, blu, alpha);
                }
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            }
        } else if (axis == Direction.Axis.Z) {
            for (int dh = 0; dh < hsteps; ++dh) {
                float hh = (float)dh * hstep;
                BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
                for (int i = 0; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float y = r * Mth.cos((float)theta);
                    float z = hh;
                    float x = r * Mth.sin((float)theta);
                    builder.addVertex(x + cx, y + cy, z + cz).setColor(red, grn, blu, alpha);
                }
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            }
            if (!isFlat) {
                for (int i = 0; i <= num_steps180; ++i) {
                    BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
                    float theta = step * (float)i;
                    float x = r * Mth.cos((float)theta);
                    y = r * Mth.sin((float)theta);
                    builder.addVertex(cx + x, cy - y, cz + 0.0f).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx - x, cy + y, cz + 0.0f).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx - x, cy + y, cz + h).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx + x, cy - y, cz + h).setColor(red, grn, blu, alpha);
                    BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
                }
            } else {
                BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
                for (int i = 0; i <= num_steps180; ++i) {
                    float theta = step * (float)i;
                    float x = r * Mth.cos((float)theta);
                    y = r * Mth.sin((float)theta);
                    builder.addVertex(cx + x, cy - y, cz).setColor(red, grn, blu, alpha);
                    builder.addVertex(cx - x, cy + y, cz).setColor(red, grn, blu, alpha);
                }
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            }
        }
    }

    public static void drawCylinderFaces(Tesselator tesselator, float cx, float cy, float cz, float r, float h, Direction.Axis axis, int subd, boolean isFlat, float red, float grn, float blu, float alpha) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps360 = (int)(Math.PI * 2 / (double)step) + 1;
        if (axis == Direction.Axis.Y) {
            BufferBuilder builder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            builder.addVertex(cx, cy, cz).setColor(red, grn, blu, alpha);
            for (int i = 0; i <= num_steps360; ++i) {
                float theta = step * (float)i;
                float x = r * Mth.cos((float)theta);
                float z = r * Mth.sin((float)theta);
                builder.addVertex(x + cx, cy, z + cz).setColor(red, grn, blu, alpha);
            }
            BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            if (!isFlat) {
                BufferBuilder builderr = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                builderr.addVertex(cx, cy + h, cz).setColor(red, grn, blu, alpha);
                for (int i = 0; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float x = r * Mth.cos((float)theta);
                    float z = r * Mth.sin((float)theta);
                    builderr.addVertex(x + cx, cy + h, z + cz).setColor(red, grn, blu, alpha);
                }
                BufferUploader.drawWithShader((MeshData)builderr.buildOrThrow());
                BufferBuilder builderrr = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
                float xp = r * 1.0f;
                float zp = r * 0.0f;
                for (int i = 1; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float x = r * Mth.cos((float)theta);
                    float z = r * Mth.sin((float)theta);
                    builderrr.addVertex(cx + xp, cy + 0.0f, cz + zp).setColor(red, grn, blu, alpha);
                    builderrr.addVertex(cx + xp, cy + h, cz + zp).setColor(red, grn, blu, alpha);
                    builderrr.addVertex(cx + x, cy + h, cz + z).setColor(red, grn, blu, alpha);
                    builderrr.addVertex(cx + x, cy + 0.0f, cz + z).setColor(red, grn, blu, alpha);
                    xp = x;
                    zp = z;
                }
                BufferUploader.drawWithShader((MeshData)builderrr.buildOrThrow());
            }
        } else if (axis == Direction.Axis.X) {
            BufferBuilder builder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            builder.addVertex(cx, cy, cz).setColor(red, grn, blu, alpha);
            for (int i = 0; i <= num_steps360; ++i) {
                float theta = step * (float)i;
                float y = r * Mth.cos((float)theta);
                float z = r * Mth.sin((float)theta);
                builder.addVertex(cx, cy + y, z + cz).setColor(red, grn, blu, alpha);
            }
            BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            if (!isFlat) {
                BufferBuilder builderr = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                builderr.addVertex(cx + h, cy, cz).setColor(red, grn, blu, alpha);
                for (int i = 0; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float y = r * Mth.cos((float)theta);
                    float z = r * Mth.sin((float)theta);
                    builderr.addVertex(cx + h, cy + y, cz + z).setColor(red, grn, blu, alpha);
                }
                BufferUploader.drawWithShader((MeshData)builderr.buildOrThrow());
                BufferBuilder builderrr = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
                float yp = r * 1.0f;
                float zp = r * 0.0f;
                for (int i = 1; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float y = r * Mth.cos((float)theta);
                    float z = r * Mth.sin((float)theta);
                    builderrr.addVertex(cx + 0.0f, cy + yp, cz + zp).setColor(red, grn, blu, alpha);
                    builderrr.addVertex(cx + h, cy + yp, cz + zp).setColor(red, grn, blu, alpha);
                    builderrr.addVertex(cx + h, cy + y, cz + z).setColor(red, grn, blu, alpha);
                    builderrr.addVertex(cx + 0.0f, cy + y, cz + z).setColor(red, grn, blu, alpha);
                    yp = y;
                    zp = z;
                }
                BufferUploader.drawWithShader((MeshData)builderrr.buildOrThrow());
            }
        } else if (axis == Direction.Axis.Z) {
            BufferBuilder builder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            builder.addVertex(cx, cy, cz).setColor(red, grn, blu, alpha);
            for (int i = 0; i <= num_steps360; ++i) {
                float theta = step * (float)i;
                float x = r * Mth.cos((float)theta);
                float y = r * Mth.sin((float)theta);
                builder.addVertex(x + cx, cy + y, cz).setColor(red, grn, blu, alpha);
            }
            BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            if (!isFlat) {
                BufferBuilder builderr = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                builderr.addVertex(cx, cy, cz + h).setColor(red, grn, blu, alpha);
                for (int i = 0; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float x = r * Mth.cos((float)theta);
                    float y = r * Mth.sin((float)theta);
                    builderr.addVertex(x + cx, cy + y, cz + h).setColor(red, grn, blu, alpha);
                }
                BufferUploader.drawWithShader((MeshData)builderr.buildOrThrow());
                BufferBuilder builderrr = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
                float xp = r;
                float yp = 0.0f;
                for (int i = 1; i <= num_steps360; ++i) {
                    float theta = step * (float)i;
                    float x = r * Mth.cos((float)theta);
                    float y = r * Mth.sin((float)theta);
                    builderrr.addVertex(cx + xp, cy + yp, cz + 0.0f).setColor(red, grn, blu, alpha);
                    builderrr.addVertex(cx + xp, cy + yp, cz + h).setColor(red, grn, blu, alpha);
                    builderrr.addVertex(cx + x, cy + y, cz + h).setColor(red, grn, blu, alpha);
                    builderrr.addVertex(cx + x, cy + y, cz + 0.0f).setColor(red, grn, blu, alpha);
                    xp = x;
                    yp = y;
                }
                BufferUploader.drawWithShader((MeshData)builderrr.buildOrThrow());
            }
        }
    }

    public static void drawSphereWireframe(Tesselator tesselator, float cx, float cy, float cz, float r, int subd, float red, float grn, float blu, float alpha) {
        float y;
        float z;
        float x;
        BufferBuilder builder;
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step) + 1;
        for (int i = 0; i <= num_steps360; ++i) {
            builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            float theta = step * (float)i;
            for (int j = 0; j <= num_steps180; ++j) {
                float phi = step * (float)j;
                x = r * Mth.sin((float)phi) * Mth.cos((float)theta);
                z = r * Mth.sin((float)phi) * Mth.sin((float)theta);
                y = r * Mth.cos((float)phi);
                builder.addVertex(x + cx, y + cy, z + cz).setColor(red, grn, blu, alpha);
            }
            BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        }
        for (int j = 0; j <= num_steps180; ++j) {
            builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            float phi = step * (float)j;
            for (int i = 0; i <= num_steps360; ++i) {
                float theta = step * (float)i;
                x = r * Mth.sin((float)phi) * Mth.cos((float)theta);
                z = r * Mth.sin((float)phi) * Mth.sin((float)theta);
                y = r * Mth.cos((float)phi);
                builder.addVertex(x + cx, y + cy, z + cz).setColor(red, grn, blu, alpha);
            }
            BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        }
    }

    public static void drawSphereFaces(Tesselator tesselator, float cx, float cy, float cz, float r, int subd, float red, float grn, float blu, float alpha) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step);
        for (int i = 0; i <= num_steps360; ++i) {
            float theta = (float)i * step;
            float thetaprime = theta + step;
            BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            float xb = 0.0f;
            float zb = 0.0f;
            float xbp = 0.0f;
            float zbp = 0.0f;
            float yp = r;
            for (int j = 0; j <= num_steps180; ++j) {
                float phi = (float)j * step;
                float x = r * Mth.sin((float)phi) * Mth.cos((float)theta);
                float z = r * Mth.sin((float)phi) * Mth.sin((float)theta);
                float y = r * Mth.cos((float)phi);
                float xp = r * Mth.sin((float)phi) * Mth.cos((float)thetaprime);
                float zp = r * Mth.sin((float)phi) * Mth.sin((float)thetaprime);
                builder.addVertex(xb + cx, yp + cy, zb + cz).setColor(red, grn, blu, alpha);
                builder.addVertex(xbp + cx, yp + cy, zbp + cz).setColor(red, grn, blu, alpha);
                builder.addVertex(xp + cx, y + cy, zp + cz).setColor(red, grn, blu, alpha);
                builder.addVertex(x + cx, y + cy, z + cz).setColor(red, grn, blu, alpha);
                xb = x;
                zb = z;
                xbp = xp;
                zbp = zp;
                yp = y;
            }
            BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        }
    }

    public static abstract class RenderedShape<T extends ShapeDispatcher.ExpiringShape> {
        protected T shape;
        protected Minecraft client;
        long expiryTick;
        double renderEpsilon;

        public abstract void renderLines(PoseStack var1, Tesselator var2, double var3, double var5, double var7, float var9);

        public void renderFaces(Tesselator tesselator, double cx, double cy, double cz, float partialTick) {
        }

        protected RenderedShape(Minecraft client, T shape) {
            this.shape = shape;
            this.client = client;
            this.expiryTick = client.level.getGameTime() + (long)((ShapeDispatcher.ExpiringShape)shape).getExpiry();
            this.renderEpsilon = (3.0 + (double)this.key() / 9.223372036854776E18) / 1000.0;
        }

        public boolean isExpired(long currentTick) {
            return this.expiryTick < currentTick;
        }

        public long key() {
            return ((ShapeDispatcher.ExpiringShape)this.shape).key(this.client.level.registryAccess());
        }

        public boolean shouldRender(ResourceKey<Level> dim) {
            if (((ShapeDispatcher.ExpiringShape)this.shape).followEntity <= 0) {
                return true;
            }
            if (this.client.level == null) {
                return false;
            }
            if (this.client.level.dimension() != dim) {
                return false;
            }
            return this.client.level.getEntity(((ShapeDispatcher.ExpiringShape)this.shape).followEntity) != null;
        }

        public boolean stageDeux() {
            return false;
        }

        public void promoteWith(RenderedShape<?> rshape) {
            this.expiryTick = rshape.expiryTick;
        }
    }

    public static class RenderedCylinder
    extends RenderedShape<ShapeDispatcher.Cylinder> {
        public RenderedCylinder(Minecraft client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Cylinder)shape);
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tesselator, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Cylinder)this.shape).a == 0.0) {
                return;
            }
            Vec3 vc = ((ShapeDispatcher.Cylinder)this.shape).relativiseRender((Level)this.client.level, ((ShapeDispatcher.Cylinder)this.shape).center, partialTick);
            double dir = Mth.sign((double)((ShapeDispatcher.Cylinder)this.shape).height);
            ShapesRenderer.drawCylinderWireframe(tesselator, (float)(vc.x - cx - dir * this.renderEpsilon), (float)(vc.y - cy - dir * this.renderEpsilon), (float)(vc.z - cz - dir * this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).radius + this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).height + 2.0 * dir * this.renderEpsilon), ((ShapeDispatcher.Cylinder)this.shape).axis, ((ShapeDispatcher.Cylinder)this.shape).subdivisions, ((ShapeDispatcher.Cylinder)this.shape).radius == 0.0f, ((ShapeDispatcher.Cylinder)this.shape).r, ((ShapeDispatcher.Cylinder)this.shape).g, ((ShapeDispatcher.Cylinder)this.shape).b, ((ShapeDispatcher.Cylinder)this.shape).a);
        }

        @Override
        public void renderFaces(Tesselator tesselator, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Cylinder)this.shape).fa == 0.0) {
                return;
            }
            Vec3 vc = ((ShapeDispatcher.Cylinder)this.shape).relativiseRender((Level)this.client.level, ((ShapeDispatcher.Cylinder)this.shape).center, partialTick);
            double dir = Mth.sign((double)((ShapeDispatcher.Cylinder)this.shape).height);
            ShapesRenderer.drawCylinderFaces(tesselator, (float)(vc.x - cx - dir * this.renderEpsilon), (float)(vc.y - cy - dir * this.renderEpsilon), (float)(vc.z - cz - dir * this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).radius + this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).height + 2.0 * dir * this.renderEpsilon), ((ShapeDispatcher.Cylinder)this.shape).axis, ((ShapeDispatcher.Cylinder)this.shape).subdivisions, ((ShapeDispatcher.Cylinder)this.shape).radius == 0.0f, ((ShapeDispatcher.Cylinder)this.shape).fr, ((ShapeDispatcher.Cylinder)this.shape).fg, ((ShapeDispatcher.Cylinder)this.shape).fb, ((ShapeDispatcher.Cylinder)this.shape).fa);
        }
    }

    public static class RenderedSphere
    extends RenderedShape<ShapeDispatcher.Sphere> {
        public RenderedSphere(Minecraft client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Sphere)shape);
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tesselator, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Sphere)this.shape).a == 0.0) {
                return;
            }
            Vec3 vc = ((ShapeDispatcher.Sphere)this.shape).relativiseRender((Level)this.client.level, ((ShapeDispatcher.Sphere)this.shape).center, partialTick);
            ShapesRenderer.drawSphereWireframe(tesselator, (float)(vc.x - cx), (float)(vc.y - cy), (float)(vc.z - cz), (float)((double)((ShapeDispatcher.Sphere)this.shape).radius + this.renderEpsilon), ((ShapeDispatcher.Sphere)this.shape).subdivisions, ((ShapeDispatcher.Sphere)this.shape).r, ((ShapeDispatcher.Sphere)this.shape).g, ((ShapeDispatcher.Sphere)this.shape).b, ((ShapeDispatcher.Sphere)this.shape).a);
        }

        @Override
        public void renderFaces(Tesselator tesselator, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Sphere)this.shape).fa == 0.0) {
                return;
            }
            Vec3 vc = ((ShapeDispatcher.Sphere)this.shape).relativiseRender((Level)this.client.level, ((ShapeDispatcher.Sphere)this.shape).center, partialTick);
            ShapesRenderer.drawSphereFaces(tesselator, (float)(vc.x - cx), (float)(vc.y - cy), (float)(vc.z - cz), (float)((double)((ShapeDispatcher.Sphere)this.shape).radius + this.renderEpsilon), ((ShapeDispatcher.Sphere)this.shape).subdivisions, ((ShapeDispatcher.Sphere)this.shape).fr, ((ShapeDispatcher.Sphere)this.shape).fg, ((ShapeDispatcher.Sphere)this.shape).fb, ((ShapeDispatcher.Sphere)this.shape).fa);
        }
    }

    public static class RenderedPolyface
    extends RenderedShape<ShapeDispatcher.Polyface> {
        private static final VertexFormat.Mode[] faceIndices = new VertexFormat.Mode[]{VertexFormat.Mode.LINES, VertexFormat.Mode.LINE_STRIP, VertexFormat.Mode.DEBUG_LINES, VertexFormat.Mode.DEBUG_LINE_STRIP, VertexFormat.Mode.TRIANGLES, VertexFormat.Mode.TRIANGLE_STRIP, VertexFormat.Mode.TRIANGLE_FAN, VertexFormat.Mode.QUADS};

        public RenderedPolyface(Minecraft client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Polyface)shape);
        }

        @Override
        public void renderFaces(Tesselator tesselator, double cx, double cy, double cz, float partialTick) {
            if (((ShapeDispatcher.Polyface)this.shape).fa == 0.0f) {
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).doublesided) {
                RenderSystem.disableCull();
            } else {
                RenderSystem.enableCull();
            }
            BufferBuilder builder = tesselator.begin(faceIndices[((ShapeDispatcher.Polyface)this.shape).mode], DefaultVertexFormat.POSITION_COLOR);
            for (int i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); ++i) {
                Vec3 vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.level, vec, partialTick);
                }
                builder.addVertex((float)(vec.x() - cx), (float)(vec.y() - cy), (float)(vec.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).fr, ((ShapeDispatcher.Polyface)this.shape).fg, ((ShapeDispatcher.Polyface)this.shape).fb, ((ShapeDispatcher.Polyface)this.shape).fa);
            }
            BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)false);
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tesselator, double cx, double cy, double cz, float partialTick) {
            if (((ShapeDispatcher.Polyface)this.shape).a == 0.0f) {
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).mode == 6) {
                BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
                Vec3 vec0 = null;
                for (int i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); ++i) {
                    Vec3 vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.level, vec, partialTick);
                    }
                    if (i == 0) {
                        vec0 = vec;
                    }
                    builder.addVertex((float)(vec.x() - cx), (float)(vec.y() - cy), (float)(vec.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                }
                builder.addVertex((float)(vec0.x() - cx), (float)(vec0.y() - cy), (float)(vec0.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
                if (((ShapeDispatcher.Polyface)this.shape).inneredges) {
                    BufferBuilder builderr = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
                    for (int i = 1; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size() - 1; ++i) {
                        Vec3 vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                        if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                            vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.level, vec, partialTick);
                        }
                        builderr.addVertex((float)(vec.x() - cx), (float)(vec.y() - cy), (float)(vec.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                        builderr.addVertex((float)(vec0.x() - cx), (float)(vec0.y() - cy), (float)(vec0.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                    }
                    BufferUploader.drawWithShader((MeshData)builderr.buildOrThrow());
                }
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).mode == 5) {
                int i;
                BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
                Vec3 vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(1);
                if (((ShapeDispatcher.Polyface)this.shape).relative.get(1).booleanValue()) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.level, vec, partialTick);
                }
                builder.addVertex((float)(vec.x() - cx), (float)(vec.y() - cy), (float)(vec.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                for (i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); i += 2) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.level, vec, partialTick);
                    }
                    builder.addVertex((float)(vec.x() - cx), (float)(vec.y() - cy), (float)(vec.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                }
                i = ((ShapeDispatcher.Polyface)this.shape).vertexList.size() - 1;
                i -= 1 - i % 2;
                while (i > 0) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.level, vec, partialTick);
                    }
                    builder.addVertex((float)(vec.x() - cx), (float)(vec.y() - cy), (float)(vec.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                    i -= 2;
                }
                if (((ShapeDispatcher.Polyface)this.shape).inneredges) {
                    for (i = 2; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size() - 1; ++i) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                        if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                            vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.level, vec, partialTick);
                        }
                        builder.addVertex((float)(vec.x() - cx), (float)(vec.y() - cy), (float)(vec.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                    }
                }
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).mode == 4) {
                BufferBuilder builder = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
                for (int i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); ++i) {
                    Vec3 vecA = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vecA = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.level, vecA, partialTick);
                    }
                    Vec3 vecB = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(++i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vecB = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.level, vecB, partialTick);
                    }
                    Vec3 vecC = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(++i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vecC = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((Level)this.client.level, vecC, partialTick);
                    }
                    builder.addVertex((float)(vecA.x() - cx), (float)(vecA.y() - cy), (float)(vecA.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                    builder.addVertex((float)(vecB.x() - cx), (float)(vecB.y() - cy), (float)(vecB.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                    builder.addVertex((float)(vecB.x() - cx), (float)(vecB.y() - cy), (float)(vecB.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                    builder.addVertex((float)(vecC.x() - cx), (float)(vecC.y() - cy), (float)(vecC.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                    builder.addVertex((float)(vecC.x() - cx), (float)(vecC.y() - cy), (float)(vecC.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                    builder.addVertex((float)(vecA.x() - cx), (float)(vecA.y() - cy), (float)(vecA.z() - cz)).setColor(((ShapeDispatcher.Polyface)this.shape).r, ((ShapeDispatcher.Polyface)this.shape).g, ((ShapeDispatcher.Polyface)this.shape).b, ((ShapeDispatcher.Polyface)this.shape).a);
                }
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
            }
        }
    }

    public static class RenderedLine
    extends RenderedShape<ShapeDispatcher.Line> {
        public RenderedLine(Minecraft client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Line)shape);
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tesselator, double cx, double cy, double cz, float partialTick) {
            Vec3 v1 = ((ShapeDispatcher.Line)this.shape).relativiseRender((Level)this.client.level, ((ShapeDispatcher.Line)this.shape).from, partialTick);
            Vec3 v2 = ((ShapeDispatcher.Line)this.shape).relativiseRender((Level)this.client.level, ((ShapeDispatcher.Line)this.shape).to, partialTick);
            ShapesRenderer.drawLine(tesselator, (float)(v1.x - cx - this.renderEpsilon), (float)(v1.y - cy - this.renderEpsilon), (float)(v1.z - cz - this.renderEpsilon), (float)(v2.x - cx + this.renderEpsilon), (float)(v2.y - cy + this.renderEpsilon), (float)(v2.z - cz + this.renderEpsilon), ((ShapeDispatcher.Line)this.shape).r, ((ShapeDispatcher.Line)this.shape).g, ((ShapeDispatcher.Line)this.shape).b, ((ShapeDispatcher.Line)this.shape).a);
        }
    }

    public static class RenderedBox
    extends RenderedShape<ShapeDispatcher.Box> {
        private RenderedBox(Minecraft client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Box)shape);
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tesselator, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Box)this.shape).a == 0.0) {
                return;
            }
            Vec3 v1 = ((ShapeDispatcher.Box)this.shape).relativiseRender((Level)this.client.level, ((ShapeDispatcher.Box)this.shape).from, partialTick);
            Vec3 v2 = ((ShapeDispatcher.Box)this.shape).relativiseRender((Level)this.client.level, ((ShapeDispatcher.Box)this.shape).to, partialTick);
            ShapesRenderer.drawBoxWireGLLines(tesselator, (float)(v1.x - cx - this.renderEpsilon), (float)(v1.y - cy - this.renderEpsilon), (float)(v1.z - cz - this.renderEpsilon), (float)(v2.x - cx + this.renderEpsilon), (float)(v2.y - cy + this.renderEpsilon), (float)(v2.z - cz + this.renderEpsilon), v1.x != v2.x, v1.y != v2.y, v1.z != v2.z, ((ShapeDispatcher.Box)this.shape).r, ((ShapeDispatcher.Box)this.shape).g, ((ShapeDispatcher.Box)this.shape).b, ((ShapeDispatcher.Box)this.shape).a, ((ShapeDispatcher.Box)this.shape).r, ((ShapeDispatcher.Box)this.shape).g, ((ShapeDispatcher.Box)this.shape).b);
        }

        @Override
        public void renderFaces(Tesselator tesselator, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.Box)this.shape).fa == 0.0) {
                return;
            }
            Vec3 v1 = ((ShapeDispatcher.Box)this.shape).relativiseRender((Level)this.client.level, ((ShapeDispatcher.Box)this.shape).from, partialTick);
            Vec3 v2 = ((ShapeDispatcher.Box)this.shape).relativiseRender((Level)this.client.level, ((ShapeDispatcher.Box)this.shape).to, partialTick);
            ShapesRenderer.drawBoxFaces(tesselator, (float)(v1.x - cx - this.renderEpsilon), (float)(v1.y - cy - this.renderEpsilon), (float)(v1.z - cz - this.renderEpsilon), (float)(v2.x - cx + this.renderEpsilon), (float)(v2.y - cy + this.renderEpsilon), (float)(v2.z - cz + this.renderEpsilon), v1.x != v2.x, v1.y != v2.y, v1.z != v2.z, ((ShapeDispatcher.Box)this.shape).fr, ((ShapeDispatcher.Box)this.shape).fg, ((ShapeDispatcher.Box)this.shape).fb, ((ShapeDispatcher.Box)this.shape).fa);
        }
    }

    public static class RenderedText
    extends RenderedShape<ShapeDispatcher.DisplayedText> {
        protected RenderedText(Minecraft client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.DisplayedText)shape);
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tesselator, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.DisplayedText)this.shape).a == 0.0) {
                return;
            }
            Vec3 v1 = ((ShapeDispatcher.DisplayedText)this.shape).relativiseRender((Level)this.client.level, ((ShapeDispatcher.DisplayedText)this.shape).pos, partialTick);
            Camera camera1 = this.client.gameRenderer.getMainCamera();
            Font textRenderer = this.client.font;
            if (((ShapeDispatcher.DisplayedText)this.shape).doublesided) {
                RenderSystem.disableCull();
            } else {
                RenderSystem.enableCull();
            }
            matrices.pushPose();
            matrices.translate(v1.x - cx, v1.y - cy, v1.z - cz);
            ShapesRenderer.rotatePoseStackByShapeDirection(matrices, ((ShapeDispatcher.DisplayedText)this.shape).facing, camera1, v1);
            matrices.scale(((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f, -((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f, ((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f);
            if (((ShapeDispatcher.DisplayedText)this.shape).tilt != 0.0f) {
                matrices.mulPose(Axis.ZP.rotationDegrees(((ShapeDispatcher.DisplayedText)this.shape).tilt));
            }
            if (((ShapeDispatcher.DisplayedText)this.shape).lean != 0.0f) {
                matrices.mulPose(Axis.XP.rotationDegrees(((ShapeDispatcher.DisplayedText)this.shape).lean));
            }
            if (((ShapeDispatcher.DisplayedText)this.shape).turn != 0.0f) {
                matrices.mulPose(Axis.YP.rotationDegrees(((ShapeDispatcher.DisplayedText)this.shape).turn));
            }
            matrices.translate((double)(-10.0f * ((ShapeDispatcher.DisplayedText)this.shape).indent), (double)(-10.0f * ((ShapeDispatcher.DisplayedText)this.shape).height - 9.0f), -10.0 * this.renderEpsilon - (double)(10.0f * ((ShapeDispatcher.DisplayedText)this.shape).raise));
            matrices.scale(-1.0f, 1.0f, 1.0f);
            float text_x = 0.0f;
            if (((ShapeDispatcher.DisplayedText)this.shape).align == 0) {
                text_x = (float)(-textRenderer.width(((ShapeDispatcher.DisplayedText)this.shape).value.getString())) / 2.0f;
            } else if (((ShapeDispatcher.DisplayedText)this.shape).align == 1) {
                text_x = -textRenderer.width(((ShapeDispatcher.DisplayedText)this.shape).value.getString());
            }
            MultiBufferSource.BufferSource immediate = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
            textRenderer.drawInBatch(((ShapeDispatcher.DisplayedText)this.shape).value, text_x, 0.0f, ((ShapeDispatcher.DisplayedText)this.shape).textcolor, false, matrices.last().pose(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, ((ShapeDispatcher.DisplayedText)this.shape).textbck, 0xF000F0);
            immediate.endBatch();
            matrices.popPose();
            RenderSystem.enableCull();
        }

        @Override
        public boolean stageDeux() {
            return true;
        }

        @Override
        public void promoteWith(RenderedShape<?> rshape) {
            super.promoteWith(rshape);
            try {
                ((ShapeDispatcher.DisplayedText)this.shape).value = ((ShapeDispatcher.DisplayedText)rshape.shape).value;
            }
            catch (ClassCastException ignored) {
                CarpetScriptServer.LOG.error("shape " + String.valueOf(rshape.shape.getClass()) + " cannot cast to a Label");
            }
        }
    }

    public static class RenderedSprite
    extends RenderedShape<ShapeDispatcher.DisplayedSprite> {
        private final boolean isitem;
        private ItemDisplayContext transformType = ItemDisplayContext.NONE;
        private BlockPos blockPos;
        private BlockState blockState;
        private BlockEntity BlockEntity = null;

        protected RenderedSprite(Minecraft client, ShapeDispatcher.ExpiringShape shape, boolean isitem) {
            super(client, (ShapeDispatcher.DisplayedSprite)shape);
            this.isitem = isitem;
            if (isitem) {
                this.transformType = ItemDisplayContext.valueOf((String)((ShapeDispatcher.DisplayedSprite)shape).itemTransformType.toUpperCase(Locale.ROOT));
            }
        }

        @Override
        public void renderLines(PoseStack matrices, Tesselator tesselator, double cx, double cy, double cz, float partialTick) {
            if ((double)((ShapeDispatcher.DisplayedSprite)this.shape).a == 0.0) {
                return;
            }
            Vec3 v1 = ((ShapeDispatcher.DisplayedSprite)this.shape).relativiseRender((Level)this.client.level, ((ShapeDispatcher.DisplayedSprite)this.shape).pos, partialTick);
            Camera camera1 = this.client.gameRenderer.getMainCamera();
            matrices.pushPose();
            if (!this.isitem) {
                matrices.translate(0.5, 0.5, 0.5);
            }
            matrices.translate(v1.x - cx, v1.y - cy, v1.z - cz);
            ShapesRenderer.rotatePoseStackByShapeDirection(matrices, ((ShapeDispatcher.DisplayedSprite)this.shape).facing, camera1, this.isitem ? v1 : v1.add(0.5, 0.5, 0.5));
            if (((ShapeDispatcher.DisplayedSprite)this.shape).tilt != 0.0f) {
                matrices.mulPose(Axis.ZP.rotationDegrees(-((ShapeDispatcher.DisplayedSprite)this.shape).tilt));
            }
            if (((ShapeDispatcher.DisplayedSprite)this.shape).lean != 0.0f) {
                matrices.mulPose(Axis.XP.rotationDegrees(-((ShapeDispatcher.DisplayedSprite)this.shape).lean));
            }
            if (((ShapeDispatcher.DisplayedSprite)this.shape).turn != 0.0f) {
                matrices.mulPose(Axis.YP.rotationDegrees(((ShapeDispatcher.DisplayedSprite)this.shape).turn));
            }
            matrices.scale(((ShapeDispatcher.DisplayedSprite)this.shape).scaleX, ((ShapeDispatcher.DisplayedSprite)this.shape).scaleY, ((ShapeDispatcher.DisplayedSprite)this.shape).scaleZ);
            if (!this.isitem) {
                matrices.translate(-0.5, -0.5, -0.5);
            } else {
                matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            this.blockPos = BlockPos.containing((Position)v1);
            int light = 0;
            if (this.client.level != null) {
                light = LightTexture.pack((int)(((ShapeDispatcher.DisplayedSprite)this.shape).blockLight < 0 ? this.client.level.getBrightness(LightLayer.BLOCK, this.blockPos) : ((ShapeDispatcher.DisplayedSprite)this.shape).blockLight), (int)(((ShapeDispatcher.DisplayedSprite)this.shape).skyLight < 0 ? this.client.level.getBrightness(LightLayer.SKY, this.blockPos) : ((ShapeDispatcher.DisplayedSprite)this.shape).skyLight));
            }
            this.blockState = ((ShapeDispatcher.DisplayedSprite)this.shape).blockState;
            MultiBufferSource.BufferSource immediate = this.client.renderBuffers().bufferSource();
            if (!this.isitem) {
                BlockEntityRenderer blockEntityRenderer;
                BlockEntity color22;
                Block color22;
                if (this.blockState.getRenderShape() == RenderShape.MODEL) {
                    BakedModel bakedModel = this.client.getBlockRenderer().getBlockModel(this.blockState);
                    int color22 = this.client.getBlockColors().getColor(this.blockState, (BlockAndTintGetter)this.client.level, this.blockPos, 0);
                    float red = (float)(color22 >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color22 >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color22 & 0xFF) / 255.0f;
                    RenderType type = this.blockState.getBlock() instanceof LeavesBlock && !Minecraft.useFancyGraphics() ? RenderType.solid() : ItemBlockRenderTypes.getRenderType((BlockState)this.blockState, (boolean)false);
                    this.client.getBlockRenderer().getModelRenderer().renderModel(matrices.last(), immediate.getBuffer(type), this.blockState, bakedModel, red, green, blue, light, OverlayTexture.NO_OVERLAY);
                }
                if (this.BlockEntity == null && (color22 = this.blockState.getBlock()) instanceof EntityBlock) {
                    EntityBlock eb = (EntityBlock)color22;
                    this.BlockEntity = eb.newBlockEntity(this.blockPos, this.blockState);
                    if (this.BlockEntity != null) {
                        this.BlockEntity.setLevel((Level)this.client.level);
                        if (((ShapeDispatcher.DisplayedSprite)this.shape).blockEntity != null) {
                            this.BlockEntity.loadWithComponents(((ShapeDispatcher.DisplayedSprite)this.shape).blockEntity, (HolderLookup.Provider)this.client.level.registryAccess());
                        }
                    }
                }
                if ((color22 = this.BlockEntity) instanceof ShulkerBoxBlockEntity) {
                    ShulkerBoxBlockEntity sbBlockEntity = (ShulkerBoxBlockEntity)color22;
                    this.sbrender(sbBlockEntity, partialTick, matrices, (MultiBufferSource)immediate, light, OverlayTexture.NO_OVERLAY);
                } else if (this.BlockEntity != null && (blockEntityRenderer = this.client.getBlockEntityRenderDispatcher().getRenderer(this.BlockEntity)) != null) {
                    blockEntityRenderer.render(this.BlockEntity, partialTick, matrices, (MultiBufferSource)immediate, light, OverlayTexture.NO_OVERLAY);
                }
            } else if (((ShapeDispatcher.DisplayedSprite)this.shape).item != null) {
                this.client.getItemRenderer().renderStatic(((ShapeDispatcher.DisplayedSprite)this.shape).item, this.transformType, light, OverlayTexture.NO_OVERLAY, matrices, (MultiBufferSource)immediate, (Level)this.client.level, (int)((ShapeDispatcher.DisplayedSprite)this.shape).key(this.client.level.registryAccess()));
            }
            matrices.popPose();
            immediate.endBatch();
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
        }

        @Override
        public boolean stageDeux() {
            return true;
        }

        public void sbrender(ShulkerBoxBlockEntity shulkerBoxBlockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
            DyeColor dyeColor;
            BlockState blockState;
            Direction direction = Direction.UP;
            if (shulkerBoxBlockEntity.hasLevel() && (blockState = shulkerBoxBlockEntity.getBlockState()).getBlock() instanceof ShulkerBoxBlock) {
                direction = (Direction)blockState.getValue((Property)ShulkerBoxBlock.FACING);
            }
            Material material = (dyeColor = shulkerBoxBlockEntity.getColor()) == null ? Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION : (Material)Sheets.SHULKER_TEXTURE_LOCATION.get(dyeColor.getId());
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.scale(0.9995f, 0.9995f, 0.9995f);
            poseStack.mulPose(direction.getRotation());
            poseStack.scale(1.0f, -1.0f, -1.0f);
            poseStack.translate(0.0, -1.0, 0.0);
            ShulkerModel<?> model = VanillaClient.ShulkerBoxRenderer_model((BlockEntityRenderer<ShulkerBoxBlockEntity>)this.client.getBlockEntityRenderDispatcher().getRenderer((BlockEntity)shulkerBoxBlockEntity));
            ModelPart modelPart = model.getLid();
            modelPart.setPos(0.0f, 24.0f - shulkerBoxBlockEntity.getProgress(f) * 0.5f * 16.0f, 0.0f);
            modelPart.yRot = 270.0f * shulkerBoxBlockEntity.getProgress(f) * ((float)Math.PI / 180);
            VertexConsumer vertexConsumer = material.buffer(multiBufferSource, RenderType::entityCutoutNoCull);
            model.renderToBuffer(poseStack, vertexConsumer, i, j, -1);
            poseStack.popPose();
        }
    }
}

