/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetSettings;
import carpet.utils.EvictingQueue;
import carpet.utils.Messenger;
import carpet.utils.WoolTool;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SpawnReporter {
    private static final MobCategory[] CACHED_MOBCATEGORY_VALUES = MobCategory.values();
    public static boolean mockSpawns = false;
    public static final HashMap<ResourceKey<Level>, Integer> chunkCounts = new HashMap();
    public static final HashMap<Pair<ResourceKey<Level>, MobCategory>, Object2LongOpenHashMap<EntityType<?>>> spawn_stats = new HashMap();
    public static double mobcap_exponent = 0.0;
    public static final Object2LongOpenHashMap<Pair<ResourceKey<Level>, MobCategory>> spawn_attempts = new Object2LongOpenHashMap();
    public static final Object2LongOpenHashMap<Pair<ResourceKey<Level>, MobCategory>> overall_spawn_ticks = new Object2LongOpenHashMap();
    public static final Object2LongOpenHashMap<Pair<ResourceKey<Level>, MobCategory>> spawn_ticks_full = new Object2LongOpenHashMap();
    public static final Object2LongOpenHashMap<Pair<ResourceKey<Level>, MobCategory>> spawn_ticks_fail = new Object2LongOpenHashMap();
    public static final Object2LongOpenHashMap<Pair<ResourceKey<Level>, MobCategory>> spawn_ticks_succ = new Object2LongOpenHashMap();
    public static final Object2LongOpenHashMap<Pair<ResourceKey<Level>, MobCategory>> spawn_ticks_spawns = new Object2LongOpenHashMap();
    public static final Object2LongOpenHashMap<Pair<ResourceKey<Level>, MobCategory>> spawn_cap_count = new Object2LongOpenHashMap();
    public static final HashMap<Pair<ResourceKey<Level>, MobCategory>, EvictingQueue<Pair<EntityType<?>, BlockPos>>> spawned_mobs = new HashMap();
    public static final HashMap<MobCategory, Integer> spawn_tries = new HashMap();
    private static int spawnTrackingStartTime = 0;
    private static BoundingBox trackedSpawningArea = null;
    public static Object2LongOpenHashMap<MobCategory> local_spawns = null;
    public static HashSet<MobCategory> first_chunk_marker = null;
    public static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);

    public static void registerSpawn(Mob mob, MobCategory cat, BlockPos pos) {
        if (trackedSpawningArea != null && !trackedSpawningArea.isInside((Vec3i)pos)) {
            return;
        }
        Pair key = Pair.of((Object)mob.level().dimension(), (Object)cat);
        spawn_stats.get(key).addTo((Object)mob.getType(), 1L);
        spawned_mobs.get(key).put(Pair.of((Object)mob.getType(), (Object)pos));
        if (!local_spawns.containsKey((Object)cat)) {
            CarpetSettings.LOG.error("Rogue spawn detected for category " + cat.getName() + " for mob " + mob.getType().getDescription().getString() + ". If you see this message let carpet peeps know about it on github issues.");
            local_spawns.put((Object)cat, 0L);
        }
        local_spawns.addTo((Object)cat, 1L);
    }

    public static List<Component> printMobcapsForDimension(ServerLevel world, boolean multiline) {
        ResourceKey dim = world.dimension();
        String name = dim.location().getPath();
        ArrayList<Component> lst = new ArrayList<Component>();
        if (multiline) {
            lst.add(Messenger.s(String.format("Mobcaps for %s:", name)));
        }
        NaturalSpawner.SpawnState lastSpawner = world.getChunkSource().getLastSpawnState();
        Object2IntMap dimCounts = lastSpawner.getMobCategoryCounts();
        int chunkcount = chunkCounts.getOrDefault(dim, -1);
        if (dimCounts == null || chunkcount < 0) {
            lst.add(Messenger.c("g   --UNAVAILABLE--"));
            return lst;
        }
        ArrayList<Object> shortCodes = new ArrayList<Object>();
        for (MobCategory category : SpawnReporter.cachedMobCategories()) {
            int cur = dimCounts.getOrDefault((Object)category, -1);
            int max = (int)((double)chunkcount * ((double)category.getMaxInstancesPerChunk() / (double)MAGIC_NUMBER));
            String color = Messenger.heatmap_color(cur, max);
            String mobColor = Messenger.creatureTypeColor(category);
            if (multiline) {
                int rounds = spawn_tries.get(category);
                lst.add(Messenger.c(String.format("w   %s: ", category.getName()), cur < 0 ? "g -" : color + " " + cur, "g  / ", mobColor + " " + max, rounds == 1 ? "w " : String.format("gi  (%d rounds/tick)", spawn_tries.get(category))));
                continue;
            }
            shortCodes.add(color + " " + String.valueOf(cur < 0 ? "-" : Integer.valueOf(cur)));
            shortCodes.add("g /");
            shortCodes.add(mobColor + " " + max);
            shortCodes.add("g ,");
        }
        if (!multiline) {
            if (shortCodes.size() > 0) {
                shortCodes.remove(shortCodes.size() - 1);
                lst.add(Messenger.c(shortCodes.toArray(new Object[0])));
            } else {
                lst.add(Messenger.c("g   --UNAVAILABLE--"));
            }
        }
        return lst;
    }

    public static List<Component> getRecentSpawns(Level world, MobCategory category) {
        ArrayList<Component> lst = new ArrayList<Component>();
        if (!SpawnReporter.trackingSpawns()) {
            lst.add(Messenger.s("Spawn tracking not started"));
            return lst;
        }
        String categoryName = category.getName();
        lst.add(Messenger.s(String.format("Recent %s spawns:", categoryName)));
        for (Pair pair : spawned_mobs.get(Pair.of((Object)world.dimension(), (Object)category)).keySet()) {
            lst.add(Messenger.c("w  - ", Messenger.tp("wb", (BlockPos)pair.getRight()), String.format("w : %s", ((EntityType)pair.getLeft()).getDescription().getString())));
        }
        if (lst.size() == 1) {
            lst.add(Messenger.s(" - Nothing spawned yet, sorry."));
        }
        return lst;
    }

    public static List<Component> handleWoolAction(BlockPos pos, ServerLevel worldIn) {
        DyeColor under = WoolTool.getWoolColorAtPosition((Level)worldIn, pos.below());
        if (under == null) {
            if (SpawnReporter.trackingSpawns()) {
                return SpawnReporter.makeTrackingReport((Level)worldIn);
            }
            return SpawnReporter.printMobcapsForDimension(worldIn, true);
        }
        MobCategory category = SpawnReporter.getCategoryFromWoolColor(under);
        if (category != null) {
            if (SpawnReporter.trackingSpawns()) {
                return SpawnReporter.getRecentSpawns((Level)worldIn, category);
            }
            return SpawnReporter.printEntitiesByType(category, worldIn, true);
        }
        if (SpawnReporter.trackingSpawns()) {
            return SpawnReporter.makeTrackingReport((Level)worldIn);
        }
        return SpawnReporter.printMobcapsForDimension(worldIn, true);
    }

    public static MobCategory getCategoryFromWoolColor(DyeColor color) {
        return switch (color) {
            case DyeColor.RED -> MobCategory.MONSTER;
            case DyeColor.GREEN -> MobCategory.CREATURE;
            case DyeColor.BLUE -> MobCategory.WATER_CREATURE;
            case DyeColor.BROWN -> MobCategory.AMBIENT;
            case DyeColor.CYAN -> MobCategory.WATER_AMBIENT;
            default -> null;
        };
    }

    public static List<Component> printEntitiesByType(MobCategory cat, ServerLevel worldIn, boolean all) {
        ArrayList<Component> lst = new ArrayList<Component>();
        lst.add(Messenger.s(String.format("Loaded entities for %s category:", cat)));
        for (Entity entity : worldIn.getEntities(EntityTypeTest.forClass(Entity.class), e -> e.getType().getCategory() == cat)) {
            Mob mob;
            boolean persistent;
            boolean bl = persistent = entity instanceof Mob && ((mob = (Mob)entity).isPersistenceRequired() || mob.requiresCustomPersistence());
            if (!all && persistent) continue;
            EntityType type = entity.getType();
            BlockPos pos = entity.blockPosition();
            lst.add(Messenger.c("w  - ", Messenger.tp(persistent ? "gb" : "wb", pos), String.format(persistent ? "g : %s" : "w : %s", type.getDescription().getString())));
        }
        if (lst.size() == 1) {
            lst.add(Messenger.s(" - Empty."));
        }
        return lst;
    }

    public static void initializeMocking() {
        mockSpawns = true;
    }

    public static void stopMocking() {
        mockSpawns = false;
    }

    public static void resetSpawnStats(MinecraftServer server, boolean full) {
        if (full) {
            for (MobCategory category : SpawnReporter.cachedMobCategories()) {
                spawn_tries.put(category, 1);
            }
        }
        overall_spawn_ticks.clear();
        spawn_attempts.clear();
        spawn_ticks_full.clear();
        spawn_ticks_fail.clear();
        spawn_ticks_succ.clear();
        spawn_ticks_spawns.clear();
        spawn_cap_count.clear();
        for (MobCategory category : SpawnReporter.cachedMobCategories()) {
            for (ResourceKey world : server.levelKeys()) {
                Pair key = Pair.of((Object)world, (Object)category);
                spawn_stats.put((Pair<ResourceKey<Level>, MobCategory>)key, new Object2LongOpenHashMap());
                spawned_mobs.put((Pair<ResourceKey<Level>, MobCategory>)key, new EvictingQueue());
            }
        }
        spawnTrackingStartTime = 0;
    }

    public static MobCategory[] cachedMobCategories() {
        return CACHED_MOBCATEGORY_VALUES;
    }

    public static boolean trackingSpawns() {
        return (long)spawnTrackingStartTime != 0L;
    }

    public static void startTracking(MinecraftServer server, BoundingBox trackedArea) {
        SpawnReporter.resetSpawnStats(server, false);
        spawnTrackingStartTime = server.getTickCount();
        trackedSpawningArea = trackedArea;
    }

    public static void stopTracking(MinecraftServer server) {
        SpawnReporter.resetSpawnStats(server, false);
        spawnTrackingStartTime = 0;
        trackedSpawningArea = null;
    }

    private static String getWorldCode(ResourceKey<Level> world) {
        if (world == Level.OVERWORLD) {
            return "";
        }
        return "(" + Character.toUpperCase(world.location().getPath().charAt("THE_".length())) + ")";
    }

    public static List<Component> makeTrackingReport(Level worldIn) {
        ArrayList<Component> report = new ArrayList<Component>();
        if (!SpawnReporter.trackingSpawns()) {
            report.add(Messenger.c("w Spawn tracking is disabled, type '", "wi /spawn tracking start", "/spawn tracking start", "w ' to enable"));
            return report;
        }
        int duration = worldIn.getServer().getTickCount() - spawnTrackingStartTime;
        report.add(Messenger.c("bw --------------------"));
        String simulated = mockSpawns ? "[SIMULATED] " : "";
        String location = trackedSpawningArea != null ? String.format("[in (%d, %d, %d)x(%d, %d, %d)]", trackedSpawningArea.minX(), trackedSpawningArea.minY(), trackedSpawningArea.minZ(), trackedSpawningArea.maxX(), trackedSpawningArea.maxY(), trackedSpawningArea.maxZ()) : "";
        report.add(Messenger.s(String.format("%sSpawn statistics %s: for %.1f min", simulated, location, (double)duration / 72000.0 * 60.0)));
        for (MobCategory category : SpawnReporter.cachedMobCategories()) {
            for (ResourceKey dim : worldIn.getServer().levelKeys()) {
                Pair key = Pair.of((Object)dim, (Object)category);
                if (spawn_ticks_spawns.getLong((Object)key) <= 0L) continue;
                double hours = (double)overall_spawn_ticks.getLong((Object)key) / 72000.0;
                long spawnAttemptsForCategory = spawn_attempts.getLong((Object)key);
                report.add(Messenger.s(String.format(" > %s%s (%.1f min), %.1f m/t, %%{%.1fF %.1f- %.1f+}; %.2f s/att", category.getName().substring(0, 3), SpawnReporter.getWorldCode((ResourceKey<Level>)dim), 60.0 * hours, 1.0 * (double)spawn_cap_count.getLong((Object)key) / (double)spawnAttemptsForCategory, 100.0 * (double)spawn_ticks_full.getLong((Object)key) / (double)spawnAttemptsForCategory, 100.0 * (double)spawn_ticks_fail.getLong((Object)key) / (double)spawnAttemptsForCategory, 100.0 * (double)spawn_ticks_succ.getLong((Object)key) / (double)spawnAttemptsForCategory, 1.0 * (double)spawn_ticks_spawns.getLong((Object)key) / (double)(spawn_ticks_fail.getLong((Object)key) + spawn_ticks_succ.getLong((Object)key)))));
                for (Object2LongMap.Entry entry : spawn_stats.get(key).object2LongEntrySet()) {
                    report.add(Messenger.s(String.format("   - %s: %d spawns, %d per hour", ((EntityType)entry.getKey()).getDescription().getString(), entry.getLongValue(), 72000L * entry.getLongValue() / (long)duration)));
                }
            }
        }
        return report;
    }

    public static void killEntity(LivingEntity entity) {
        if (entity.isPassenger()) {
            entity.getVehicle().discard();
        }
        if (entity.isVehicle()) {
            for (Entity e : entity.getPassengers()) {
                e.discard();
            }
        }
        if (entity instanceof Ocelot) {
            for (Entity e : entity.getCommandSenderWorld().getEntities((Entity)entity, entity.getBoundingBox())) {
                e.discard();
            }
        }
        entity.discard();
    }

    private static List<MobSpawnSettings.SpawnerData> getSpawnEntries(ServerLevel serverLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, MobCategory mobCategory, BlockPos blockPos, @Nullable Holder<Biome> holder) {
        return NaturalSpawner.isInNetherFortressBounds((BlockPos)blockPos, (ServerLevel)serverLevel, (MobCategory)mobCategory, (StructureManager)structureManager) ? NetherFortressStructure.FORTRESS_ENEMIES.unwrap() : chunkGenerator.getMobsAt(holder != null ? holder : serverLevel.getBiome(blockPos), structureManager, mobCategory, blockPos).unwrap();
    }

    public static List<Component> report(BlockPos pos, ServerLevel worldIn) {
        ArrayList<Component> rep = new ArrayList<Component>();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        ChunkAccess chunk = worldIn.getChunk(pos);
        int lc = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, x, z) + 1;
        String relativeHeight = y == lc ? "right at it." : String.format("%d blocks %s it.", Mth.abs((int)(y - lc)), y >= lc ? "above" : "below");
        rep.add(Messenger.s(String.format("Maximum spawn Y value for (%+d, %+d) is %d. You are " + relativeHeight, x, z, lc)));
        rep.add(Messenger.s("Spawns:"));
        for (MobCategory category : SpawnReporter.cachedMobCategories()) {
            String categoryCode = String.valueOf(category).substring(0, 3);
            List<MobSpawnSettings.SpawnerData> lst = SpawnReporter.getSpawnEntries(worldIn, worldIn.structureManager(), worldIn.getChunkSource().getGenerator(), category, pos, (Holder<Biome>)worldIn.getBiome(pos));
            if (lst == null || lst.isEmpty()) continue;
            for (MobSpawnSettings.SpawnerData spawnEntry : lst) {
                Mob mob;
                if (SpawnPlacements.getPlacementType((EntityType)spawnEntry.type) == null) continue;
                boolean canSpawn = SpawnPlacements.isSpawnPositionOk((EntityType)spawnEntry.type, (LevelReader)worldIn, (BlockPos)pos);
                int willSpawn = -1;
                boolean fits = false;
                try {
                    mob = (Mob)spawnEntry.type.create((Level)worldIn);
                }
                catch (Exception e) {
                    CarpetSettings.LOG.warn("Exception while creating mob for spawn reporter", (Throwable)e);
                    return rep;
                }
                if (canSpawn) {
                    willSpawn = 0;
                    for (int attempt = 0; attempt < 50; ++attempt) {
                        float f = (float)x + 0.5f;
                        float f1 = (float)z + 0.5f;
                        mob.moveTo((double)f, (double)y, (double)f1, worldIn.random.nextFloat() * 360.0f, 0.0f);
                        fits = worldIn.noCollision((Entity)mob);
                        EntityType etype = mob.getType();
                        for (int i = 0; i < 20; ++i) {
                            if (!SpawnPlacements.checkSpawnRules((EntityType)etype, (ServerLevelAccessor)worldIn, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, (RandomSource)worldIn.random) || !SpawnPlacements.isSpawnPositionOk((EntityType)etype, (LevelReader)worldIn, (BlockPos)pos) || !mob.checkSpawnRules((LevelAccessor)worldIn, MobSpawnType.NATURAL)) continue;
                            if (etype == EntityType.OCELOT) {
                                BlockState blockState = worldIn.getBlockState(pos.below());
                                if (pos.getY() < worldIn.getSeaLevel() || !blockState.is(Blocks.GRASS_BLOCK) && !blockState.is(BlockTags.LEAVES)) continue;
                            }
                            ++willSpawn;
                        }
                        mob.finalizeSpawn((ServerLevelAccessor)worldIn, worldIn.getCurrentDifficultyAt(mob.blockPosition()), MobSpawnType.NATURAL, null);
                        fits = fits && worldIn.noCollision((Entity)mob);
                        SpawnReporter.killEntity((LivingEntity)mob);
                        try {
                            mob = (Mob)spawnEntry.type.create((Level)worldIn);
                            continue;
                        }
                        catch (Exception e) {
                            CarpetSettings.LOG.warn("Exception while creating mob for spawn reporter", (Throwable)e);
                            return rep;
                        }
                    }
                }
                String mobTypeName = mob.getType().getDescription().getString();
                int weight = spawnEntry.getWeight().asInt();
                if (canSpawn) {
                    String color = fits && willSpawn > 0 ? "e" : "gi";
                    rep.add(Messenger.c(String.format("%s %s: %s (%d:%d-%d/%d), can: ", color, categoryCode, mobTypeName, weight, spawnEntry.minCount, spawnEntry.maxCount, mob.getMaxSpawnClusterSize()), "l YES", color + " , fit: ", fits ? "l YES" : "r NO", color + " , will: ", (willSpawn > 0 ? "l " : "r ") + Math.round((double)willSpawn) / 10L + "%"));
                } else {
                    rep.add(Messenger.c(String.format("gi %s: %s (%d:%d-%d/%d), can: ", categoryCode, mobTypeName, weight, spawnEntry.minCount, spawnEntry.maxCount, mob.getMaxSpawnClusterSize()), "n NO"));
                }
                SpawnReporter.killEntity((LivingEntity)mob);
            }
        }
        return rep;
    }
}

