/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class DrawCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"draw").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandDraw))).then(Commands.m_82127_((String)"sphere").then(Commands.m_82129_((String)"center", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(DrawCommand.drawShape((Command<CommandSourceStack>)((Command)c -> DrawCommand.drawSphere((CommandContext<CommandSourceStack>)c, false)), context)))))).then(Commands.m_82127_((String)"ball").then(Commands.m_82129_((String)"center", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(DrawCommand.drawShape((Command<CommandSourceStack>)((Command)c -> DrawCommand.drawSphere((CommandContext<CommandSourceStack>)c, true)), context)))))).then(Commands.m_82127_((String)"diamond").then(Commands.m_82129_((String)"center", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(DrawCommand.drawShape((Command<CommandSourceStack>)((Command)c -> DrawCommand.drawDiamond((CommandContext<CommandSourceStack>)c, true)), context)))))).then(Commands.m_82127_((String)"pyramid").then(Commands.m_82129_((String)"center", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"pointing", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"up", "down"}, (SuggestionsBuilder)b)).then(Commands.m_82129_((String)"orientation", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"y", "x", "z"}, (SuggestionsBuilder)b)).then(DrawCommand.drawShape((Command<CommandSourceStack>)((Command)c -> DrawCommand.drawPyramid((CommandContext<CommandSourceStack>)c, "square", true)), context))))))))).then(Commands.m_82127_((String)"cone").then(Commands.m_82129_((String)"center", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"pointing", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"up", "down"}, (SuggestionsBuilder)b)).then(Commands.m_82129_((String)"orientation", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"y", "x", "z"}, (SuggestionsBuilder)b)).then(DrawCommand.drawShape((Command<CommandSourceStack>)((Command)c -> DrawCommand.drawPyramid((CommandContext<CommandSourceStack>)c, "circle", true)), context))))))))).then(Commands.m_82127_((String)"cylinder").then(Commands.m_82129_((String)"center", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"orientation", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"y", "x", "z"}, (SuggestionsBuilder)b)).then(DrawCommand.drawShape((Command<CommandSourceStack>)((Command)c -> DrawCommand.drawPrism((CommandContext<CommandSourceStack>)c, "circle")), context)))))))).then(Commands.m_82127_((String)"cuboid").then(Commands.m_82129_((String)"center", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"orientation", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"y", "x", "z"}, (SuggestionsBuilder)b)).then(DrawCommand.drawShape((Command<CommandSourceStack>)((Command)c -> DrawCommand.drawPrism((CommandContext<CommandSourceStack>)c, "square")), context)))))));
        dispatcher.register(command);
    }

    private static RequiredArgumentBuilder<CommandSourceStack, BlockInput> drawShape(Command<CommandSourceStack> drawer, CommandBuildContext commandBuildContext) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)commandBuildContext)).executes(drawer)).then(Commands.m_82127_((String)"replace").then(Commands.m_82129_((String)"filter", (ArgumentType)BlockPredicateArgument.m_234627_((CommandBuildContext)commandBuildContext)).executes(drawer)));
    }

    private static <T> T getArg(CommandContext<CommandSourceStack> ctx, ArgumentExtractor<T> extract, String hwat) throws CommandSyntaxException {
        return DrawCommand.getArg(ctx, extract, hwat, false);
    }

    private static <T> T getArg(CommandContext<CommandSourceStack> ctx, ArgumentExtractor<T> extract, String hwat, boolean optional) throws CommandSyntaxException {
        T arg = null;
        try {
            arg = extract.apply(ctx, hwat);
        }
        catch (IllegalArgumentException e) {
            if (optional) {
                return null;
            }
            Messenger.m((CommandSourceStack)ctx.getSource(), "rb Missing " + hwat);
            throw new ErrorHandled();
        }
        return arg;
    }

    private static double lengthSq(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    private static int setBlock(ServerLevel world, BlockPos.MutableBlockPos mbpos, int x, int y, int z, BlockInput block, Predicate<BlockInWorld> replacement, List<BlockPos> list) {
        mbpos.m_122178_(x, y, z);
        int success = 0;
        if (replacement == null || replacement.test(new BlockInWorld((LevelReader)world, (BlockPos)mbpos, true))) {
            BlockEntity tileentity = world.m_7702_((BlockPos)mbpos);
            if (tileentity instanceof Container) {
                ((Container)tileentity).m_6211_();
            }
            if (block.m_114670_(world, (BlockPos)mbpos, 2)) {
                list.add(mbpos.m_7949_());
                ++success;
            }
        }
        return success;
    }

    private static int drawSphere(CommandContext<CommandSourceStack> ctx, boolean solid) throws CommandSyntaxException {
        Predicate replacement;
        BlockInput block;
        int radius;
        BlockPos pos;
        try {
            pos = DrawCommand.getArg(ctx, BlockPosArgument::m_174395_, "center");
            radius = DrawCommand.getArg(ctx, IntegerArgumentType::getInteger, "radius");
            block = DrawCommand.getArg(ctx, BlockStateArgument::m_116123_, "block");
            replacement = DrawCommand.getArg(ctx, BlockPredicateArgument::m_115573_, "filter", true);
        }
        catch (ErrorHandled ignored) {
            return 0;
        }
        int affected = 0;
        ServerLevel world = ((CommandSourceStack)ctx.getSource()).m_81372_();
        double radiusX = (double)radius + 0.5;
        double radiusY = (double)radius + 0.5;
        double radiusZ = (double)radius + 0.5;
        double invRadiusX = 1.0 / radiusX;
        double invRadiusY = 1.0 / radiusY;
        double invRadiusZ = 1.0 / radiusZ;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        BlockPos.MutableBlockPos mbpos = pos.m_122032_();
        ArrayList list = Lists.newArrayList();
        double nextXn = 0.0;
        block2: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextYn = 0.0;
            block3: for (int y = 0; y <= ceilRadiusY; ++y) {
                double yn = nextYn;
                nextYn = (double)(y + 1) * invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= ceilRadiusZ; ++z) {
                    double zn = nextZn;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    double distanceSq = DrawCommand.lengthSq(xn, yn, zn);
                    if (distanceSq > 1.0) {
                        if (z != 0) continue block3;
                        if (y != 0) continue block2;
                        break block2;
                    }
                    if (!solid && DrawCommand.lengthSq(nextXn, yn, zn) <= 1.0 && DrawCommand.lengthSq(xn, nextYn, zn) <= 1.0 && DrawCommand.lengthSq(xn, yn, nextZn) <= 1.0) continue;
                    CarpetSettings.impendingFillSkipUpdates.set(!CarpetSettings.fillUpdates);
                    for (int xmod = -1; xmod < 2; xmod += 2) {
                        for (int ymod = -1; ymod < 2; ymod += 2) {
                            for (int zmod = -1; zmod < 2; zmod += 2) {
                                affected += DrawCommand.setBlock(world, mbpos, pos.m_123341_() + xmod * x, pos.m_123342_() + ymod * y, pos.m_123343_() + zmod * z, block, replacement, list);
                            }
                        }
                    }
                    CarpetSettings.impendingFillSkipUpdates.set(false);
                }
            }
        }
        if (CarpetSettings.fillUpdates) {
            list.forEach(blockpos1 -> world.m_6289_(blockpos1, world.m_8055_(blockpos1).m_60734_()));
        }
        Messenger.m((CommandSourceStack)ctx.getSource(), "gi Filled " + affected + " blocks");
        return affected;
    }

    private static int drawDiamond(CommandContext<CommandSourceStack> ctx, boolean solid) throws CommandSyntaxException {
        Predicate replacement;
        BlockInput block;
        int radius;
        BlockPos pos;
        try {
            pos = DrawCommand.getArg(ctx, BlockPosArgument::m_174395_, "center");
            radius = DrawCommand.getArg(ctx, IntegerArgumentType::getInteger, "radius");
            block = DrawCommand.getArg(ctx, BlockStateArgument::m_116123_, "block");
            replacement = DrawCommand.getArg(ctx, BlockPredicateArgument::m_115573_, "filter", true);
        }
        catch (ErrorHandled ignored) {
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        int affected = 0;
        BlockPos.MutableBlockPos mbpos = pos.m_122032_();
        ArrayList list = Lists.newArrayList();
        ServerLevel world = source.m_81372_();
        CarpetSettings.impendingFillSkipUpdates.set(!CarpetSettings.fillUpdates);
        for (int r = 0; r < radius; ++r) {
            int y = r - radius + 1;
            for (int x = -r; x <= r; ++x) {
                int z = r - Math.abs(x);
                affected += DrawCommand.setBlock(world, mbpos, pos.m_123341_() + x, pos.m_123342_() - y, pos.m_123343_() + z, block, replacement, list);
                affected += DrawCommand.setBlock(world, mbpos, pos.m_123341_() + x, pos.m_123342_() - y, pos.m_123343_() - z, block, replacement, list);
                affected += DrawCommand.setBlock(world, mbpos, pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z, block, replacement, list);
                affected += DrawCommand.setBlock(world, mbpos, pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() - z, block, replacement, list);
            }
        }
        CarpetSettings.impendingFillSkipUpdates.set(false);
        if (CarpetSettings.fillUpdates) {
            list.forEach(p -> world.m_6289_(p, world.m_8055_(p).m_60734_()));
        }
        Messenger.m(source, "gi Filled " + affected + " blocks");
        return affected;
    }

    private static int fillFlat(ServerLevel world, BlockPos pos, int offset, double dr, boolean rectangle, String orientation, BlockInput block, Predicate<BlockInWorld> replacement, List<BlockPos> list, BlockPos.MutableBlockPos mbpos) {
        int successes = 0;
        int r = Mth.m_14107_((double)dr);
        double drsq = dr * dr;
        if (orientation.equalsIgnoreCase("x")) {
            for (int a = -r; a <= r; ++a) {
                for (int b = -r; b <= r; ++b) {
                    if (!rectangle && !((double)(a * a + b * b) <= drsq)) continue;
                    successes += DrawCommand.setBlock(world, mbpos, pos.m_123341_() + offset, pos.m_123342_() + a, pos.m_123343_() + b, block, replacement, list);
                }
            }
            return successes;
        }
        if (orientation.equalsIgnoreCase("y")) {
            for (int a = -r; a <= r; ++a) {
                for (int b = -r; b <= r; ++b) {
                    if (!rectangle && !((double)(a * a + b * b) <= drsq)) continue;
                    successes += DrawCommand.setBlock(world, mbpos, pos.m_123341_() + a, pos.m_123342_() + offset, pos.m_123343_() + b, block, replacement, list);
                }
            }
            return successes;
        }
        if (orientation.equalsIgnoreCase("z")) {
            for (int a = -r; a <= r; ++a) {
                for (int b = -r; b <= r; ++b) {
                    if (!rectangle && !((double)(a * a + b * b) <= drsq)) continue;
                    successes += DrawCommand.setBlock(world, mbpos, pos.m_123341_() + b, pos.m_123342_() + a, pos.m_123343_() + offset, block, replacement, list);
                }
            }
            return successes;
        }
        return 0;
    }

    private static int drawPyramid(CommandContext<CommandSourceStack> ctx, String base, boolean solid) throws CommandSyntaxException {
        Predicate replacement;
        BlockInput block;
        String orientation;
        boolean pointup;
        int height;
        double radius;
        BlockPos pos;
        try {
            pos = DrawCommand.getArg(ctx, BlockPosArgument::m_174395_, "center");
            radius = (double)DrawCommand.getArg(ctx, IntegerArgumentType::getInteger, "radius").intValue() + 0.5;
            height = DrawCommand.getArg(ctx, IntegerArgumentType::getInteger, "height");
            pointup = DrawCommand.getArg(ctx, StringArgumentType::getString, "pointing").equalsIgnoreCase("up");
            orientation = DrawCommand.getArg(ctx, StringArgumentType::getString, "orientation");
            block = DrawCommand.getArg(ctx, BlockStateArgument::m_116123_, "block");
            replacement = DrawCommand.getArg(ctx, BlockPredicateArgument::m_115573_, "filter", true);
        }
        catch (ErrorHandled ignored) {
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        int affected = 0;
        BlockPos.MutableBlockPos mbpos = pos.m_122032_();
        ArrayList list = Lists.newArrayList();
        ServerLevel world = source.m_81372_();
        CarpetSettings.impendingFillSkipUpdates.set(!CarpetSettings.fillUpdates);
        boolean isSquare = base.equalsIgnoreCase("square");
        for (int i = 0; i < height; ++i) {
            double r = pointup ? radius - radius * (double)i / (double)height - 1.0 : radius * (double)i / (double)height;
            affected += DrawCommand.fillFlat(world, pos, i, r, isSquare, orientation, block, replacement, list, mbpos);
        }
        CarpetSettings.impendingFillSkipUpdates.set(false);
        if (CarpetSettings.fillUpdates) {
            for (BlockPos blockpos1 : list) {
                Block blokc = world.m_8055_(blockpos1).m_60734_();
                world.m_6289_(blockpos1, blokc);
            }
        }
        Messenger.m(source, "gi Filled " + affected + " blocks");
        return affected;
    }

    private static int drawPrism(CommandContext<CommandSourceStack> ctx, String base) {
        Predicate replacement;
        BlockInput block;
        String orientation;
        int height;
        double radius;
        BlockPos pos;
        try {
            pos = DrawCommand.getArg(ctx, BlockPosArgument::m_174395_, "center");
            radius = (double)DrawCommand.getArg(ctx, IntegerArgumentType::getInteger, "radius").intValue() + 0.5;
            height = DrawCommand.getArg(ctx, IntegerArgumentType::getInteger, "height");
            orientation = DrawCommand.getArg(ctx, StringArgumentType::getString, "orientation");
            block = DrawCommand.getArg(ctx, BlockStateArgument::m_116123_, "block");
            replacement = DrawCommand.getArg(ctx, BlockPredicateArgument::m_115573_, "filter", true);
        }
        catch (ErrorHandled | CommandSyntaxException ignored) {
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        int affected = 0;
        BlockPos.MutableBlockPos mbpos = pos.m_122032_();
        ArrayList list = Lists.newArrayList();
        ServerLevel world = source.m_81372_();
        CarpetSettings.impendingFillSkipUpdates.set(!CarpetSettings.fillUpdates);
        boolean isSquare = base.equalsIgnoreCase("square");
        for (int i = 0; i < height; ++i) {
            affected += DrawCommand.fillFlat(world, pos, i, radius, isSquare, orientation, block, replacement, list, mbpos);
        }
        CarpetSettings.impendingFillSkipUpdates.set(false);
        if (CarpetSettings.fillUpdates) {
            for (BlockPos blockpos1 : list) {
                Block blokc = world.m_8055_(blockpos1).m_60734_();
                world.m_6289_(blockpos1, blokc);
            }
        }
        Messenger.m(source, "gi Filled " + affected + " blocks");
        return affected;
    }

    @FunctionalInterface
    private static interface ArgumentExtractor<T> {
        public T apply(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;
    }

    private static class ErrorHandled
    extends RuntimeException {
        private ErrorHandled() {
        }
    }
}

