/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.ChunkHolderInterface;
import carpet.fakes.ChunkTicketManagerInterface;
import carpet.fakes.ServerLightingProviderInterface;
import carpet.fakes.ServerWorldInterface;
import carpet.fakes.SimpleEntityLookupInterface;
import carpet.fakes.ThreadedAnvilChunkStorageInterface;
import carpet.script.CarpetEventServer;
import carpet.script.utils.WorldTools;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkMap.class})
public abstract class ChunkMap_scarpetChunkCreationMixin
implements ThreadedAnvilChunkStorageInterface {
    @Shadow
    @Final
    ServerLevel f_140133_;
    @Shadow
    @Final
    private LongSet f_140132_;
    @Shadow
    @Final
    private Long2ObjectLinkedOpenHashMap<ChunkHolder> f_140129_;
    @Shadow
    private boolean f_140140_;
    @Shadow
    @Final
    private ThreadedLevelLightEngine f_140134_;
    @Shadow
    @Final
    private ChunkTaskPriorityQueueSorter f_140141_;
    @Shadow
    @Final
    private BlockableEventLoop<Runnable> f_140135_;
    @Shadow
    @Final
    private ChunkProgressListener f_140144_;
    @Shadow
    @Final
    private ChunkMap.DistanceManager f_140145_;
    @Unique
    ThreadLocal<Boolean> generated = ThreadLocal.withInitial(() -> null);

    @Shadow
    protected abstract boolean m_140324_();

    @Shadow
    protected abstract Iterable<ChunkHolder> m_140416_();

    @Shadow
    protected abstract CompletableFuture<Either<List<ChunkAccess>, ChunkHolder.ChunkLoadingFailure>> m_280541_(ChunkHolder var1, int var2, IntFunction<ChunkStatus> var3);

    @Inject(method={"protoChunkToFullChunk"}, at={@At(value="HEAD")})
    private void onChunkGeneratedStart(ChunkHolder chunkHolder, CallbackInfoReturnable<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> cir) {
        if (CarpetEventServer.Event.CHUNK_GENERATED.isNeeded() || CarpetEventServer.Event.CHUNK_LOADED.isNeeded()) {
            this.generated.set(chunkHolder.m_140089_().m_6415_() != ChunkStatus.f_62326_);
        } else {
            this.generated.set(null);
        }
    }

    @Inject(method={"protoChunkToFullChunk"}, at={@At(value="RETURN")})
    private void onChunkGeneratedEnd(ChunkHolder chunkHolder, CallbackInfoReturnable<CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> cir) {
        Boolean localGenerated = this.generated.get();
        if (localGenerated != null) {
            MinecraftServer server = this.f_140133_.m_7654_();
            int ticks = server.m_129921_();
            ChunkPos chpos = chunkHolder.m_140092_();
            if (CarpetEventServer.Event.CHUNK_GENERATED.isNeeded() && localGenerated.booleanValue()) {
                server.m_6937_((Runnable)new TickTask(ticks, () -> CarpetEventServer.Event.CHUNK_GENERATED.onChunkEvent(this.f_140133_, chpos, true)));
            }
            if (CarpetEventServer.Event.CHUNK_LOADED.isNeeded()) {
                server.m_6937_((Runnable)new TickTask(ticks, () -> CarpetEventServer.Event.CHUNK_LOADED.onChunkEvent(this.f_140133_, chpos, localGenerated)));
            }
        }
    }

    @Unique
    private void addTicket(ChunkPos pos, ChunkStatus status) {
        this.f_140145_.m_140792_(TicketType.f_9449_, pos, 33 + ChunkStatus.m_62370_((ChunkStatus)status), (Object)pos);
    }

    @Unique
    private void addTicket(ChunkPos pos) {
        this.addTicket(pos, ChunkStatus.f_62314_);
    }

    @Unique
    private void addRelightTicket(ChunkPos pos) {
        this.f_140145_.m_140840_(TicketType.f_9446_, pos, 1, (Object)pos);
    }

    @Override
    public void releaseRelightTicket(ChunkPos pos) {
        this.f_140135_.m_6937_(Util.m_137474_(() -> this.f_140145_.m_140849_(TicketType.f_9446_, pos, 1, (Object)pos), () -> "release relight ticket " + String.valueOf(pos)));
    }

    @Unique
    private void tickTicketManager() {
        this.f_140145_.m_140805_((ChunkMap)this);
    }

    @Unique
    private Set<ChunkPos> getExistingChunks(Set<ChunkPos> requestedChunks) {
        HashMap<String, RegionFile> regionCache = new HashMap<String, RegionFile>();
        HashSet<ChunkPos> ret = new HashSet<ChunkPos>();
        for (ChunkPos pos : requestedChunks) {
            if (!WorldTools.canHasChunk(this.f_140133_, pos, regionCache, true)) continue;
            ret.add(pos);
        }
        return ret;
    }

    @Unique
    private Set<ChunkPos> loadExistingChunksFromDisk(Set<ChunkPos> requestedChunks) {
        Set<ChunkPos> existingChunks = this.getExistingChunks(requestedChunks);
        for (ChunkPos pos : existingChunks) {
            ((ChunkHolder)this.f_140129_.get(pos.m_45588_())).m_140049_(ChunkStatus.f_62314_, (ChunkMap)this);
        }
        return existingChunks;
    }

    @Unique
    private Set<ChunkPos> loadExistingChunks(Set<ChunkPos> requestedChunks, Object2IntMap<String> report) {
        if (report != null) {
            report.put((Object)"requested_chunks", requestedChunks.size());
        }
        for (ChunkPos pos2 : requestedChunks) {
            this.addTicket(pos2);
        }
        this.tickTicketManager();
        Set loadedChunks = requestedChunks.stream().filter(pos -> ((ChunkHolder)this.f_140129_.get(pos.m_45588_())).m_140089_() != null).collect(Collectors.toSet());
        if (report != null) {
            report.put((Object)"loaded_chunks", loadedChunks.size());
        }
        HashSet<ChunkPos> unloadedChunks = new HashSet<ChunkPos>(requestedChunks);
        unloadedChunks.removeAll(loadedChunks);
        Set<ChunkPos> existingChunks = this.loadExistingChunksFromDisk(unloadedChunks);
        existingChunks.addAll(loadedChunks);
        return existingChunks;
    }

    @Unique
    private Set<ChunkPos> loadExistingChunks(Set<ChunkPos> requestedChunks) {
        return this.loadExistingChunks(requestedChunks, null);
    }

    @Unique
    private void waitFor(Future<?> future) {
        this.f_140135_.m_18701_(future::isDone);
    }

    @Unique
    private void waitFor(List<? extends CompletableFuture<?>> futures) {
        this.waitFor(Util.m_143840_(futures));
    }

    @Unique
    private ChunkAccess getCurrentChunk(ChunkPos pos) {
        CompletableFuture future = ((ChunkHolder)this.f_140129_.get(pos.m_45588_())).m_140090_();
        this.waitFor(future);
        return (ChunkAccess)future.join();
    }

    @Override
    public void relightChunk(ChunkPos pos) {
        ChunkAccess chunk;
        this.addTicket(pos);
        this.tickTicketManager();
        if (((ChunkHolder)this.f_140129_.get(pos.m_45588_())).m_140089_() == null && WorldTools.canHasChunk(this.f_140133_, pos, null, true)) {
            ((ChunkHolder)this.f_140129_.get(pos.m_45588_())).m_140049_(ChunkStatus.f_62314_, (ChunkMap)this);
        }
        if (!(chunk = this.getCurrentChunk(pos)).m_6415_().m_62427_(ChunkStatus.f_62323_.m_62482_())) {
            return;
        }
        ((ServerLightingProviderInterface)this.f_140134_).removeLightData(chunk);
        this.addRelightTicket(pos);
        ChunkHolder chunkHolder = (ChunkHolder)this.f_140129_.get(pos.m_45588_());
        CompletionStage lightFuture = this.m_280541_(chunkHolder, 1, pos_ -> ChunkStatus.f_62323_).thenCompose(either -> (CompletionStage)either.map(list -> ((ServerLightingProviderInterface)this.f_140134_).relight(chunk), unloaded -> {
            this.releaseRelightTicket(pos);
            return CompletableFuture.completedFuture(null);
        }));
        this.waitFor((Future<?>)((Object)lightFuture));
    }

    @Override
    public Map<String, Integer> regenerateChunkRegion(List<ChunkPos> requestedChunksList) {
        Object2IntOpenHashMap report = new Object2IntOpenHashMap();
        HashSet<ChunkPos> requestedChunks = new HashSet<ChunkPos>(requestedChunksList);
        Set<ChunkPos> existingChunks = this.loadExistingChunks(requestedChunks, (Object2IntMap<String>)report);
        HashSet<ChunkAccess> affectedChunks = new HashSet<ChunkAccess>();
        for (ChunkPos chunkPos : existingChunks) {
            affectedChunks.add(this.getCurrentChunk(chunkPos));
        }
        report.put((Object)"affected_chunks", affectedChunks.size());
        HashSet<ChunkPos> neighbors = new HashSet<ChunkPos>();
        for (ChunkAccess chunkAccess : affectedChunks) {
            ChunkPos chunkPos = chunkAccess.m_7697_();
            for (int i = -1; i <= 1; ++i) {
                for (int z = -1; z <= 1; ++z) {
                    ChunkPos chunkPos2;
                    if (i == 0 && z == 0 || requestedChunks.contains(chunkPos2 = new ChunkPos(chunkPos.f_45578_ + i, chunkPos.f_45579_ + z))) continue;
                    neighbors.add(chunkPos2);
                }
            }
        }
        this.loadExistingChunks(neighbors);
        HashSet<ChunkAccess> hashSet = new HashSet<ChunkAccess>();
        for (ChunkPos chunkPos : neighbors) {
            ChunkAccess chunkAccess = this.getCurrentChunk(chunkPos);
            if (!chunkAccess.m_6415_().m_62427_(ChunkStatus.f_62323_.m_62482_())) continue;
            hashSet.add(chunkAccess);
        }
        for (ChunkAccess chunkAccess : affectedChunks) {
            ChunkPos chunkPos = chunkAccess.m_7697_();
            long longPos = chunkPos.m_45588_();
            if (this.f_140132_.contains(longPos) && chunkAccess instanceof LevelChunk) {
                ((SimpleEntityLookupInterface)((ServerWorldInterface)this.f_140133_).getEntityLookupCMPublic()).getChunkEntities(chunkPos).forEach(entity -> {
                    if (!(entity instanceof Player)) {
                        entity.m_146870_();
                    }
                });
            }
            if (chunkAccess instanceof LevelChunk) {
                ((LevelChunk)chunkAccess).m_62913_(false);
            }
            if (this.f_140132_.remove(chunkPos.m_45588_()) && chunkAccess instanceof LevelChunk) {
                this.f_140133_.m_8712_((LevelChunk)chunkAccess);
            }
            ((ServerLightingProviderInterface)this.f_140134_).invokeUpdateChunkStatus(chunkPos);
            ((ServerLightingProviderInterface)this.f_140134_).removeLightData(chunkAccess);
            this.f_140144_.m_5511_(chunkPos, null);
        }
        for (ChunkAccess chunkAccess : affectedChunks) {
            ChunkPos chunkPos = chunkAccess.m_7697_();
            long pos = chunkPos.m_45588_();
            ChunkHolder oldHolder = (ChunkHolder)this.f_140129_.remove(pos);
            ChunkHolder newHolder = new ChunkHolder(chunkPos, oldHolder.m_140093_(), (LevelHeightAccessor)this.f_140133_, (LevelLightEngine)this.f_140134_, (ChunkHolder.LevelChangeListener)this.f_140141_, (ChunkHolder.PlayerProvider)this);
            ((ChunkHolderInterface)newHolder).setDefaultProtoChunk(chunkPos, this.f_140135_, this.f_140133_);
            this.f_140129_.put(pos, (Object)newHolder);
            ((ChunkTicketManagerInterface)this.f_140145_).replaceHolder(oldHolder, newHolder);
        }
        this.f_140140_ = true;
        this.m_140324_();
        Map<ChunkPos, ChunkStatus> map = affectedChunks.stream().collect(Collectors.toMap(ChunkAccess::m_7697_, ChunkAccess::m_6415_));
        for (Map.Entry<ChunkPos, ChunkStatus> entry : map.entrySet()) {
            this.addTicket(entry.getKey(), entry.getValue());
        }
        this.tickTicketManager();
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (Map.Entry<ChunkPos, ChunkStatus> entry : map.entrySet()) {
            arrayList.add(Pair.of((Object)entry.getValue(), (Object)((ChunkHolder)this.f_140129_.get(entry.getKey().m_45588_())).m_140049_(entry.getValue(), (ChunkMap)this)));
        }
        Map map2 = arrayList.stream().collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        for (ChunkStatus chunkStatus : ChunkStatus.m_62349_()) {
            List futures = map2.get(chunkStatus);
            if (futures == null) continue;
            String statusName = BuiltInRegistries.f_256940_.m_7981_((Object)chunkStatus).m_135815_();
            report.put((Object)("layer_count_" + statusName), futures.size());
            long start = System.currentTimeMillis();
            this.waitFor(futures);
            report.put((Object)("layer_time_" + statusName), (int)(System.currentTimeMillis() - start));
        }
        report.put((Object)"relight_count", hashSet.size());
        for (ChunkAccess chunkAccess : hashSet) {
            ((ServerLightingProviderInterface)this.f_140134_).removeLightData(chunkAccess);
        }
        for (ChunkAccess chunkAccess : hashSet) {
            this.addRelightTicket(chunkAccess.m_7697_());
        }
        this.tickTicketManager();
        ArrayList<CompletionStage> lightFutures = new ArrayList<CompletionStage>();
        for (ChunkAccess chunk : hashSet) {
            ChunkPos pos = chunk.m_7697_();
            lightFutures.add(this.m_280541_((ChunkHolder)this.f_140129_.get(pos.m_45588_()), 1, pos_ -> ChunkStatus.f_62323_).thenCompose(either -> (CompletionStage)either.map(list -> ((ServerLightingProviderInterface)this.f_140134_).relight(chunk), unloaded -> {
                this.releaseRelightTicket(pos);
                return CompletableFuture.completedFuture(null);
            })));
        }
        long l = System.currentTimeMillis();
        this.waitFor(lightFutures);
        report.put((Object)"relight_time", (int)(System.currentTimeMillis() - l));
        return report;
    }

    @Override
    public Iterable<ChunkHolder> getChunksCM() {
        return this.m_140416_();
    }
}

