/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.fakes.LevelInterface;
import carpet.utils.SpawnReporter;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NaturalSpawner.class})
public class NaturalSpawnerMixin {
    @Shadow
    @Final
    static int f_46978_;
    @Shadow
    @Final
    private static MobCategory[] f_46979_;

    @Redirect(method={"isValidSpawnPostitionForType"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;noCollision(Lnet/minecraft/world/phys/AABB;)Z"))
    private static boolean doesNotCollide(ServerLevel world, AABB bb) {
        int z;
        int x;
        if (!CarpetSettings.lagFreeSpawning) {
            return world.m_45772_(bb);
        }
        int minX = Mth.m_14107_((double)bb.f_82288_);
        int minY = Mth.m_14107_((double)bb.f_82289_);
        int minZ = Mth.m_14107_((double)bb.f_82290_);
        int maxY = Mth.m_14165_((double)bb.f_82292_) - 1;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        if (bb.m_82362_() <= 1.0) {
            for (int y = minY; y <= maxY; ++y) {
                blockpos.m_122178_(minX, y, minZ);
                VoxelShape box = world.m_8055_((BlockPos)blockpos).m_60812_((BlockGetter)world, (BlockPos)blockpos);
                if (box == Shapes.m_83040_()) continue;
                if (box == Shapes.m_83144_()) {
                    return false;
                }
                return world.m_45772_(bb);
            }
            return true;
        }
        int maxX = Mth.m_14165_((double)bb.f_82291_) - 1;
        int maxZ = Mth.m_14165_((double)bb.f_82293_) - 1;
        for (int y = minY; y <= maxY; ++y) {
            for (x = minX; x <= maxX; ++x) {
                for (z = minZ; z <= maxZ; ++z) {
                    blockpos.m_122178_(x, y, z);
                    VoxelShape box = world.m_8055_((BlockPos)blockpos).m_60812_((BlockGetter)world, (BlockPos)blockpos);
                    if (box == Shapes.m_83040_()) continue;
                    if (box == Shapes.m_83144_()) {
                        return false;
                    }
                    return world.m_45772_(bb);
                }
            }
        }
        int min_below = minY - 1;
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                blockpos.m_122178_(x, min_below, z);
                BlockState state = world.m_8055_((BlockPos)blockpos);
                Block block = state.m_60734_();
                if (!state.m_204336_(BlockTags.f_13039_) && !state.m_204336_(BlockTags.f_13032_) && (!(block instanceof FenceGateBlock) || ((Boolean)state.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue())) continue;
                if (x == minX || x == maxX || z == minZ || z == maxZ) {
                    return world.m_45772_(bb);
                }
                return false;
            }
        }
        return true;
    }

    @Redirect(method={"getMobForSpawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityType;create(Lnet/minecraft/world/level/Level;)Lnet/minecraft/world/entity/Entity;"))
    private static Entity create(EntityType<?> entityType, Level world_1) {
        if (CarpetSettings.lagFreeSpawning) {
            Map<EntityType<?>, Entity> precookedMobs = ((LevelInterface)world_1).getPrecookedMobs();
            if (precookedMobs.containsKey(entityType)) {
                return precookedMobs.get(entityType);
            }
            Entity e = entityType.m_20615_(world_1);
            precookedMobs.put(entityType, e);
            return e;
        }
        return entityType.m_20615_(world_1);
    }

    @Redirect(method={"spawnCategoryForPosition(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;addFreshEntityWithPassengers(Lnet/minecraft/world/entity/Entity;)V"))
    private static void spawnEntity(ServerLevel world, Entity entity_1, MobCategory group, ServerLevel world2, ChunkAccess chunk, BlockPos pos, NaturalSpawner.SpawnPredicate checker, NaturalSpawner.AfterSpawnCallback runner) {
        if (CarpetSettings.lagFreeSpawning) {
            ((LevelInterface)world).getPrecookedMobs().remove(entity_1.m_6095_());
        }
        if (SpawnReporter.track_spawns > 0L && SpawnReporter.local_spawns != null) {
            SpawnReporter.registerSpawn((Mob)entity_1, group, entity_1.m_20183_());
        }
        if (!SpawnReporter.mock_spawns) {
            world.m_47205_(entity_1);
        }
    }

    @Redirect(method={"spawnCategoryForPosition(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/event/ForgeEventFactory;onFinalizeSpawn(Lnet/minecraft/world/entity/Mob;Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/MobSpawnType;Lnet/minecraft/world/entity/SpawnGroupData;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/entity/SpawnGroupData;"))
    private static SpawnGroupData spawnEntity(Mob mobEntity, ServerLevelAccessor serverWorldAccess, DifficultyInstance difficulty, MobSpawnType spawnReason, SpawnGroupData entityData, CompoundTag spawnTag) {
        if (!SpawnReporter.mock_spawns) {
            return ForgeEventFactory.onFinalizeSpawn((Mob)mobEntity, (ServerLevelAccessor)serverWorldAccess, (DifficultyInstance)difficulty, (MobSpawnType)spawnReason, (SpawnGroupData)entityData, (CompoundTag)spawnTag);
        }
        return null;
    }

    @Redirect(method={"spawnCategoryForPosition(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;distanceToSqr(DDD)D"))
    private static double getSqDistanceTo(Player playerEntity, double double_1, double double_2, double double_3, MobCategory entityCategory, ServerLevel serverWorld, ChunkAccess chunk, BlockPos blockPos) {
        double distanceTo = playerEntity.m_20275_(double_1, double_2, double_3);
        if (CarpetSettings.lagFreeSpawning && distanceTo > 16384.0 && entityCategory != MobCategory.CREATURE) {
            return 0.0;
        }
        return distanceTo;
    }

    @Redirect(method={"spawnForChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/NaturalSpawner;spawnCategoryForChunk(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/LevelChunk;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"))
    private static void spawnMultipleTimes(MobCategory category, ServerLevel world, LevelChunk chunk, NaturalSpawner.SpawnPredicate checker, NaturalSpawner.AfterSpawnCallback runner) {
        for (int i = 0; i < SpawnReporter.spawn_tries.get(category); ++i) {
            NaturalSpawner.m_47045_((MobCategory)category, (ServerLevel)world, (LevelChunk)chunk, (NaturalSpawner.SpawnPredicate)checker, (NaturalSpawner.AfterSpawnCallback)runner);
        }
    }

    @Inject(method={"spawnForChunk"}, at={@At(value="HEAD")})
    private static void checkSpawns(ServerLevel world, LevelChunk chunk, NaturalSpawner.SpawnState info, boolean spawnAnimals, boolean spawnMonsters, boolean shouldSpawnAnimals, CallbackInfo ci) {
        if (SpawnReporter.track_spawns > 0L) {
            for (MobCategory entityCategory : f_46979_) {
                if (!spawnAnimals && entityCategory.m_21609_() || !spawnMonsters && !entityCategory.m_21609_() || !shouldSpawnAnimals && entityCategory.m_21610_()) continue;
                ResourceKey dim = world.m_46472_();
                int newCap = entityCategory.m_21608_();
                int int_2 = SpawnReporter.chunkCounts.get(dim);
                int int_3 = newCap * int_2 / f_46978_;
                int mobCount = info.m_47148_().getInt((Object)entityCategory);
                if (SpawnReporter.track_spawns > 0L && !SpawnReporter.first_chunk_marker.contains(entityCategory)) {
                    SpawnReporter.first_chunk_marker.add(entityCategory);
                    Pair key = Pair.of((Object)dim, (Object)entityCategory);
                    int spawnTries = SpawnReporter.spawn_tries.get(entityCategory);
                    SpawnReporter.spawn_attempts.put((Pair<ResourceKey<Level>, MobCategory>)key, SpawnReporter.spawn_attempts.get(key) + (long)spawnTries);
                    SpawnReporter.spawn_cap_count.put((Pair<ResourceKey<Level>, MobCategory>)key, SpawnReporter.spawn_cap_count.get(key) + (long)mobCount);
                }
                if (mobCount > int_3 && !SpawnReporter.mock_spawns) continue;
                SpawnReporter.local_spawns.putIfAbsent(entityCategory, 0L);
            }
        }
    }
}

