/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.utils.SpawnReporter;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerChunkCache.class})
public abstract class ServerChunkCacheMixin {
    @Shadow
    @Final
    private ServerLevel f_8329_;
    @Shadow
    @Final
    private DistanceManager f_8327_;

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager;getNaturalSpawnChunkCount()I"))
    private int setupTracking(DistanceManager chunkTicketManager) {
        int j = chunkTicketManager.m_140816_();
        ResourceKey dim = this.f_8329_.m_46472_();
        SpawnReporter.chunkCounts.put((ResourceKey<Level>)dim, j);
        if (SpawnReporter.track_spawns > 0L) {
            SpawnReporter.local_spawns = new HashMap();
            SpawnReporter.first_chunk_marker = new HashSet();
            for (MobCategory cat : MobCategory.values()) {
                Pair key = Pair.of((Object)dim, (Object)cat);
                SpawnReporter.overall_spawn_ticks.put((Pair<ResourceKey<Level>, MobCategory>)key, SpawnReporter.overall_spawn_ticks.get(key) + (long)SpawnReporter.spawn_tries.get(cat).intValue());
            }
        }
        return j;
    }

    @Inject(method={"tickChunks"}, at={@At(value="RETURN")})
    private void onFinishSpawnWorldCycle(CallbackInfo ci) {
        boolean boolean_3;
        LevelData levelProperties_1 = this.f_8329_.m_6106_();
        boolean bl = boolean_3 = levelProperties_1.m_6793_() % 400L == 0L;
        if (SpawnReporter.track_spawns > 0L && SpawnReporter.local_spawns != null) {
            for (MobCategory cat : MobCategory.values()) {
                ResourceKey dim = this.f_8329_.m_46472_();
                Pair key = Pair.of((Object)dim, (Object)cat);
                int spawnTries = SpawnReporter.spawn_tries.get(cat);
                if (!SpawnReporter.local_spawns.containsKey(cat)) {
                    if (cat.m_21610_() && !boolean_3) continue;
                    SpawnReporter.spawn_ticks_full.put((Pair<ResourceKey<Level>, MobCategory>)key, SpawnReporter.spawn_ticks_full.get(key) + (long)spawnTries);
                    continue;
                }
                if (SpawnReporter.local_spawns.get(cat) > 0L) {
                    SpawnReporter.spawn_ticks_succ.put((Pair<ResourceKey<Level>, MobCategory>)key, SpawnReporter.spawn_ticks_succ.get(key) + (long)spawnTries);
                    SpawnReporter.spawn_ticks_spawns.put((Pair<ResourceKey<Level>, MobCategory>)key, SpawnReporter.spawn_ticks_spawns.get(key) + SpawnReporter.local_spawns.get(cat));
                    continue;
                }
                SpawnReporter.spawn_ticks_fail.put((Pair<ResourceKey<Level>, MobCategory>)key, SpawnReporter.spawn_ticks_fail.get(key) + (long)spawnTries);
            }
        }
        SpawnReporter.local_spawns = null;
    }
}

