/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.LevelInterface;
import carpet.fakes.MinecraftServerInterface;
import carpet.helpers.TickRateManager;
import carpet.utils.CarpetProfiler;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevel_tickMixin
extends Level
implements LevelInterface {
    private CarpetProfiler.ProfilerToken currentSection;

    protected ServerLevel_tickMixin(WritableLevelData writableLevelData, ResourceKey<Level> resourceKey, RegistryAccess registryAccess, Holder<DimensionType> holder, Supplier<ProfilerFiller> supplier, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, supplier, bl, bl2, l, i);
    }

    @Override
    public TickRateManager tickRateManager() {
        return ((MinecraftServerInterface)this.m_7654_()).getTickRateManager();
    }

    @Shadow
    protected abstract void m_8807_();

    @Shadow
    protected abstract void m_8809_();

    @Inject(method={"tick"}, at={@At(value="CONSTANT", args={"stringValue=weather"})})
    private void startWeatherSection(BooleanSupplier booleanSupplier_1, CallbackInfo ci) {
        this.currentSection = CarpetProfiler.start_section(this, "Environment", CarpetProfiler.TYPE.GENERAL);
    }

    @Inject(method={"tick"}, at={@At(value="CONSTANT", args={"stringValue=tickPending"})})
    private void stopWeatherStartTileTicks(BooleanSupplier booleanSupplier_1, CallbackInfo ci) {
        if (this.currentSection != null) {
            CarpetProfiler.end_current_section(this.currentSection);
            this.currentSection = CarpetProfiler.start_section(this, "Schedule Ticks", CarpetProfiler.TYPE.GENERAL);
        }
    }

    @Inject(method={"tick"}, at={@At(value="CONSTANT", args={"stringValue=raid"})})
    private void stopTileTicksStartRaid(BooleanSupplier booleanSupplier_1, CallbackInfo ci) {
        if (this.currentSection != null) {
            CarpetProfiler.end_current_section(this.currentSection);
            this.currentSection = CarpetProfiler.start_section(this, "Raid", CarpetProfiler.TYPE.GENERAL);
        }
    }

    @Inject(method={"tick"}, at={@At(value="CONSTANT", args={"stringValue=chunkSource"})})
    private void stopRaid(BooleanSupplier booleanSupplier_1, CallbackInfo ci) {
        if (this.currentSection != null) {
            CarpetProfiler.end_current_section(this.currentSection);
        }
    }

    @Inject(method={"tick"}, at={@At(value="CONSTANT", args={"stringValue=blockEvents"})})
    private void startBlockEvents(BooleanSupplier booleanSupplier_1, CallbackInfo ci) {
        this.currentSection = CarpetProfiler.start_section(this, "Block Events", CarpetProfiler.TYPE.GENERAL);
    }

    @Inject(method={"tick"}, at={@At(value="CONSTANT", args={"stringValue=entities"})})
    private void stopBlockEventsStartEntitySection(BooleanSupplier booleanSupplier_1, CallbackInfo ci) {
        if (this.currentSection != null) {
            CarpetProfiler.end_current_section(this.currentSection);
            this.currentSection = CarpetProfiler.start_section(this, "Entities", CarpetProfiler.TYPE.GENERAL);
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;tickBlockEntities()V", shift=At.Shift.BEFORE)})
    private void endEntitySection(BooleanSupplier booleanSupplier_1, CallbackInfo ci) {
        CarpetProfiler.end_current_section(this.currentSection);
        this.currentSection = null;
    }

    @Inject(method={"tickChunk"}, at={@At(value="HEAD")})
    private void startThunderSpawningSection(CallbackInfo ci) {
        this.currentSection = CarpetProfiler.start_section(this, "Spawning", CarpetProfiler.TYPE.GENERAL);
    }

    @Inject(method={"tickChunk"}, at={@At(value="CONSTANT", args={"stringValue=iceandsnow"})})
    private void endThunderSpawningAndStartIceSnowRandomTicks(CallbackInfo ci) {
        if (this.currentSection != null) {
            CarpetProfiler.end_current_section(this.currentSection);
            this.currentSection = CarpetProfiler.start_section(this, "Environment", CarpetProfiler.TYPE.GENERAL);
        }
    }

    @Inject(method={"tickChunk"}, at={@At(value="CONSTANT", args={"stringValue=tickBlocks"})})
    private void endIceAndSnowAndStartRandomTicks(CallbackInfo ci) {
        if (this.currentSection != null) {
            CarpetProfiler.end_current_section(this.currentSection);
            this.currentSection = CarpetProfiler.start_section(this, "Random Ticks", CarpetProfiler.TYPE.GENERAL);
        }
    }

    @Inject(method={"tickChunk"}, at={@At(value="RETURN")})
    private void endRandomTicks(CallbackInfo ci) {
        if (this.currentSection != null) {
            CarpetProfiler.end_current_section(this.currentSection);
            this.currentSection = null;
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/border/WorldBorder;tick()V"))
    private void tickWorldBorder(WorldBorder worldBorder) {
        if (this.tickRateManager().runsNormally()) {
            worldBorder.m_61969_();
        }
    }

    @Inject(method={"advanceWeatherCycle"}, cancellable=true, at={@At(value="HEAD")})
    private void tickWeather(CallbackInfo ci) {
        if (!this.tickRateManager().runsNormally()) {
            ci.cancel();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;tickTime()V"))
    private void tickTimeConditionally(ServerLevel serverWorld) {
        if (this.tickRateManager().runsNormally()) {
            this.m_8809_();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isDebug()Z"))
    private boolean tickPendingBlocks(ServerLevel serverWorld) {
        if (!this.tickRateManager().runsNormally()) {
            return true;
        }
        return serverWorld.m_46659_();
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raids;tick()V"))
    private void tickConditionally(Raids raidManager) {
        if (this.tickRateManager().runsNormally()) {
            raidManager.m_37957_();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;runBlockEvents()V"))
    private void tickConditionally(ServerLevel serverWorld) {
        if (this.tickRateManager().runsNormally()) {
            this.m_8807_();
        }
    }
}

