/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.helpers.ParticleDisplay;
import carpet.utils.Messenger;
import carpet.utils.MobAI;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class Villager_aiMixin
extends AbstractVillager {
    int totalFood;
    boolean hasBed;
    int displayAge;

    @Shadow
    protected abstract void m_35518_();

    @Shadow
    protected abstract int m_35529_();

    @Shadow
    public abstract void m_35513_();

    public Villager_aiMixin(EntityType<? extends AbstractVillager> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void ontick(CallbackInfo ci) {
        if (MobAI.isTracking((Entity)this, MobAI.TrackingType.IRON_GOLEM_SPAWNING)) {
            Optional last_seen = (Optional)this.f_20939_.m_147339_().get(MemoryModuleType.f_26327_);
            long time = !last_seen.isPresent() ? 0L : ((ExpirableValue)last_seen.get()).m_148191_();
            boolean recentlySeen = time > 0L;
            Optional optional_11 = this.f_20939_.m_21952_(MemoryModuleType.f_26328_);
            boolean sleep = false;
            boolean panic = this.f_20939_.m_21954_(Activity.f_37984_);
            long currentTime = this.m_9236_().m_46467_();
            if (optional_11.isPresent()) {
                sleep = currentTime - (Long)optional_11.get() < 24000L;
            }
            this.m_6593_(Messenger.c((sleep ? "eb " : "fb ") + "\u263d ", (panic ? "lb " : "fb ") + "\u2623 ", (recentlySeen ? "rb " : "lb ") + time));
            this.m_20340_(true);
        } else if (MobAI.isTracking((Entity)this, MobAI.TrackingType.BREEDING)) {
            if (this.f_19797_ % 50 == 0 || this.f_19797_ < 20) {
                this.totalFood = this.m_35529_() / 12;
                this.hasBed = this.f_20939_.m_21952_(MemoryModuleType.f_26359_).isPresent();
                this.displayAge = this.m_146764_();
            }
            if (Math.abs(this.displayAge) < 100 && this.displayAge != 0) {
                this.displayAge = this.m_146764_();
            }
            this.m_6593_(Messenger.c((this.hasBed ? "eb " : "fb ") + "\u2616 ", (this.totalFood > 0 ? "eb " : "fb ") + "\u2668", (this.totalFood > 0 ? "e " : "f ") + this.totalFood + " ", (this.displayAge == 0 ? "eb " : "fb ") + "\u2661", this.displayAge == 0 ? "e " : "f " + this.displayAge));
            this.m_20340_(true);
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void onInteract(Player playerEntity_1, InteractionHand hand_1, CallbackInfoReturnable<InteractionResult> cir) {
        if (MobAI.isTracking((Entity)this, MobAI.TrackingType.BREEDING)) {
            ItemStack itemStack_1 = playerEntity_1.m_21120_(hand_1);
            if (itemStack_1.m_41720_() == Items.f_42616_) {
                GlobalPos bedPos = this.f_20939_.m_21952_(MemoryModuleType.f_26359_).orElse(null);
                if (bedPos == null || bedPos.m_122640_() != this.m_9236_().m_46472_()) {
                    this.m_35518_();
                    ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_194652_, Blocks.f_50375_.m_49966_()), this.m_20185_(), this.m_20186_() + (double)this.m_20192_() + 1.0, this.m_20189_(), 1, 0.1, 0.1, 0.1, 0.0);
                } else {
                    ParticleDisplay.drawParticleLine((ServerPlayer)playerEntity_1, this.m_20182_(), Vec3.m_82512_((Vec3i)bedPos.m_122646_()), "dust 0 0 0 1", "happy_villager", 100, 0.2);
                }
            } else if (itemStack_1.m_41720_() == Items.f_42583_) {
                while (this.m_35529_() >= 12) {
                    this.m_35513_();
                }
            } else if (itemStack_1.m_41720_() instanceof BedItem) {
                List list_1 = ((ServerLevel)this.m_20193_()).m_8904_().m_27181_(type -> type.m_203565_(PoiTypes.f_218060_), this.m_20183_(), 48, PoiManager.Occupancy.ANY).toList();
                for (PoiRecord poi : list_1) {
                    Vec3 pv = Vec3.m_82512_((Vec3i)poi.m_27257_());
                    if (!poi.m_27253_()) {
                        ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, pv.f_82479_, pv.f_82480_ + 1.5, pv.f_82481_, 50, 0.1, 0.3, 0.1, 0.0);
                        continue;
                    }
                    if (this.canReachHome((Villager)this, poi.m_27257_(), poi)) {
                        ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, pv.f_82479_, pv.f_82480_ + 1.0, pv.f_82481_, 50, 0.1, 0.3, 0.1, 0.0);
                        continue;
                    }
                    ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_194652_, Blocks.f_50375_.m_49966_()), pv.f_82479_, pv.f_82480_ + 1.0, pv.f_82481_, 1, 0.1, 0.1, 0.1, 0.0);
                }
            }
            cir.setReturnValue((Object)InteractionResult.FAIL);
            cir.cancel();
        }
    }

    private boolean canReachHome(Villager villager, BlockPos pos, PoiRecord poi) {
        Path path = villager.m_21573_().m_7864_(pos, ((PoiType)poi.m_218018_().m_203334_()).f_27328_());
        return path != null && path.m_77403_();
    }

    @Inject(method={"spawnGolemIfNeeded"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;inflate(DDD)Lnet/minecraft/world/phys/AABB;", shift=At.Shift.AFTER)})
    private void particleIt(ServerLevel serverWorld, long l, int i, CallbackInfo ci) {
        if (MobAI.isTracking((Entity)this, MobAI.TrackingType.IRON_GOLEM_SPAWNING)) {
            ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_194652_, Blocks.f_50375_.m_49966_()), this.m_20185_(), this.m_20186_() + 3.0, this.m_20189_(), 1, 0.1, 0.1, 0.1, 0.0);
        }
    }
}

