/*
 * Decompiled with CFR 0.152.
 */
package carpet.network;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.InvalidRuleValueException;
import carpet.api.settings.SettingsManager;
import carpet.fakes.LevelInterface;
import carpet.helpers.TickRateManager;
import carpet.network.CarpetClient;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;

public class ClientNetworkHandler {
    private static final Map<String, BiConsumer<LocalPlayer, Tag>> dataHandlers = new HashMap<String, BiConsumer<LocalPlayer, Tag>>();

    public static void handleData(FriendlyByteBuf data, LocalPlayer player) {
        if (data != null) {
            int id = data.m_130242_();
            if (id == 69) {
                ClientNetworkHandler.onHi(data);
            }
            if (id == 1) {
                ClientNetworkHandler.onSyncData(data, player);
            }
        }
    }

    private static void onHi(FriendlyByteBuf data) {
        CarpetClient.setCarpet();
        CarpetClient.serverCarpetVersion = data.m_130136_(64);
        if (CarpetSettings.carpetVersion.equals(CarpetClient.serverCarpetVersion)) {
            CarpetSettings.LOG.info("Joined carpet server with matching carpet version");
        } else {
            CarpetSettings.LOG.warn("Joined carpet server with another carpet version: " + CarpetClient.serverCarpetVersion);
        }
        ClientNetworkHandler.respondHello();
    }

    public static void respondHello() {
        CarpetClient.getPlayer().f_108617_.m_104955_((Packet)new ServerboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, new FriendlyByteBuf(Unpooled.buffer()).m_130130_(420).m_130070_(CarpetSettings.carpetVersion)));
    }

    private static void onSyncData(FriendlyByteBuf data, LocalPlayer player) {
        CompoundTag compound = data.m_130260_();
        if (compound == null) {
            return;
        }
        for (String key : compound.m_128431_()) {
            if (dataHandlers.containsKey(key)) {
                try {
                    dataHandlers.get(key).accept(player, compound.m_128423_(key));
                }
                catch (Exception exc) {
                    CarpetSettings.LOG.info("Corrupt carpet data for " + key);
                }
                continue;
            }
            CarpetSettings.LOG.error("Unknown carpet data: " + key);
        }
    }

    public static void clientCommand(String command) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", command);
        tag.m_128359_("command", command);
        CompoundTag outer = new CompoundTag();
        outer.m_128365_("clientCommand", (Tag)tag);
        CarpetClient.getPlayer().f_108617_.m_104955_((Packet)new ServerboundCustomPayloadPacket(CarpetClient.CARPET_CHANNEL, new FriendlyByteBuf(Unpooled.buffer()).m_130130_(1).m_130079_(outer)));
    }

    static {
        dataHandlers.put("Rules", (p, t) -> {
            CompoundTag ruleset = (CompoundTag)t;
            for (String ruleKey : ruleset.m_128431_()) {
                CarpetRule<?> rule;
                String ruleName;
                CompoundTag ruleNBT = (CompoundTag)ruleset.m_128423_(ruleKey);
                SettingsManager manager = null;
                if (ruleNBT.m_128441_("Manager")) {
                    ruleName = ruleNBT.m_128461_("Rule");
                    String managerName = ruleNBT.m_128461_("Manager");
                    if (managerName.equals("carpet")) {
                        manager = CarpetServer.settingsManager;
                    } else {
                        for (CarpetExtension extension : CarpetServer.extensions) {
                            SettingsManager eManager = extension.extensionSettingsManager();
                            if (eManager == null || !managerName.equals(eManager.identifier())) continue;
                            manager = eManager;
                            break;
                        }
                    }
                } else {
                    manager = CarpetServer.settingsManager;
                    ruleName = ruleKey;
                }
                if ((rule = manager != null ? manager.getCarpetRule(ruleName) : null) == null) continue;
                String value = ruleNBT.m_128461_("Value");
                try {
                    rule.set((CommandSourceStack)null, value);
                }
                catch (InvalidRuleValueException invalidRuleValueException) {}
            }
        });
        dataHandlers.put("TickRate", (p, t) -> {
            TickRateManager tickRateManager = ((LevelInterface)p.f_108545_).tickRateManager();
            tickRateManager.setTickRate(((NumericTag)t).m_7057_());
        });
        dataHandlers.put("TickingState", (p, t) -> {
            CompoundTag tickingState = (CompoundTag)t;
            TickRateManager tickRateManager = ((LevelInterface)p.f_108545_).tickRateManager();
            tickRateManager.setFrozenState(tickingState.m_128471_("is_paused"), tickingState.m_128471_("deepFreeze"));
        });
        dataHandlers.put("SuperHotState", (p, t) -> {
            TickRateManager tickRateManager = ((LevelInterface)p.f_108545_).tickRateManager();
            tickRateManager.setSuperHot(((ByteTag)t).equals((Object)ByteTag.f_128257_));
        });
        dataHandlers.put("TickPlayerActiveTimeout", (p, t) -> {
            TickRateManager tickRateManager = ((LevelInterface)p.f_108545_).tickRateManager();
            tickRateManager.setPlayerActiveTimeout(((NumericTag)t).m_7047_());
        });
        dataHandlers.put("scShape", (p, t) -> {
            if (CarpetClient.shapes != null) {
                CarpetClient.shapes.addShape((CompoundTag)t);
            }
        });
        dataHandlers.put("scShapes", (p, t) -> {
            if (CarpetClient.shapes != null) {
                CarpetClient.shapes.addShapes((ListTag)t);
            }
        });
        dataHandlers.put("clientCommand", (p, t) -> CarpetClient.onClientCommand(t));
    }
}

