/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.CarpetContext;
import carpet.script.CarpetScriptHost;
import carpet.script.CarpetScriptServer;
import carpet.script.ScriptHost;
import carpet.script.exception.IntegrityException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.InvalidCallbackException;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.utils.GlocalFlag;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CarpetEventServer {
    public final List<ScheduledCall> scheduledCalls = new LinkedList<ScheduledCall>();
    public final CarpetScriptServer scriptServer;
    private static final List<Value> NOARGS = Collections.emptyList();
    public final Map<String, Event> customEvents = new HashMap<String, Event>();
    public GlocalFlag handleEvents = new GlocalFlag(true);

    public CarpetEventServer(CarpetScriptServer scriptServer) {
        this.scriptServer = scriptServer;
        Event.clearAllBuiltinEvents();
    }

    public void tick() {
        if (Carpet.isTickProcessingPaused(this.scriptServer.server)) {
            return;
        }
        Iterator<ScheduledCall> eventIterator = this.scheduledCalls.iterator();
        ArrayList<ScheduledCall> currentCalls = new ArrayList<ScheduledCall>();
        while (eventIterator.hasNext()) {
            ScheduledCall call = eventIterator.next();
            --call.dueTime;
            if (call.dueTime > 0L) continue;
            currentCalls.add(call);
            eventIterator.remove();
        }
        for (ScheduledCall call : currentCalls) {
            call.execute();
        }
    }

    public void scheduleCall(CarpetContext context, FunctionValue function, List<Value> args, long due) {
        this.scheduledCalls.add(new ScheduledCall(context, function, args, due));
    }

    public void runScheduledCall(BlockPos origin, CommandSourceStack source, String hostname, CarpetScriptHost host, FunctionValue udf, List<Value> argv) {
        if (hostname != null && !this.scriptServer.modules.containsKey(hostname)) {
            return;
        }
        try {
            host.callUDF(origin, source, udf, argv);
        }
        catch (IntegrityException | InvalidCallbackException | NullPointerException exception) {
            // empty catch block
        }
    }

    public CallbackResult runEventCall(CommandSourceStack sender, String hostname, String optionalTarget, FunctionValue udf, List<Value> argv) {
        CarpetScriptHost appHost = this.scriptServer.getAppHostByName(hostname);
        if (appHost == null) {
            return CallbackResult.FAIL;
        }
        if (appHost.isPerUser() && optionalTarget == null) {
            return CallbackResult.PASS;
        }
        ServerPlayer target = null;
        if (optionalTarget != null && (target = sender.m_81377_().m_6846_().m_11255_(optionalTarget)) == null) {
            return CallbackResult.FAIL;
        }
        CommandSourceStack source = sender.m_81325_(Vanilla.MinecraftServer_getRunPermissionLevel(sender.m_81377_()));
        CarpetScriptHost executingHost = appHost.retrieveForExecution(sender, target);
        if (executingHost == null) {
            return CallbackResult.FAIL;
        }
        try {
            Value returnValue = executingHost.callUDF(source, udf, argv);
            return returnValue instanceof StringValue && returnValue.getString().equals("cancel") ? CallbackResult.CANCEL : CallbackResult.SUCCESS;
        }
        catch (IntegrityException | InvalidCallbackException | NullPointerException error) {
            CarpetScriptServer.LOG.error("Got exception when running event call ", (Throwable)error);
            return CallbackResult.FAIL;
        }
    }

    public boolean addEventFromCommand(CommandSourceStack source, String event, String host, String funName) {
        Event ev = Event.getEvent(event, this.scriptServer);
        if (ev == null) {
            return false;
        }
        boolean added = ev.handler.addFromExternal(source, host, funName, h -> this.onEventAddedToHost(ev, (ScriptHost)h), this.scriptServer);
        if (added) {
            Carpet.Messenger_message(source, "gi Added " + funName + " to " + event);
        }
        return added;
    }

    public void addBuiltInEvent(String event, ScriptHost host, FunctionValue function, List<Value> args) {
        Event ev = Event.byName.get(event);
        this.onEventAddedToHost(ev, host);
        boolean success = ev.handler.addEventCallInternal(host, function, args == null ? NOARGS : args);
        if (!success) {
            throw new InternalExpressionException("Global event " + event + " requires " + ev.handler.reqArgs + ", not " + (function.getNumParams() - (args == null ? 0 : args.size())));
        }
    }

    public boolean handleCustomEvent(String event, CarpetScriptHost host, FunctionValue function, List<Value> args) {
        Event ev = Event.getOrCreateCustom(event, this.scriptServer);
        this.onEventAddedToHost(ev, host);
        return ev.handler.addEventCallInternal(host, function, args == null ? NOARGS : args);
    }

    public int signalEvent(String event, CarpetContext cc, @Nullable ServerPlayer target, List<Value> callArgs) {
        Event ev = Event.getEvent(event, ((CarpetScriptHost)cc.host).scriptServer());
        return ev == null ? -1 : ev.handler.signal(cc.source(), target, callArgs);
    }

    private void onEventAddedToHost(Event event, ScriptHost host) {
        if (event.deprecated()) {
            host.issueDeprecation(event.name + " event");
        }
        event.handler.sortByPriority(this.scriptServer);
    }

    public boolean removeEventFromCommand(CommandSourceStack source, String event, String funName) {
        Event ev = Event.getEvent(event, this.scriptServer);
        if (ev == null) {
            Carpet.Messenger_message(source, "r Unknown event: " + event);
            return false;
        }
        Callback.Signature call = Callback.fromString(funName);
        ev.handler.removeEventCall(call.host, call.target, call.function);
        Carpet.Messenger_message(source, "gi Removed event: " + funName + " from " + event);
        return true;
    }

    public boolean removeBuiltInEvent(String event, CarpetScriptHost host) {
        Event ev = Event.getEvent(event, host.scriptServer());
        if (ev == null) {
            return false;
        }
        ev.handler.removeAllCalls(host);
        return true;
    }

    public void removeBuiltInEvent(String event, CarpetScriptHost host, String funName) {
        Event ev = Event.getEvent(event, host.scriptServer());
        if (ev != null) {
            ev.handler.removeEventCall(host.getName(), host.user, funName);
        }
    }

    public void removeAllHostEvents(CarpetScriptHost host) {
        Event.removeAllHostEvents(host);
        if (host.isPerUser()) {
            for (ScriptHost child : host.userHosts.values()) {
                Event.removeAllHostEvents((CarpetScriptHost)child);
            }
        }
        this.scheduledCalls.removeIf(sc -> sc.host != null && sc.host.equals(host.getName()));
    }

    public static class Event {
        public static final Map<String, Event> byName = new HashMap<String, Event>();
        public static final Event START;
        public static final Event SHUTDOWN;
        public static final Event TICK;
        public static final Event NETHER_TICK;
        public static final Event ENDER_TICK;
        public static final Event CHUNK_GENERATED;
        public static final Event CHUNK_LOADED;
        public static final Event CHUNK_UNLOADED;
        public static final Event PLAYER_JUMPS;
        public static final Event PLAYER_DEPLOYS_ELYTRA;
        public static final Event PLAYER_WAKES_UP;
        public static final Event PLAYER_ESCAPES_SLEEP;
        public static final Event PLAYER_RIDES;
        public static final Event PLAYER_USES_ITEM;
        public static final Event PLAYER_CLICKS_BLOCK;
        public static final Event PLAYER_RIGHT_CLICKS_BLOCK;
        public static final Event PLAYER_INTERACTS_WITH_BLOCK;
        public static final Event PLAYER_PLACING_BLOCK;
        public static final Event PLAYER_PLACES_BLOCK;
        public static final Event PLAYER_BREAK_BLOCK;
        public static final Event PLAYER_INTERACTS_WITH_ENTITY;
        public static final Event PLAYER_TRADES;
        public static final Event PLAYER_PICKS_UP_ITEM;
        public static final Event PLAYER_ATTACKS_ENTITY;
        public static final Event PLAYER_STARTS_SNEAKING;
        public static final Event PLAYER_STOPS_SNEAKING;
        public static final Event PLAYER_STARTS_SPRINTING;
        public static final Event PLAYER_STOPS_SPRINTING;
        public static final Event PLAYER_RELEASED_ITEM;
        public static final Event PLAYER_FINISHED_USING_ITEM;
        public static final Event PLAYER_DROPS_ITEM;
        public static final Event PLAYER_DROPS_STACK;
        public static final Event PLAYER_CHOOSES_RECIPE;
        public static final Event PLAYER_SWITCHES_SLOT;
        public static final Event PLAYER_SWAPS_HANDS;
        public static final Event PLAYER_SWINGS_HAND;
        public static final Event PLAYER_TAKES_DAMAGE;
        public static final Event PLAYER_DEALS_DAMAGE;
        public static final Event PLAYER_COLLIDES_WITH_ENTITY;
        public static final Event PLAYER_DIES;
        public static final Event PLAYER_RESPAWNS;
        public static final Event PLAYER_CHANGES_DIMENSION;
        public static final Event PLAYER_CONNECTS;
        public static final Event PLAYER_DISCONNECTS;
        public static final Event PLAYER_MESSAGE;
        public static final Event PLAYER_COMMAND;
        public static final Event STATISTICS;
        public static final Event LIGHTNING;
        public static final Event EXPLOSION_OUTCOME;
        public static final Event EXPLOSION;
        @Deprecated
        public static final Map<EntityType<? extends Entity>, Event> ENTITY_LOAD;
        public static final Map<EntityType<? extends Entity>, Event> ENTITY_HANDLER;
        public final String name;
        public final CallbackList handler;
        public final boolean isPublic;

        public static List<Event> publicEvents(CarpetScriptServer server) {
            List<Event> events = byName.values().stream().filter(e -> e.isPublic).collect(Collectors.toList());
            if (server != null) {
                events.addAll(server.events.customEvents.values());
            }
            return events;
        }

        private static LivingEntity getExplosionCausingEntity(Entity entity) {
            Projectile p;
            Entity owner;
            if (entity == null) {
                return null;
            }
            if (entity instanceof PrimedTnt) {
                PrimedTnt tnt = (PrimedTnt)entity;
                return tnt.m_19749_();
            }
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                return le;
            }
            if (entity instanceof Projectile && (owner = (p = (Projectile)entity).m_19749_()) instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)owner;
                return le;
            }
            return null;
        }

        @Deprecated
        public static String getEntityLoadEventName(EntityType<? extends Entity> et) {
            return "entity_loaded_" + ValueConversions.of(BuiltInRegistries.f_256780_.m_7981_(et)).getString();
        }

        public static String getEntityHandlerEventName(EntityType<? extends Entity> et) {
            return "entity_handler_" + ValueConversions.of(BuiltInRegistries.f_256780_.m_7981_(et)).getString();
        }

        public Event(String name, int reqArgs, boolean isGlobalOnly) {
            this(name, reqArgs, isGlobalOnly, true);
        }

        public Event(String name, int reqArgs, boolean isGlobalOnly, boolean isPublic) {
            this.name = name;
            this.handler = new CallbackList(reqArgs, true, isGlobalOnly);
            this.isPublic = isPublic;
            byName.put(name, this);
        }

        public static List<Event> getAllEvents(CarpetScriptServer server, Predicate<Event> predicate) {
            ArrayList<Event> eventList = new ArrayList<Event>(byName.values());
            eventList.addAll(server.events.customEvents.values());
            if (predicate == null) {
                return eventList;
            }
            return eventList.stream().filter(predicate).toList();
        }

        public static Event getEvent(String name, CarpetScriptServer server) {
            if (byName.containsKey(name)) {
                return byName.get(name);
            }
            return server.events.customEvents.get(name);
        }

        public static Event getOrCreateCustom(String name, CarpetScriptServer server) {
            Event event = Event.getEvent(name, server);
            if (event != null) {
                return event;
            }
            return new Event(name, server);
        }

        public static void removeAllHostEvents(CarpetScriptHost host) {
            byName.values().forEach(e -> e.handler.removeAllCalls(host));
            host.scriptServer().events.customEvents.values().forEach(e -> e.handler.removeAllCalls(host));
        }

        public static void transferAllHostEventsToChild(CarpetScriptHost host) {
            byName.values().forEach(e -> e.handler.createChildEvents(host));
            host.scriptServer().events.customEvents.values().forEach(e -> e.handler.createChildEvents(host));
        }

        public static void clearAllBuiltinEvents() {
            byName.values().forEach(e -> e.handler.clearEverything());
        }

        private Event(String name, CarpetScriptServer server) {
            this.name = name;
            this.handler = new CallbackList(1, false, false);
            this.isPublic = true;
            server.events.customEvents.put(name, this);
        }

        public boolean isNeeded() {
            return this.handler.callList.size() > 0;
        }

        public boolean deprecated() {
            return false;
        }

        public void onTick(MinecraftServer server) {
        }

        public void onChunkEvent(ServerLevel world, ChunkPos chPos, boolean generated) {
        }

        public boolean onPlayerEvent(ServerPlayer player) {
            return false;
        }

        public boolean onPlayerMessage(ServerPlayer player, String message) {
            return false;
        }

        public void onPlayerStatistic(ServerPlayer player, Stat<?> stat, int amount) {
        }

        public void onMountControls(ServerPlayer player, float strafeSpeed, float forwardSpeed, boolean jumping, boolean sneaking) {
        }

        public boolean onItemAction(ServerPlayer player, InteractionHand enumhand, ItemStack itemstack) {
            return false;
        }

        public boolean onBlockAction(ServerPlayer player, BlockPos blockpos, Direction facing) {
            return false;
        }

        public boolean onBlockHit(ServerPlayer player, InteractionHand enumhand, BlockHitResult hitRes) {
            return false;
        }

        public boolean onBlockBroken(ServerPlayer player, BlockPos pos, BlockState previousBS) {
            return false;
        }

        public boolean onBlockPlaced(ServerPlayer player, BlockPos pos, InteractionHand enumhand, ItemStack itemstack) {
            return false;
        }

        public boolean onEntityHandAction(ServerPlayer player, Entity entity, InteractionHand enumhand) {
            return false;
        }

        public void onHandAction(ServerPlayer player, InteractionHand enumhand) {
        }

        public void onEntityAction(Entity entity, boolean created) {
        }

        public void onDimensionChange(ServerPlayer player, Vec3 from, Vec3 to, ResourceKey<Level> fromDim, ResourceKey<Level> dimTo) {
        }

        public boolean onDamage(Entity target, float amount, DamageSource source) {
            return false;
        }

        public boolean onRecipeSelected(ServerPlayer player, ResourceLocation recipe, boolean fullStack) {
            return false;
        }

        public void onSlotSwitch(ServerPlayer player, int from, int to) {
        }

        public void onTrade(ServerPlayer player, Merchant merchant, MerchantOffer tradeOffer) {
        }

        public void onExplosion(ServerLevel world, Entity e, Supplier<LivingEntity> attacker, double x, double y, double z, float power, boolean createFire, List<BlockPos> affectedBlocks, List<Entity> affectedEntities, Explosion.BlockInteraction type) {
        }

        public void onWorldEvent(ServerLevel world, BlockPos pos) {
        }

        public void onWorldEventFlag(ServerLevel world, BlockPos pos, int flag) {
        }

        public void handleAny(Object ... args) {
        }

        public void onCustomPlayerEvent(ServerPlayer player, Object ... args) {
            if (this.handler.reqArgs != args.length + 1) {
                throw new InternalExpressionException("Expected " + this.handler.reqArgs + " arguments for " + this.name + ", got " + (args.length + 1));
            }
            this.handler.call(() -> {
                ArrayList<Value> valArgs = new ArrayList<Value>();
                valArgs.add(EntityValue.of((Entity)player));
                for (Object o : args) {
                    valArgs.add(ValueConversions.guess(player.m_284548_(), o));
                }
                return valArgs;
            }, () -> ((ServerPlayer)player).m_20203_());
        }

        public void onCustomWorldEvent(ServerLevel world, Object ... args) {
            if (this.handler.reqArgs != args.length) {
                throw new InternalExpressionException("Expected " + this.handler.reqArgs + " arguments for " + this.name + ", got " + args.length);
            }
            this.handler.call(() -> {
                ArrayList<Value> valArgs = new ArrayList<Value>();
                for (Object o : args) {
                    valArgs.add(ValueConversions.guess(world, o));
                }
                return valArgs;
            }, () -> world.m_7654_().m_129893_().m_81327_(world));
        }

        static {
            Carpet.initCarpetEvents();
            START = new Event("server_starts", 0, true){

                @Override
                public void onTick(MinecraftServer server) {
                    this.handler.call(Collections::emptyList, () -> ((MinecraftServer)server).m_129893_());
                }
            };
            SHUTDOWN = new Event("server_shuts_down", 0, true){

                @Override
                public void onTick(MinecraftServer server) {
                    this.handler.call(Collections::emptyList, () -> ((MinecraftServer)server).m_129893_());
                }
            };
            TICK = new Event("tick", 0, true){

                @Override
                public void onTick(MinecraftServer server) {
                    this.handler.call(Collections::emptyList, () -> ((MinecraftServer)server).m_129893_());
                }
            };
            NETHER_TICK = new Event("tick_nether", 0, true){

                @Override
                public boolean deprecated() {
                    return true;
                }

                @Override
                public void onTick(MinecraftServer server) {
                    this.handler.call(Collections::emptyList, () -> server.m_129893_().m_81327_(server.m_129880_(Level.f_46429_)));
                }
            };
            ENDER_TICK = new Event("tick_ender", 0, true){

                @Override
                public boolean deprecated() {
                    return true;
                }

                @Override
                public void onTick(MinecraftServer server) {
                    this.handler.call(Collections::emptyList, () -> server.m_129893_().m_81327_(server.m_129880_(Level.f_46430_)));
                }
            };
            CHUNK_GENERATED = new Event("chunk_generated", 2, true){

                @Override
                public void onChunkEvent(ServerLevel world, ChunkPos chPos, boolean generated) {
                    this.handler.call(() -> Arrays.asList(new NumericValue(chPos.f_45578_ << 4), new NumericValue(chPos.f_45579_ << 4)), () -> world.m_7654_().m_129893_().m_81327_(world));
                }
            };
            CHUNK_LOADED = new Event("chunk_loaded", 2, true){

                @Override
                public void onChunkEvent(ServerLevel world, ChunkPos chPos, boolean generated) {
                    this.handler.call(() -> Arrays.asList(new NumericValue(chPos.f_45578_ << 4), new NumericValue(chPos.f_45579_ << 4)), () -> world.m_7654_().m_129893_().m_81327_(world));
                }
            };
            CHUNK_UNLOADED = new Event("chunk_unloaded", 2, true){

                @Override
                public void onChunkEvent(ServerLevel world, ChunkPos chPos, boolean generated) {
                    this.handler.call(() -> Arrays.asList(new NumericValue(chPos.f_45578_ << 4), new NumericValue(chPos.f_45579_ << 4)), () -> world.m_7654_().m_129893_().m_81327_(world));
                }
            };
            PLAYER_JUMPS = new Event("player_jumps", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_DEPLOYS_ELYTRA = new Event("player_deploys_elytra", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_WAKES_UP = new Event("player_wakes_up", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_ESCAPES_SLEEP = new Event("player_escapes_sleep", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_RIDES = new Event("player_rides", 5, false){

                @Override
                public void onMountControls(ServerPlayer player, float strafeSpeed, float forwardSpeed, boolean jumping, boolean sneaking) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), new NumericValue(forwardSpeed), new NumericValue(strafeSpeed), BooleanValue.of(jumping), BooleanValue.of(sneaking)), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_USES_ITEM = new Event("player_uses_item", 3, false){

                @Override
                public boolean onItemAction(ServerPlayer player, InteractionHand enumhand, ItemStack itemstack) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), ValueConversions.of(itemstack, player.m_9236_().m_9598_()), StringValue.of(enumhand == InteractionHand.MAIN_HAND ? "mainhand" : "offhand")), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_CLICKS_BLOCK = new Event("player_clicks_block", 3, false){

                @Override
                public boolean onBlockAction(ServerPlayer player, BlockPos blockpos, Direction facing) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), new BlockValue(null, player.m_284548_(), blockpos), StringValue.of(facing.m_122433_())), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_RIGHT_CLICKS_BLOCK = new Event("player_right_clicks_block", 6, false){

                @Override
                public boolean onBlockHit(ServerPlayer player, InteractionHand enumhand, BlockHitResult hitRes) {
                    return this.handler.call(() -> {
                        ItemStack itemstack = player.m_21120_(enumhand);
                        BlockPos blockpos = hitRes.m_82425_();
                        Direction enumfacing = hitRes.m_82434_();
                        Vec3 vec3d = hitRes.m_82450_().m_82492_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_());
                        return Arrays.asList(new EntityValue((Entity)player), ValueConversions.of(itemstack, player.m_9236_().m_9598_()), StringValue.of(enumhand == InteractionHand.MAIN_HAND ? "mainhand" : "offhand"), new BlockValue(null, player.m_284548_(), blockpos), StringValue.of(enumfacing.m_122433_()), ListValue.of(new NumericValue(vec3d.f_82479_), new NumericValue(vec3d.f_82480_), new NumericValue(vec3d.f_82481_)));
                    }, () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_INTERACTS_WITH_BLOCK = new Event("player_interacts_with_block", 5, false){

                @Override
                public boolean onBlockHit(ServerPlayer player, InteractionHand enumhand, BlockHitResult hitRes) {
                    this.handler.call(() -> {
                        BlockPos blockpos = hitRes.m_82425_();
                        Direction enumfacing = hitRes.m_82434_();
                        Vec3 vec3d = hitRes.m_82450_().m_82492_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_());
                        return Arrays.asList(new EntityValue((Entity)player), StringValue.of(enumhand == InteractionHand.MAIN_HAND ? "mainhand" : "offhand"), new BlockValue(null, player.m_284548_(), blockpos), StringValue.of(enumfacing.m_122433_()), ListValue.of(new NumericValue(vec3d.f_82479_), new NumericValue(vec3d.f_82480_), new NumericValue(vec3d.f_82481_)));
                    }, () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_PLACING_BLOCK = new Event("player_placing_block", 4, false){

                @Override
                public boolean onBlockPlaced(ServerPlayer player, BlockPos pos, InteractionHand enumhand, ItemStack itemstack) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), ValueConversions.of(itemstack, player.m_9236_().m_9598_()), StringValue.of(enumhand == InteractionHand.MAIN_HAND ? "mainhand" : "offhand"), new BlockValue(null, player.m_284548_(), pos)), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_PLACES_BLOCK = new Event("player_places_block", 4, false){

                @Override
                public boolean onBlockPlaced(ServerPlayer player, BlockPos pos, InteractionHand enumhand, ItemStack itemstack) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), ValueConversions.of(itemstack, player.m_9236_().m_9598_()), StringValue.of(enumhand == InteractionHand.MAIN_HAND ? "mainhand" : "offhand"), new BlockValue(null, player.m_284548_(), pos)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_BREAK_BLOCK = new Event("player_breaks_block", 2, false){

                @Override
                public boolean onBlockBroken(ServerPlayer player, BlockPos pos, BlockState previousBS) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), new BlockValue(previousBS, player.m_284548_(), pos)), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_INTERACTS_WITH_ENTITY = new Event("player_interacts_with_entity", 3, false){

                @Override
                public boolean onEntityHandAction(ServerPlayer player, Entity entity, InteractionHand enumhand) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), new EntityValue(entity), StringValue.of(enumhand == InteractionHand.MAIN_HAND ? "mainhand" : "offhand")), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_TRADES = new Event("player_trades", 5, false){

                @Override
                public void onTrade(ServerPlayer player, Merchant merchant, MerchantOffer tradeOffer) {
                    RegistryAccess regs = player.m_9236_().m_9598_();
                    this.handler.call(() -> {
                        Value value;
                        Value[] valueArray = new Value[5];
                        valueArray[0] = new EntityValue((Entity)player);
                        if (merchant instanceof AbstractVillager) {
                            AbstractVillager villager = (AbstractVillager)merchant;
                            value = new EntityValue((Entity)villager);
                        } else {
                            value = Value.NULL;
                        }
                        valueArray[1] = value;
                        valueArray[2] = ValueConversions.of(tradeOffer.m_45352_(), regs);
                        valueArray[3] = ValueConversions.of(tradeOffer.m_45364_(), regs);
                        valueArray[4] = ValueConversions.of(tradeOffer.m_45368_(), regs);
                        return Arrays.asList(valueArray);
                    }, () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_PICKS_UP_ITEM = new Event("player_picks_up_item", 2, false){

                @Override
                public boolean onItemAction(ServerPlayer player, InteractionHand enumhand, ItemStack itemstack) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), ValueConversions.of(itemstack, player.m_9236_().m_9598_())), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_ATTACKS_ENTITY = new Event("player_attacks_entity", 2, false){

                @Override
                public boolean onEntityHandAction(ServerPlayer player, Entity entity, InteractionHand enumhand) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), new EntityValue(entity)), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_STARTS_SNEAKING = new Event("player_starts_sneaking", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_STOPS_SNEAKING = new Event("player_stops_sneaking", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_STARTS_SPRINTING = new Event("player_starts_sprinting", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_STOPS_SPRINTING = new Event("player_stops_sprinting", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_RELEASED_ITEM = new Event("player_releases_item", 3, false){

                @Override
                public boolean onItemAction(ServerPlayer player, InteractionHand enumhand, ItemStack itemstack) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), ValueConversions.of(itemstack, player.m_9236_().m_9598_()), StringValue.of(enumhand == InteractionHand.MAIN_HAND ? "mainhand" : "offhand")), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_FINISHED_USING_ITEM = new Event("player_finishes_using_item", 3, false){

                @Override
                public boolean onItemAction(ServerPlayer player, InteractionHand enumhand, ItemStack itemstack) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), ValueConversions.of(itemstack, player.m_9236_().m_9598_()), new StringValue(enumhand == InteractionHand.MAIN_HAND ? "mainhand" : "offhand")), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_DROPS_ITEM = new Event("player_drops_item", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    return this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_DROPS_STACK = new Event("player_drops_stack", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    return this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_CHOOSES_RECIPE = new Event("player_chooses_recipe", 3, false){

                @Override
                public boolean onRecipeSelected(ServerPlayer player, ResourceLocation recipe, boolean fullStack) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), NBTSerializableValue.nameFromRegistryId(recipe), BooleanValue.of(fullStack)), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_SWITCHES_SLOT = new Event("player_switches_slot", 3, false){

                @Override
                public void onSlotSwitch(ServerPlayer player, int from, int to) {
                    if (from == to) {
                        return;
                    }
                    this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), new NumericValue(from), new NumericValue(to)), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_SWAPS_HANDS = new Event("player_swaps_hands", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    return this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_SWINGS_HAND = new Event("player_swings_hand", 2, false){

                @Override
                public void onHandAction(ServerPlayer player, InteractionHand hand) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), StringValue.of(hand == InteractionHand.MAIN_HAND ? "mainhand" : "offhand")), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_TAKES_DAMAGE = new Event("player_takes_damage", 4, false){

                @Override
                public boolean onDamage(Entity target, float amount, DamageSource source) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue(target), new NumericValue(amount), StringValue.of(source.m_19385_()), source.m_7639_() == null ? Value.NULL : new EntityValue(source.m_7639_())), () -> ((Entity)target).m_20203_());
                }
            };
            PLAYER_DEALS_DAMAGE = new Event("player_deals_damage", 3, false){

                @Override
                public boolean onDamage(Entity target, float amount, DamageSource source) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue(source.m_7639_()), new NumericValue(amount), new EntityValue(target)), () -> source.m_7639_().m_20203_());
                }
            };
            PLAYER_COLLIDES_WITH_ENTITY = new Event("player_collides_with_entity", 2, false){

                @Override
                public boolean onEntityHandAction(ServerPlayer player, Entity entity, InteractionHand enumhand) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), new EntityValue(entity)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_DIES = new Event("player_dies", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_RESPAWNS = new Event("player_respawns", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_CHANGES_DIMENSION = new Event("player_changes_dimension", 5, false){

                @Override
                public void onDimensionChange(ServerPlayer player, Vec3 from, Vec3 to, ResourceKey<Level> fromDim, ResourceKey<Level> dimTo) {
                    Value fromValue = ListValue.fromTriple(from.f_82479_, from.f_82480_, from.f_82481_);
                    NullValue toValue = to == null ? Value.NULL : ListValue.fromTriple(to.f_82479_, to.f_82480_, to.f_82481_);
                    Value fromDimStr = NBTSerializableValue.nameFromRegistryId(fromDim.m_135782_());
                    Value toDimStr = NBTSerializableValue.nameFromRegistryId(dimTo.m_135782_());
                    this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), fromValue, fromDimStr, toValue, toDimStr), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_CONNECTS = new Event("player_connects", 1, false){

                @Override
                public boolean onPlayerEvent(ServerPlayer player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((Entity)player)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_DISCONNECTS = new Event("player_disconnects", 2, false){

                @Override
                public boolean onPlayerMessage(ServerPlayer player, String message) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), new StringValue(message)), () -> ((ServerPlayer)player).m_20203_());
                    return false;
                }
            };
            PLAYER_MESSAGE = new Event("player_message", 2, false){

                @Override
                public boolean onPlayerMessage(ServerPlayer player, String message) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), new StringValue(message)), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            PLAYER_COMMAND = new Event("player_command", 2, false){

                @Override
                public boolean onPlayerMessage(ServerPlayer player, String message) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), new StringValue(message)), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            STATISTICS = new Event("statistic", 4, false){
                private final Set<ResourceLocation> skippedStats = Set.of(Stats.f_12991_, Stats.f_12992_, Stats.f_144255_, Stats.f_144256_);

                private <T> ResourceLocation getStatId(Stat<T> stat) {
                    return stat.m_12859_().m_12893_().m_7981_(stat.m_12867_());
                }

                @Override
                public void onPlayerStatistic(ServerPlayer player, Stat<?> stat, int amount) {
                    ResourceLocation id = this.getStatId(stat);
                    if (this.skippedStats.contains(id)) {
                        return;
                    }
                    Registry registry = player.m_9236_().m_9598_().m_175515_(Registries.f_256849_);
                    this.handler.call(() -> Arrays.asList(new EntityValue((Entity)player), NBTSerializableValue.nameFromRegistryId(registry.m_7981_((Object)stat.m_12859_())), NBTSerializableValue.nameFromRegistryId(id), new NumericValue(amount)), () -> ((ServerPlayer)player).m_20203_());
                }
            };
            LIGHTNING = new Event("lightning", 2, true){

                @Override
                public void onWorldEventFlag(ServerLevel world, BlockPos pos, int flag) {
                    this.handler.call(() -> Arrays.asList(new BlockValue(null, world, pos), flag > 0 ? Value.TRUE : Value.FALSE), () -> world.m_7654_().m_129893_().m_81327_(world));
                }
            };
            EXPLOSION_OUTCOME = new Event("explosion_outcome", 8, true){

                @Override
                public void onExplosion(ServerLevel world, Entity e, Supplier<LivingEntity> attacker, double x, double y, double z, float power, boolean createFire, List<BlockPos> affectedBlocks, List<Entity> affectedEntities, Explosion.BlockInteraction type) {
                    this.handler.call(() -> Arrays.asList(ListValue.fromTriple(x, y, z), NumericValue.of(Float.valueOf(power)), EntityValue.of(e), EntityValue.of((Entity)(attacker != null ? (Entity)attacker.get() : Event.getExplosionCausingEntity(e))), StringValue.of(type.name().toLowerCase(Locale.ROOT)), BooleanValue.of(createFire), ListValue.wrap(affectedBlocks.stream().filter(b -> !world.m_46859_(b)).map(b -> new BlockValue(world.m_8055_(b), world, (BlockPos)b))), ListValue.wrap(affectedEntities.stream().map(EntityValue::of))), () -> world.m_7654_().m_129893_().m_81327_(world));
                }
            };
            EXPLOSION = new Event("explosion", 6, true){

                @Override
                public void onExplosion(ServerLevel world, Entity e, Supplier<LivingEntity> attacker, double x, double y, double z, float power, boolean createFire, List<BlockPos> affectedBlocks, List<Entity> affectedEntities, Explosion.BlockInteraction type) {
                    this.handler.call(() -> Arrays.asList(ListValue.fromTriple(x, y, z), NumericValue.of(Float.valueOf(power)), EntityValue.of(e), EntityValue.of((Entity)(attacker != null ? (Entity)attacker.get() : Event.getExplosionCausingEntity(e))), StringValue.of(type.name().toLowerCase(Locale.ROOT)), BooleanValue.of(createFire)), () -> world.m_7654_().m_129893_().m_81327_(world));
                }
            };
            ENTITY_LOAD = BuiltInRegistries.f_256780_.m_123024_().map(et -> Map.entry(et, new Event(Event.getEntityLoadEventName((EntityType<? extends Entity>)et), 1, true, false){

                @Override
                public void onEntityAction(Entity entity, boolean created) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue(entity)), () -> entity.m_20194_().m_129893_().m_81327_((ServerLevel)entity.m_9236_()).m_81325_(Vanilla.MinecraftServer_getRunPermissionLevel(entity.m_20194_())));
                }
            })).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
            ENTITY_HANDLER = BuiltInRegistries.f_256780_.m_123024_().map(et -> Map.entry(et, new Event(Event.getEntityHandlerEventName((EntityType<? extends Entity>)et), 2, true, false){

                @Override
                public void onEntityAction(Entity entity, boolean created) {
                    this.handler.call(() -> Arrays.asList(new EntityValue(entity), BooleanValue.of(created)), () -> entity.m_20194_().m_129893_().m_81327_((ServerLevel)entity.m_9236_()).m_81325_(Vanilla.MinecraftServer_getRunPermissionLevel(entity.m_20194_())));
                }
            })).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    public static class ScheduledCall
    extends Callback {
        private final CarpetContext ctx;
        public long dueTime;

        public ScheduledCall(CarpetContext context, FunctionValue function, List<Value> args, long dueTime) {
            super(context.host.getName(), null, function, args, (CarpetScriptServer)context.scriptServer());
            this.ctx = context.duplicate();
            this.dueTime = dueTime;
        }

        public void execute() {
            this.scriptServer.events.runScheduledCall(this.ctx.origin(), this.ctx.source(), this.host, (CarpetScriptHost)this.ctx.host, this.function, this.parametrizedArgs);
        }
    }

    public static enum CallbackResult {
        SUCCESS,
        PASS,
        FAIL,
        CANCEL;

    }

    public static class CallbackList {
        private List<Callback> callList = new ArrayList<Callback>();
        private final List<Callback> removedCalls = new ArrayList<Callback>();
        private boolean inCall = false;
        private boolean inSignal = false;
        public final int reqArgs;
        final boolean isSystem;
        final boolean perPlayerDistribution;

        public CallbackList(int reqArgs, boolean isSystem, boolean isGlobalOnly) {
            this.reqArgs = reqArgs;
            this.isSystem = isSystem;
            this.perPlayerDistribution = isSystem && !isGlobalOnly;
        }

        public List<Callback> inspectCurrentCalls() {
            return new ArrayList<Callback>(this.callList);
        }

        private void removeCallsIf(Predicate<Callback> when) {
            if (!this.inCall && !this.inSignal) {
                this.callList.removeIf(when);
                return;
            }
            for (int i = 0; i < this.callList.size(); ++i) {
                Callback call = this.callList.get(i);
                if (!when.test(call)) continue;
                this.removedCalls.add(call);
            }
        }

        public boolean call(Supplier<List<Value>> argumentSupplier, Supplier<CommandSourceStack> cmdSourceSupplier) {
            CommandSourceStack source;
            if (this.callList.isEmpty()) {
                return false;
            }
            try {
                source = cmdSourceSupplier.get();
            }
            catch (NullPointerException noReference) {
                return false;
            }
            CarpetScriptServer scriptServer = Vanilla.MinecraftServer_getScriptServer(source.m_81377_());
            if (scriptServer.stopAll) {
                return false;
            }
            Boolean isCancelled = scriptServer.events.handleEvents.runIfEnabled(() -> {
                String nameCheck;
                Runnable profilerToken = Carpet.startProfilerSection("Scarpet events");
                List argv = (List)argumentSupplier.get();
                String string = nameCheck = this.perPlayerDistribution ? source.m_81368_() : null;
                assert (argv.size() == this.reqArgs);
                boolean cancelled = false;
                try {
                    this.inCall = true;
                    for (int i = 0; i < this.callList.size(); ++i) {
                        Callback call = this.callList.get(i);
                        if (nameCheck != null && call.optionalTarget != null && !nameCheck.equals(call.optionalTarget)) continue;
                        CallbackResult result = call.execute(source, argv);
                        if (result == CallbackResult.CANCEL) {
                            cancelled = true;
                            break;
                        }
                        if (result != CallbackResult.FAIL) continue;
                        this.removedCalls.add(call);
                    }
                }
                finally {
                    this.inCall = false;
                }
                for (Callback call : this.removedCalls) {
                    this.callList.remove(call);
                }
                this.removedCalls.clear();
                profilerToken.run();
                return cancelled;
            });
            return isCancelled != null && isCancelled != false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int signal(CommandSourceStack sender, @Nullable ServerPlayer recipient, List<Value> callArg) {
            if (this.callList.isEmpty()) {
                return 0;
            }
            int successes = 0;
            try {
                this.inSignal = true;
                for (int i = 0; i < this.callList.size(); ++i) {
                    if (this.callList.get(i).signal(sender, recipient, callArg) != CallbackResult.SUCCESS) continue;
                    ++successes;
                }
            }
            finally {
                this.inSignal = false;
            }
            return successes;
        }

        public boolean addFromExternal(CommandSourceStack source, String hostName, String funName, Consumer<ScriptHost> hostOnEventHandler, CarpetScriptServer scriptServer) {
            CarpetScriptHost host = scriptServer.getAppHostByName(hostName);
            if (host == null) {
                Carpet.Messenger_message(source, "r Unknown app " + hostName);
                return false;
            }
            hostOnEventHandler.accept(host);
            FunctionValue udf = host.getFunction(funName);
            if (udf == null || udf.getArguments().size() != this.reqArgs) {
                Carpet.Messenger_message(source, "r Callback doesn't expect required number of arguments: " + this.reqArgs);
                return false;
            }
            String target = null;
            if (host.isPerUser()) {
                try {
                    target = source.m_81375_().m_6302_();
                }
                catch (CommandSyntaxException e) {
                    Carpet.Messenger_message(source, "r Cannot add event to a player scoped app from a command without a player context");
                    return false;
                }
            }
            this.removeEventCall(hostName, target, udf.getString());
            this.callList.add(new Callback(hostName, target, udf, null, scriptServer));
            return true;
        }

        public boolean addEventCallInternal(ScriptHost host, FunctionValue function, List<Value> args) {
            if (function == null || function.getArguments().size() - args.size() != this.reqArgs) {
                return false;
            }
            this.removeEventCall(host.getName(), host.user, function.getString());
            this.callList.add(new Callback(host.getName(), host.user, function, args, (CarpetScriptServer)host.scriptServer()));
            return true;
        }

        public void removeEventCall(String hostName, String target, String funName) {
            this.removeCallsIf(c -> c.function.getString().equals(funName) && Objects.equals(c.host, hostName) && Objects.equals(c.optionalTarget, target));
        }

        public void removeAllCalls(CarpetScriptHost host) {
            this.removeCallsIf(c -> Objects.equals(c.host, host.getName()) && Objects.equals(c.optionalTarget, host.user));
        }

        public void createChildEvents(CarpetScriptHost host) {
            ArrayList copyCalls = new ArrayList();
            this.callList.forEach(c -> {
                if (Objects.equals(c.host, host.getName()) && c.optionalTarget == null) {
                    copyCalls.add(new Callback(c.host, host.user, c.function, c.parametrizedArgs, host.scriptServer()));
                }
            });
            this.callList.addAll(copyCalls);
        }

        public void clearEverything() {
            if (this.inSignal || this.inCall) {
                this.callList = new ArrayList<Callback>();
            }
            this.callList.clear();
        }

        public void sortByPriority(CarpetScriptServer scriptServer) {
            this.callList.sort(Comparator.comparingDouble(c -> -scriptServer.getAppHostByName((String)c.host).eventPriority));
        }
    }

    public static class Callback {
        public final String host;
        @Nullable
        public final String optionalTarget;
        public final FunctionValue function;
        public final List<Value> parametrizedArgs;
        public final CarpetScriptServer scriptServer;

        public Callback(String host, @Nullable String target, FunctionValue function, List<Value> parametrizedArgs, CarpetScriptServer scriptServer) {
            this.host = host;
            this.function = function;
            this.optionalTarget = target;
            this.parametrizedArgs = parametrizedArgs == null ? NOARGS : parametrizedArgs;
            this.scriptServer = scriptServer;
        }

        public CallbackResult execute(CommandSourceStack sender, List<Value> runtimeArgs) {
            if (!this.parametrizedArgs.isEmpty()) {
                runtimeArgs = new ArrayList<Value>(runtimeArgs);
                runtimeArgs.addAll(this.parametrizedArgs);
            }
            if (this.scriptServer.stopAll) {
                return CallbackResult.FAIL;
            }
            return this.scriptServer.events.runEventCall(sender.m_81325_(Vanilla.MinecraftServer_getRunPermissionLevel(sender.m_81377_())), this.host, this.optionalTarget, this.function, runtimeArgs);
        }

        public CallbackResult signal(CommandSourceStack sender, @Nullable ServerPlayer recipient, List<Value> runtimeArgs) {
            return recipient != null && !recipient.m_6302_().equals(this.optionalTarget) ? CallbackResult.FAIL : this.execute(sender, runtimeArgs);
        }

        public String toString() {
            return this.function.getString() + (String)(this.host == null ? "" : "(from " + this.host + (String)(this.optionalTarget == null ? "" : "/" + this.optionalTarget) + ")");
        }

        public static Signature fromString(String str) {
            Pattern find = Pattern.compile("(\\w+)(?:\\(from (\\w+)(?:/(\\w+))?\\))?");
            Matcher matcher = find.matcher(str);
            if (matcher.matches()) {
                return new Signature(matcher.group(1), matcher.group(2), matcher.group(3));
            }
            return new Signature(str, null, null);
        }

        public record Signature(String function, String host, String target) {
        }
    }
}

