/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.Context;
import carpet.script.value.Value;

@FunctionalInterface
public interface LazyValue {
    public static final LazyValue FALSE = (c, t) -> Value.FALSE;
    public static final LazyValue TRUE = (c, t) -> Value.TRUE;
    public static final LazyValue NULL = (c, t) -> Value.NULL;
    public static final LazyValue ZERO = (c, t) -> Value.ZERO;

    public static LazyValue ofConstant(Value val) {
        return new Constant(val);
    }

    public Value evalValue(Context var1, Context.Type var2);

    default public Value evalValue(Context c) {
        return this.evalValue(c, Context.Type.NONE);
    }

    public static class Constant
    implements ContextFreeLazyValue {
        Value result;

        public Constant(Value value) {
            this.result = value;
        }

        public Value get() {
            return this.result;
        }

        @Override
        public Value evalType(Context.Type type) {
            return this.result.fromConstant();
        }

        @Override
        public Value evalValue(Context c, Context.Type type) {
            return this.result.fromConstant();
        }
    }

    @FunctionalInterface
    public static interface ContextFreeLazyValue
    extends LazyValue {
        public Value evalType(Context.Type var1);

        @Override
        default public Value evalValue(Context c, Context.Type type) {
            return this.evalType(type);
        }
    }
}

