/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.CarpetEventServer;
import carpet.script.CarpetExpression;
import carpet.script.CarpetScriptHost;
import carpet.script.CarpetScriptServer;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.ScriptHost;
import carpet.script.Tokenizer;
import carpet.script.exception.CarpetExpressionException;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.utils.AppStoreManager;
import carpet.script.value.FunctionValue;
import carpet.script.value.Value;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.commons.lang3.StringUtils;

public class ScriptCommand {
    private static final TreeSet<String> scarpetFunctions;
    private static final TreeSet<String> APIFunctions;

    public static List<String> suggestFunctions(ScriptHost host, String previous, String prefix) {
        int quoteCount = StringUtils.countMatches((CharSequence)(previous = previous.replace("\\'", "")), (char)'\'');
        if (quoteCount % 2 == 1) {
            return Collections.emptyList();
        }
        int maxLen = prefix.length() < 3 ? prefix.length() * 2 + 1 : 1234;
        String eventPrefix = prefix.startsWith("__on_") ? prefix.substring(5) : null;
        List<String> scarpetMatches = scarpetFunctions.stream().filter(s -> s.startsWith(prefix) && s.length() <= maxLen).map(s -> s + "(").collect(Collectors.toList());
        scarpetMatches.addAll(APIFunctions.stream().filter(s -> s.startsWith(prefix) && s.length() <= maxLen).map(s -> s + "(").toList());
        if (eventPrefix != null) {
            scarpetMatches.addAll(CarpetEventServer.Event.publicEvents(null).stream().filter(e -> e.name.startsWith(eventPrefix)).map(s -> "__on_" + s.name + "(").toList());
        }
        scarpetMatches.addAll(host.globalFunctionNames(host.main, s -> s.startsWith(prefix)).map(s -> s + "(").toList());
        scarpetMatches.addAll(host.globalVariableNames(host.main, s -> s.startsWith(prefix)).toList());
        return scarpetMatches;
    }

    private static CompletableFuture<Suggestions> suggestCode(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) throws CommandSyntaxException {
        char ch;
        CarpetScriptHost currentHost = ScriptCommand.getHost(context);
        String previous = suggestionsBuilder.getRemaining();
        int strlen = previous.length();
        StringBuilder lastToken = new StringBuilder();
        for (int idx = strlen - 1; idx >= 0 && (Character.isLetterOrDigit(ch = previous.charAt(idx)) || ch == '_'); --idx) {
            lastToken.append(ch);
        }
        if (lastToken.length() == 0) {
            return suggestionsBuilder.buildFuture();
        }
        String prefix = lastToken.reverse().toString();
        String previousString = previous.substring(0, previous.length() - prefix.length());
        ScriptCommand.suggestFunctions(currentHost, previousString, prefix).forEach(text -> suggestionsBuilder.suggest(previousString + text));
        return suggestionsBuilder.buildFuture();
    }

    private static CompletableFuture<Suggestions> suggestDownloadableApps(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) throws CommandSyntaxException {
        return CompletableFuture.supplyAsync(() -> {
            String previous = suggestionsBuilder.getRemaining();
            try {
                AppStoreManager.suggestionsFromPath(previous, (CommandSourceStack)context.getSource()).forEach(arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0));
            }
            catch (IOException e) {
                CarpetScriptServer.LOG.warn("Exception when fetching app store structure", (Throwable)e);
            }
            return suggestionsBuilder.build();
        });
    }

    private static CarpetScriptServer ss(CommandContext<CommandSourceStack> context) {
        return Vanilla.MinecraftServer_getScriptServer(((CommandSourceStack)context.getSource()).m_81377_());
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder b = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"globals").executes(context -> ScriptCommand.listGlobals((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82127_((String)"all").executes(context -> ScriptCommand.listGlobals((CommandContext<CommandSourceStack>)context, true)));
        LiteralArgumentBuilder o = (LiteralArgumentBuilder)Commands.m_82127_((String)"stop").executes(cc -> {
            ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).stopAll = true;
            return 1;
        });
        LiteralArgumentBuilder u = (LiteralArgumentBuilder)Commands.m_82127_((String)"resume").executes(cc -> {
            ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).stopAll = false;
            return 1;
        });
        LiteralArgumentBuilder l = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"run").requires(Vanilla::ServerPlayer_canScriptACE)).then(Commands.m_82129_((String)"expr", (ArgumentType)StringArgumentType.greedyString()).suggests(ScriptCommand::suggestCode).executes(cc -> ScriptCommand.compute((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"expr"))));
        LiteralArgumentBuilder s = (LiteralArgumentBuilder)Commands.m_82127_((String)"invoke").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"call", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> SharedSuggestionProvider.m_82970_(ScriptCommand.suggestFunctionCalls((CommandContext<CommandSourceStack>)cc), (SuggestionsBuilder)bb)).executes(cc -> ScriptCommand.invoke((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"call"), null, null, ""))).then(Commands.m_82129_((String)"arguments", (ArgumentType)StringArgumentType.greedyString()).executes(cc -> ScriptCommand.invoke((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"call"), null, null, StringArgumentType.getString((CommandContext)cc, (String)"arguments")))));
        LiteralArgumentBuilder c = (LiteralArgumentBuilder)Commands.m_82127_((String)"invokepoint").then(Commands.m_82129_((String)"call", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> SharedSuggestionProvider.m_82970_(ScriptCommand.suggestFunctionCalls((CommandContext<CommandSourceStack>)cc), (SuggestionsBuilder)bb)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"origin", (ArgumentType)BlockPosArgument.m_118239_()).executes(cc -> ScriptCommand.invoke((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"call"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"origin"), null, ""))).then(Commands.m_82129_((String)"arguments", (ArgumentType)StringArgumentType.greedyString()).executes(cc -> ScriptCommand.invoke((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"call"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"origin"), null, StringArgumentType.getString((CommandContext)cc, (String)"arguments"))))));
        LiteralArgumentBuilder h = (LiteralArgumentBuilder)Commands.m_82127_((String)"invokearea").then(Commands.m_82129_((String)"call", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> SharedSuggestionProvider.m_82970_(ScriptCommand.suggestFunctionCalls((CommandContext<CommandSourceStack>)cc), (SuggestionsBuilder)bb)).then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(cc -> ScriptCommand.invoke((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"call"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"from"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"to"), ""))).then(Commands.m_82129_((String)"arguments", (ArgumentType)StringArgumentType.greedyString()).executes(cc -> ScriptCommand.invoke((CommandContext<CommandSourceStack>)cc, StringArgumentType.getString((CommandContext)cc, (String)"call"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"from"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"to"), StringArgumentType.getString((CommandContext)cc, (String)"arguments")))))));
        LiteralArgumentBuilder i = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"scan").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"origin", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"expr", (ArgumentType)StringArgumentType.greedyString()).suggests(ScriptCommand::suggestCode).executes(cc -> ScriptCommand.scriptScan((CommandContext<CommandSourceStack>)cc, BlockPosArgument.m_174395_((CommandContext)cc, (String)"origin"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"from"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"to"), StringArgumentType.getString((CommandContext)cc, (String)"expr")))))));
        LiteralArgumentBuilder e = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fill").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"origin", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"expr", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)commandBuildContext)).executes(cc -> ScriptCommand.scriptFill((CommandContext<CommandSourceStack>)cc, BlockPosArgument.m_174395_((CommandContext)cc, (String)"origin"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"from"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"to"), StringArgumentType.getString((CommandContext)cc, (String)"expr"), BlockStateArgument.m_116123_((CommandContext)cc, (String)"block"), null, "solid"))).then(Commands.m_82127_((String)"replace").then(Commands.m_82129_((String)"filter", (ArgumentType)BlockPredicateArgument.m_234627_((CommandBuildContext)commandBuildContext)).executes(cc -> ScriptCommand.scriptFill((CommandContext<CommandSourceStack>)cc, BlockPosArgument.m_174395_((CommandContext)cc, (String)"origin"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"from"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"to"), StringArgumentType.getString((CommandContext)cc, (String)"expr"), BlockStateArgument.m_116123_((CommandContext)cc, (String)"block"), BlockPredicateArgument.m_115573_((CommandContext)cc, (String)"filter"), "solid")))))))));
        LiteralArgumentBuilder t = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"outline").requires(player -> player.m_6761_(2))).then(Commands.m_82129_((String)"origin", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"expr", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)commandBuildContext)).executes(cc -> ScriptCommand.scriptFill((CommandContext<CommandSourceStack>)cc, BlockPosArgument.m_174395_((CommandContext)cc, (String)"origin"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"from"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"to"), StringArgumentType.getString((CommandContext)cc, (String)"expr"), BlockStateArgument.m_116123_((CommandContext)cc, (String)"block"), null, "outline"))).then(Commands.m_82127_((String)"replace").then(Commands.m_82129_((String)"filter", (ArgumentType)BlockPredicateArgument.m_234627_((CommandBuildContext)commandBuildContext)).executes(cc -> ScriptCommand.scriptFill((CommandContext<CommandSourceStack>)cc, BlockPosArgument.m_174395_((CommandContext)cc, (String)"origin"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"from"), BlockPosArgument.m_174395_((CommandContext)cc, (String)"to"), StringArgumentType.getString((CommandContext)cc, (String)"expr"), BlockStateArgument.m_116123_((CommandContext)cc, (String)"block"), BlockPredicateArgument.m_115573_((CommandContext)cc, (String)"filter"), "outline")))))))));
        LiteralArgumentBuilder a = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"load").requires(Vanilla::ServerPlayer_canScriptACE)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"app", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> SharedSuggestionProvider.m_82970_(ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).listAvailableModules(true), (SuggestionsBuilder)bb)).executes(cc -> {
            boolean success = ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).addScriptHost((CommandSourceStack)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"app"), null, true, false, false, null);
            return success ? 1 : 0;
        })).then(Commands.m_82127_((String)"global").executes(cc -> {
            boolean success = ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).addScriptHost((CommandSourceStack)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"app"), null, false, false, false, null);
            return success ? 1 : 0;
        })));
        LiteralArgumentBuilder f = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"unload").requires(Vanilla::ServerPlayer_canScriptACE)).then(Commands.m_82129_((String)"app", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> SharedSuggestionProvider.m_82970_(ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).unloadableModules, (SuggestionsBuilder)bb)).executes(cc -> {
            boolean success = ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).removeScriptHost((CommandSourceStack)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"app"), true, false);
            return success ? 1 : 0;
        }));
        LiteralArgumentBuilder q = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"event").requires(Vanilla::ServerPlayer_canScriptACE)).executes(ScriptCommand::listEvents)).then(Commands.m_82127_((String)"add_to").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"event", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> SharedSuggestionProvider.m_82970_((Iterable)CarpetEventServer.Event.publicEvents(ScriptCommand.ss((CommandContext<CommandSourceStack>)cc)).stream().map(ev -> ev.name).collect(Collectors.toList()), (SuggestionsBuilder)bb)).then(Commands.m_82129_((String)"call", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> SharedSuggestionProvider.m_82970_(ScriptCommand.suggestFunctionCalls((CommandContext<CommandSourceStack>)cc), (SuggestionsBuilder)bb)).executes(cc -> ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).events.addEventFromCommand((CommandSourceStack)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"event"), null, StringArgumentType.getString((CommandContext)cc, (String)"call")) ? 1 : 0))).then(Commands.m_82127_((String)"from").then(Commands.m_82129_((String)"app", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> SharedSuggestionProvider.m_82970_(ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).modules.keySet(), (SuggestionsBuilder)bb)).then(Commands.m_82129_((String)"call", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> SharedSuggestionProvider.m_82970_(ScriptCommand.suggestFunctionCalls((CommandContext<CommandSourceStack>)cc), (SuggestionsBuilder)bb)).executes(cc -> ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).events.addEventFromCommand((CommandSourceStack)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"event"), StringArgumentType.getString((CommandContext)cc, (String)"app"), StringArgumentType.getString((CommandContext)cc, (String)"call")) ? 1 : 0))))))).then(Commands.m_82127_((String)"remove_from").then(Commands.m_82129_((String)"event", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> SharedSuggestionProvider.m_82970_((Iterable)CarpetEventServer.Event.publicEvents(ScriptCommand.ss((CommandContext<CommandSourceStack>)cc)).stream().filter(CarpetEventServer.Event::isNeeded).map(ev -> ev.name).collect(Collectors.toList()), (SuggestionsBuilder)bb)).then(Commands.m_82129_((String)"call", (ArgumentType)StringArgumentType.greedyString()).suggests((cc, bb) -> SharedSuggestionProvider.m_82981_(CarpetEventServer.Event.getEvent((String)StringArgumentType.getString((CommandContext)cc, (String)"event"), (CarpetScriptServer)ScriptCommand.ss((CommandContext<CommandSourceStack>)cc)).handler.inspectCurrentCalls().stream().map(CarpetEventServer.Callback::toString), (SuggestionsBuilder)bb)).executes(cc -> ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).events.removeEventFromCommand((CommandSourceStack)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"event"), StringArgumentType.getString((CommandContext)cc, (String)"call")) ? 1 : 0))));
        LiteralArgumentBuilder d = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"download").requires(Vanilla::ServerPlayer_canScriptACE)).then(Commands.m_82129_((String)"path", (ArgumentType)StringArgumentType.greedyString()).suggests(ScriptCommand::suggestDownloadableApps).executes(cc -> AppStoreManager.downloadScript((CommandSourceStack)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"path"))));
        LiteralArgumentBuilder r = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(Vanilla::ServerPlayer_canScriptACE)).then(Commands.m_82129_((String)"app", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> SharedSuggestionProvider.m_82970_(ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).unloadableModules, (SuggestionsBuilder)bb)).executes(cc -> {
            boolean success = ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).uninstallApp((CommandSourceStack)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"app"));
            return success ? 1 : 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"script").requires(Vanilla::ServerPlayer_canScriptGeneral)).then((ArgumentBuilder)b)).then((ArgumentBuilder)u)).then((ArgumentBuilder)o)).then((ArgumentBuilder)l)).then((ArgumentBuilder)s)).then((ArgumentBuilder)c)).then((ArgumentBuilder)h)).then((ArgumentBuilder)i)).then((ArgumentBuilder)e)).then((ArgumentBuilder)t)).then((ArgumentBuilder)a)).then((ArgumentBuilder)f)).then((ArgumentBuilder)q)).then((ArgumentBuilder)d)).then((ArgumentBuilder)r));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"script").requires(Vanilla::ServerPlayer_canScriptGeneral)).then(Commands.m_82127_((String)"in").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"app", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> SharedSuggestionProvider.m_82970_(ScriptCommand.ss((CommandContext<CommandSourceStack>)cc).modules.keySet(), (SuggestionsBuilder)bb)).then((ArgumentBuilder)b)).then((ArgumentBuilder)u)).then((ArgumentBuilder)o)).then((ArgumentBuilder)l)).then((ArgumentBuilder)s)).then((ArgumentBuilder)c)).then((ArgumentBuilder)h)).then((ArgumentBuilder)i)).then((ArgumentBuilder)e)).then((ArgumentBuilder)t))));
    }

    private static CarpetScriptHost getHost(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CarpetScriptHost host;
        CarpetScriptServer scriptServer = ScriptCommand.ss(context);
        try {
            String name = StringArgumentType.getString(context, (String)"app").toLowerCase(Locale.ROOT);
            CarpetScriptHost parentHost = scriptServer.modules.getOrDefault(name, scriptServer.globalHost);
            host = parentHost.retrieveOwnForExecution((CommandSourceStack)context.getSource());
        }
        catch (IllegalArgumentException ignored) {
            host = scriptServer.globalHost;
        }
        host.setChatErrorSnooper((CommandSourceStack)context.getSource());
        return host;
    }

    private static Collection<String> suggestFunctionCalls(CommandContext<CommandSourceStack> c) throws CommandSyntaxException {
        CarpetScriptHost host = ScriptCommand.getHost(c);
        return host.globalFunctionNames(host.main, s -> !s.startsWith("_")).sorted().collect(Collectors.toList());
    }

    private static int listEvents(CommandContext<CommandSourceStack> context) {
        CarpetScriptServer scriptServer = ScriptCommand.ss(context);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Carpet.Messenger_message(source, "w Lists ALL event handlers:");
        for (CarpetEventServer.Event event : CarpetEventServer.Event.getAllEvents(scriptServer, null)) {
            boolean shownEvent = false;
            for (CarpetEventServer.Callback c : event.handler.inspectCurrentCalls()) {
                if (!shownEvent) {
                    Carpet.Messenger_message(source, "w Handlers for " + event.name + ": ");
                    shownEvent = true;
                }
                Carpet.Messenger_message(source, "w  - " + c.function.getString() + (String)(c.host == null ? "" : " (from " + c.host + ")"));
            }
        }
        return 1;
    }

    private static int listGlobals(CommandContext<CommandSourceStack> context, boolean all) throws CommandSyntaxException {
        CarpetScriptHost host = ScriptCommand.getHost(context);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        CarpetScriptServer scriptServer = ScriptCommand.ss(context);
        Carpet.Messenger_message(source, "lb Stored functions" + (String)(host == scriptServer.globalHost ? ":" : " in " + host.getName() + ":"));
        host.globalFunctionNames(host.main, str -> all || !str.startsWith("__")).sorted().forEach(s -> {
            FunctionValue fun = host.getFunction((String)s);
            if (fun == null) {
                Carpet.Messenger_message(source, "gb " + s, "g  - unused import");
                Carpet.Messenger_message(source, "gi ----------------");
                return;
            }
            Expression expr = fun.getExpression();
            Tokenizer.Token tok = fun.getToken();
            List<String> snippet = expr.getExpressionSnippet(tok);
            Carpet.Messenger_message(source, "wb " + fun.fullName(), "t  defined at: line " + (tok.lineno + 1) + " pos " + (tok.linepos + 1));
            for (String snippetLine : snippet) {
                Carpet.Messenger_message(source, "w " + snippetLine);
            }
            Carpet.Messenger_message(source, "gi ----------------");
        });
        Carpet.Messenger_message(source, "w  ");
        Carpet.Messenger_message(source, "lb Global variables" + (String)(host == scriptServer.globalHost ? ":" : " in " + host.getName() + ":"));
        host.globalVariableNames(host.main, s -> s.startsWith("global_")).sorted().forEach(s -> {
            LazyValue variable = host.getGlobalVariable((String)s);
            if (variable == null) {
                Carpet.Messenger_message(source, "gb " + s, "g  - unused import");
            } else {
                Carpet.Messenger_message(source, "wb " + s + ": ", "w " + variable.evalValue(null).getPrettyString());
            }
        });
        return 1;
    }

    public static int handleCall(CommandSourceStack source, CarpetScriptHost host, Supplier<Value> call) {
        try {
            Runnable token = Carpet.startProfilerSection("Scarpet run");
            host.setChatErrorSnooper(source);
            long start = System.nanoTime();
            Value result = call.get();
            long time = (System.nanoTime() - start) / 1000L;
            String metric = "\u00b5s";
            if (time > 5000L) {
                time /= 1000L;
                metric = "ms";
            }
            if (time > 10000L) {
                time /= 1000L;
                metric = "s";
            }
            Carpet.Messenger_message(source, "wi  = ", "wb " + result.getString(), "gi  (" + time + metric + ")");
            int intres = (int)result.readInteger();
            token.run();
            return intres;
        }
        catch (CarpetExpressionException e) {
            host.handleErrorWithStack("Error while evaluating expression", e);
        }
        catch (ArithmeticException ae) {
            host.handleErrorWithStack("Math doesn't compute", ae);
        }
        catch (StackOverflowError soe) {
            host.handleErrorWithStack("Your thoughts are too deep", soe);
        }
        return 0;
    }

    private static int invoke(CommandContext<CommandSourceStack> context, String call, BlockPos pos1, BlockPos pos2, String args) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        CarpetScriptHost host = ScriptCommand.getHost(context);
        if (call.startsWith("__")) {
            Carpet.Messenger_message(source, "r Hidden functions are only callable in scripts");
            return 0;
        }
        ArrayList<Integer> positions = new ArrayList<Integer>();
        if (pos1 != null) {
            positions.add(pos1.m_123341_());
            positions.add(pos1.m_123342_());
            positions.add(pos1.m_123343_());
        }
        if (pos2 != null) {
            positions.add(pos2.m_123341_());
            positions.add(pos2.m_123342_());
            positions.add(pos2.m_123343_());
        }
        return ScriptCommand.handleCall(source, host, () -> host.callLegacy(source, call, positions, args));
    }

    private static int compute(CommandContext<CommandSourceStack> context, String expr) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        CarpetScriptHost host = ScriptCommand.getHost(context);
        return ScriptCommand.handleCall(source, host, () -> {
            CarpetExpression ex = new CarpetExpression(host.main, expr, source, new BlockPos(0, 0, 0));
            return ex.scriptRunCommand(host, BlockPos.m_274446_((Position)source.m_81371_()));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int scriptScan(CommandContext<CommandSourceStack> context, BlockPos origin, BlockPos a, BlockPos b, String expr) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        CarpetScriptHost host = ScriptCommand.getHost(context);
        BoundingBox area = BoundingBox.m_162375_((Vec3i)a, (Vec3i)b);
        CarpetExpression cexpr = new CarpetExpression(host.main, expr, source, origin);
        int int_1 = area.m_71056_() * area.m_71057_() * area.m_71058_();
        if (int_1 > Vanilla.MinecraftServer_getFillLimit(source.m_81377_())) {
            Carpet.Messenger_message(source, "r too many blocks to evaluate: " + int_1);
            return 1;
        }
        int successCount = 0;
        Carpet.getImpendingFillSkipUpdates().set(!Carpet.getFillUpdates());
        try {
            for (int x = area.m_162395_(); x <= area.m_162399_(); ++x) {
                for (int y = area.m_162396_(); y <= area.m_162400_(); ++y) {
                    for (int z = area.m_162398_(); z <= area.m_162401_(); ++z) {
                        try {
                            if (!cexpr.fillAndScanCommand(host, x, y, z)) continue;
                            ++successCount;
                            continue;
                        }
                        catch (ArithmeticException arithmeticException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (CarpetExpressionException exc) {
            host.handleErrorWithStack("Error while processing command", exc);
            int n = 0;
            return n;
        }
        finally {
            Carpet.getImpendingFillSkipUpdates().set(false);
        }
        Carpet.Messenger_message(source, "w Expression successful in " + successCount + " out of " + int_1 + " blocks");
        return successCount;
    }

    private static int scriptFill(CommandContext<CommandSourceStack> context, BlockPos origin, BlockPos a, BlockPos b, String expr, BlockInput block, Predicate<BlockInWorld> replacement, String mode) throws CommandSyntaxException {
        int z;
        int y;
        int x;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        CarpetScriptHost host = ScriptCommand.getHost(context);
        BoundingBox area = BoundingBox.m_162375_((Vec3i)a, (Vec3i)b);
        CarpetExpression cexpr = new CarpetExpression(host.main, expr, source, origin);
        int int_1 = area.m_71056_() * area.m_71057_() * area.m_71058_();
        if (int_1 > Vanilla.MinecraftServer_getFillLimit(source.m_81377_())) {
            Carpet.Messenger_message(source, "r too many blocks to evaluate: " + int_1);
            return 1;
        }
        boolean[][][] volume = new boolean[area.m_71056_()][area.m_71057_()][area.m_71058_()];
        BlockPos.MutableBlockPos mbpos = origin.m_122032_();
        ServerLevel world = source.m_81372_();
        for (int x2 = area.m_162395_(); x2 <= area.m_162399_(); ++x2) {
            for (int y2 = area.m_162396_(); y2 <= area.m_162400_(); ++y2) {
                for (int z2 = area.m_162398_(); z2 <= area.m_162401_(); ++z2) {
                    try {
                        if (!cexpr.fillAndScanCommand(host, x2, y2, z2)) continue;
                        volume[x2 - area.m_162395_()][y2 - area.m_162396_()][z2 - area.m_162398_()] = true;
                        continue;
                    }
                    catch (CarpetExpressionException e) {
                        host.handleErrorWithStack("Exception while filling the area", e);
                        return 0;
                    }
                    catch (ArithmeticException e) {
                        // empty catch block
                    }
                }
            }
        }
        int maxx = area.m_71056_() - 1;
        int maxy = area.m_71057_() - 1;
        int maxz = area.m_71058_() - 1;
        if ("outline".equalsIgnoreCase(mode)) {
            boolean[][][] newVolume = new boolean[area.m_71056_()][area.m_71057_()][area.m_71058_()];
            for (x = 0; x <= maxx; ++x) {
                for (y = 0; y <= maxy; ++y) {
                    for (z = 0; z <= maxz; ++z) {
                        if (!volume[x][y][z] || !(x != 0 && !volume[x - 1][y][z] || x != maxx && !volume[x + 1][y][z] || y != 0 && !volume[x][y - 1][z] || y != maxy && !volume[x][y + 1][z] || z != 0 && !volume[x][y][z - 1]) && (z == maxz || volume[x][y][z + 1])) continue;
                        newVolume[x][y][z] = true;
                    }
                }
            }
            volume = newVolume;
        }
        int affected = 0;
        Carpet.getImpendingFillSkipUpdates().set(!Carpet.getFillUpdates());
        for (x = 0; x <= maxx; ++x) {
            for (y = 0; y <= maxy; ++y) {
                for (z = 0; z <= maxz; ++z) {
                    if (!volume[x][y][z]) continue;
                    mbpos.m_122178_(x + area.m_162395_(), y + area.m_162396_(), z + area.m_162398_());
                    if (replacement != null && !replacement.test(new BlockInWorld((LevelReader)world, (BlockPos)mbpos, true))) continue;
                    BlockEntity tileentity = world.m_7702_((BlockPos)mbpos);
                    Clearable.m_18908_((Object)tileentity);
                    if (!block.m_114670_(world, (BlockPos)mbpos, 2)) continue;
                    ++affected;
                }
            }
        }
        Carpet.getImpendingFillSkipUpdates().set(false);
        if (Carpet.getFillUpdates() && block != null) {
            for (x = 0; x <= maxx; ++x) {
                for (y = 0; y <= maxy; ++y) {
                    for (z = 0; z <= maxz; ++z) {
                        if (!volume[x][y][z]) continue;
                        mbpos.m_122178_(x + area.m_162395_(), y + area.m_162396_(), z + area.m_162398_());
                        Block blokc = world.m_8055_((BlockPos)mbpos).m_60734_();
                        world.m_6289_((BlockPos)mbpos, blokc);
                    }
                }
            }
        }
        Carpet.Messenger_message(source, "gi Affected " + affected + " blocks in " + area.m_71056_() * area.m_71057_() * area.m_71058_() + " block volume");
        return 1;
    }

    static {
        Set<String> allFunctions = new CarpetExpression(null, "null", null, null).getExpr().getFunctionNames();
        scarpetFunctions = new TreeSet<String>(Expression.none.getFunctionNames());
        APIFunctions = allFunctions.stream().filter(s -> !scarpetFunctions.contains(s)).collect(Collectors.toCollection(TreeSet::new));
    }
}

