/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Fluff;
import carpet.script.LazyValue;
import carpet.script.argument.BlockArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.BreakStatement;
import carpet.script.exception.ContinueStatement;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.BlockValue;
import carpet.script.value.LazyListValue;
import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;

public class BlockIterators {
    public static void apply(Expression expression) {
        expression.addLazyFunction("scan", (c, t, llv) -> {
            if (llv.size() < 3) {
                throw new InternalExpressionException("'scan' needs many more arguments");
            }
            List<Value> lv = Fluff.AbstractFunction.unpackLazy(llv.subList(0, llv.size() - 1), c, Context.NONE);
            CarpetContext cc = (CarpetContext)c;
            BlockArgument centerLocator = BlockArgument.findIn(cc, lv, 0);
            Vector3Argument rangeLocator = Vector3Argument.findIn(lv, centerLocator.offset);
            BlockPos center = centerLocator.block.getPos();
            Vec3i range = rangeLocator.fromBlock ? new Vec3i(Mth.m_14107_((double)Math.abs(rangeLocator.vec.f_82479_ - (double)center.m_123341_())), Mth.m_14107_((double)Math.abs(rangeLocator.vec.f_82480_ - (double)center.m_123342_())), Mth.m_14107_((double)Math.abs(rangeLocator.vec.f_82481_ - (double)center.m_123343_()))) : new Vec3i(Mth.m_14107_((double)Math.abs(rangeLocator.vec.f_82479_)), Mth.m_14107_((double)Math.abs(rangeLocator.vec.f_82480_)), Mth.m_14107_((double)Math.abs(rangeLocator.vec.f_82481_)));
            Vec3i upperRange = range;
            if (lv.size() > rangeLocator.offset + 1) {
                rangeLocator = Vector3Argument.findIn(lv, rangeLocator.offset);
                upperRange = rangeLocator.fromBlock ? new Vec3i(Mth.m_14107_((double)Math.abs(rangeLocator.vec.f_82479_ - (double)center.m_123341_())), Mth.m_14107_((double)Math.abs(rangeLocator.vec.f_82480_ - (double)center.m_123342_())), Mth.m_14107_((double)Math.abs(rangeLocator.vec.f_82481_ - (double)center.m_123343_()))) : new Vec3i(Mth.m_14107_((double)Math.abs(rangeLocator.vec.f_82479_)), Mth.m_14107_((double)Math.abs(rangeLocator.vec.f_82480_)), Mth.m_14107_((double)Math.abs(rangeLocator.vec.f_82481_)));
            }
            if (llv.size() != rangeLocator.offset + 1) {
                throw new InternalExpressionException("'scan' takes two, or three block positions, and an expression: " + lv.size() + " " + rangeLocator.offset);
            }
            LazyValue expr = (LazyValue)llv.get(rangeLocator.offset);
            int cx = center.m_123341_();
            int cy = center.m_123342_();
            int cz = center.m_123343_();
            int xrange = range.m_123341_();
            int yrange = range.m_123342_();
            int zrange = range.m_123343_();
            int xprange = upperRange.m_123341_();
            int yprange = upperRange.m_123342_();
            int zprange = upperRange.m_123343_();
            LazyValue xVal = c.getVariable("_x");
            LazyValue yVal = c.getVariable("_y");
            LazyValue zVal = c.getVariable("_z");
            LazyValue defaultVal = c.getVariable("_");
            int sCount = 0;
            block3: for (int y = cy - yrange; y <= cy + yprange; ++y) {
                int yFinal = y;
                c.setVariable("_y", (ct, tt) -> new NumericValue(yFinal).bindTo("_y"));
                for (int x = cx - xrange; x <= cx + xprange; ++x) {
                    int xFinal = x;
                    c.setVariable("_x", (ct, tt) -> new NumericValue(xFinal).bindTo("_x"));
                    for (int z = cz - zrange; z <= cz + zprange; ++z) {
                        Value result;
                        int zFinal = z;
                        c.setVariable("_z", (ct, tt) -> new NumericValue(zFinal).bindTo("_z"));
                        Value blockValue = BlockValue.fromCoords((CarpetContext)c, xFinal, yFinal, zFinal).bindTo("_");
                        c.setVariable("_", (ct, tt) -> blockValue);
                        try {
                            result = expr.evalValue((Context)c, (Context.Type)((Object)t));
                        }
                        catch (ContinueStatement notIgnored) {
                            result = notIgnored.retval;
                        }
                        catch (BreakStatement notIgnored) {
                            break block3;
                        }
                        if (t == Context.VOID || !result.getBoolean()) continue;
                        ++sCount;
                    }
                }
            }
            c.setVariable("_x", xVal);
            c.setVariable("_y", yVal);
            c.setVariable("_z", zVal);
            c.setVariable("_", defaultVal);
            int finalSCount = sCount;
            return (ct, tt) -> new NumericValue(finalSCount);
        });
        expression.addLazyFunction("volume", (c, t, llv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (llv.size() < 3) {
                throw new InternalExpressionException("'volume' needs many more arguments");
            }
            List<Value> lv = Fluff.AbstractFunction.unpackLazy(llv.subList(0, llv.size() - 1), c, Context.NONE);
            BlockArgument pos1Locator = BlockArgument.findIn(cc, lv, 0);
            BlockArgument pos2Locator = BlockArgument.findIn(cc, lv, pos1Locator.offset);
            BlockPos pos1 = pos1Locator.block.getPos();
            BlockPos pos2 = pos2Locator.block.getPos();
            int x1 = pos1.m_123341_();
            int y1 = pos1.m_123342_();
            int z1 = pos1.m_123343_();
            int x2 = pos2.m_123341_();
            int y2 = pos2.m_123342_();
            int z2 = pos2.m_123343_();
            int minx = Math.min(x1, x2);
            int miny = Math.min(y1, y2);
            int minz = Math.min(z1, z2);
            int maxx = Math.max(x1, x2);
            int maxy = Math.max(y1, y2);
            int maxz = Math.max(z1, z2);
            LazyValue expr = (LazyValue)llv.get(pos2Locator.offset);
            LazyValue xVal = c.getVariable("_x");
            LazyValue yVal = c.getVariable("_y");
            LazyValue zVal = c.getVariable("_z");
            LazyValue defaultVal = c.getVariable("_");
            int sCount = 0;
            block3: for (int y = miny; y <= maxy; ++y) {
                int yFinal = y;
                c.setVariable("_y", (ct, tt) -> new NumericValue(yFinal).bindTo("_y"));
                for (int x = minx; x <= maxx; ++x) {
                    int xFinal = x;
                    c.setVariable("_x", (ct, tt) -> new NumericValue(xFinal).bindTo("_x"));
                    for (int z = minz; z <= maxz; ++z) {
                        Value result;
                        int zFinal = z;
                        c.setVariable("_z", (ct, tt) -> new NumericValue(zFinal).bindTo("_z"));
                        Value blockValue = BlockValue.fromCoords((CarpetContext)c, xFinal, yFinal, zFinal).bindTo("_");
                        c.setVariable("_", (ct, tt) -> blockValue);
                        try {
                            result = expr.evalValue((Context)c, (Context.Type)((Object)t));
                        }
                        catch (ContinueStatement notIgnored) {
                            result = notIgnored.retval;
                        }
                        catch (BreakStatement notIgnored) {
                            break block3;
                        }
                        if (t == Context.VOID || !result.getBoolean()) continue;
                        ++sCount;
                    }
                }
            }
            c.setVariable("_x", xVal);
            c.setVariable("_y", yVal);
            c.setVariable("_z", zVal);
            c.setVariable("_", defaultVal);
            int finalSCount = sCount;
            return (ct, tt) -> new NumericValue(finalSCount);
        });
        expression.addContextFunction("neighbours", -1, (c, t, lv) -> {
            BlockPos center = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos();
            ServerLevel world = ((CarpetContext)c).level();
            ArrayList<Value> neighbours = new ArrayList<Value>();
            neighbours.add(new BlockValue(world, center.m_7494_()));
            neighbours.add(new BlockValue(world, center.m_7495_()));
            neighbours.add(new BlockValue(world, center.m_122012_()));
            neighbours.add(new BlockValue(world, center.m_122019_()));
            neighbours.add(new BlockValue(world, center.m_122029_()));
            neighbours.add(new BlockValue(world, center.m_122024_()));
            return ListValue.wrap(neighbours);
        });
        expression.addContextFunction("rect", -1, (c, t, lv) -> {
            int smaxz;
            int smaxy;
            int smaxx;
            int sminz;
            int sminy;
            int sminx;
            final CarpetContext cc = (CarpetContext)c;
            BlockArgument cposLocator = BlockArgument.findIn(cc, lv, 0);
            BlockPos cpos = cposLocator.block.getPos();
            final int cx = cpos.m_123341_();
            final int cy = cpos.m_123342_();
            final int cz = cpos.m_123343_();
            if (lv.size() > cposLocator.offset) {
                Vector3Argument diffLocator = Vector3Argument.findIn(lv, cposLocator.offset);
                if (diffLocator.fromBlock) {
                    sminx = Mth.m_14107_((double)Math.abs(diffLocator.vec.f_82479_ - (double)cx));
                    sminy = Mth.m_14107_((double)Math.abs(diffLocator.vec.f_82480_ - (double)cx));
                    sminz = Mth.m_14107_((double)Math.abs(diffLocator.vec.f_82481_ - (double)cx));
                } else {
                    sminx = Mth.m_14107_((double)Math.abs(diffLocator.vec.f_82479_));
                    sminy = Mth.m_14107_((double)Math.abs(diffLocator.vec.f_82480_));
                    sminz = Mth.m_14107_((double)Math.abs(diffLocator.vec.f_82481_));
                }
                if (lv.size() > diffLocator.offset) {
                    Vector3Argument posDiff = Vector3Argument.findIn(lv, diffLocator.offset);
                    if (posDiff.fromBlock) {
                        smaxx = Mth.m_14107_((double)Math.abs(posDiff.vec.f_82479_ - (double)cx));
                        smaxy = Mth.m_14107_((double)Math.abs(posDiff.vec.f_82480_ - (double)cx));
                        smaxz = Mth.m_14107_((double)Math.abs(posDiff.vec.f_82481_ - (double)cx));
                    } else {
                        smaxx = Mth.m_14107_((double)Math.abs(posDiff.vec.f_82479_));
                        smaxy = Mth.m_14107_((double)Math.abs(posDiff.vec.f_82480_));
                        smaxz = Mth.m_14107_((double)Math.abs(posDiff.vec.f_82481_));
                    }
                } else {
                    smaxx = sminx;
                    smaxy = sminy;
                    smaxz = sminz;
                }
            } else {
                sminx = 1;
                sminy = 1;
                sminz = 1;
                smaxx = 1;
                smaxy = 1;
                smaxz = 1;
            }
            return new LazyListValue(){
                final int minx;
                final int miny;
                final int minz;
                final int maxx;
                final int maxy;
                final int maxz;
                int x;
                int y;
                int z;
                {
                    this.minx = cx - sminx;
                    this.miny = cy - sminy;
                    this.minz = cz - sminz;
                    this.maxx = cx + smaxx;
                    this.maxy = cy + smaxy;
                    this.maxz = cz + smaxz;
                    this.reset();
                }

                @Override
                public boolean hasNext() {
                    return this.y <= this.maxy;
                }

                @Override
                public Value next() {
                    BlockValue r = BlockValue.fromCoords(cc, this.x, this.y, this.z);
                    ++this.x;
                    if (this.x > this.maxx) {
                        this.x = this.minx;
                        ++this.z;
                        if (this.z > this.maxz) {
                            this.z = this.minz;
                            ++this.y;
                        }
                    }
                    return r;
                }

                @Override
                public void fatality() {
                    super.fatality();
                }

                @Override
                public void reset() {
                    this.x = this.minx;
                    this.y = this.miny;
                    this.z = this.minz;
                }

                @Override
                public String getString() {
                    return String.format(Locale.ROOT, "rect[(%d,%d,%d),..,(%d,%d,%d)]", this.minx, this.miny, this.minz, this.maxx, this.maxy, this.maxz);
                }
            };
        });
        expression.addContextFunction("diamond", -1, (c, t, lv) -> {
            int height;
            int width;
            int cz;
            int cy;
            int cx;
            CarpetContext cc;
            block6: {
                cc = (CarpetContext)c;
                BlockArgument cposLocator = BlockArgument.findIn((CarpetContext)c, lv, 0);
                BlockPos cpos = cposLocator.block.getPos();
                try {
                    cx = cpos.m_123341_();
                    cy = cpos.m_123342_();
                    cz = cpos.m_123343_();
                    if (lv.size() == cposLocator.offset) {
                        return ListValue.of(BlockValue.fromCoords(cc, cx, cy - 1, cz), BlockValue.fromCoords(cc, cx, cy, cz), BlockValue.fromCoords(cc, cx - 1, cy, cz), BlockValue.fromCoords(cc, cx, cy, cz - 1), BlockValue.fromCoords(cc, cx + 1, cy, cz), BlockValue.fromCoords(cc, cx, cy, cz + 1), BlockValue.fromCoords(cc, cx, cy + 1, cz));
                    }
                    if (lv.size() == 1 + cposLocator.offset) {
                        width = (int)((NumericValue)lv.get(cposLocator.offset)).getLong();
                        height = 0;
                        break block6;
                    }
                    if (lv.size() == 2 + cposLocator.offset) {
                        width = (int)((NumericValue)lv.get(cposLocator.offset)).getLong();
                        height = (int)((NumericValue)lv.get(cposLocator.offset + 1)).getLong();
                        break block6;
                    }
                    throw new InternalExpressionException("Incorrect number of arguments for 'diamond'");
                }
                catch (ClassCastException ignored) {
                    throw new InternalExpressionException("Attempted to pass a non-number to 'diamond'");
                }
            }
            if (height == 0) {
                return new LazyListValue(){
                    int curradius;
                    int curpos;
                    {
                        this.reset();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.curradius <= width;
                    }

                    @Override
                    public Value next() {
                        if (this.curradius == 0) {
                            this.curradius = 1;
                            return BlockValue.fromCoords(cc, cx, cy, cz);
                        }
                        BlockValue block = BlockValue.fromCoords(cc, cx + (this.curradius - Math.abs(this.curpos - 2 * this.curradius)), cy, cz - this.curradius + Math.abs(Math.abs(this.curpos - this.curradius) % (4 * this.curradius) - 2 * this.curradius));
                        ++this.curpos;
                        if (this.curpos >= this.curradius * 4) {
                            ++this.curradius;
                            this.curpos = 0;
                        }
                        return block;
                    }

                    @Override
                    public void reset() {
                        this.curradius = 0;
                        this.curpos = 0;
                    }

                    @Override
                    public String getString() {
                        return String.format(Locale.ROOT, "diamond[(%d,%d,%d),%d,0]", cx, cy, cz, width);
                    }
                };
            }
            return new LazyListValue(){
                int curradius;
                int curpos;
                int curheight;
                {
                    this.reset();
                }

                @Override
                public boolean hasNext() {
                    return this.curheight <= height;
                }

                @Override
                public Value next() {
                    if (this.curheight == -height || this.curheight == height) {
                        return BlockValue.fromCoords(cc, cx, cy + this.curheight++, cz);
                    }
                    if (this.curradius == 0) {
                        ++this.curradius;
                        return BlockValue.fromCoords(cc, cx, cy + this.curheight, cz);
                    }
                    BlockValue block = BlockValue.fromCoords(cc, cx + (this.curradius - Math.abs(this.curpos - 2 * this.curradius)), cy + this.curheight, cz - this.curradius + Math.abs(Math.abs(this.curpos - this.curradius) % (4 * this.curradius) - 2 * this.curradius));
                    ++this.curpos;
                    if (this.curpos >= this.curradius * 4) {
                        ++this.curradius;
                        this.curpos = 0;
                        if (this.curradius > width - Math.abs(width * this.curheight / height)) {
                            ++this.curheight;
                            this.curradius = 0;
                        }
                    }
                    return block;
                }

                @Override
                public void reset() {
                    this.curradius = 0;
                    this.curpos = 0;
                    this.curheight = -height;
                }

                @Override
                public String getString() {
                    return String.format(Locale.ROOT, "diamond[(%d,%d,%d),%d,%d]", cx, cy, cz, width, height);
                }
            };
        });
    }
}

