/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.Expression;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Vanilla;
import carpet.script.utils.InputValidator;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class Scoreboards {
    private static String getScoreboardKeyFromValue(Value keyValue) {
        if (keyValue instanceof EntityValue) {
            EntityValue ev = (EntityValue)keyValue;
            Entity e = ev.getEntity();
            return e instanceof Player ? e.m_7755_().getString() : e.m_20149_();
        }
        return keyValue.getString();
    }

    public static void apply(Expression expression) {
        expression.addContextFunction("scoreboard", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            ServerScoreboard scoreboard = cc.server().m_129896_();
            if (lv.isEmpty()) {
                return ListValue.wrap(scoreboard.m_83474_().stream().map(StringValue::new));
            }
            String objectiveName = ((Value)lv.get(0)).getString();
            Objective objective = scoreboard.m_83469_(objectiveName);
            if (objective == null) {
                return Value.NULL;
            }
            if (lv.size() == 1) {
                return ListValue.wrap(scoreboard.m_83498_(objective).stream().map(s -> new StringValue(s.m_83405_())));
            }
            String key = Scoreboards.getScoreboardKeyFromValue((Value)lv.get(1));
            if (lv.size() == 2) {
                return !scoreboard.m_83461_(key, objective) ? Value.NULL : NumericValue.of(scoreboard.m_83471_(key, objective).m_83400_());
            }
            Value value = (Value)lv.get(2);
            if (value.isNull()) {
                Score score = scoreboard.m_83471_(key, objective);
                scoreboard.m_83479_(key, objective);
                return NumericValue.of(score.m_83400_());
            }
            if (value instanceof NumericValue) {
                Score score = scoreboard.m_83471_(key, objective);
                score.m_83402_(NumericValue.asNumber(value).getInt());
                return NumericValue.of(score.m_83400_());
            }
            throw new InternalExpressionException("'scoreboard' requires a number or null as the third parameter");
        });
        expression.addContextFunction("scoreboard_remove", -1, (c, t, lv) -> {
            String objectiveName;
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'scoreboard_remove' requires at least one parameter");
            }
            CarpetContext cc = (CarpetContext)c;
            ServerScoreboard scoreboard = cc.server().m_129896_();
            Objective objective = scoreboard.m_83469_(objectiveName = ((Value)lv.get(0)).getString());
            if (objective == null) {
                return Value.FALSE;
            }
            if (lv.size() == 1) {
                scoreboard.m_83502_(objective);
                return Value.TRUE;
            }
            String key = Scoreboards.getScoreboardKeyFromValue((Value)lv.get(1));
            if (!scoreboard.m_83461_(key, objective)) {
                return Value.NULL;
            }
            Score scoreboardPlayerScore = scoreboard.m_83471_(key, objective);
            NumericValue previous = new NumericValue(scoreboardPlayerScore.m_83400_());
            scoreboard.m_83479_(key, objective);
            return previous;
        });
        expression.addContextFunction("scoreboard_add", -1, (c, t, lv) -> {
            ObjectiveCriteria criterion;
            CarpetContext cc = (CarpetContext)c;
            ServerScoreboard scoreboard = cc.server().m_129896_();
            if (lv.isEmpty() || lv.size() > 2) {
                throw new InternalExpressionException("'scoreboard_add' should have one or two parameters");
            }
            String objectiveName = ((Value)lv.get(0)).getString();
            if (lv.size() == 1) {
                criterion = ObjectiveCriteria.f_83588_;
            } else {
                String critetionName = ((Value)lv.get(1)).getString();
                criterion = ObjectiveCriteria.m_83614_((String)critetionName).orElse(null);
                if (criterion == null) {
                    throw new ThrowStatement(critetionName, Throwables.UNKNOWN_CRITERION);
                }
            }
            Objective objective = scoreboard.m_83469_(objectiveName);
            if (objective != null) {
                c.host.issueDeprecation("reading or modifying an objective's criterion with scoreboard_add");
                if (lv.size() == 1) {
                    return StringValue.of(objective.m_83321_().m_83620_());
                }
                if (objective.m_83321_().equals(criterion) || lv.size() == 1) {
                    return Value.NULL;
                }
                Vanilla.Scoreboard_getObjectivesByCriterion((Scoreboard)scoreboard).get(objective.m_83321_()).remove(objective);
                Vanilla.Objective_setCriterion(objective, criterion);
                Vanilla.Scoreboard_getObjectivesByCriterion((Scoreboard)scoreboard).computeIfAbsent(criterion, cr -> Lists.newArrayList()).add(objective);
                scoreboard.m_7092_(objective);
                return Value.FALSE;
            }
            scoreboard.m_83436_(objectiveName, criterion, (Component)Component.m_237113_((String)objectiveName), criterion.m_83622_());
            return Value.TRUE;
        });
        expression.addContextFunction("scoreboard_property", -1, (c, t, lv) -> {
            String property;
            if (lv.size() < 2) {
                throw new InternalExpressionException("'scoreboard_property' requires at least two parameters");
            }
            CarpetContext cc = (CarpetContext)c;
            ServerScoreboard scoreboard = cc.server().m_129896_();
            Objective objective = scoreboard.m_83469_(((Value)lv.get(0)).getString());
            if (objective == null) {
                return Value.NULL;
            }
            boolean modify = lv.size() > 2;
            Value setValue = null;
            if (modify) {
                setValue = (Value)lv.get(2);
            }
            switch (property = ((Value)lv.get(1)).getString()) {
                case "criterion": {
                    if (modify) {
                        ObjectiveCriteria criterion = ObjectiveCriteria.m_83614_((String)setValue.getString()).orElse(null);
                        if (criterion == null) {
                            throw new InternalExpressionException("Unknown scoreboard criterion: " + setValue.getString());
                        }
                        if (objective.m_83321_().equals(criterion) || lv.size() == 1) {
                            return Value.FALSE;
                        }
                        Vanilla.Scoreboard_getObjectivesByCriterion((Scoreboard)scoreboard).get(objective.m_83321_()).remove(objective);
                        Vanilla.Objective_setCriterion(objective, criterion);
                        Vanilla.Scoreboard_getObjectivesByCriterion((Scoreboard)scoreboard).computeIfAbsent(criterion, cr -> Lists.newArrayList()).add(objective);
                        scoreboard.m_7092_(objective);
                        return Value.TRUE;
                    }
                    return StringValue.of(objective.m_83321_().m_83620_());
                }
                case "display_name": {
                    if (modify) {
                        Component text = FormattedTextValue.getTextByValue(setValue);
                        objective.m_83316_(text);
                        return Value.TRUE;
                    }
                    return new FormattedTextValue(objective.m_83322_());
                }
                case "display_slot": {
                    if (modify) {
                        int slotId = Scoreboard.m_83504_((String)setValue.getString());
                        if (slotId == -1) {
                            throw new InternalExpressionException("Unknown scoreboard display slot: " + setValue.getString());
                        }
                        if (objective.equals(scoreboard.m_83416_(slotId))) {
                            return Value.FALSE;
                        }
                        scoreboard.m_7136_(slotId, objective);
                        return Value.TRUE;
                    }
                    ArrayList<Value> slots = new ArrayList<Value>();
                    for (int i = 0; i < 19; ++i) {
                        if (scoreboard.m_83416_(i) != objective) continue;
                        String slotName = Scoreboard.m_83453_((int)i);
                        slots.add(StringValue.of(slotName));
                    }
                    return ListValue.wrap(slots);
                }
                case "render_type": {
                    if (modify) {
                        ObjectiveCriteria.RenderType renderType = ObjectiveCriteria.RenderType.m_83634_((String)setValue.getString().toLowerCase());
                        if (objective.m_83324_().equals((Object)renderType)) {
                            return Value.FALSE;
                        }
                        objective.m_83314_(renderType);
                        return Value.TRUE;
                    }
                    return StringValue.of(objective.m_83324_().m_83633_());
                }
            }
            throw new InternalExpressionException("scoreboard property '" + property + "' is not a valid property");
        });
        expression.addContextFunction("scoreboard_display", 2, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            ServerScoreboard scoreboard = cc.server().m_129896_();
            String location = ((Value)lv.get(0)).getString();
            int slot = Scoreboard.m_83504_((String)location);
            if (slot < 0) {
                throw new InternalExpressionException("Invalid objective slot: " + location);
            }
            Value target = (Value)lv.get(1);
            if (target.isNull()) {
                scoreboard.m_7136_(slot, null);
                return new NumericValue(slot);
            }
            String objectiveString = target.getString();
            Objective objective = scoreboard.m_83469_(objectiveString);
            if (objective == null) {
                return Value.NULL;
            }
            scoreboard.m_7136_(slot, objective);
            return new NumericValue(slot);
        });
        expression.addContextFunction("team_list", -1, (c, t, lv) -> {
            if (lv.size() > 1) {
                throw new InternalExpressionException("'team_list' requires zero or one parameters");
            }
            CarpetContext cc = (CarpetContext)c;
            ServerScoreboard scoreboard = cc.server().m_129896_();
            if (lv.isEmpty()) {
                return ListValue.wrap(scoreboard.m_83488_().stream().map(StringValue::of));
            }
            if (lv.size() != 1) {
                return Value.NULL;
            }
            PlayerTeam team = scoreboard.m_83489_(((Value)lv.get(0)).getString());
            return team == null ? Value.NULL : ListValue.wrap(team.m_6809_().stream().map(StringValue::of));
        });
        expression.addContextFunction("team_add", -1, (c, t, lv) -> {
            if (lv.size() >= 3 || lv.isEmpty()) {
                throw new InternalExpressionException("'team_add' requires one or two parameters");
            }
            CarpetContext cc = (CarpetContext)c;
            ServerScoreboard scoreboard = cc.server().m_129896_();
            String teamName = ((Value)lv.get(0)).getString();
            if (lv.size() == 1) {
                if (scoreboard.m_83489_(teamName) != null) {
                    return Value.NULL;
                }
                scoreboard.m_83492_(teamName);
                return new StringValue(teamName);
            }
            if (lv.size() != 2) {
                return Value.NULL;
            }
            Value playerVal = (Value)lv.get(1);
            String player = EntityValue.getPlayerNameByValue(playerVal);
            if (player == null) {
                return Value.NULL;
            }
            PlayerTeam team = scoreboard.m_83489_(teamName);
            if (team == null) {
                return Value.NULL;
            }
            if (team.m_83536_((Team)scoreboard.m_83500_(player))) {
                return Value.FALSE;
            }
            scoreboard.m_6546_(player, team);
            return Value.TRUE;
        });
        expression.addContextFunction("team_remove", 1, (c, t, lv) -> {
            Value teamVal;
            CarpetContext cc = (CarpetContext)c;
            ServerScoreboard scoreboard = cc.server().m_129896_();
            PlayerTeam team = scoreboard.m_83489_((teamVal = (Value)lv.get(0)).getString());
            if (team == null) {
                return Value.NULL;
            }
            scoreboard.m_83475_(team);
            return Value.TRUE;
        });
        expression.addContextFunction("team_leave", 1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            ServerScoreboard scoreboard = cc.server().m_129896_();
            Value playerVal = (Value)lv.get(0);
            String player = EntityValue.getPlayerNameByValue(playerVal);
            return player == null ? Value.NULL : BooleanValue.of(scoreboard.m_83495_(player));
        });
        expression.addContextFunction("team_property", -1, (c, t, lv) -> {
            PlayerTeam team;
            CarpetContext cc = (CarpetContext)c;
            ServerScoreboard scoreboard = cc.server().m_129896_();
            if (lv.size() < 2 || lv.size() > 3) {
                throw new InternalExpressionException("'team_property' requires two or three arguments");
            }
            Value teamVal = (Value)lv.get(0);
            Value propertyVal = (Value)lv.get(1);
            Value settingVal = null;
            boolean modifying = false;
            if (lv.size() == 3) {
                modifying = true;
                settingVal = (Value)lv.get(2);
            }
            if ((team = scoreboard.m_83489_(teamVal.getString())) == null) {
                return Value.NULL;
            }
            if (!(propertyVal instanceof StringValue)) {
                throw new InternalExpressionException("'team_property' requires a string as the second argument");
            }
            switch (propertyVal.getString()) {
                case "collisionRule": {
                    if (!modifying) {
                        return new StringValue(team.m_7156_().f_83543_);
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string as the third argument for the property " + propertyVal.getString());
                    }
                    Team.CollisionRule collisionRule = Team.CollisionRule.m_83555_((String)settingVal.getString());
                    if (collisionRule == null) {
                        throw new InternalExpressionException("Unknown value for property " + propertyVal.getString() + ": " + settingVal.getString());
                    }
                    team.m_83344_(collisionRule);
                    break;
                }
                case "color": {
                    if (!modifying) {
                        return new StringValue(team.m_7414_().m_126666_());
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string as the third argument for the property " + propertyVal.getString());
                    }
                    ChatFormatting color = ChatFormatting.m_126657_((String)settingVal.getString().toUpperCase());
                    if (color == null || !color.m_126664_()) {
                        throw new InternalExpressionException("Unknown value for property " + propertyVal.getString() + ": " + settingVal.getString());
                    }
                    team.m_83351_(color);
                    break;
                }
                case "deathMessageVisibility": {
                    if (!modifying) {
                        return new StringValue(team.m_7468_().f_83567_);
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string as the third argument for the property " + propertyVal.getString());
                    }
                    Team.Visibility deathMessageVisibility = Team.Visibility.m_83579_((String)settingVal.getString());
                    if (deathMessageVisibility == null) {
                        throw new InternalExpressionException("Unknown value for property " + propertyVal.getString() + ": " + settingVal.getString());
                    }
                    team.m_83358_(deathMessageVisibility);
                    break;
                }
                case "displayName": {
                    if (!modifying) {
                        return new FormattedTextValue(team.m_83364_());
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string or formatted text as the third argument for the property " + propertyVal.getString());
                    }
                    team.m_83353_(FormattedTextValue.getTextByValue(settingVal));
                    break;
                }
                case "friendlyFire": {
                    if (!modifying) {
                        return BooleanValue.of(team.m_6260_());
                    }
                    if (!(settingVal instanceof NumericValue)) {
                        throw new InternalExpressionException("'team_property' requires a boolean as the third argument for the property " + propertyVal.getString());
                    }
                    team.m_83355_(settingVal.getBoolean());
                    break;
                }
                case "nametagVisibility": {
                    if (!modifying) {
                        return new StringValue(team.m_7470_().f_83567_);
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string as the third argument for the property " + propertyVal.getString());
                    }
                    Team.Visibility nametagVisibility = Team.Visibility.m_83579_((String)settingVal.getString());
                    if (nametagVisibility == null) {
                        throw new InternalExpressionException("Unknown value for property " + propertyVal.getString() + ": " + settingVal.getString());
                    }
                    team.m_83346_(nametagVisibility);
                    break;
                }
                case "prefix": {
                    if (!modifying) {
                        return new FormattedTextValue(team.m_83370_());
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property ' requires a string or formatted text as the third argument for the property " + propertyVal.getString());
                    }
                    team.m_83360_(FormattedTextValue.getTextByValue(settingVal));
                    break;
                }
                case "seeFriendlyInvisibles": {
                    if (!modifying) {
                        return BooleanValue.of(team.m_6259_());
                    }
                    if (!(settingVal instanceof NumericValue)) {
                        throw new InternalExpressionException("'team_property' requires a boolean as the third argument for the property " + propertyVal.getString());
                    }
                    team.m_83362_(settingVal.getBoolean());
                    break;
                }
                case "suffix": {
                    if (!modifying) {
                        return new FormattedTextValue(team.m_83371_());
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string or formatted text as the third argument for the property " + propertyVal.getString());
                    }
                    team.m_83365_(FormattedTextValue.getTextByValue(settingVal));
                    break;
                }
                default: {
                    throw new InternalExpressionException("team property '" + propertyVal.getString() + "' is not a valid property");
                }
            }
            return Value.TRUE;
        });
        expression.addContextFunction("bossbar", -1, (c, t, lv) -> {
            CustomBossEvents bossBarManager = ((CarpetContext)c).server().m_129901_();
            if (lv.size() > 3) {
                throw new InternalExpressionException("'bossbar' accepts max three arguments");
            }
            if (lv.isEmpty()) {
                return ListValue.wrap(bossBarManager.m_136304_().stream().map(CustomBossEvent::m_136263_).map(ResourceLocation::toString).map(StringValue::of));
            }
            String id = ((Value)lv.get(0)).getString();
            ResourceLocation identifier = InputValidator.identifierOf(id);
            if (lv.size() == 1) {
                if (bossBarManager.m_136297_(identifier) != null) {
                    return Value.FALSE;
                }
                return StringValue.of(bossBarManager.m_136299_(identifier, (Component)Component.m_237113_((String)id)).m_136263_().toString());
            }
            String property = ((Value)lv.get(1)).getString();
            CustomBossEvent bossBar = bossBarManager.m_136297_(identifier);
            if (bossBar == null) {
                return Value.NULL;
            }
            Value propertyValue = lv.size() == 3 ? (Value)lv.get(2) : null;
            switch (property) {
                case "color": {
                    if (propertyValue == null) {
                        BossEvent.BossBarColor color = bossBar.m_18862_();
                        return color == null ? Value.NULL : StringValue.of(color.m_18886_());
                    }
                    BossEvent.BossBarColor color = BossEvent.BossBarColor.m_18884_((String)propertyValue.getString());
                    if (color == null) {
                        return Value.NULL;
                    }
                    bossBar.m_6451_(BossEvent.BossBarColor.m_18884_((String)propertyValue.getString()));
                    return Value.TRUE;
                }
                case "max": {
                    if (propertyValue == null) {
                        return NumericValue.of(bossBar.m_136285_());
                    }
                    if (!(propertyValue instanceof NumericValue)) {
                        throw new InternalExpressionException("'bossbar' requires a number as the value for the property " + property);
                    }
                    NumericValue number = (NumericValue)propertyValue;
                    bossBar.m_136278_(number.getInt());
                    return Value.TRUE;
                }
                case "name": {
                    if (propertyValue == null) {
                        return new FormattedTextValue(bossBar.m_18861_());
                    }
                    bossBar.m_6456_(FormattedTextValue.getTextByValue(propertyValue));
                    return Value.TRUE;
                }
                case "add_player": {
                    if (propertyValue == null) {
                        throw new InternalExpressionException("Bossbar property " + property + " can't be queried, add a third parameter");
                    }
                    if (propertyValue instanceof ListValue) {
                        ListValue list = (ListValue)propertyValue;
                        list.getItems().forEach(v -> {
                            ServerPlayer player = EntityValue.getPlayerByValue(((CarpetContext)c).server(), propertyValue);
                            if (player != null) {
                                bossBar.m_6543_(player);
                            }
                        });
                        return Value.TRUE;
                    }
                    ServerPlayer player = EntityValue.getPlayerByValue(((CarpetContext)c).server(), propertyValue);
                    if (player != null) {
                        bossBar.m_6543_(player);
                        return Value.TRUE;
                    }
                    return Value.FALSE;
                }
                case "players": {
                    if (propertyValue == null) {
                        return ListValue.wrap(bossBar.m_8324_().stream().map(EntityValue::new));
                    }
                    if (propertyValue instanceof ListValue) {
                        ListValue list = (ListValue)propertyValue;
                        bossBar.m_7706_();
                        list.getItems().forEach(v -> {
                            ServerPlayer p = EntityValue.getPlayerByValue(((CarpetContext)c).server(), v);
                            if (p != null) {
                                bossBar.m_6543_(p);
                            }
                        });
                        return Value.TRUE;
                    }
                    ServerPlayer p = EntityValue.getPlayerByValue(((CarpetContext)c).server(), propertyValue);
                    bossBar.m_7706_();
                    if (p != null) {
                        bossBar.m_6543_(p);
                        return Value.TRUE;
                    }
                    return Value.FALSE;
                }
                case "style": {
                    if (propertyValue == null) {
                        return StringValue.of(bossBar.m_18863_().m_18902_());
                    }
                    BossEvent.BossBarOverlay style = BossEvent.BossBarOverlay.m_18903_((String)propertyValue.getString());
                    if (style == null) {
                        throw new InternalExpressionException("'" + propertyValue.getString() + "' is not a valid value for property " + property);
                    }
                    bossBar.m_5648_(style);
                    return Value.TRUE;
                }
                case "value": {
                    if (propertyValue == null) {
                        return NumericValue.of(bossBar.m_136282_());
                    }
                    if (!(propertyValue instanceof NumericValue)) {
                        throw new InternalExpressionException("'bossbar' requires a number as the value for the property " + property);
                    }
                    NumericValue number = (NumericValue)propertyValue;
                    bossBar.m_136264_(number.getInt());
                    return Value.TRUE;
                }
                case "visible": {
                    if (propertyValue == null) {
                        return BooleanValue.of(bossBar.m_8323_());
                    }
                    bossBar.m_8321_(propertyValue.getBoolean());
                    return Value.TRUE;
                }
                case "remove": {
                    bossBarManager.m_136302_(bossBar);
                    return Value.TRUE;
                }
            }
            throw new InternalExpressionException("Unknown bossbar property " + property);
        });
    }
}

