/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.command;

import carpet.script.CarpetScriptHost;
import carpet.script.CarpetScriptServer;
import carpet.script.argument.FunctionArgument;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.AngleArgument;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ObjectiveCriteriaArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.ScoreboardSlotArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.SwizzleArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.BossBarCommands;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.scores.Scoreboard;

public abstract class CommandArgument {
    private static final List<? extends CommandArgument> baseTypes = Lists.newArrayList((Object[])new CommandArgument[]{new StringArgument(), new VanillaUnconfigurableArgument("bool", BoolArgumentType::bool, (c, p) -> BooleanValue.of(BoolArgumentType.getBool((CommandContext)c, (String)p)), false), new FloatArgument(), new IntArgument(), new WordArgument(), new GreedyStringArgument(), new VanillaUnconfigurableArgument("yaw", AngleArgument::m_83807_, (c, p) -> new NumericValue(AngleArgument.m_83810_((CommandContext)c, (String)p)), true), new BlockPosArgument(), new VanillaUnconfigurableArgument("block", BlockStateArgument::m_234650_, (c, p) -> {
        BlockInput result = BlockStateArgument.m_116123_((CommandContext)c, (String)p);
        return new BlockValue(result.m_114669_(), ((CommandSourceStack)c.getSource()).m_81372_(), Vanilla.BlockInput_getTag(result));
    }, param -> (ctx, builder) -> ((BlockStateArgument)ctx.getArgument(param, BlockStateArgument.class)).listSuggestions(ctx, builder)), new VanillaUnconfigurableArgument("blockpredicate", BlockPredicateArgument::m_234627_, (c, p) -> ValueConversions.ofBlockPredicate((RegistryAccess)((CommandSourceStack)c.getSource()).m_81377_().m_206579_(), BlockPredicateArgument.m_115573_((CommandContext)c, (String)p)), param -> (ctx, builder) -> ((BlockPredicateArgument)ctx.getArgument(param, BlockPredicateArgument.class)).listSuggestions(ctx, builder)), new VanillaUnconfigurableArgument("teamcolor", ColorArgument::m_85463_, (c, p) -> {
        ChatFormatting format = ColorArgument.m_85466_((CommandContext)c, (String)p);
        return ListValue.of(StringValue.of(format.m_126666_()), ValueConversions.ofRGB(format.m_126665_()));
    }, false), new VanillaUnconfigurableArgument("columnpos", ColumnPosArgument::m_118989_, (c, p) -> ValueConversions.of(ColumnPosArgument.m_118992_((CommandContext)c, (String)p)), false), new VanillaUnconfigurableArgument("dimension", DimensionArgument::m_88805_, (c, p) -> ValueConversions.of(DimensionArgument.m_88808_((CommandContext)c, (String)p)), false), new EntityArgument(), new VanillaUnconfigurableArgument("anchor", EntityAnchorArgument::m_90350_, (c, p) -> StringValue.of(EntityAnchorArgument.m_90353_((CommandContext)c, (String)p).name()), false), new VanillaUnconfigurableArgument("entitytype", c -> ResourceArgument.m_247102_((CommandBuildContext)c, (ResourceKey)Registries.f_256939_), (c, p) -> ValueConversions.of(ResourceArgument.m_247713_((CommandContext)c, (String)p).m_205785_()), (SuggestionProvider<CommandSourceStack>)SuggestionProviders.f_121645_), new VanillaUnconfigurableArgument("floatrange", RangeArgument::m_105405_, (c, p) -> ValueConversions.of((MinMaxBounds)c.getArgument(p, MinMaxBounds.Doubles.class)), true), new PlayerProfileArgument(), new VanillaUnconfigurableArgument("intrange", RangeArgument::m_105404_, (c, p) -> ValueConversions.of(RangeArgument.Ints.m_105419_((CommandContext)c, (String)p)), true), new VanillaUnconfigurableArgument("enchantment", Registries.f_256762_), new SlotArgument(), new VanillaUnconfigurableArgument("item", ItemArgument::m_235279_, (c, p) -> ValueConversions.of(ItemArgument.m_120963_((CommandContext)c, (String)p).m_120980_(1, false), ((CommandSourceStack)c.getSource()).m_5894_()), param -> (ctx, builder) -> ((ItemArgument)ctx.getArgument(param, ItemArgument.class)).listSuggestions(ctx, builder)), new VanillaUnconfigurableArgument("message", MessageArgument::m_96832_, (c, p) -> new FormattedTextValue(MessageArgument.m_96835_((CommandContext)c, (String)p)), true), new VanillaUnconfigurableArgument("effect", Registries.f_256929_), new TagArgument(), new VanillaUnconfigurableArgument("path", NbtPathArgument::m_99487_, (c, p) -> StringValue.of(NbtPathArgument.m_99498_((CommandContext)c, (String)p).toString()), true), new VanillaUnconfigurableArgument("objective", ObjectiveArgument::m_101957_, (c, p) -> ValueConversions.of(ObjectiveArgument.m_101960_((CommandContext)c, (String)p)), false), new VanillaUnconfigurableArgument("criterion", ObjectiveCriteriaArgument::m_102555_, (c, p) -> StringValue.of(ObjectiveCriteriaArgument.m_102565_((CommandContext)c, (String)p).m_83620_()), false), new VanillaUnconfigurableArgument("particle", ParticleArgument::m_245999_, (c, p) -> ValueConversions.of(ParticleArgument.m_103937_((CommandContext)c, (String)p)), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(c, b) -> SharedSuggestionProvider.m_82926_((Iterable)((CommandSourceStack)c.getSource()).m_81377_().m_206579_().m_175515_(Registries.f_256890_).m_6566_(), (SuggestionsBuilder)b))), new VanillaUnconfigurableArgument("recipe", ResourceLocationArgument::m_106984_, (c, p) -> ValueConversions.of(ResourceLocationArgument.m_106994_((CommandContext)c, (String)p).m_6423_()), (SuggestionProvider<CommandSourceStack>)SuggestionProviders.f_121642_), new VanillaUnconfigurableArgument("advancement", ResourceLocationArgument::m_106984_, (c, p) -> ValueConversions.of(ResourceLocationArgument.m_106987_((CommandContext)c, (String)p).m_138327_()), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(ctx, builder) -> SharedSuggestionProvider.m_82957_(((CommandSourceStack)ctx.getSource()).m_81377_().m_129889_().m_136028_().stream().map(Advancement::m_138327_), (SuggestionsBuilder)builder))), new VanillaUnconfigurableArgument("lootcondition", ResourceLocationArgument::m_106984_, (c, p) -> ValueConversions.of(((CommandSourceStack)c.getSource()).m_5894_().m_175515_(Registries.f_256976_).m_7981_((Object)ResourceLocationArgument.m_107001_((CommandContext)c, (String)p).m_7940_())), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(ctx, builder) -> SharedSuggestionProvider.m_82926_((Iterable)((CommandSourceStack)ctx.getSource()).m_81377_().m_278653_().m_278706_(LootDataType.f_278407_), (SuggestionsBuilder)builder))), new VanillaUnconfigurableArgument("loottable", ResourceLocationArgument::m_106984_, (c, p) -> ValueConversions.of(ResourceLocationArgument.m_107011_((CommandContext)c, (String)p)), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(ctx, builder) -> SharedSuggestionProvider.m_82926_((Iterable)((CommandSourceStack)ctx.getSource()).m_81377_().m_278653_().m_278706_(LootDataType.f_278413_), (SuggestionsBuilder)builder))), new VanillaUnconfigurableArgument("attribute", Registries.f_256728_), new VanillaUnconfigurableArgument("boss", ResourceLocationArgument::m_106984_, (c, p) -> ValueConversions.of(ResourceLocationArgument.m_107011_((CommandContext)c, (String)p)), (SuggestionProvider<CommandSourceStack>)BossBarCommands.f_136570_), new VanillaUnconfigurableArgument("biome", c -> ResourceOrTagArgument.m_247455_((CommandBuildContext)c, (ResourceKey)Registries.f_256952_), (c, p) -> {
        ResourceOrTagArgument.Result result = ResourceOrTagArgument.m_245464_((CommandContext)c, (String)"biome", (ResourceKey)Registries.f_256952_);
        Either res = result.m_245347_();
        if (res.left().isPresent()) {
            return ValueConversions.of(((Holder.Reference)res.left().get()).m_205785_());
        }
        if (res.right().isPresent()) {
            return ValueConversions.of(((HolderSet.Named)res.right().get()).m_205839_());
        }
        return Value.NULL;
    }, (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(ctx, builder) -> SharedSuggestionProvider.m_82926_((Iterable)((CommandSourceStack)ctx.getSource()).m_81377_().m_206579_().m_175515_(Registries.f_256952_).m_6566_(), (SuggestionsBuilder)builder))), new VanillaUnconfigurableArgument("sound", ResourceLocationArgument::m_106984_, (c, p) -> ValueConversions.of(ResourceLocationArgument.m_107011_((CommandContext)c, (String)p)), (SuggestionProvider<CommandSourceStack>)SuggestionProviders.f_121643_), new VanillaUnconfigurableArgument("storekey", ResourceLocationArgument::m_106984_, (c, p) -> ValueConversions.of(ResourceLocationArgument.m_107011_((CommandContext)c, (String)p)), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(ctx, builder) -> SharedSuggestionProvider.m_82957_((Stream)((CommandSourceStack)ctx.getSource()).m_81377_().m_129897_().m_78036_(), (SuggestionsBuilder)builder))), new CustomIdentifierArgument(), new VanillaUnconfigurableArgument("rotation", RotationArgument::m_120479_, (c, p) -> {
        Vec2 rot = RotationArgument.m_120482_((CommandContext)c, (String)p).m_6970_((CommandSourceStack)c.getSource());
        return ListValue.of(new NumericValue(rot.f_82470_), new NumericValue(rot.f_82471_));
    }, true), new ScoreholderArgument(), new VanillaUnconfigurableArgument("scoreboardslot", ScoreboardSlotArgument::m_109196_, (c, p) -> StringValue.of(Scoreboard.m_83453_((int)ScoreboardSlotArgument.m_109199_((CommandContext)c, (String)p))), false), new VanillaUnconfigurableArgument("swizzle", SwizzleArgument::m_120807_, (c, p) -> StringValue.of(SwizzleArgument.m_120810_((CommandContext)c, (String)p).stream().map(Direction.Axis::m_7912_).collect(Collectors.joining())), true), new VanillaUnconfigurableArgument("team", TeamArgument::m_112088_, (c, p) -> StringValue.of(TeamArgument.m_112091_((CommandContext)c, (String)p).m_5758_()), false), new VanillaUnconfigurableArgument("time", TimeArgument::m_113037_, (c, p) -> new NumericValue(IntegerArgumentType.getInteger((CommandContext)c, (String)p)), false), new VanillaUnconfigurableArgument("uuid", UuidArgument::m_113850_, (c, p) -> StringValue.of(UuidArgument.m_113853_((CommandContext)c, (String)p).toString()), false), new VanillaUnconfigurableArgument("surfacelocation", Vec2Argument::m_120822_, (c, p) -> {
        Vec2 res = Vec2Argument.m_120825_((CommandContext)c, (String)p);
        return ListValue.of(NumericValue.of(Float.valueOf(res.f_82470_)), NumericValue.of(Float.valueOf(res.f_82471_)));
    }, false), new LocationArgument()});
    public static final Map<String, CommandArgument> builtIns = baseTypes.stream().collect(Collectors.toMap(CommandArgument::getTypeSuffix, a -> a));
    public static final CommandArgument DEFAULT = baseTypes.get(0);
    protected String suffix;
    @Nullable
    protected Collection<String> examples;
    protected boolean needsMatching;
    protected boolean caseSensitive = true;
    protected Function<String, SuggestionProvider<CommandSourceStack>> suggestionProvider;
    protected FunctionArgument customSuggester;

    public static CommandSyntaxException error(String text) {
        return new SimpleCommandExceptionType((Message)Component.m_237113_((String)text)).create();
    }

    public static CommandArgument getTypeForArgument(String argument, CarpetScriptHost host) {
        String[] components = argument.split("_");
        for (int i = 0; i < components.length; ++i) {
            String candidate = String.join((CharSequence)"_", Arrays.asList(components).subList(i, components.length));
            CommandArgument arg = host.appArgTypes.get(candidate);
            if (arg != null) {
                return arg;
            }
            arg = builtIns.get(candidate);
            if (arg == null) continue;
            return arg;
        }
        return DEFAULT;
    }

    public static RequiredArgumentBuilder<CommandSourceStack, ?> argumentNode(String param, CarpetScriptHost host) throws CommandSyntaxException {
        CommandArgument arg = CommandArgument.getTypeForArgument(param, host);
        if (arg.suggestionProvider != null) {
            return Commands.m_82129_((String)param, arg.getArgumentType(host)).suggests(arg.suggestionProvider.apply(param));
        }
        if (!arg.needsMatching) {
            return Commands.m_82129_((String)param, arg.getArgumentType(host));
        }
        String hostName = host.getName();
        CarpetScriptServer scriptServer = host.scriptServer();
        return Commands.m_82129_((String)param, arg.getArgumentType(host)).suggests((ctx, b) -> {
            CarpetScriptHost cHost = scriptServer.modules.get(hostName).retrieveOwnForExecution((CommandSourceStack)ctx.getSource());
            return arg.suggest((CommandContext<CommandSourceStack>)ctx, b, cHost);
        });
    }

    protected CommandArgument(String suffix, @Nullable Collection<String> examples, boolean suggestFromExamples) {
        this.suffix = suffix;
        this.examples = examples;
        this.needsMatching = suggestFromExamples;
    }

    protected abstract ArgumentType<?> getArgumentType(CarpetScriptHost var1) throws CommandSyntaxException;

    public static Value getValue(CommandContext<CommandSourceStack> context, String param, CarpetScriptHost host) throws CommandSyntaxException {
        return CommandArgument.getTypeForArgument(param, host).getValueFromContext(context, param);
    }

    protected abstract Value getValueFromContext(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    public String getTypeSuffix() {
        return this.suffix;
    }

    public static CommandArgument buildFromConfig(String suffix, Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
        if (!config.containsKey("type")) {
            throw CommandArgument.error("Custom type " + suffix + " should at least specify the type");
        }
        String baseType = config.get("type").getString();
        if (!builtIns.containsKey(baseType)) {
            throw CommandArgument.error("Unknown base type " + baseType + " for custom type " + suffix);
        }
        CommandArgument variant = builtIns.get(baseType).factory(host.scriptServer().server).get();
        variant.suffix = suffix;
        variant.configure(config, host);
        return variant;
    }

    protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
        this.caseSensitive = config.getOrDefault("case_sensitive", Value.TRUE).getBoolean();
        if (config.containsKey("suggester")) {
            this.customSuggester = FunctionArgument.fromCommandSpec(host, config.get("suggester"));
        }
        if (config.containsKey("suggest")) {
            if (config.containsKey("suggester")) {
                throw CommandArgument.error("Attempted to provide 'suggest' list while 'suggester' is present for custom type " + this.suffix);
            }
            Value suggestionValue = config.get("suggest");
            if (!(suggestionValue instanceof ListValue)) {
                throw CommandArgument.error("Argument suggestions needs to be a list for custom type " + this.suffix);
            }
            this.examples = ((ListValue)suggestionValue).getItems().stream().map(Value::getString).collect(Collectors.toSet());
            if (!this.examples.isEmpty()) {
                this.needsMatching = true;
            }
        }
    }

    public CompletableFuture<Suggestions> suggest(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder, CarpetScriptHost host) throws CommandSyntaxException {
        String prefix = suggestionsBuilder.getRemaining();
        if (!this.caseSensitive) {
            prefix = prefix.toLowerCase(Locale.ROOT);
        }
        this.suggestFor(context, prefix, host).forEach(arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0));
        return suggestionsBuilder.buildFuture();
    }

    protected List<String> suggestFor(CommandContext<CommandSourceStack> context, String prefix, CarpetScriptHost host) throws CommandSyntaxException {
        return this.getOptions(context, host).stream().filter(s -> this.optionMatchesPrefix(prefix, (String)s)).collect(Collectors.toList());
    }

    protected Collection<String> getOptions(CommandContext<CommandSourceStack> context, CarpetScriptHost host) throws CommandSyntaxException {
        if (this.customSuggester != null) {
            Runnable currentSection = Carpet.startProfilerSection("Scarpet command");
            HashMap<Value, Value> params = new HashMap<Value, Value>();
            for (ParsedCommandNode pnode : context.getNodes()) {
                CommandNode node = pnode.getNode();
                if (!(node instanceof ArgumentCommandNode)) continue;
                params.put(StringValue.of(node.getName()), CommandArgument.getValue(context, node.getName(), host));
            }
            ArrayList<Value> args = new ArrayList<Value>(this.customSuggester.args.size() + 1);
            args.add(MapValue.wrap(params));
            args.addAll(this.customSuggester.args);
            Value response = host.handleCommand((CommandSourceStack)context.getSource(), this.customSuggester.function, args);
            if (!(response instanceof ListValue)) {
                throw CommandArgument.error("Custom suggester should return a list of options for custom type " + this.suffix);
            }
            Collection res = ((ListValue)response).getItems().stream().map(Value::getString).collect(Collectors.toList());
            currentSection.run();
            return res;
        }
        return this.needsMatching ? this.examples : Collections.singletonList("... " + this.getTypeSuffix());
    }

    protected boolean optionMatchesPrefix(String prefix, String option) {
        if (!this.caseSensitive) {
            option = option.toLowerCase(Locale.ROOT);
        }
        int i = 0;
        while (!option.startsWith(prefix, i)) {
            if ((i = option.indexOf(95, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract Supplier<CommandArgument> factory(MinecraftServer var1);

    private static class StringArgument
    extends CommandArgument {
        Set<String> validOptions = Collections.emptySet();

        private StringArgument() {
            super("string", StringArgumentType.StringType.QUOTABLE_PHRASE.getExamples(), true);
        }

        @Override
        public ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return StringArgumentType.string();
        }

        @Override
        public Value getValueFromContext(CommandContext<CommandSourceStack> context, String param) throws CommandSyntaxException {
            String choseValue = StringArgumentType.getString(context, (String)param);
            if (!this.caseSensitive) {
                choseValue = choseValue.toLowerCase(Locale.ROOT);
            }
            if (!this.validOptions.isEmpty() && !this.validOptions.contains(choseValue)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Incorrect value for " + param + ": " + choseValue + " for custom type " + this.suffix))).create();
            }
            return StringValue.of(choseValue);
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            if (config.containsKey("options")) {
                Value optionsValue = config.get("options");
                if (!(optionsValue instanceof ListValue)) {
                    throw StringArgument.error("Custom string type requires options passed as a list for custom type " + this.suffix);
                }
                this.validOptions = ((ListValue)optionsValue).getItems().stream().map(v -> this.caseSensitive ? v.getString() : v.getString().toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            }
        }

        @Override
        protected Collection<String> getOptions(CommandContext<CommandSourceStack> context, CarpetScriptHost host) throws CommandSyntaxException {
            return this.validOptions.isEmpty() ? super.getOptions(context, host) : this.validOptions;
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return StringArgument::new;
        }
    }

    public static class VanillaUnconfigurableArgument
    extends CommandArgument {
        private final ArgumentProvider argumentTypeSupplier;
        private final ArgumentProviderEx argumentTypeSupplierEx;
        private final ValueExtractor valueExtractor;
        private final boolean providesExamples;

        public VanillaUnconfigurableArgument(String suffix, ArgumentProvider argumentTypeSupplier, ValueExtractor valueExtractor, boolean suggestFromExamples) {
            super(suffix, null, suggestFromExamples);
            try {
                this.examples = argumentTypeSupplier.get().getExamples();
            }
            catch (CommandSyntaxException e) {
                this.examples = Collections.emptyList();
            }
            this.providesExamples = suggestFromExamples;
            this.argumentTypeSupplier = argumentTypeSupplier;
            this.valueExtractor = valueExtractor;
            this.argumentTypeSupplierEx = null;
        }

        public VanillaUnconfigurableArgument(String suffix, ArgumentProvider argumentTypeSupplier, ValueExtractor valueExtractor, SuggestionProvider<CommandSourceStack> suggester) {
            super(suffix, Collections.emptyList(), false);
            this.suggestionProvider = param -> suggester;
            this.providesExamples = false;
            this.argumentTypeSupplier = argumentTypeSupplier;
            this.valueExtractor = valueExtractor;
            this.argumentTypeSupplierEx = null;
        }

        public VanillaUnconfigurableArgument(String suffix, ArgumentProviderEx argumentTypeSupplier, ValueExtractor valueExtractor, boolean suggestFromExamples, MinecraftServer server) {
            super(suffix, null, suggestFromExamples);
            try {
                CommandBuildContext context = CommandBuildContext.m_255418_((HolderLookup.Provider)server.m_206579_(), (FeatureFlagSet)server.m_129910_().m_247623_());
                this.examples = argumentTypeSupplier.get(context).getExamples();
            }
            catch (CommandSyntaxException e) {
                this.examples = Collections.emptyList();
            }
            this.providesExamples = suggestFromExamples;
            this.argumentTypeSupplierEx = argumentTypeSupplier;
            this.valueExtractor = valueExtractor;
            this.argumentTypeSupplier = null;
        }

        public VanillaUnconfigurableArgument(String suffix, ArgumentProviderEx argumentTypeSupplier, ValueExtractor valueExtractor, SuggestionProvider<CommandSourceStack> suggester) {
            super(suffix, Collections.emptyList(), false);
            this.suggestionProvider = param -> suggester;
            this.providesExamples = false;
            this.argumentTypeSupplierEx = argumentTypeSupplier;
            this.valueExtractor = valueExtractor;
            this.argumentTypeSupplier = null;
        }

        public VanillaUnconfigurableArgument(String suffix, ArgumentProviderEx argumentTypeSupplier, ValueExtractor valueExtractor, Function<String, SuggestionProvider<CommandSourceStack>> suggesterGen) {
            super(suffix, Collections.emptyList(), false);
            this.suggestionProvider = suggesterGen;
            this.providesExamples = false;
            this.argumentTypeSupplierEx = argumentTypeSupplier;
            this.valueExtractor = valueExtractor;
            this.argumentTypeSupplier = null;
        }

        public <T> VanillaUnconfigurableArgument(String suffix, ResourceKey<Registry<T>> registry) {
            this(suffix, (CommandBuildContext c) -> ResourceArgument.m_247102_((CommandBuildContext)c, (ResourceKey)registry), (CommandContext<CommandSourceStack> c, String p) -> ValueConversions.of(ResourceArgument.m_246781_((CommandContext)c, (String)p, (ResourceKey)registry).m_205785_()), (SuggestionProvider<CommandSourceStack>)((SuggestionProvider)(c, b) -> SharedSuggestionProvider.m_82926_((Iterable)((CommandSourceStack)c.getSource()).m_81377_().m_206579_().m_175515_(registry).m_6566_(), (SuggestionsBuilder)b)));
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) throws CommandSyntaxException {
            return this.argumentTypeSupplier != null ? this.argumentTypeSupplier.get() : this.argumentTypeSupplierEx.get(CommandBuildContext.m_255418_((HolderLookup.Provider)host.scriptServer().server.m_206579_(), (FeatureFlagSet)host.scriptServer().server.m_129910_().m_247623_()));
        }

        @Override
        protected Value getValueFromContext(CommandContext<CommandSourceStack> context, String param) throws CommandSyntaxException {
            return this.valueExtractor.apply(context, param);
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return this.argumentTypeSupplier != null ? () -> new VanillaUnconfigurableArgument(this.getTypeSuffix(), this.argumentTypeSupplier, this.valueExtractor, this.providesExamples) : () -> new VanillaUnconfigurableArgument(this.getTypeSuffix(), this.argumentTypeSupplierEx, this.valueExtractor, this.providesExamples, server);
        }
    }

    @FunctionalInterface
    private static interface ArgumentProvider {
        public ArgumentType<?> get() throws CommandSyntaxException;
    }

    @FunctionalInterface
    private static interface ValueExtractor {
        public Value apply(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;
    }

    private static class FloatArgument
    extends CommandArgument {
        private Double min = null;
        private Double max = null;

        private FloatArgument() {
            super("float", DoubleArgumentType.doubleArg().getExamples(), true);
        }

        @Override
        public ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            if (this.min != null) {
                if (this.max != null) {
                    return DoubleArgumentType.doubleArg((double)this.min, (double)this.max);
                }
                return DoubleArgumentType.doubleArg((double)this.min);
            }
            return DoubleArgumentType.doubleArg();
        }

        @Override
        public Value getValueFromContext(CommandContext<CommandSourceStack> context, String param) {
            return new NumericValue(DoubleArgumentType.getDouble(context, (String)param));
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            if (config.containsKey("min")) {
                this.min = NumericValue.asNumber(config.get("min"), "min").getDouble();
            }
            if (config.containsKey("max")) {
                this.max = NumericValue.asNumber(config.get("max"), "max").getDouble();
            }
            if (this.max != null && this.min == null) {
                throw FloatArgument.error("Double types cannot be only upper-bounded for custom type " + this.suffix);
            }
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return FloatArgument::new;
        }
    }

    private static class IntArgument
    extends CommandArgument {
        private Long min = null;
        private Long max = null;

        private IntArgument() {
            super("int", LongArgumentType.longArg().getExamples(), true);
        }

        @Override
        public ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            if (this.min != null) {
                if (this.max != null) {
                    return LongArgumentType.longArg((long)this.min, (long)this.max);
                }
                return LongArgumentType.longArg((long)this.min);
            }
            return LongArgumentType.longArg();
        }

        @Override
        public Value getValueFromContext(CommandContext<CommandSourceStack> context, String param) {
            return new NumericValue(LongArgumentType.getLong(context, (String)param));
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            if (config.containsKey("min")) {
                this.min = NumericValue.asNumber(config.get("min"), "min").getLong();
            }
            if (config.containsKey("max")) {
                this.max = NumericValue.asNumber(config.get("max"), "max").getLong();
            }
            if (this.max != null && this.min == null) {
                throw IntArgument.error("Double types cannot be only upper-bounded for custom type " + this.suffix);
            }
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return IntArgument::new;
        }
    }

    private static class WordArgument
    extends StringArgument {
        private WordArgument() {
            this.suffix = "term";
            this.examples = StringArgumentType.StringType.SINGLE_WORD.getExamples();
        }

        @Override
        public ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return StringArgumentType.word();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return WordArgument::new;
        }
    }

    private static class GreedyStringArgument
    extends StringArgument {
        private GreedyStringArgument() {
            this.suffix = "text";
            this.examples = StringArgumentType.StringType.GREEDY_PHRASE.getExamples();
        }

        @Override
        public ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return StringArgumentType.greedyString();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return GreedyStringArgument::new;
        }
    }

    private static class BlockPosArgument
    extends CommandArgument {
        private boolean mustBeLoaded = false;

        private BlockPosArgument() {
            super("pos", net.minecraft.commands.arguments.coordinates.BlockPosArgument.m_118239_().getExamples(), false);
        }

        @Override
        public ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return net.minecraft.commands.arguments.coordinates.BlockPosArgument.m_118239_();
        }

        @Override
        public Value getValueFromContext(CommandContext<CommandSourceStack> context, String param) throws CommandSyntaxException {
            BlockPos pos = this.mustBeLoaded ? net.minecraft.commands.arguments.coordinates.BlockPosArgument.m_118242_(context, (String)param) : net.minecraft.commands.arguments.coordinates.BlockPosArgument.m_174395_(context, (String)param);
            return ValueConversions.of(pos);
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            this.mustBeLoaded = config.getOrDefault("loaded", Value.FALSE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return BlockPosArgument::new;
        }
    }

    @FunctionalInterface
    private static interface ArgumentProviderEx {
        public ArgumentType<?> get(CommandBuildContext var1) throws CommandSyntaxException;
    }

    private static class EntityArgument
    extends CommandArgument {
        boolean onlyFans = false;
        boolean single = false;

        private EntityArgument() {
            super("entities", net.minecraft.commands.arguments.EntityArgument.m_91460_().getExamples(), false);
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            if (this.onlyFans) {
                return this.single ? net.minecraft.commands.arguments.EntityArgument.m_91466_() : net.minecraft.commands.arguments.EntityArgument.m_91470_();
            }
            return this.single ? net.minecraft.commands.arguments.EntityArgument.m_91449_() : net.minecraft.commands.arguments.EntityArgument.m_91460_();
        }

        @Override
        protected Value getValueFromContext(CommandContext<CommandSourceStack> context, String param) throws CommandSyntaxException {
            Collection founds = net.minecraft.commands.arguments.EntityArgument.m_91467_(context, (String)param);
            if (!this.single) {
                return ListValue.wrap(founds.stream().map(EntityValue::new));
            }
            if (founds.isEmpty()) {
                return Value.NULL;
            }
            if (founds.size() == 1) {
                return new EntityValue((Entity)founds.iterator().next());
            }
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Multiple entities returned while only one was requested for custom type " + this.suffix))).create();
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            this.onlyFans = config.getOrDefault("players", Value.FALSE).getBoolean();
            this.single = config.getOrDefault("single", Value.FALSE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return EntityArgument::new;
        }
    }

    private static class PlayerProfileArgument
    extends CommandArgument {
        boolean single = false;

        private PlayerProfileArgument() {
            super("players", GameProfileArgument.m_94584_().getExamples(), false);
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return GameProfileArgument.m_94584_();
        }

        @Override
        protected Value getValueFromContext(CommandContext<CommandSourceStack> context, String param) throws CommandSyntaxException {
            Collection profiles = GameProfileArgument.m_94590_(context, (String)param);
            if (!this.single) {
                return ListValue.wrap(profiles.stream().map(p -> StringValue.of(p.getName())));
            }
            int size = profiles.size();
            if (size == 0) {
                return Value.NULL;
            }
            if (size == 1) {
                return StringValue.of(((GameProfile)profiles.iterator().next()).getName());
            }
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Multiple game profiles returned while only one was requested for custom type " + this.suffix))).create();
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            this.single = config.getOrDefault("single", Value.FALSE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return PlayerProfileArgument::new;
        }
    }

    private static class SlotArgument
    extends CommandArgument {
        private String restrict;
        private static final Map<String, ContainerIds> RESTRICTED_CONTAINERS = new HashMap<String, ContainerIds>(){
            {
                int i;
                for (String source : Arrays.asList("player", "enderchest", "equipment", "armor", "weapon", "container", "villager", "horse")) {
                    this.put(source, new ContainerIds((IntSet)new IntOpenHashSet(), new HashSet<String>()));
                }
                for (i = 0; i < 41; ++i) {
                    ((ContainerIds)this.get("player")).numericalIds().add(i);
                }
                for (i = 0; i < 41; ++i) {
                    ((ContainerIds)this.get("player")).commandIds().add("container." + i);
                }
                for (i = 0; i < 9; ++i) {
                    ((ContainerIds)this.get("player")).commandIds().add("hotbar." + i);
                }
                for (i = 0; i < 27; ++i) {
                    ((ContainerIds)this.get("player")).commandIds().add("inventory." + i);
                }
                for (String place : Arrays.asList("weapon", "weapon.mainhand", "weapon.offhand")) {
                    ((ContainerIds)this.get("player")).commandIds().add(place);
                    ((ContainerIds)this.get("equipment")).commandIds().add(place);
                    ((ContainerIds)this.get("weapon")).commandIds().add(place);
                }
                for (String place : Arrays.asList("armor.feet", "armor.legs", "armor.chest", "armor.head")) {
                    ((ContainerIds)this.get("player")).commandIds().add(place);
                    ((ContainerIds)this.get("equipment")).commandIds().add(place);
                    ((ContainerIds)this.get("armor")).commandIds().add(place);
                }
                for (i = 0; i < 27; ++i) {
                    ((ContainerIds)this.get("enderchest")).numericalIds().add(200 + i);
                }
                for (i = 0; i < 27; ++i) {
                    ((ContainerIds)this.get("enderchest")).commandIds().add("enderchest." + i);
                }
                for (i = 0; i < 6; ++i) {
                    ((ContainerIds)this.get("equipment")).numericalIds().add(98 + i);
                }
                for (i = 0; i < 4; ++i) {
                    ((ContainerIds)this.get("armor")).numericalIds().add(100 + i);
                }
                for (i = 0; i < 2; ++i) {
                    ((ContainerIds)this.get("weapon")).numericalIds().add(98 + i);
                }
                for (i = 0; i < 54; ++i) {
                    ((ContainerIds)this.get("container")).numericalIds().add(i);
                }
                for (i = 0; i < 41; ++i) {
                    ((ContainerIds)this.get("container")).commandIds().add("container." + i);
                }
                for (i = 0; i < 8; ++i) {
                    ((ContainerIds)this.get("villager")).numericalIds().add(i);
                }
                for (i = 0; i < 8; ++i) {
                    ((ContainerIds)this.get("villager")).commandIds().add("villager." + i);
                }
                for (i = 0; i < 15; ++i) {
                    ((ContainerIds)this.get("horse")).numericalIds().add(500 + i);
                }
                for (i = 0; i < 15; ++i) {
                    ((ContainerIds)this.get("horse")).commandIds().add("horse." + i);
                }
                ((ContainerIds)this.get("horse")).numericalIds().add(400);
                ((ContainerIds)this.get("horse")).commandIds().add("horse.saddle");
                ((ContainerIds)this.get("horse")).numericalIds().add(401);
                ((ContainerIds)this.get("horse")).commandIds().add("horse.armor");
            }
        };

        protected SlotArgument() {
            super("slot", net.minecraft.commands.arguments.SlotArgument.m_111276_().getExamples(), false);
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return net.minecraft.commands.arguments.SlotArgument.m_111276_();
        }

        @Override
        protected Value getValueFromContext(CommandContext<CommandSourceStack> context, String param) throws CommandSyntaxException {
            int slot = net.minecraft.commands.arguments.SlotArgument.m_111279_(context, (String)param);
            if (this.restrict != null && !RESTRICTED_CONTAINERS.get(this.restrict).numericalIds().contains(slot)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Incorrect slot restricted to " + this.restrict + " for custom type " + this.suffix))).create();
            }
            return ValueConversions.ofVanillaSlotResult(slot);
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            if (config.containsKey("restrict")) {
                this.restrict = config.get("restrict").getString().toLowerCase(Locale.ROOT);
                this.needsMatching = true;
                if (!RESTRICTED_CONTAINERS.containsKey(this.restrict)) {
                    throw SlotArgument.error("Incorrect slot restriction " + this.restrict + " for custom type " + this.suffix);
                }
            }
        }

        @Override
        protected Collection<String> getOptions(CommandContext<CommandSourceStack> context, CarpetScriptHost host) throws CommandSyntaxException {
            return this.restrict == null ? super.getOptions(context, host) : RESTRICTED_CONTAINERS.get(this.restrict).commandIds();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return SlotArgument::new;
        }

        private record ContainerIds(IntSet numericalIds, Set<String> commandIds) {
        }
    }

    private static class TagArgument
    extends CommandArgument {
        boolean mapRequired = true;

        private TagArgument() {
            super("tag", CompoundTagArgument.m_87657_().getExamples(), false);
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return this.mapRequired ? CompoundTagArgument.m_87657_() : NbtTagArgument.m_100659_();
        }

        @Override
        protected Value getValueFromContext(CommandContext<CommandSourceStack> context, String param) {
            return this.mapRequired ? new NBTSerializableValue((Tag)CompoundTagArgument.m_87660_(context, (String)param)) : new NBTSerializableValue(NbtTagArgument.m_100662_(context, (String)param));
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            this.mapRequired = !config.getOrDefault("allow_element", Value.FALSE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return TagArgument::new;
        }
    }

    private static class CustomIdentifierArgument
    extends CommandArgument {
        Set<ResourceLocation> validOptions = Collections.emptySet();

        protected CustomIdentifierArgument() {
            super("identifier", Collections.emptyList(), true);
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return ResourceLocationArgument.m_106984_();
        }

        @Override
        protected Value getValueFromContext(CommandContext<CommandSourceStack> context, String param) throws CommandSyntaxException {
            ResourceLocation choseValue = ResourceLocationArgument.m_107011_(context, (String)param);
            if (!this.validOptions.isEmpty() && !this.validOptions.contains(choseValue)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Incorrect value for " + param + ": " + String.valueOf(choseValue) + " for custom type " + this.suffix))).create();
            }
            return ValueConversions.of(choseValue);
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return CustomIdentifierArgument::new;
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            if (config.containsKey("options")) {
                Value optionsValue = config.get("options");
                if (!(optionsValue instanceof ListValue)) {
                    throw CustomIdentifierArgument.error("Custom sting type requires options passed as a list for custom type " + this.suffix);
                }
                this.validOptions = ((ListValue)optionsValue).getItems().stream().map(v -> new ResourceLocation(v.getString())).collect(Collectors.toSet());
            }
        }
    }

    private static class ScoreholderArgument
    extends CommandArgument {
        boolean single = false;

        private ScoreholderArgument() {
            super("scoreholder", ScoreHolderArgument.m_108217_().getExamples(), false);
            this.suggestionProvider = param -> ScoreHolderArgument.f_108210_;
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return this.single ? ScoreHolderArgument.m_108217_() : ScoreHolderArgument.m_108239_();
        }

        @Override
        protected Value getValueFromContext(CommandContext<CommandSourceStack> context, String param) throws CommandSyntaxException {
            Collection holders = ScoreHolderArgument.m_108243_(context, (String)param);
            if (!this.single) {
                return ListValue.wrap(holders.stream().map(StringValue::of));
            }
            int size = holders.size();
            if (size == 0) {
                return Value.NULL;
            }
            if (size == 1) {
                return StringValue.of((String)holders.iterator().next());
            }
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Multiple score holders returned while only one was requested for custom type " + this.suffix))).create();
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            this.single = config.getOrDefault("single", Value.FALSE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return PlayerProfileArgument::new;
        }
    }

    private static class LocationArgument
    extends CommandArgument {
        boolean blockCentered = true;

        private LocationArgument() {
            super("location", Vec3Argument.m_120841_().getExamples(), false);
        }

        @Override
        protected ArgumentType<?> getArgumentType(CarpetScriptHost host) {
            return Vec3Argument.m_120847_((boolean)this.blockCentered);
        }

        @Override
        protected Value getValueFromContext(CommandContext<CommandSourceStack> context, String param) {
            return ValueConversions.of(Vec3Argument.m_120844_(context, (String)param));
        }

        @Override
        protected void configure(Map<String, Value> config, CarpetScriptHost host) throws CommandSyntaxException {
            super.configure(config, host);
            this.blockCentered = config.getOrDefault("block_centered", Value.TRUE).getBoolean();
        }

        @Override
        protected Supplier<CommandArgument> factory(MinecraftServer server) {
            return LocationArgument::new;
        }
    }
}

