/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.CarpetScriptServer;
import carpet.script.external.Vanilla;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public class FeatureGenerator {
    public static final Map<String, Function<ServerLevel, Thing>> featureMap = new HashMap<String, Function<ServerLevel, Thing>>(){
        {
            this.put("oak_bees", l -> FeatureGenerator.simpleTree(FeatureGenerator.createTree(Blocks.f_49999_, Blocks.f_50050_, 4, 2, 0, 2).m_68244_().m_68249_(List.of(new BeehiveDecorator(1.0f))).m_68251_()));
            this.put("fancy_oak_bees", l -> FeatureGenerator.simpleTree(new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49999_), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50050_), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68244_().m_68249_(List.of(new BeehiveDecorator(1.0f))).m_68251_()));
            this.put("birch_bees", l -> FeatureGenerator.simpleTree(FeatureGenerator.createTree(Blocks.f_50001_, Blocks.f_50052_, 5, 2, 0, 2).m_68244_().m_68249_(List.of(new BeehiveDecorator(1.0f))).m_68251_()));
            this.put("coral_tree", l -> FeatureGenerator.simplePlop(Feature.f_65737_, FeatureConfiguration.f_67737_));
            this.put("coral_claw", l -> FeatureGenerator.simplePlop(Feature.f_65739_, FeatureConfiguration.f_67737_));
            this.put("coral_mushroom", l -> FeatureGenerator.simplePlop(Feature.f_65738_, FeatureConfiguration.f_67737_));
            this.put("coral", l -> FeatureGenerator.simplePlop(Feature.f_65755_, new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{PlacementUtils.m_206502_((Feature)Feature.f_65737_, (FeatureConfiguration)FeatureConfiguration.f_67737_, (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65739_, (FeatureConfiguration)FeatureConfiguration.f_67737_, (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.m_206502_((Feature)Feature.f_65738_, (FeatureConfiguration)FeatureConfiguration.f_67737_, (PlacementModifier[])new PlacementModifier[0])}))));
            this.put("bastion_remnant_units", l -> {
                RegistryAccess regs = l.m_9598_();
                HolderLookup.RegistryLookup processorLists = regs.m_255025_(Registries.f_257011_);
                Holder.Reference bastionGenericDegradation = processorLists.m_255043_(ProcessorLists.f_127221_);
                HolderLookup.RegistryLookup pools = regs.m_255025_(Registries.f_256948_);
                Holder.Reference empty = pools.m_255043_(Pools.f_127186_);
                return FeatureGenerator.spawnCustomStructure((Structure)new JigsawStructure(new Structure.StructureSettings((HolderSet)l.m_9598_().m_175515_(Registries.f_256952_).m_203561_(BiomeTags.f_207599_), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), Holder.m_205709_((Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)"bastion/units/air_base", (Holder)bastionGenericDegradation), (Object)1)), StructureTemplatePool.Projection.RIGID)), 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)33)), false));
            });
            this.put("bastion_remnant_hoglin_stable", l -> {
                RegistryAccess regs = l.m_9598_();
                HolderLookup.RegistryLookup processorLists = regs.m_255025_(Registries.f_257011_);
                Holder.Reference bastionGenericDegradation = processorLists.m_255043_(ProcessorLists.f_127221_);
                HolderLookup.RegistryLookup pools = regs.m_255025_(Registries.f_256948_);
                Holder.Reference empty = pools.m_255043_(Pools.f_127186_);
                return FeatureGenerator.spawnCustomStructure((Structure)new JigsawStructure(new Structure.StructureSettings((HolderSet)l.m_9598_().m_175515_(Registries.f_256952_).m_203561_(BiomeTags.f_207599_), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), Holder.m_205709_((Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)"bastion/hoglin_stable/air_base", (Holder)bastionGenericDegradation), (Object)1)), StructureTemplatePool.Projection.RIGID)), 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)33)), false));
            });
            this.put("bastion_remnant_treasure", l -> {
                RegistryAccess regs = l.m_9598_();
                HolderLookup.RegistryLookup processorLists = regs.m_255025_(Registries.f_257011_);
                Holder.Reference bastionGenericDegradation = processorLists.m_255043_(ProcessorLists.f_127221_);
                HolderLookup.RegistryLookup pools = regs.m_255025_(Registries.f_256948_);
                Holder.Reference empty = pools.m_255043_(Pools.f_127186_);
                return FeatureGenerator.spawnCustomStructure((Structure)new JigsawStructure(new Structure.StructureSettings((HolderSet)l.m_9598_().m_175515_(Registries.f_256952_).m_203561_(BiomeTags.f_207599_), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), Holder.m_205709_((Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)"bastion/treasure/big_air_full", (Holder)bastionGenericDegradation), (Object)1)), StructureTemplatePool.Projection.RIGID)), 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)33)), false));
            });
            this.put("bastion_remnant_bridge", l -> {
                RegistryAccess regs = l.m_9598_();
                HolderLookup.RegistryLookup processorLists = regs.m_255025_(Registries.f_257011_);
                Holder.Reference bastionGenericDegradation = processorLists.m_255043_(ProcessorLists.f_127221_);
                HolderLookup.RegistryLookup pools = regs.m_255025_(Registries.f_256948_);
                Holder.Reference empty = pools.m_255043_(Pools.f_127186_);
                return FeatureGenerator.spawnCustomStructure((Structure)new JigsawStructure(new Structure.StructureSettings((HolderSet)l.m_9598_().m_175515_(Registries.f_256952_).m_203561_(BiomeTags.f_207599_), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), Holder.m_205709_((Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)"bastion/bridge/starting_pieces/entrance_base", (Holder)bastionGenericDegradation), (Object)1)), StructureTemplatePool.Projection.RIGID)), 6, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)33)), false));
            });
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static synchronized Boolean plop(String featureName, ServerLevel world, BlockPos pos) {
        ConfiguredFeature<?, ?> configuredStandard;
        Structure configuredStandard2;
        Function<ServerLevel, Thing> custom = featureMap.get(featureName);
        if (custom != null) {
            return custom.apply(world).plop(world, pos);
        }
        ResourceLocation id = new ResourceLocation(featureName);
        Structure structure = (Structure)world.m_9598_().m_175515_(Registries.f_256944_).m_7745_(id);
        if (structure != null) {
            return FeatureGenerator.plopAnywhere(structure, world, pos, world.m_7726_().m_8481_(), false);
        }
        ConfiguredFeature configuredFeature = (ConfiguredFeature)world.m_9598_().m_175515_(Registries.f_256911_).m_7745_(id);
        if (configuredFeature != null) {
            ThreadLocal<Boolean> checks = Vanilla.skipGenerationChecks(world);
            checks.set(true);
            try {
                Boolean bl = configuredFeature.m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), world.f_46441_, pos);
                return bl;
            }
            finally {
                checks.set(false);
            }
        }
        Optional structureType = world.m_9598_().m_175515_(Registries.f_256938_).m_6612_(id);
        if (structureType.isPresent() && (configuredStandard2 = FeatureGenerator.getDefaultFeature((StructureType)structureType.get(), world, pos)) != null) {
            return FeatureGenerator.plopAnywhere(configuredStandard2, world, pos, world.m_7726_().m_8481_(), false);
        }
        Feature feature = (Feature)world.m_9598_().m_175515_(Registries.f_256833_).m_7745_(id);
        if (feature != null && (configuredStandard = FeatureGenerator.getDefaultFeature(feature, world, pos, true)) != null) {
            ThreadLocal<Boolean> checks = Vanilla.skipGenerationChecks(world);
            checks.set(true);
            try {
                Boolean bl = configuredStandard.m_224953_((WorldGenLevel)world, world.m_7726_().m_8481_(), world.f_46441_, pos);
                return bl;
            }
            finally {
                checks.set(false);
            }
        }
        return null;
    }

    @Nullable
    public static Structure resolveConfiguredStructure(String name, ServerLevel world, BlockPos pos) {
        ResourceLocation id = new ResourceLocation(name);
        Structure configuredStructureFeature = (Structure)world.m_9598_().m_175515_(Registries.f_256944_).m_7745_(id);
        if (configuredStructureFeature != null) {
            return configuredStructureFeature;
        }
        StructureType structureFeature = (StructureType)world.m_9598_().m_175515_(Registries.f_256938_).m_7745_(id);
        if (structureFeature == null) {
            return null;
        }
        return FeatureGenerator.getDefaultFeature(structureFeature, world, pos);
    }

    public static synchronized boolean plopGrid(Structure structureFeature, ServerLevel world, BlockPos pos) {
        return FeatureGenerator.plopAnywhere(structureFeature, world, pos, world.m_7726_().m_8481_(), true);
    }

    private static Thing simplePlop(ConfiguredFeature<?, ?> feature) {
        return (w, p) -> {
            ThreadLocal<Boolean> checks = Vanilla.skipGenerationChecks(w);
            checks.set(true);
            try {
                Boolean bl = feature.m_224953_((WorldGenLevel)w, w.m_7726_().m_8481_(), w.f_46441_, p);
                return bl;
            }
            finally {
                checks.set(false);
            }
        };
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> Thing simplePlop(F feature, FC config) {
        return FeatureGenerator.simplePlop(new ConfiguredFeature(feature, config));
    }

    private static Thing simpleTree(TreeConfiguration config) {
        return FeatureGenerator.simplePlop(new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)config));
    }

    private static Thing spawnCustomStructure(Structure structure) {
        return FeatureGenerator.setupCustomStructure(structure, false);
    }

    private static Thing setupCustomStructure(Structure structure, boolean wireOnly) {
        return (w, p) -> FeatureGenerator.plopAnywhere(structure, w, p, w.m_7726_().m_8481_(), wireOnly);
    }

    private static Structure getDefaultFeature(StructureType<?> structure, ServerLevel world, BlockPos pos) {
        Holder existingBiome = world.m_204166_(pos);
        Structure result = null;
        Iterator<Structure> iterator = world.m_9598_().m_175515_(Registries.f_256944_).m_6579_().stream().filter(cS -> ((Structure)cS.getValue()).m_213658_() == structure).map(Map.Entry::getValue).toList().iterator();
        while (iterator.hasNext()) {
            Structure confstr;
            result = confstr = iterator.next();
            if (!confstr.m_226559_().m_203333_(existingBiome)) continue;
            return result;
        }
        return result;
    }

    private static ConfiguredFeature<?, ?> getDefaultFeature(Feature<?> feature, ServerLevel world, BlockPos pos, boolean tryHard) {
        List configuredStepFeatures = ((Biome)world.m_204166_(pos).m_203334_()).m_47536_().m_47818_();
        for (HolderSet step : configuredStepFeatures) {
            for (Holder provider : step) {
                if (((ConfiguredFeature)((PlacedFeature)provider.m_203334_()).f_191775_().m_203334_()).f_65377_() != feature) continue;
                return (ConfiguredFeature)((PlacedFeature)provider.m_203334_()).f_191775_().m_203334_();
            }
        }
        if (!tryHard) {
            return null;
        }
        return world.m_9598_().m_175515_(Registries.f_256911_).m_6579_().stream().filter(cS -> ((ConfiguredFeature)cS.getValue()).f_65377_() == feature).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public static <T extends FeatureConfiguration> StructureStart shouldStructureStartAt(ServerLevel world, BlockPos pos, Structure structure, boolean computeBox) {
        ServerChunkCache chunkSource = world.m_7726_();
        RandomState seed = chunkSource.m_214994_();
        ChunkGenerator generator = chunkSource.m_8481_();
        ChunkGeneratorStructureState structureState = chunkSource.m_255415_();
        List structureConfig = structureState.m_255260_(Holder.m_205709_((Object)structure));
        ChunkPos chunkPos = new ChunkPos(pos);
        boolean couldPlace = structureConfig.stream().anyMatch(p -> p.m_255071_(structureState, chunkPos.f_45578_, chunkPos.f_45579_));
        if (!couldPlace) {
            return null;
        }
        HolderSet structureBiomes = structure.m_226559_();
        if (!computeBox) {
            if (structure.m_262864_(new Structure.GenerationContext(world.m_9598_(), generator, generator.m_62218_(), seed, world.m_215082_(), world.m_7328_(), chunkPos, (LevelHeightAccessor)world, arg_0 -> ((HolderSet)structureBiomes).m_203333_(arg_0))).isPresent()) {
                return StructureStart.f_73561_;
            }
        } else {
            StructureStart filledStructure = structure.m_226596_(world.m_9598_(), generator, generator.m_62218_(), seed, world.m_215082_(), world.m_7328_(), chunkPos, 0, (LevelHeightAccessor)world, arg_0 -> ((HolderSet)structureBiomes).m_203333_(arg_0));
            if (filledStructure != null && filledStructure.m_73603_()) {
                return filledStructure;
            }
        }
        return null;
    }

    private static TreeConfiguration.TreeConfigurationBuilder createTree(Block block, Block block2, int i, int j, int k, int l) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)block), (TrunkPlacer)new StraightTrunkPlacer(i, j, k), (BlockStateProvider)BlockStateProvider.m_191382_((Block)block2), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)l), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean plopAnywhere(Structure structure, ServerLevel world, BlockPos pos, ChunkGenerator generator, boolean wireOnly) {
        ThreadLocal<Boolean> checks = Vanilla.skipGenerationChecks(world);
        checks.set(true);
        try {
            StructureStart start = structure.m_226596_(world.m_9598_(), generator, generator.m_62218_(), world.m_7726_().m_214994_(), world.m_215082_(), world.m_7328_(), new ChunkPos(pos), 0, (LevelHeightAccessor)world, b -> true);
            if (start == StructureStart.f_73561_) {
                boolean bl = false;
                return bl;
            }
            RandomSource rand = RandomSource.m_216335_((long)world.m_213780_().m_188502_());
            int j = pos.m_123341_() >> 4;
            int k = pos.m_123343_() >> 4;
            long chId = ChunkPos.m_45589_((int)j, (int)k);
            world.m_6325_(j, k).m_213792_(structure, start);
            world.m_6325_(j, k).m_213843_(structure, chId);
            BoundingBox box = start.m_73601_();
            if (!wireOnly) {
                Registry registry3 = world.m_9598_().m_175515_(Registries.f_256944_);
                world.m_143497_(() -> {
                    Objects.requireNonNull(structure);
                    return registry3.m_7854_((Object)structure).map(Object::toString).orElseGet(structure::toString);
                });
                start.m_226850_((WorldGenLevel)world, world.m_215010_(), generator, rand, box, new ChunkPos(j, k));
            }
            int i = Math.max(box.m_71056_(), box.m_71058_()) / 16 + 1;
            for (int k1 = j - i; k1 <= j + i; ++k1) {
                for (int l1 = k - i; l1 <= k + i; ++l1) {
                    if (k1 == j && l1 == k || !box.m_71019_(k1 << 4, l1 << 4, (k1 << 4) + 15, (l1 << 4) + 15)) continue;
                    world.m_6325_(k1, l1).m_213843_(structure, chId);
                }
            }
        }
        catch (Exception booboo) {
            CarpetScriptServer.LOG.error("Unknown Exception while plopping structure: " + String.valueOf(booboo), (Throwable)booboo);
            boolean bl = false;
            return bl;
        }
        finally {
            checks.set(false);
        }
        return true;
    }

    @FunctionalInterface
    private static interface Thing {
        public Boolean plop(ServerLevel var1, BlockPos var2);
    }
}

