/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.Mth;

public class PerlinNoiseSampler {
    protected static final int[][] gradients3d = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}, {1, 1, 0}, {0, -1, 1}, {-1, 1, 0}, {0, -1, -1}};
    protected static final int[][] gradients2d = new int[][]{{1, 1}, {-1, 1}, {1, -1}, {-1, -1}};
    private final byte[] permutations;
    public final double originX;
    public final double originY;
    public final double originZ;
    public static PerlinNoiseSampler instance = new PerlinNoiseSampler(new Random(0L));
    public static Map<Long, PerlinNoiseSampler> samplers = new Long2ObjectOpenHashMap();

    public static PerlinNoiseSampler getPerlin(long aLong) {
        if (samplers.size() > 256) {
            samplers.clear();
        }
        return samplers.computeIfAbsent(aLong, seed -> new PerlinNoiseSampler(new Random((long)seed)));
    }

    public PerlinNoiseSampler(Random random) {
        int j;
        this.originX = random.nextDouble() * 256.0;
        this.originY = random.nextDouble() * 256.0;
        this.originZ = random.nextDouble() * 256.0;
        this.permutations = new byte[256];
        for (j = 0; j < 256; ++j) {
            this.permutations[j] = (byte)j;
        }
        for (j = 0; j < 256; ++j) {
            int k = random.nextInt(256 - j);
            byte b = this.permutations[j];
            this.permutations[j] = this.permutations[j + k];
            this.permutations[j + k] = b;
        }
    }

    public double sample3d(double x, double y, double z) {
        double f = x + this.originX;
        double g = y + this.originY;
        double h = z + this.originZ;
        int i = Mth.m_14107_((double)f);
        int j = Mth.m_14107_((double)g);
        int k = Mth.m_14107_((double)h);
        double l = f - (double)i;
        double m = g - (double)j;
        double n = h - (double)k;
        double o = PerlinNoiseSampler.perlinFade(l);
        double p = PerlinNoiseSampler.perlinFade(m);
        double q = PerlinNoiseSampler.perlinFade(n);
        return this.sample3d(i, j, k, l, m, n, o, p, q) / 2.0 + 0.5;
    }

    private double sample3d(int sectionX, int sectionY, int sectionZ, double localX, double localY, double localZ, double fadeLocalX, double fadeLocalY, double fadeLocalZ) {
        int i = this.getGradient(sectionX) + sectionY;
        int j = this.getGradient(i) + sectionZ;
        int k = this.getGradient(i + 1) + sectionZ;
        int l = this.getGradient(sectionX + 1) + sectionY;
        int m = this.getGradient(l) + sectionZ;
        int n = this.getGradient(l + 1) + sectionZ;
        double d = PerlinNoiseSampler.grad3d(this.getGradient(j), localX, localY, localZ);
        double e = PerlinNoiseSampler.grad3d(this.getGradient(m), localX - 1.0, localY, localZ);
        double f = PerlinNoiseSampler.grad3d(this.getGradient(k), localX, localY - 1.0, localZ);
        double g = PerlinNoiseSampler.grad3d(this.getGradient(n), localX - 1.0, localY - 1.0, localZ);
        double h = PerlinNoiseSampler.grad3d(this.getGradient(j + 1), localX, localY, localZ - 1.0);
        double o = PerlinNoiseSampler.grad3d(this.getGradient(m + 1), localX - 1.0, localY, localZ - 1.0);
        double p = PerlinNoiseSampler.grad3d(this.getGradient(k + 1), localX, localY - 1.0, localZ - 1.0);
        double q = PerlinNoiseSampler.grad3d(this.getGradient(n + 1), localX - 1.0, localY - 1.0, localZ - 1.0);
        return PerlinNoiseSampler.lerp3(fadeLocalX, fadeLocalY, fadeLocalZ, d, e, f, g, h, o, p, q);
    }

    private static double grad3d(int hash, double x, double y, double z) {
        int i = hash & 0xF;
        return PerlinNoiseSampler.dot3d(gradients3d[i], x, y, z);
    }

    protected static double dot3d(int[] gArr, double x, double y, double z) {
        return (double)gArr[0] * x + (double)gArr[1] * y + (double)gArr[2] * z;
    }

    public static double lerp3(double deltaX, double deltaY, double deltaZ, double d, double e, double f, double g, double h, double i, double j, double k) {
        return PerlinNoiseSampler.lerp(deltaZ, PerlinNoiseSampler.lerp2(deltaX, deltaY, d, e, f, g), PerlinNoiseSampler.lerp2(deltaX, deltaY, h, i, j, k));
    }

    public double sample2d(double x, double y) {
        double f = x + this.originX;
        double g = y + this.originY;
        int i = Mth.m_14107_((double)f);
        int j = Mth.m_14107_((double)g);
        double l = f - (double)i;
        double m = g - (double)j;
        double o = PerlinNoiseSampler.perlinFade(l);
        double p = PerlinNoiseSampler.perlinFade(m);
        return this.sample2d(i, j, l, m, o, p) / 2.0 + 0.5;
    }

    private double sample2d(int sectionX, int sectionY, double localX, double localY, double fadeLocalX, double fadeLocalY) {
        int j = this.getGradient(sectionX) + sectionY;
        int m = this.getGradient(sectionX + 1) + sectionY;
        double d = PerlinNoiseSampler.grad2d(this.getGradient(j), localX, localY);
        double e = PerlinNoiseSampler.grad2d(this.getGradient(m), localX - 1.0, localY);
        double f = PerlinNoiseSampler.grad2d(this.getGradient(j + 1), localX, localY - 1.0);
        double g = PerlinNoiseSampler.grad2d(this.getGradient(m + 1), localX - 1.0, localY - 1.0);
        return PerlinNoiseSampler.lerp2(fadeLocalX, fadeLocalY, d, e, f, g);
    }

    private static double grad2d(int hash, double x, double y) {
        int i = hash & 3;
        return PerlinNoiseSampler.dot2d(gradients2d[i], x, y);
    }

    protected static double dot2d(int[] gArr, double x, double y) {
        return (double)gArr[0] * x + (double)gArr[1] * y;
    }

    public static double lerp2(double deltaX, double deltaY, double d, double e, double f, double g) {
        return PerlinNoiseSampler.lerp(deltaY, PerlinNoiseSampler.lerp(deltaX, d, e), PerlinNoiseSampler.lerp(deltaX, f, g));
    }

    public double sample1d(double x) {
        double f = x + this.originX;
        int i = Mth.m_14107_((double)f);
        double l = f - (double)i;
        double o = PerlinNoiseSampler.perlinFade(l);
        return this.sample1d(i, l, o) + 0.5;
    }

    private double sample1d(int sectionX, double localX, double fadeLocalX) {
        double d = PerlinNoiseSampler.grad1d(this.getGradient(sectionX), localX);
        double e = PerlinNoiseSampler.grad1d(this.getGradient(sectionX + 1), localX - 1.0);
        return PerlinNoiseSampler.lerp(fadeLocalX, d, e);
    }

    private static double grad1d(int hash, double x) {
        return (hash & 1) == 0 ? x : -x;
    }

    public static double lerp(double delta, double first, double second) {
        return first + delta * (second - first);
    }

    public int getGradient(int hash) {
        return this.permutations[hash & 0xFF] & 0xFF;
    }

    public static double perlinFade(double d) {
        return d * d * d * (d * (d * 6.0 - 15.0) + 10.0);
    }
}

