/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.CarpetContext;
import carpet.script.CarpetScriptServer;
import carpet.script.EntityEventsGroup;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.utils.EntityTools;
import carpet.script.utils.InputValidator;
import carpet.script.utils.Tracer;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityValue
extends Value {
    private Entity entity;
    private static final Map<String, net.minecraft.commands.arguments.selector.EntitySelector> selectorCache = new HashMap<String, net.minecraft.commands.arguments.selector.EntitySelector>();
    public static final EntityTypeTest<Entity, ?> ANY = EntityTypeTest.m_156916_(Entity.class);
    private static final Map<String, EquipmentSlot> inventorySlots = Map.of("mainhand", EquipmentSlot.MAINHAND, "offhand", EquipmentSlot.OFFHAND, "head", EquipmentSlot.HEAD, "chest", EquipmentSlot.CHEST, "legs", EquipmentSlot.LEGS, "feet", EquipmentSlot.FEET);
    private static final Map<String, BiFunction<Entity, Value, Value>> featureAccessors = new HashMap<String, BiFunction<Entity, Value, Value>>(){
        {
            this.put("removed", (entity, arg) -> BooleanValue.of(entity.m_213877_()));
            this.put("uuid", (e, a) -> new StringValue(e.m_20149_()));
            this.put("id", (e, a) -> new NumericValue(e.m_19879_()));
            this.put("pos", (e, a) -> ListValue.of(new NumericValue(e.m_20185_()), new NumericValue(e.m_20186_()), new NumericValue(e.m_20189_())));
            this.put("location", (e, a) -> ListValue.of(new NumericValue(e.m_20185_()), new NumericValue(e.m_20186_()), new NumericValue(e.m_20189_()), new NumericValue(e.m_146908_()), new NumericValue(e.m_146909_())));
            this.put("x", (e, a) -> new NumericValue(e.m_20185_()));
            this.put("y", (e, a) -> new NumericValue(e.m_20186_()));
            this.put("z", (e, a) -> new NumericValue(e.m_20189_()));
            this.put("motion", (e, a) -> {
                Vec3 velocity = e.m_20184_();
                return ListValue.of(new NumericValue(velocity.f_82479_), new NumericValue(velocity.f_82480_), new NumericValue(velocity.f_82481_));
            });
            this.put("motion_x", (e, a) -> new NumericValue(e.m_20184_().f_82479_));
            this.put("motion_y", (e, a) -> new NumericValue(e.m_20184_().f_82480_));
            this.put("motion_z", (e, a) -> new NumericValue(e.m_20184_().f_82481_));
            this.put("on_ground", (e, a) -> BooleanValue.of(e.m_20096_()));
            this.put("name", (e, a) -> new StringValue(e.m_7755_().getString()));
            this.put("display_name", (e, a) -> new FormattedTextValue(e.m_5446_()));
            this.put("command_name", (e, a) -> new StringValue(e.m_6302_()));
            this.put("custom_name", (e, a) -> e.m_8077_() ? new StringValue(e.m_7770_().getString()) : Value.NULL);
            this.put("type", (e, a) -> NBTSerializableValue.nameFromRegistryId(e.m_9236_().m_9598_().m_175515_(Registries.f_256939_).m_7981_((Object)e.m_6095_())));
            this.put("is_riding", (e, a) -> BooleanValue.of(e.m_20159_()));
            this.put("is_ridden", (e, a) -> BooleanValue.of(e.m_20160_()));
            this.put("passengers", (e, a) -> ListValue.wrap(e.m_20197_().stream().map(EntityValue::new)));
            this.put("mount", (e, a) -> e.m_20202_() != null ? new EntityValue(e.m_20202_()) : Value.NULL);
            this.put("unmountable", (e, a) -> BooleanValue.of(Vanilla.Entity_isPermanentVehicle(e)));
            this.put("tags", (e, a) -> ListValue.wrap(e.m_19880_().stream().map(StringValue::new)));
            this.put("scoreboard_tags", (e, a) -> ListValue.wrap(e.m_19880_().stream().map(StringValue::new)));
            this.put("entity_tags", (e, a) -> {
                EntityType type = e.m_6095_();
                return ListValue.wrap(e.m_20194_().m_206579_().m_175515_(Registries.f_256939_).m_203612_().filter(entry -> ((HolderSet.Named)entry.getSecond()).m_203614_().anyMatch(h -> h.m_203334_() == type)).map(entry -> ValueConversions.of((TagKey)entry.getFirst())));
            });
            this.put("has_tag", (e, a) -> BooleanValue.of(e.m_19880_().contains(a.getString())));
            this.put("has_scoreboard_tag", (e, a) -> BooleanValue.of(e.m_19880_().contains(a.getString())));
            this.put("has_entity_tag", (e, a) -> {
                Optional tag = e.m_20194_().m_206579_().m_175515_(Registries.f_256939_).m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)InputValidator.identifierOf(a.getString())));
                if (tag.isEmpty()) {
                    return Value.NULL;
                }
                EntityType type = e.m_6095_();
                return BooleanValue.of(((HolderSet.Named)tag.get()).m_203614_().anyMatch(h -> h.m_203334_() == type));
            });
            this.put("yaw", (e, a) -> new NumericValue(e.m_146908_()));
            this.put("head_yaw", (e, a) -> e instanceof LivingEntity ? new NumericValue(e.m_6080_()) : Value.NULL);
            this.put("body_yaw", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    numericValue = new NumericValue(le.f_20883_);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("pitch", (e, a) -> new NumericValue(e.m_146909_()));
            this.put("look", (e, a) -> {
                Vec3 look = e.m_20154_();
                return ListValue.of(new NumericValue(look.f_82479_), new NumericValue(look.f_82480_), new NumericValue(look.f_82481_));
            });
            this.put("is_burning", (e, a) -> BooleanValue.of(e.m_6060_()));
            this.put("fire", (e, a) -> new NumericValue(e.m_20094_()));
            this.put("is_freezing", (e, a) -> BooleanValue.of(e.m_146890_()));
            this.put("frost", (e, a) -> new NumericValue(e.m_146888_()));
            this.put("silent", (e, a) -> BooleanValue.of(e.m_20067_()));
            this.put("gravity", (e, a) -> BooleanValue.of(!e.m_20068_()));
            this.put("immune_to_fire", (e, a) -> BooleanValue.of(e.m_5825_()));
            this.put("immune_to_frost", (e, a) -> BooleanValue.of(!e.m_142079_()));
            this.put("invulnerable", (e, a) -> BooleanValue.of(e.m_20147_()));
            this.put("dimension", (e, a) -> NBTSerializableValue.nameFromRegistryId(e.m_9236_().m_46472_().m_135782_()));
            this.put("height", (e, a) -> new NumericValue(e.m_6972_((Pose)Pose.STANDING).f_20378_));
            this.put("width", (e, a) -> new NumericValue(e.m_6972_((Pose)Pose.STANDING).f_20377_));
            this.put("eye_height", (e, a) -> new NumericValue(e.m_20192_()));
            this.put("age", (e, a) -> new NumericValue(e.f_19797_));
            this.put("breeding_age", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof AgeableMob) {
                    AgeableMob am = (AgeableMob)e;
                    numericValue = new NumericValue(am.m_146764_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("despawn_timer", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    numericValue = new NumericValue(le.m_21216_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("blue_skull", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof WitherSkull) {
                    WitherSkull w = (WitherSkull)e;
                    numericValue = BooleanValue.of(w.m_37635_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("offering_flower", (e, a) -> {
                IronGolem ig;
                return e instanceof IronGolem ? BooleanValue.of((ig = (IronGolem)e).m_28875_() > 0) : Value.NULL;
            });
            this.put("item", (e, a) -> {
                Value value;
                if (e instanceof ItemEntity) {
                    ItemEntity ie = (ItemEntity)e;
                    value = ValueConversions.of(ie.m_32055_(), (RegistryAccess)e.m_20194_().m_206579_());
                } else if (e instanceof ItemFrame) {
                    ItemFrame frame = (ItemFrame)e;
                    value = ValueConversions.of(frame.m_31822_(), (RegistryAccess)e.m_20194_().m_206579_());
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("count", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof ItemEntity) {
                    ItemEntity ie = (ItemEntity)e;
                    numericValue = new NumericValue(ie.m_32055_().m_41613_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("pickup_delay", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof ItemEntity) {
                    ItemEntity ie = (ItemEntity)e;
                    numericValue = new NumericValue(Vanilla.ItemEntity_getPickupDelay(ie));
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("portal_cooldown", (e, a) -> new NumericValue(Vanilla.Entity_getPublicNetherPortalCooldown(e)));
            this.put("portal_timer", (e, a) -> new NumericValue(Vanilla.Entity_getPortalTimer(e)));
            this.put("is_baby", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    numericValue = BooleanValue.of(le.m_6162_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("target", (e, a) -> {
                Mob mob;
                LivingEntity target;
                if (e instanceof Mob && (target = (mob = (Mob)e).m_5448_()) != null) {
                    return new EntityValue((Entity)target);
                }
                return Value.NULL;
            });
            this.put("home", (e, a) -> {
                Mob mob;
                return e instanceof Mob ? ((mob = (Mob)e).m_21535_() > 0.0f ? new BlockValue(null, (ServerLevel)e.m_9236_(), mob.m_21534_()) : Value.FALSE) : Value.NULL;
            });
            this.put("spawn_point", (e, a) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer spe = (ServerPlayer)e;
                    if (spe.m_8961_() == null) {
                        return Value.FALSE;
                    }
                    return ListValue.of(ValueConversions.of(spe.m_8961_()), ValueConversions.of(spe.m_8963_()), new NumericValue(spe.m_8962_()), BooleanValue.of(spe.m_8964_()));
                }
                return Value.NULL;
            });
            this.put("pose", (e, a) -> new StringValue(e.m_20089_().name().toLowerCase(Locale.ROOT)));
            this.put("sneaking", (e, a) -> e.m_6144_() ? Value.TRUE : Value.FALSE);
            this.put("sprinting", (e, a) -> e.m_20142_() ? Value.TRUE : Value.FALSE);
            this.put("swimming", (e, a) -> e.m_6069_() ? Value.TRUE : Value.FALSE);
            this.put("swinging", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    numericValue = BooleanValue.of(le.f_20911_);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("air", (e, a) -> new NumericValue(e.m_20146_()));
            this.put("language", (e, a) -> {
                Value value;
                if (!(e instanceof ServerPlayer)) {
                    value = Value.NULL;
                } else {
                    ServerPlayer p = (ServerPlayer)e;
                    value = StringValue.of(Vanilla.ServerPlayer_getLanguage(p));
                }
                return value;
            });
            this.put("persistence", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    numericValue = BooleanValue.of(mob.m_21532_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("hunger", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.m_36324_().m_38702_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("saturation", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.m_36324_().m_38722_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("exhaustion", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.m_36324_().m_150380_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("absorption", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.m_6103_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("xp", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.f_36079_);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("xp_level", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.f_36078_);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("xp_progress", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.f_36080_);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("score", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.m_36344_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("jumping", (e, a) -> {
                LivingEntity le;
                return e instanceof LivingEntity ? (Vanilla.LivingEntity_isJumping(le = (LivingEntity)e) ? Value.TRUE : Value.FALSE) : Value.NULL;
            });
            this.put("gamemode", (e, a) -> {
                Value value;
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    value = new StringValue(sp.f_8941_.m_9290_().m_46405_());
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("path", (e, a) -> {
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    Path path = mob.m_21573_().m_26570_();
                    if (path == null) {
                        return Value.NULL;
                    }
                    return ValueConversions.fromPath((ServerLevel)e.m_20193_(), path);
                }
                return Value.NULL;
            });
            this.put("brain", (e, a) -> {
                String module = a.getString();
                MemoryModuleType moduleType = (MemoryModuleType)e.m_9236_().m_9598_().m_175515_(Registries.f_257023_).m_7745_(InputValidator.identifierOf(module));
                if (moduleType == MemoryModuleType.f_26349_) {
                    return Value.NULL;
                }
                if (e instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)e;
                    Brain brain = livingEntity.m_6274_();
                    Map memories = brain.m_147339_();
                    Optional optmemory = (Optional)memories.get(moduleType);
                    if (optmemory == null || !optmemory.isPresent()) {
                        return Value.NULL;
                    }
                    ExpirableValue memory = (ExpirableValue)optmemory.get();
                    return ValueConversions.fromTimedMemory(e, memory.m_148191_(), memory.m_26319_());
                }
                return Value.NULL;
            });
            this.put("gamemode_id", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    numericValue = new NumericValue(sp.f_8941_.m_9290_().m_46392_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("permission_level", (e, a) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer spe = (ServerPlayer)e;
                    for (int i = 4; i >= 0; --i) {
                        if (!spe.m_20310_(i)) continue;
                        return new NumericValue(i);
                    }
                    return new NumericValue(0L);
                }
                return Value.NULL;
            });
            this.put("player_type", (e, a) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    String moddedType = Carpet.isModdedPlayer(p);
                    if (moddedType != null) {
                        return StringValue.of(moddedType);
                    }
                    MinecraftServer server = p.m_20193_().m_7654_();
                    if (server.m_6982_()) {
                        return new StringValue("multiplayer");
                    }
                    boolean runningLan = server.m_6992_();
                    if (!runningLan) {
                        return new StringValue("singleplayer");
                    }
                    boolean isowner = server.m_7779_(p.m_36316_());
                    if (isowner) {
                        return new StringValue("lan_host");
                    }
                    return new StringValue("lan player");
                }
                return Value.NULL;
            });
            this.put("client_brand", (e, a) -> {
                Value value;
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    value = StringValue.of(Carpet.getPlayerStatus(sp));
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("team", (e, a) -> e.m_5647_() == null ? Value.NULL : new StringValue(e.m_5647_().m_5758_()));
            this.put("ping", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    numericValue = new NumericValue(sp.f_8943_);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("effect", (e, a) -> {
                if (!(e instanceof LivingEntity)) {
                    return Value.NULL;
                }
                LivingEntity le = (LivingEntity)e;
                if (a == null) {
                    ArrayList<Value> effects = new ArrayList<Value>();
                    for (MobEffectInstance p : le.m_21220_()) {
                        effects.add(ListValue.of(new StringValue(p.m_19576_().replaceFirst("^effect\\.minecraft\\.", "")), new NumericValue(p.m_19564_()), new NumericValue(p.m_19557_())));
                    }
                    return ListValue.wrap(effects);
                }
                String effectName = a.getString();
                MobEffect potion = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(InputValidator.identifierOf(effectName));
                if (potion == null) {
                    throw new InternalExpressionException("No such an effect: " + effectName);
                }
                if (!le.m_21023_(potion)) {
                    return Value.NULL;
                }
                MobEffectInstance pe = le.m_21124_(potion);
                return ListValue.of(new NumericValue(pe.m_19564_()), new NumericValue(pe.m_19557_()));
            });
            this.put("health", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    numericValue = new NumericValue(le.m_21223_());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("may_fly", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    numericValue = BooleanValue.of(player.m_150110_().f_35936_);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("flying", (e, v) -> {
                NumericValue numericValue;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    numericValue = BooleanValue.of(player.m_150110_().f_35935_);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("may_build", (e, v) -> {
                NumericValue numericValue;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    numericValue = BooleanValue.of(player.m_150110_().f_35938_);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("insta_build", (e, v) -> {
                NumericValue numericValue;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    numericValue = BooleanValue.of(player.m_150110_().f_35937_);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("fly_speed", (e, v) -> {
                Value value;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    value = NumericValue.of(Float.valueOf(player.m_150110_().m_35942_()));
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("walk_speed", (e, v) -> {
                Value value;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    value = NumericValue.of(Float.valueOf(player.m_150110_().m_35947_()));
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("holds", (e, a) -> {
                EquipmentSlot where = EquipmentSlot.MAINHAND;
                if (a != null) {
                    where = inventorySlots.get(a.getString());
                }
                if (where == null) {
                    throw new InternalExpressionException("Unknown inventory slot: " + a.getString());
                }
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    return ValueConversions.of(le.m_6844_(where), (RegistryAccess)e.m_20194_().m_206579_());
                }
                return Value.NULL;
            });
            this.put("selected_slot", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player p = (Player)e;
                    numericValue = new NumericValue(p.m_150109_().f_35977_);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("active_block", (e, a) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    BlockPos pos = Vanilla.ServerPlayerGameMode_getCurrentBlockPosition(sp.f_8941_);
                    if (pos == null) {
                        return Value.NULL;
                    }
                    return new BlockValue(null, sp.m_284548_(), pos);
                }
                return Value.NULL;
            });
            this.put("breaking_progress", (e, a) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    int progress = Vanilla.ServerPlayerGameMode_getCurrentBlockBreakingProgress(sp.f_8941_);
                    return progress < 0 ? Value.NULL : new NumericValue(progress);
                }
                return Value.NULL;
            });
            this.put("facing", (e, a) -> {
                int index = 0;
                if (a != null) {
                    index = (6 + (int)NumericValue.asNumber(a).getLong()) % 6;
                }
                if (index < 0 || index > 5) {
                    throw new InternalExpressionException("Facing order should be between -6 and 5");
                }
                return new StringValue(Direction.m_122382_((Entity)e)[index].m_7912_());
            });
            this.put("trace", (e, a) -> {
                Object hitres;
                float reach = 4.5f;
                boolean entities = true;
                boolean liquids = false;
                boolean blocks = true;
                boolean exact = false;
                if (a != null) {
                    if (!(a instanceof ListValue)) {
                        reach = (float)NumericValue.asNumber(a).getDouble();
                    } else {
                        ListValue lv = (ListValue)a;
                        List<Value> args = lv.getItems();
                        if (args.size() == 0) {
                            throw new InternalExpressionException("'trace' needs more arguments");
                        }
                        reach = (float)NumericValue.asNumber(args.get(0)).getDouble();
                        if (args.size() > 1) {
                            entities = false;
                            blocks = false;
                            for (int i = 1; i < args.size(); ++i) {
                                String what = args.get(i).getString();
                                if (what.equalsIgnoreCase("entities")) {
                                    entities = true;
                                    continue;
                                }
                                if (what.equalsIgnoreCase("blocks")) {
                                    blocks = true;
                                    continue;
                                }
                                if (what.equalsIgnoreCase("liquids")) {
                                    liquids = true;
                                    continue;
                                }
                                if (what.equalsIgnoreCase("exact")) {
                                    exact = true;
                                    continue;
                                }
                                throw new InternalExpressionException("Incorrect tracing: " + what);
                            }
                        }
                    }
                } else if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    if (sp.f_8941_.m_9295_()) {
                        reach = 5.0f;
                    }
                }
                if ((hitres = entities && !blocks ? Tracer.rayTraceEntities(e, 1.0f, reach, reach * reach) : (entities ? Tracer.rayTrace(e, 1.0f, reach, liquids) : Tracer.rayTraceBlocks(e, 1.0f, reach, liquids))) == null) {
                    return Value.NULL;
                }
                if (exact && hitres.m_6662_() != HitResult.Type.MISS) {
                    return ValueConversions.of(hitres.m_82450_());
                }
                switch (hitres.m_6662_()) {
                    case MISS: {
                        return Value.NULL;
                    }
                    case BLOCK: {
                        return new BlockValue((ServerLevel)e.m_20193_(), ((BlockHitResult)hitres).m_82425_());
                    }
                    case ENTITY: {
                        return new EntityValue(((EntityHitResult)hitres).m_82443_());
                    }
                }
                return Value.NULL;
            });
            this.put("attribute", (e, a) -> {
                if (!(e instanceof LivingEntity)) {
                    return Value.NULL;
                }
                LivingEntity el = (LivingEntity)e;
                Registry attributes = e.m_9236_().m_9598_().m_175515_(Registries.f_256728_);
                if (a == null) {
                    AttributeMap container = el.m_21204_();
                    return MapValue.wrap(attributes.m_123024_().filter(arg_0 -> ((AttributeMap)container).m_22171_(arg_0)).collect(Collectors.toMap(aa -> ValueConversions.of(attributes.m_7981_(aa)), aa -> NumericValue.of(container.m_22181_(aa)))));
                }
                ResourceLocation id = InputValidator.identifierOf(a.getString());
                Attribute attrib = (Attribute)attributes.m_6612_(id).orElseThrow(() -> new InternalExpressionException("Unknown attribute: " + a.getString()));
                if (!el.m_21204_().m_22171_(attrib)) {
                    return Value.NULL;
                }
                return NumericValue.of(el.m_21133_(attrib));
            });
            this.put("nbt", (e, a) -> {
                CompoundTag nbttagcompound = e.m_20240_(new CompoundTag());
                if (a == null) {
                    return new NBTSerializableValue((Tag)nbttagcompound);
                }
                return new NBTSerializableValue((Tag)nbttagcompound).get((Value)a);
            });
            this.put("category", (e, a) -> new StringValue(e.m_6095_().m_20674_().toString().toLowerCase(Locale.ROOT)));
        }
    };
    private static final Map<String, BiConsumer<Entity, Value>> featureModifiers = new HashMap<String, BiConsumer<Entity, Value>>(){
        {
            this.put("remove", (entity, value) -> entity.m_146870_());
            this.put("age", (e, v) -> {
                e.f_19797_ = Math.abs((int)NumericValue.asNumber(v).getLong());
            });
            this.put("health", (e, v) -> {
                float health = (float)NumericValue.asNumber(v).getDouble();
                if (health <= 0.0f && e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    if (player.f_36096_ != null) {
                        player.m_6915_();
                    }
                    ((LivingEntity)e).m_21153_(health);
                }
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    le.m_21153_(health);
                }
            });
            this.put("may_fly", (e, v) -> {
                boolean mayFly = v.getBoolean();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.m_150110_().f_35936_ = mayFly;
                    if (!mayFly && player.m_150110_().f_35935_) {
                        player.m_150110_().f_35935_ = false;
                    }
                    player.m_6885_();
                }
            });
            this.put("flying", (e, v) -> {
                boolean flying = v.getBoolean();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.m_150110_().f_35935_ = flying;
                    player.m_6885_();
                }
            });
            this.put("may_build", (e, v) -> {
                boolean mayBuild = v.getBoolean();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.m_150110_().f_35938_ = mayBuild;
                    player.m_6885_();
                }
            });
            this.put("insta_build", (e, v) -> {
                boolean instaBuild = v.getBoolean();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.m_150110_().f_35937_ = instaBuild;
                    player.m_6885_();
                }
            });
            this.put("fly_speed", (e, v) -> {
                float flySpeed = NumericValue.asNumber(v).getFloat();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.m_150110_().m_35943_(flySpeed);
                    player.m_6885_();
                }
            });
            this.put("walk_speed", (e, v) -> {
                float walkSpeed = NumericValue.asNumber(v).getFloat();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.m_150110_().m_35948_(walkSpeed);
                    player.m_6885_();
                }
            });
            this.put("selected_slot", (e, v) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    int slot = NumericValue.asNumber(v).getInt();
                    player.f_8906_.m_9829_((Packet)new ClientboundSetCarriedItemPacket(slot));
                }
            });
            this.put("kill", (e, v) -> e.m_6074_());
            this.put("location", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 5 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                EntityValue.updatePosition(e, NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble(), (float)NumericValue.asNumber(coords.get(3)).getDouble(), (float)NumericValue.asNumber(coords.get(4)).getDouble());
            });
            this.put("pos", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                EntityValue.updatePosition(e, NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble(), e.m_146908_(), e.m_146909_());
            });
            this.put("x", (e, v) -> EntityValue.updatePosition(e, NumericValue.asNumber(v).getDouble(), e.m_20186_(), e.m_20189_(), e.m_146908_(), e.m_146909_()));
            this.put("y", (e, v) -> EntityValue.updatePosition(e, e.m_20185_(), NumericValue.asNumber(v).getDouble(), e.m_20189_(), e.m_146908_(), e.m_146909_()));
            this.put("z", (e, v) -> EntityValue.updatePosition(e, e.m_20185_(), e.m_20186_(), NumericValue.asNumber(v).getDouble(), e.m_146908_(), e.m_146909_()));
            this.put("yaw", (e, v) -> EntityValue.updatePosition(e, e.m_20185_(), e.m_20186_(), e.m_20189_(), (float)NumericValue.asNumber(v).getDouble() % 360.0f, e.m_146909_()));
            this.put("head_yaw", (e, v) -> {
                if (e instanceof LivingEntity) {
                    e.m_5616_((float)NumericValue.asNumber(v).getDouble() % 360.0f);
                }
            });
            this.put("body_yaw", (e, v) -> {
                if (e instanceof LivingEntity) {
                    e.m_146922_((float)NumericValue.asNumber(v).getDouble() % 360.0f);
                }
            });
            this.put("pitch", (e, v) -> EntityValue.updatePosition(e, e.m_20185_(), e.m_20186_(), e.m_20189_(), e.m_146908_(), Mth.m_14036_((float)((float)NumericValue.asNumber(v).getDouble()), (float)-90.0f, (float)90.0f)));
            this.put("look", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> vec = lv.getItems();
                float x = NumericValue.asNumber(vec.get(0)).getFloat();
                float y = NumericValue.asNumber(vec.get(1)).getFloat();
                float z = NumericValue.asNumber(vec.get(2)).getFloat();
                float l = Mth.m_14116_((float)(x * x + y * y + z * z));
                if (l == 0.0f) {
                    return;
                }
                float pitch = (float)(-Math.asin(y /= l)) / ((float)Math.PI / 180);
                float yaw = (float)((x /= l) == 0.0f && z == 0.0f ? (double)e.m_146908_() : Mth.m_14136_((double)(-x), (double)(z /= l)) / 0.01745329238474369);
                EntityValue.updatePosition(e, e.m_20185_(), e.m_20186_(), e.m_20189_(), yaw, pitch);
            });
            this.put("move", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                EntityValue.updatePosition(e, e.m_20185_() + NumericValue.asNumber(coords.get(0)).getDouble(), e.m_20186_() + NumericValue.asNumber(coords.get(1)).getDouble(), e.m_20189_() + NumericValue.asNumber(coords.get(2)).getDouble(), e.m_146908_(), e.m_146909_());
            });
            this.put("motion", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                double dx = NumericValue.asNumber(coords.get(0)).getDouble();
                double dy = NumericValue.asNumber(coords.get(1)).getDouble();
                double dz = NumericValue.asNumber(coords.get(2)).getDouble();
                e.m_20334_(dx, dy, dz);
                EntityValue.updateVelocity(e, Mth.m_14005_((double)Mth.m_14005_((double)dx, (double)dy), (double)dz));
            });
            this.put("motion_x", (e, v) -> {
                Vec3 velocity = e.m_20184_();
                double dv = NumericValue.asNumber(v).getDouble();
                e.m_20334_(dv, velocity.f_82480_, velocity.f_82481_);
                EntityValue.updateVelocity(e, dv);
            });
            this.put("motion_y", (e, v) -> {
                Vec3 velocity = e.m_20184_();
                double dv = NumericValue.asNumber(v).getDouble();
                e.m_20334_(velocity.f_82479_, dv, velocity.f_82481_);
                EntityValue.updateVelocity(e, dv);
            });
            this.put("motion_z", (e, v) -> {
                Vec3 velocity = e.m_20184_();
                double dv = NumericValue.asNumber(v).getDouble();
                e.m_20334_(velocity.f_82479_, velocity.f_82480_, dv);
                EntityValue.updateVelocity(e, dv);
            });
            this.put("accelerate", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                e.m_5997_(NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble());
                EntityValue.updateVelocity(e, e.m_20184_().m_82553_());
            });
            this.put("custom_name", (e, v) -> {
                if (v.isNull()) {
                    e.m_20340_(false);
                    e.m_6593_(null);
                    return;
                }
                boolean showName = false;
                if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    showName = lv.getItems().get(1).getBoolean();
                    v = lv.getItems().get(0);
                }
                e.m_20340_(showName);
                e.m_6593_(FormattedTextValue.getTextByValue(v));
            });
            this.put("persistence", (e, v) -> {
                if (!(e instanceof Mob)) {
                    return;
                }
                Mob mob = (Mob)e;
                if (v == null) {
                    v = Value.TRUE;
                }
                Vanilla.Mob_setPersistence(mob, v.getBoolean());
            });
            this.put("dismount", (e, v) -> e.m_8127_());
            this.put("mount", (e, v) -> {
                if (v instanceof EntityValue) {
                    EntityValue ev = (EntityValue)v;
                    e.m_7998_(ev.getEntity(), true);
                }
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    sp.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket(e));
                }
            });
            this.put("unmountable", (e, v) -> Vanilla.Entity_setPermanentVehicle(e, v == null || v.getBoolean()));
            this.put("drop_passengers", (e, v) -> e.m_20153_());
            this.put("mount_passengers", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'mount_passengers' needs entities to ride");
                }
                if (v instanceof EntityValue) {
                    EntityValue ev = (EntityValue)v;
                    ev.getEntity().m_20329_(e);
                } else if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    for (Value element : lv.getItems()) {
                        if (!(element instanceof EntityValue)) continue;
                        EntityValue ev = (EntityValue)element;
                        ev.getEntity().m_20329_(e);
                    }
                }
            });
            this.put("tag", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'tag' requires parameters");
                }
                if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    for (Value element : lv.getItems()) {
                        e.m_20049_(element.getString());
                    }
                } else {
                    e.m_20049_(v.getString());
                }
            });
            this.put("clear_tag", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'clear_tag' requires parameters");
                }
                if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    for (Value element : lv.getItems()) {
                        e.m_20137_(element.getString());
                    }
                } else {
                    e.m_20137_(v.getString());
                }
            });
            this.put("breeding_age", (e, v) -> {
                if (e instanceof AgeableMob) {
                    AgeableMob am = (AgeableMob)e;
                    am.m_146762_((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("talk", (e, v) -> {
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    mob.m_8032_();
                }
            });
            this.put("home", (e, v) -> {
                BlockPos pos;
                if (!(e instanceof PathfinderMob)) {
                    return;
                }
                PathfinderMob ec = (PathfinderMob)e;
                if (v == null) {
                    throw new InternalExpressionException("'home' requires at least one position argument, and optional distance, or null to cancel");
                }
                if (v.isNull()) {
                    ec.m_21446_(BlockPos.f_121853_, -1);
                    Map<String, Goal> tasks = Vanilla.Mob_getTemporaryTasks((Mob)ec);
                    Vanilla.Mob_getAI((Mob)ec, false).m_25363_(tasks.get("home"));
                    tasks.remove("home");
                    return;
                }
                int distance = 16;
                if (v instanceof BlockValue) {
                    BlockValue bv = (BlockValue)v;
                    pos = bv.getPos();
                    if (pos == null) {
                        throw new InternalExpressionException("Block is not positioned in the world");
                    }
                } else if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    List<Value> list = lv.getItems();
                    Vector3Argument locator = Vector3Argument.findIn(list, 0, false, false);
                    pos = BlockPos.m_274561_((double)locator.vec.f_82479_, (double)locator.vec.f_82480_, (double)locator.vec.f_82481_);
                    if (list.size() > locator.offset) {
                        distance = (int)NumericValue.asNumber(list.get(locator.offset)).getLong();
                    }
                } else {
                    throw new InternalExpressionException("'home' requires at least one position argument, and optional distance");
                }
                ec.m_21446_(pos, distance);
                Map<String, Goal> tasks = Vanilla.Mob_getTemporaryTasks((Mob)ec);
                if (!tasks.containsKey("home")) {
                    MoveTowardsRestrictionGoal task = new MoveTowardsRestrictionGoal(ec, 1.0);
                    tasks.put("home", (Goal)task);
                    Vanilla.Mob_getAI((Mob)ec, false).m_25352_(10, (Goal)task);
                }
            });
            this.put("spawn_point", (e, a) -> {
                if (!(e instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer spe = (ServerPlayer)e;
                if (a == null) {
                    spe.m_9158_(null, null, 0.0f, false, false);
                } else if (a instanceof ListValue) {
                    ListValue lv = (ListValue)a;
                    List<Value> params = lv.getItems();
                    Vector3Argument blockLocator = Vector3Argument.findIn(params, 0, false, false);
                    BlockPos pos = BlockPos.m_274446_((Position)blockLocator.vec);
                    ResourceKey world = spe.m_20193_().m_46472_();
                    float angle = spe.m_6080_();
                    boolean forced = false;
                    if (params.size() > blockLocator.offset) {
                        Value worldValue = params.get(blockLocator.offset + 0);
                        world = ValueConversions.dimFromValue(worldValue, spe.m_20194_()).m_46472_();
                        if (params.size() > blockLocator.offset + 1) {
                            angle = NumericValue.asNumber(params.get(blockLocator.offset + 1), "angle").getFloat();
                            if (params.size() > blockLocator.offset + 2) {
                                forced = params.get(blockLocator.offset + 2).getBoolean();
                            }
                        }
                    }
                    spe.m_9158_(world, pos, angle, forced, false);
                } else if (a instanceof BlockValue) {
                    BlockValue bv = (BlockValue)a;
                    if (bv.getPos() == null || bv.getWorld() == null) {
                        throw new InternalExpressionException("block for spawn modification should be localised in the world");
                    }
                    spe.m_9158_(bv.getWorld().m_46472_(), bv.getPos(), e.m_146908_(), true, false);
                } else if (a.isNull()) {
                    spe.m_9158_(null, null, 0.0f, false, false);
                } else {
                    throw new InternalExpressionException("modifying player respawn point requires a block position, optional world, optional angle, and optional force");
                }
            });
            this.put("pickup_delay", (e, v) -> {
                if (e instanceof ItemEntity) {
                    ItemEntity ie = (ItemEntity)e;
                    ie.m_32010_((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("despawn_timer", (e, v) -> {
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    le.m_21310_((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("portal_cooldown", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'portal_cooldown' requires a value to set");
                }
                Vanilla.Entity_setPublicNetherPortalCooldown(e, NumericValue.asNumber(v).getInt());
            });
            this.put("portal_timer", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'portal_timer' requires a value to set");
                }
                Vanilla.Entity_setPortalTimer(e, NumericValue.asNumber(v).getInt());
            });
            this.put("ai", (e, v) -> {
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    mob.m_21557_(!v.getBoolean());
                }
            });
            this.put("no_clip", (e, v) -> {
                e.f_19794_ = v == null ? true : v.getBoolean();
            });
            this.put("effect", (e, v) -> {
                if (!(e instanceof LivingEntity)) {
                    return;
                }
                LivingEntity le = (LivingEntity)e;
                if (v == null) {
                    le.m_21219_();
                    return;
                }
                if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    List<Value> list = lv.getItems();
                    if (list.size() >= 1 && list.size() <= 6) {
                        String effectName = list.get(0).getString();
                        MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(InputValidator.identifierOf(effectName));
                        if (effect == null) {
                            throw new InternalExpressionException("Wrong effect name: " + effectName);
                        }
                        if (list.size() == 1) {
                            le.m_21195_(effect);
                            return;
                        }
                        int duration = (int)NumericValue.asNumber(list.get(1)).getLong();
                        if (duration <= 0) {
                            le.m_21195_(effect);
                            return;
                        }
                        int amplifier = 0;
                        if (list.size() > 2) {
                            amplifier = (int)NumericValue.asNumber(list.get(2)).getLong();
                        }
                        boolean showParticles = true;
                        if (list.size() > 3) {
                            showParticles = list.get(3).getBoolean();
                        }
                        boolean showIcon = true;
                        if (list.size() > 4) {
                            showIcon = list.get(4).getBoolean();
                        }
                        boolean ambient = false;
                        if (list.size() > 5) {
                            ambient = list.get(5).getBoolean();
                        }
                        le.m_7292_(new MobEffectInstance(effect, duration, amplifier, ambient, showParticles, showIcon));
                        return;
                    }
                } else {
                    String effectName = v.getString();
                    MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(InputValidator.identifierOf(effectName));
                    if (effect == null) {
                        throw new InternalExpressionException("Wrong effect name: " + effectName);
                    }
                    le.m_21195_(effect);
                    return;
                }
                throw new InternalExpressionException("'effect' needs either no arguments (clear) or effect name, duration, and optional amplifier, show particles, show icon and ambient");
            });
            this.put("gamemode", (e, v) -> {
                GameType toSet;
                if (!(e instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer sp = (ServerPlayer)e;
                GameType gameType = toSet = v instanceof NumericValue ? GameType.m_46393_((int)((NumericValue)v).getInt()) : GameType.m_46402_((String)v.getString().toLowerCase(Locale.ROOT), null);
                if (toSet != null) {
                    sp.m_143403_(toSet);
                }
            });
            this.put("jumping", (e, v) -> {
                if (!(e instanceof LivingEntity)) {
                    return;
                }
                LivingEntity le = (LivingEntity)e;
                le.m_6862_(v.getBoolean());
            });
            this.put("jump", (e, v) -> {
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    Vanilla.LivingEntity_setJumping(le);
                } else {
                    EntityTools.genericJump(e);
                }
            });
            this.put("swing", (e, v) -> {
                if (e instanceof LivingEntity) {
                    String handString;
                    LivingEntity le = (LivingEntity)e;
                    InteractionHand hand = InteractionHand.MAIN_HAND;
                    if (v != null && ((handString = v.getString().toLowerCase(Locale.ROOT)).equals("offhand") || handString.equals("off_hand"))) {
                        hand = InteractionHand.OFF_HAND;
                    }
                    le.m_21011_(hand, true);
                }
            });
            this.put("silent", (e, v) -> e.m_20225_(v.getBoolean()));
            this.put("gravity", (e, v) -> e.m_20242_(!v.getBoolean()));
            this.put("invulnerable", (e, v) -> {
                boolean invulnerable = v.getBoolean();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.m_150110_().f_35934_ = invulnerable;
                    player.m_6885_();
                } else {
                    e.m_20331_(invulnerable);
                }
            });
            this.put("fire", (e, v) -> e.m_7311_((int)NumericValue.asNumber(v).getLong()));
            this.put("frost", (e, v) -> e.m_146917_((int)NumericValue.asNumber(v).getLong()));
            this.put("hunger", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.m_36324_().m_38705_((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("exhaustion", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.m_36324_().m_150378_(NumericValue.asNumber(v).getFloat());
                }
            });
            this.put("add_exhaustion", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.m_36324_().m_38703_(NumericValue.asNumber(v).getFloat());
                }
            });
            this.put("absorption", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.m_7911_(NumericValue.asNumber(v, "absorbtion").getFloat());
                }
            });
            this.put("add_xp", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.m_6756_(NumericValue.asNumber(v, "add_xp").getInt());
                }
            });
            this.put("xp_level", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.m_6749_(NumericValue.asNumber(v, "xp_level").getInt() - p.f_36078_);
                }
            });
            this.put("xp_progress", (e, v) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer p = (ServerPlayer)e;
                    p.f_36080_ = NumericValue.asNumber(v, "xp_progress").getFloat();
                    p.f_8906_.m_9829_((Packet)new ClientboundSetExperiencePacket(p.f_36080_, p.f_36079_, p.f_36078_));
                }
            });
            this.put("xp_score", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.m_36397_(NumericValue.asNumber(v, "xp_score").getInt());
                }
            });
            this.put("saturation", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.m_36324_().m_38717_(NumericValue.asNumber(v, "saturation").getFloat());
                }
            });
            this.put("air", (e, v) -> e.m_20301_(NumericValue.asNumber(v, "air").getInt()));
            this.put("breaking_progress", (e, a) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    int progress = a == null || a.isNull() ? -1 : NumericValue.asNumber(a).getInt();
                    Vanilla.ServerPlayerGameMode_setBlockBreakingProgress(sp.f_8941_, progress);
                }
            });
            this.put("nbt", (e, v) -> {
                if (!(e instanceof Player)) {
                    UUID uUID = e.m_20148_();
                    Value tagValue = NBTSerializableValue.fromValue(v);
                    if (tagValue instanceof NBTSerializableValue) {
                        NBTSerializableValue nbtsv = (NBTSerializableValue)tagValue;
                        e.m_20258_(nbtsv.getCompoundTag());
                        e.m_20084_(uUID);
                    }
                }
            });
            this.put("nbt_merge", (e, v) -> {
                if (!(e instanceof Player)) {
                    UUID uUID = e.m_20148_();
                    Value tagValue = NBTSerializableValue.fromValue(v);
                    if (tagValue instanceof NBTSerializableValue) {
                        NBTSerializableValue nbtsv = (NBTSerializableValue)tagValue;
                        CompoundTag nbttagcompound = e.m_20240_(new CompoundTag());
                        nbttagcompound.m_128391_(nbtsv.getCompoundTag());
                        e.m_20258_(nbttagcompound);
                        e.m_20084_(uUID);
                    }
                }
            });
            this.put("blue_skull", (e, v) -> {
                if (e instanceof WitherSkull) {
                    WitherSkull w = (WitherSkull)e;
                    w.m_37629_(v.getBoolean());
                }
            });
            this.put("offering_flower", (e, v) -> {
                if (e instanceof IronGolem) {
                    IronGolem ig = (IronGolem)e;
                    ig.m_28885_(v.getBoolean());
                }
            });
            this.put("item", (e, v) -> {
                ItemStack item = ValueConversions.getItemStackFromValue(v, true, e.m_9236_().m_9598_());
                if (e instanceof ItemEntity) {
                    ItemEntity itementity = (ItemEntity)e;
                    itementity.m_32045_(item);
                }
                if (e instanceof ItemFrame) {
                    ItemFrame itemframe = (ItemFrame)e;
                    itemframe.m_31805_(item);
                }
            });
        }
    };

    public EntityValue(Entity e) {
        this.entity = e;
    }

    public static Value of(@Nullable Entity e) {
        return e == null ? Value.NULL : new EntityValue(e);
    }

    public static Collection<? extends Entity> getEntitiesFromSelector(CommandSourceStack source, String selector) {
        try {
            net.minecraft.commands.arguments.selector.EntitySelector entitySelector = selectorCache.get(selector);
            if (entitySelector != null) {
                return entitySelector.m_121160_(source.m_81358_(4));
            }
            entitySelector = new EntitySelectorParser(new StringReader(selector), true).m_121377_();
            selectorCache.put(selector, entitySelector);
            return entitySelector.m_121160_(source.m_81358_(4));
        }
        catch (CommandSyntaxException e) {
            throw new InternalExpressionException("Cannot select entities from " + selector);
        }
    }

    public Entity getEntity() {
        ServerPlayer newPlayer;
        ServerPlayer serverPlayer;
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer && Vanilla.ServerPlayer_isInvalidEntityObject(serverPlayer = (ServerPlayer)entity) && (newPlayer = this.entity.m_20194_().m_6846_().m_11259_(this.entity.m_20148_())) != null) {
            this.entity = newPlayer;
        }
        return this.entity;
    }

    public static ServerPlayer getPlayerByValue(MinecraftServer server, Value value) {
        EntityValue ev;
        Entity entity;
        if (value instanceof EntityValue && (entity = (ev = (EntityValue)value).getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            return sp;
        }
        if (value.isNull()) {
            return null;
        }
        String playerName = value.getString();
        return server.m_6846_().m_11255_(playerName);
    }

    public static String getPlayerNameByValue(Value value) {
        EntityValue ev;
        Entity entity;
        if (value instanceof EntityValue && (entity = (ev = (EntityValue)value).getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            return sp.m_6302_();
        }
        if (value.isNull()) {
            return null;
        }
        return value.getString();
    }

    @Override
    public String getString() {
        return this.getEntity().m_7755_().getString();
    }

    @Override
    public boolean getBoolean() {
        return true;
    }

    @Override
    public boolean equals(Object v) {
        if (v instanceof EntityValue) {
            EntityValue ev = (EntityValue)v;
            return this.getEntity().m_19879_() == ev.getEntity().m_19879_();
        }
        return super.equals(v);
    }

    @Override
    public Value in(Value v) {
        if (v instanceof ListValue) {
            ListValue lv = (ListValue)v;
            List<Value> values = lv.getItems();
            String what = values.get(0).getString();
            Value arg = null;
            if (values.size() == 2) {
                arg = values.get(1);
            } else if (values.size() > 2) {
                arg = ListValue.wrap(values.subList(1, values.size()));
            }
            return this.get(what, arg);
        }
        String what = v.getString();
        return this.get(what, null);
    }

    @Override
    public String getTypeString() {
        return "entity";
    }

    @Override
    public int hashCode() {
        return this.getEntity().hashCode();
    }

    public static EntityClassDescriptor getEntityDescriptor(String who, MinecraftServer server) {
        EntityClassDescriptor eDesc = EntityClassDescriptor.byName.get(who);
        if (eDesc == null) {
            boolean positive = true;
            if (who.startsWith("!")) {
                positive = false;
                who = who.substring(1);
            }
            String booWho = who;
            HolderSet.Named eTagValue = (HolderSet.Named)server.m_206579_().m_175515_(Registries.f_256939_).m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)InputValidator.identifierOf(who))).orElseThrow(() -> new InternalExpressionException(booWho + " is not a valid entity descriptor"));
            Set eTag = eTagValue.m_203614_().map(Holder::m_203334_).collect(Collectors.toUnmodifiableSet());
            if (positive) {
                if (eTag.size() == 1) {
                    EntityType type = (EntityType)eTag.iterator().next();
                    return new EntityClassDescriptor((EntityTypeTest<Entity, ?>)type, (Predicate<? super Entity>)((Predicate<Entity>)Entity::m_6084_), eTag.stream());
                }
                return new EntityClassDescriptor(ANY, e -> eTag.contains(e.m_6095_()) && e.m_6084_(), eTag.stream());
            }
            return new EntityClassDescriptor(ANY, e -> !eTag.contains(e.m_6095_()) && e.m_6084_(), server.m_206579_().m_175515_(Registries.f_256939_).m_123024_().filter(et -> !eTag.contains(et)));
        }
        return eDesc;
    }

    public Value get(String what, @Nullable Value arg) {
        if (!featureAccessors.containsKey(what)) {
            throw new InternalExpressionException("Unknown entity feature: " + what);
        }
        try {
            return featureAccessors.get(what).apply(this.getEntity(), arg);
        }
        catch (NullPointerException npe) {
            throw new InternalExpressionException("Cannot fetch '" + what + "' with these arguments");
        }
    }

    public void set(String what, @Nullable Value toWhat) {
        if (!featureModifiers.containsKey(what)) {
            throw new InternalExpressionException("Unknown entity action: " + what);
        }
        try {
            featureModifiers.get(what).accept(this.getEntity(), toWhat);
        }
        catch (NullPointerException npe) {
            throw new InternalExpressionException("'modify' for '" + what + "' expects a value");
        }
        catch (IndexOutOfBoundsException ind) {
            throw new InternalExpressionException("Wrong number of arguments for `modify` option: " + what);
        }
    }

    private static void updatePosition(Entity e, double x, double y, double z, float yaw, float pitch) {
        if (!Double.isFinite(x) || Double.isNaN(x) || !Double.isFinite(y) || Double.isNaN(y) || !Double.isFinite(z) || Double.isNaN(z) || !Float.isFinite(yaw) || Float.isNaN(yaw) || !Float.isFinite(pitch) || Float.isNaN(pitch)) {
            return;
        }
        if (e instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)e;
            EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
            set.add(RelativeMovement.X_ROT);
            set.add(RelativeMovement.Y_ROT);
            sp.f_8906_.m_9780_(x, y, z, yaw, pitch, set);
        } else {
            e.m_7678_(x, y, z, yaw, pitch);
            if (e instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)e;
                le.f_20884_ = le.f_19859_ = yaw;
                le.f_20886_ = le.f_20885_ = yaw;
            } else {
                ((ServerLevel)e.m_20193_()).m_7726_().m_8394_(e, (Packet)new ClientboundTeleportEntityPacket(e));
            }
        }
    }

    private static void updateVelocity(Entity e, double scale) {
        e.f_19864_ = true;
        if (Math.abs(scale) > 10000.0) {
            CarpetScriptServer.LOG.warn("Moved entity " + e.m_6302_() + " " + String.valueOf(e.m_7755_()) + " at " + String.valueOf(e.m_20182_()) + " extremely fast: " + String.valueOf(e.m_20184_()));
        }
    }

    public void setEvent(CarpetContext cc, String eventName, FunctionValue fun, List<Value> args) {
        EntityEventsGroup.Event event = EntityEventsGroup.Event.byName.get(eventName);
        if (event == null) {
            throw new InternalExpressionException("Unknown entity event: " + eventName);
        }
        Vanilla.Entity_getEventContainer(this.getEntity()).addEvent(event, cc.host, fun, args);
    }

    @Override
    public Tag toTag(boolean force) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Data", (Tag)this.getEntity().m_20240_(new CompoundTag()));
        Registry reg = this.getEntity().m_9236_().m_9598_().m_175515_(Registries.f_256939_);
        tag.m_128365_("Name", (Tag)StringTag.m_129297_((String)reg.m_7981_((Object)this.getEntity().m_6095_()).toString()));
        return tag;
    }

    public static class EntityClassDescriptor {
        public final EntityTypeTest<Entity, ? extends Entity> directType;
        public final Predicate<? super Entity> filteringPredicate;
        public final List<EntityType<? extends Entity>> types;
        public static final Map<String, EntityClassDescriptor> byName = new HashMap<String, EntityClassDescriptor>(){
            {
                List<EntityType<?>> allTypes = BuiltInRegistries.f_256780_.m_123024_().toList();
                Set<EntityType> projectiles = Set.of(EntityType.f_20548_, EntityType.f_20561_, EntityType.f_20451_, EntityType.f_20463_, EntityType.f_20467_, EntityType.f_20527_, EntityType.f_20477_, EntityType.f_20478_, EntityType.f_20483_, EntityType.f_20484_, EntityType.f_20485_, EntityType.f_20486_, EntityType.f_20487_, EntityType.f_20498_, EntityType.f_20533_, EntityType.f_20522_);
                Set<EntityType> deads = Set.of(EntityType.f_20476_, EntityType.f_147036_, EntityType.f_20552_, EntityType.f_20564_, EntityType.f_20569_, EntityType.f_20570_, EntityType.f_20571_, EntityType.f_20450_, EntityType.f_20461_, EntityType.f_20462_, EntityType.f_147033_, EntityType.f_20464_, EntityType.f_20465_, EntityType.f_20506_, EntityType.f_20515_, EntityType.f_20529_, EntityType.f_217016_);
                Set<EntityType> minecarts = Set.of(EntityType.f_20469_, EntityType.f_20470_, EntityType.f_20471_, EntityType.f_20472_, EntityType.f_20473_, EntityType.f_20474_, EntityType.f_20475_);
                Set<EntityType> undeads = Set.of(EntityType.f_20481_, EntityType.f_20524_, EntityType.f_20497_, EntityType.f_20501_, EntityType.f_20562_, EntityType.f_20530_, EntityType.f_20502_, EntityType.f_20525_, EntityType.f_20509_, EntityType.f_20496_, EntityType.f_20500_, EntityType.f_20458_, EntityType.f_20531_);
                Set<EntityType> arthropods = Set.of(EntityType.f_20550_, EntityType.f_20567_, EntityType.f_20523_, EntityType.f_20479_, EntityType.f_20554_);
                Set<EntityType> aquatique = Set.of(EntityType.f_20455_, EntityType.f_20490_, EntityType.f_20556_, EntityType.f_20559_, EntityType.f_20516_, EntityType.f_20519_, EntityType.f_20480_, EntityType.f_20489_);
                Set<EntityType> illagers = Set.of(EntityType.f_20513_, EntityType.f_20459_, EntityType.f_20493_, EntityType.f_20568_, EntityType.f_20518_, EntityType.f_20495_);
                Set living = allTypes.stream().filter(et -> !deads.contains(et) && !projectiles.contains(et) && !minecarts.contains(et)).collect(Collectors.toSet());
                Set regular = allTypes.stream().filter(et -> living.contains(et) && !undeads.contains(et) && !arthropods.contains(et) && !aquatique.contains(et) && !illagers.contains(et)).collect(Collectors.toSet());
                this.put("*", new EntityClassDescriptor(ANY, e -> true, allTypes));
                this.put("valid", new EntityClassDescriptor(ANY, (Predicate<? super Entity>)EntitySelector.f_20402_, allTypes));
                this.put("!valid", new EntityClassDescriptor(ANY, e -> !e.m_6084_(), allTypes));
                this.put("living", new EntityClassDescriptor(EntityTypeTest.m_156916_(LivingEntity.class), (Predicate<? super Entity>)EntitySelector.f_20402_, allTypes.stream().filter(living::contains)));
                this.put("!living", new EntityClassDescriptor(ANY, e -> !(e instanceof LivingEntity) && e.m_6084_(), allTypes.stream().filter(et -> !living.contains(et))));
                this.put("projectile", new EntityClassDescriptor(EntityTypeTest.m_156916_(Projectile.class), (Predicate<? super Entity>)EntitySelector.f_20402_, allTypes.stream().filter(projectiles::contains)));
                this.put("!projectile", new EntityClassDescriptor(ANY, e -> !(e instanceof Projectile) && e.m_6084_(), allTypes.stream().filter(et -> !projectiles.contains(et) && !living.contains(et))));
                this.put("minecarts", new EntityClassDescriptor(EntityTypeTest.m_156916_(AbstractMinecart.class), (Predicate<? super Entity>)EntitySelector.f_20402_, allTypes.stream().filter(minecarts::contains)));
                this.put("!minecarts", new EntityClassDescriptor(ANY, e -> !(e instanceof AbstractMinecart) && e.m_6084_(), allTypes.stream().filter(et -> !minecarts.contains(et) && !living.contains(et))));
                this.put("arthropod", new EntityClassDescriptor(EntityTypeTest.m_156916_(LivingEntity.class), e -> ((LivingEntity)e).m_6336_() == MobType.f_21642_ && e.m_6084_(), allTypes.stream().filter(arthropods::contains)));
                this.put("!arthropod", new EntityClassDescriptor(EntityTypeTest.m_156916_(LivingEntity.class), e -> ((LivingEntity)e).m_6336_() != MobType.f_21642_ && e.m_6084_(), allTypes.stream().filter(et -> !arthropods.contains(et) && living.contains(et))));
                this.put("undead", new EntityClassDescriptor(EntityTypeTest.m_156916_(LivingEntity.class), e -> ((LivingEntity)e).m_6336_() == MobType.f_21641_ && e.m_6084_(), allTypes.stream().filter(undeads::contains)));
                this.put("!undead", new EntityClassDescriptor(EntityTypeTest.m_156916_(LivingEntity.class), e -> ((LivingEntity)e).m_6336_() != MobType.f_21641_ && e.m_6084_(), allTypes.stream().filter(et -> !undeads.contains(et) && living.contains(et))));
                this.put("aquatic", new EntityClassDescriptor(EntityTypeTest.m_156916_(LivingEntity.class), e -> ((LivingEntity)e).m_6336_() == MobType.f_21644_ && e.m_6084_(), allTypes.stream().filter(aquatique::contains)));
                this.put("!aquatic", new EntityClassDescriptor(EntityTypeTest.m_156916_(LivingEntity.class), e -> ((LivingEntity)e).m_6336_() != MobType.f_21644_ && e.m_6084_(), allTypes.stream().filter(et -> !aquatique.contains(et) && living.contains(et))));
                this.put("illager", new EntityClassDescriptor(EntityTypeTest.m_156916_(LivingEntity.class), e -> ((LivingEntity)e).m_6336_() == MobType.f_21643_ && e.m_6084_(), allTypes.stream().filter(illagers::contains)));
                this.put("!illager", new EntityClassDescriptor(EntityTypeTest.m_156916_(LivingEntity.class), e -> ((LivingEntity)e).m_6336_() != MobType.f_21643_ && e.m_6084_(), allTypes.stream().filter(et -> !illagers.contains(et) && living.contains(et))));
                this.put("regular", new EntityClassDescriptor(EntityTypeTest.m_156916_(LivingEntity.class), e -> ((LivingEntity)e).m_6336_() == MobType.f_21640_ && e.m_6084_(), allTypes.stream().filter(regular::contains)));
                this.put("!regular", new EntityClassDescriptor(EntityTypeTest.m_156916_(LivingEntity.class), e -> ((LivingEntity)e).m_6336_() != MobType.f_21640_ && e.m_6084_(), allTypes.stream().filter(et -> !regular.contains(et) && living.contains(et))));
                for (ResourceLocation typeId : BuiltInRegistries.f_256780_.m_6566_()) {
                    EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(typeId);
                    String mobType = ValueConversions.simplify(typeId);
                    this.put(mobType, new EntityClassDescriptor((EntityTypeTest<Entity, ?>)type, (Predicate<? super Entity>)EntitySelector.f_20402_, Stream.of(type)));
                    this.put("!" + mobType, new EntityClassDescriptor(ANY, e -> e.m_6095_() != type && e.m_6084_(), allTypes.stream().filter(et -> et != type)));
                }
                for (MobCategory catId : MobCategory.values()) {
                    String catStr = catId.m_21607_();
                    this.put(catStr, new EntityClassDescriptor(ANY, e -> e.m_6095_().m_20674_() == catId && e.m_6084_(), allTypes.stream().filter(et -> et.m_20674_() == catId)));
                    this.put("!" + catStr, new EntityClassDescriptor(ANY, e -> e.m_6095_().m_20674_() != catId && e.m_6084_(), allTypes.stream().filter(et -> et.m_20674_() != catId)));
                }
            }
        };

        EntityClassDescriptor(EntityTypeTest<Entity, ?> type, Predicate<? super Entity> predicate, List<EntityType<?>> types) {
            this.directType = type;
            this.filteringPredicate = predicate;
            this.types = types;
        }

        EntityClassDescriptor(EntityTypeTest<Entity, ?> type, Predicate<? super Entity> predicate, Stream<EntityType<?>> types) {
            this(type, predicate, types.toList());
        }

        public Value listValue(RegistryAccess regs) {
            Registry entityRegs = regs.m_175515_(Registries.f_256939_);
            return ListValue.wrap(this.types.stream().map(et -> NBTSerializableValue.nameFromRegistryId(entityRegs.m_7981_(et))));
        }
    }
}

