/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.value.NBTSerializableValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.google.gson.JsonElement;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FormattedTextValue
extends StringValue {
    Component text;

    public FormattedTextValue(Component text) {
        super(null);
        this.text = text;
    }

    public static Value combine(Value left, Value right) {
        MutableComponent text;
        FormattedTextValue ftv;
        if (left instanceof FormattedTextValue) {
            ftv = (FormattedTextValue)left;
            text = ftv.getText().m_6881_();
        } else {
            if (left.isNull()) {
                return right;
            }
            text = Component.m_237113_((String)left.getString());
        }
        if (right instanceof FormattedTextValue) {
            ftv = (FormattedTextValue)right;
            text.m_7220_((Component)ftv.getText().m_6881_());
            return new FormattedTextValue((Component)text);
        }
        if (right.isNull()) {
            return left;
        }
        text.m_130946_(right.getString());
        return new FormattedTextValue((Component)text);
    }

    public static Value of(Component text) {
        return text == null ? Value.NULL : new FormattedTextValue(text);
    }

    @Override
    public String getString() {
        return this.text.getString();
    }

    @Override
    public boolean getBoolean() {
        return !this.text.getString().isEmpty();
    }

    @Override
    public Value clone() {
        return new FormattedTextValue(this.text);
    }

    @Override
    public String getTypeString() {
        return "text";
    }

    public Component getText() {
        return this.text;
    }

    @Override
    public Tag toTag(boolean force) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        return StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)this.text));
    }

    @Override
    public JsonElement toJson() {
        return Component.Serializer.m_130716_((Component)this.text);
    }

    @Override
    public Value add(Value o) {
        return FormattedTextValue.combine(this, o);
    }

    public String serialize() {
        return Component.Serializer.m_130703_((Component)this.text);
    }

    public static FormattedTextValue deserialize(String serialized) {
        return new FormattedTextValue((Component)Component.Serializer.m_130701_((String)serialized));
    }

    public static Component getTextByValue(Value value) {
        MutableComponent mutableComponent;
        if (value instanceof FormattedTextValue) {
            FormattedTextValue ftv = (FormattedTextValue)value;
            mutableComponent = ftv.getText();
        } else {
            mutableComponent = Component.m_237113_((String)value.getString());
        }
        return mutableComponent;
    }
}

