/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.utils.Messenger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class DistanceCalculator {
    public static final HashMap<String, Vec3> START_POINT_STORAGE = new HashMap();

    public static boolean hasStartingPoint(CommandSourceStack source) {
        return START_POINT_STORAGE.containsKey(source.m_81368_());
    }

    public static List<Component> findDistanceBetweenTwoPoints(Vec3 pos1, Vec3 pos2) {
        double dx = Mth.m_14154_((float)((float)pos1.f_82479_ - (float)pos2.f_82479_));
        double dy = Mth.m_14154_((float)((float)pos1.f_82480_ - (float)pos2.f_82480_));
        double dz = Mth.m_14154_((float)((float)pos1.f_82481_ - (float)pos2.f_82481_));
        double manhattan = dx + dy + dz;
        double spherical = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double cylindrical = Math.sqrt(dx * dx + dz * dz);
        ArrayList<Component> res = new ArrayList<Component>();
        res.add(Messenger.c("w Distance between ", Messenger.tp("c", pos1), "w  and ", Messenger.tp("c", pos2), "w :"));
        res.add(Messenger.c("w  - Spherical: ", String.format("wb %.2f", spherical)));
        res.add(Messenger.c("w  - Cylindrical: ", String.format("wb %.2f", cylindrical)));
        res.add(Messenger.c("w  - Manhattan: ", String.format("wb %.1f", manhattan)));
        return res;
    }

    public static int distance(CommandSourceStack source, Vec3 pos1, Vec3 pos2) {
        Messenger.send(source, DistanceCalculator.findDistanceBetweenTwoPoints(pos1, pos2));
        return 1;
    }

    public static int setStart(CommandSourceStack source, Vec3 pos) {
        START_POINT_STORAGE.put(source.m_81368_(), pos);
        Messenger.m(source, "gi Initial point set to: ", Messenger.tp("g", pos));
        return 1;
    }

    public static int setEnd(CommandSourceStack source, Vec3 pos) {
        if (!DistanceCalculator.hasStartingPoint(source)) {
            START_POINT_STORAGE.put(source.m_81368_(), pos);
            Messenger.m(source, "gi There was no initial point for " + source.m_81368_());
            Messenger.m(source, "gi Initial point set to: ", Messenger.tp("g", pos));
            return 0;
        }
        Messenger.send(source, DistanceCalculator.findDistanceBetweenTwoPoints(START_POINT_STORAGE.get(source.m_81368_()), pos));
        return 1;
    }
}

