/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.utils.BlockInfo;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;

public class InfoCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"info").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandInfo))).then(Commands.m_82127_((String)"block").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"block position", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> InfoCommand.infoBlock((CommandSourceStack)c.getSource(), BlockPosArgument.m_174395_((CommandContext)c, (String)"block position"), null))).then(Commands.m_82127_((String)"grep").then(Commands.m_82129_((String)"regexp", (ArgumentType)StringArgumentType.greedyString()).executes(c -> InfoCommand.infoBlock((CommandSourceStack)c.getSource(), BlockPosArgument.m_174395_((CommandContext)c, (String)"block position"), StringArgumentType.getString((CommandContext)c, (String)"regexp")))))));
        dispatcher.register(command);
    }

    public static void printBlock(List<Component> messages, CommandSourceStack source, String grep) {
        Messenger.m(source, "");
        if (grep != null) {
            Pattern p = Pattern.compile(grep);
            Messenger.m(source, messages.get(0));
            for (int i = 1; i < messages.size(); ++i) {
                Component line = messages.get(i);
                Matcher m = p.matcher(line.getString());
                if (!m.find()) continue;
                Messenger.m(source, line);
            }
        } else {
            Messenger.send(source, messages);
        }
    }

    private static int infoBlock(CommandSourceStack source, BlockPos pos, String grep) {
        if (!source.m_6761_(2)) {
            if (!source.m_81372_().m_46805_(pos)) {
                Messenger.m(source, "r Chunk is not loaded");
                return 0;
            }
            if (!source.m_81372_().m_46739_(pos)) {
                Messenger.m(source, "r Position is outside of world bounds");
                return 0;
            }
        }
        InfoCommand.printBlock(BlockInfo.blockInfo(pos, source.m_81372_()), source, grep);
        return 1;
    }
}

