/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.CarpetServer;
import carpet.fakes.IngredientInterface;
import carpet.fakes.RecipeManagerInterface;
import carpet.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;

public class HopperCounter {
    private static final Map<DyeColor, HopperCounter> COUNTERS;
    public static final TextColor WHITE;
    public final DyeColor color;
    private final String coloredName;
    private final Object2LongMap<Item> counter = new Object2LongLinkedOpenHashMap();
    private long startTick = -1L;
    private long startMillis;
    private static final Map<Item, Block> DEFAULTS;

    private HopperCounter(DyeColor color) {
        this.color = color;
        Object hexColor = Integer.toHexString(color.m_41071_());
        if (((String)hexColor).length() < 6) {
            hexColor = "0".repeat(6 - ((String)hexColor).length()) + (String)hexColor;
        }
        this.coloredName = "#" + (String)hexColor + " " + color.m_41065_();
    }

    public void add(MinecraftServer server, ItemStack stack) {
        if (this.startTick < 0L) {
            this.startTick = server.m_129783_().m_46467_();
            this.startMillis = System.currentTimeMillis();
        }
        Item item = stack.m_41720_();
        this.counter.put((Object)item, this.counter.getLong((Object)item) + (long)stack.m_41613_());
    }

    public void reset(MinecraftServer server) {
        this.counter.clear();
        this.startTick = server.m_129783_().m_46467_();
        this.startMillis = System.currentTimeMillis();
    }

    public static void resetAll(MinecraftServer server, boolean fresh) {
        for (HopperCounter counter : COUNTERS.values()) {
            counter.reset(server);
            if (!fresh) continue;
            counter.startTick = -1L;
        }
    }

    public static List<Component> formatAll(MinecraftServer server, boolean realtime) {
        ArrayList<Component> text = new ArrayList<Component>();
        for (HopperCounter counter : COUNTERS.values()) {
            List<Component> temp = counter.format(server, realtime, false);
            if (temp.size() <= 1) continue;
            if (!text.isEmpty()) {
                text.add(Messenger.s(""));
            }
            text.addAll(temp);
        }
        if (text.isEmpty()) {
            text.add(Messenger.s("No items have been counted yet."));
        }
        return text;
    }

    public List<Component> format(MinecraftServer server, boolean realTime, boolean brief) {
        long ticks = Math.max(realTime ? (System.currentTimeMillis() - this.startMillis) / 50L : server.m_129783_().m_46467_() - this.startTick, 1L);
        if (this.startTick < 0L || ticks == 0L) {
            if (brief) {
                return Collections.singletonList(Messenger.c("b" + this.coloredName, "w : ", "gi -, -/h, - min "));
            }
            return Collections.singletonList(Messenger.c(this.coloredName, "w  hasn't started counting yet"));
        }
        long total = this.getTotalItems();
        if (total == 0L) {
            if (brief) {
                return Collections.singletonList(Messenger.c("b" + this.coloredName, "w : ", "wb 0", "w , ", "wb 0", "w /h, ", String.format("wb %.1f ", (double)ticks / 1200.0), "w min"));
            }
            return Collections.singletonList(Messenger.c("w No items for ", this.coloredName, String.format("w  yet (%.2f min.%s)", (double)ticks / 1200.0, realTime ? " - real time" : ""), "nb  [X]", "^g reset", "!/counter " + this.color.m_41065_() + " reset"));
        }
        if (brief) {
            return Collections.singletonList(Messenger.c("b" + this.coloredName, "w : ", "wb " + total, "w , ", "wb " + total * 72000L / ticks, "w /h, ", String.format("wb %.1f ", (double)ticks / 1200.0), "w min"));
        }
        ArrayList<Component> items = new ArrayList<Component>();
        items.add(Messenger.c("w Items for ", this.coloredName, "w  (", String.format("wb %.2f", (double)ticks * 1.0 / 1200.0), "w  min" + (realTime ? " - real time" : "") + "), ", "w total: ", "wb " + total, "w , (", String.format("wb %.1f", (double)total * 1.0 * 72000.0 / (double)ticks), "w /h):", "nb [X]", "^g reset", "!/counter " + String.valueOf(this.color) + " reset"));
        items.addAll(this.counter.object2LongEntrySet().stream().sorted((e, f) -> Long.compare(f.getLongValue(), e.getLongValue())).map(e -> {
            Item item = (Item)e.getKey();
            MutableComponent itemName = Component.m_237115_((String)item.m_5524_());
            Style itemStyle = itemName.m_7383_();
            TextColor color = HopperCounter.guessColor(item, (RegistryAccess)server.m_206579_());
            itemName.m_6270_(color != null ? itemStyle.m_131148_(color) : itemStyle.m_131155_(Boolean.valueOf(true)));
            long count = e.getLongValue();
            return Messenger.c("g - ", itemName, "g : ", "wb " + count, "g , ", String.format("wb %.1f", (double)count * 72000.0 / (double)ticks), "w /h");
        }).collect(Collectors.toList()));
        return items;
    }

    public static int appropriateColor(int color) {
        if (color == 0) {
            return MapColor.f_283811_.f_283871_;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        if (r < 70) {
            r = 70;
        }
        if (g < 70) {
            g = 70;
        }
        if (b < 70) {
            b = 70;
        }
        return (r << 16) + (g << 8) + b;
    }

    public static TextColor fromItem(Item item, RegistryAccess registryAccess) {
        if (DEFAULTS.containsKey(item)) {
            return TextColor.m_131266_((int)HopperCounter.appropriateColor(HopperCounter.DEFAULTS.get((Object)item).m_284356_().f_283871_));
        }
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            return TextColor.m_131266_((int)HopperCounter.appropriateColor(dye.m_41089_().m_284406_().f_283871_));
        }
        Block block = null;
        Registry itemRegistry = registryAccess.m_175515_(Registries.f_256913_);
        Registry blockRegistry = registryAccess.m_175515_(Registries.f_256747_);
        ResourceLocation id = itemRegistry.m_7981_((Object)item);
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            block = blockItem.m_40614_();
        } else if (blockRegistry.m_6612_(id).isPresent()) {
            block = (Block)blockRegistry.m_7745_(id);
        }
        if (block != null) {
            if (block instanceof AbstractBannerBlock) {
                return TextColor.m_131266_((int)HopperCounter.appropriateColor(((AbstractBannerBlock)block).m_48674_().m_284406_().f_283871_));
            }
            if (block instanceof BeaconBeamBlock) {
                return TextColor.m_131266_((int)HopperCounter.appropriateColor(((BeaconBeamBlock)block).m_7988_().m_284406_().f_283871_));
            }
            return TextColor.m_131266_((int)HopperCounter.appropriateColor(block.m_284356_().f_283871_));
        }
        return null;
    }

    public static TextColor guessColor(Item item, RegistryAccess registryAccess) {
        TextColor direct = HopperCounter.fromItem(item, registryAccess);
        if (direct != null) {
            return direct;
        }
        if (CarpetServer.minecraft_server == null) {
            return WHITE;
        }
        ResourceLocation id = registryAccess.m_175515_(Registries.f_256913_).m_7981_((Object)item);
        for (RecipeType type : registryAccess.m_175515_(Registries.f_256954_)) {
            for (Recipe<?> r : ((RecipeManagerInterface)CarpetServer.minecraft_server.m_129894_()).getAllMatching(type, id, registryAccess)) {
                for (Ingredient ingredient : r.m_7527_()) {
                    for (Collection<ItemStack> stacks : ((IngredientInterface)ingredient).getRecipeStacks()) {
                        for (ItemStack iStak : stacks) {
                            TextColor cand = HopperCounter.fromItem(iStak.m_41720_(), registryAccess);
                            if (cand == null) continue;
                            return cand;
                        }
                    }
                }
            }
        }
        return null;
    }

    public static HopperCounter getCounter(DyeColor color) {
        return COUNTERS.get(color);
    }

    public static HopperCounter getCounter(String color) {
        try {
            DyeColor colorEnum = DyeColor.valueOf((String)color.toUpperCase(Locale.ROOT));
            return COUNTERS.get(colorEnum);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public long getTotalItems() {
        return this.counter.isEmpty() ? 0L : this.counter.values().longStream().sum();
    }

    static {
        WHITE = TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE);
        EnumMap<DyeColor, HopperCounter> counterMap = new EnumMap<DyeColor, HopperCounter>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            counterMap.put(color, new HopperCounter(color));
        }
        COUNTERS = Collections.unmodifiableMap(counterMap);
        DEFAULTS = Map.ofEntries(Map.entry(Items.f_41939_, Blocks.f_50098_), Map.entry(Items.f_41940_, Blocks.f_50108_), Map.entry(Items.f_41941_, Blocks.f_50097_), Map.entry(Items.f_41942_, Blocks.f_50096_), Map.entry(Items.f_41943_, Blocks.f_50127_), Map.entry(Items.f_41944_, Blocks.f_50108_), Map.entry(Items.f_41945_, Blocks.f_50042_), Map.entry(Items.f_41946_, Blocks.f_50127_), Map.entry(Items.f_41947_, Blocks.f_50100_), Map.entry(Items.f_41948_, Blocks.f_50127_), Map.entry(Items.f_41949_, Blocks.f_50105_), Map.entry(Items.f_41951_, Blocks.f_50109_), Map.entry(Items.f_41950_, Blocks.f_50041_), Map.entry(Items.f_41952_, Blocks.f_50180_), Map.entry(Items.f_41953_, Blocks.f_50181_), Map.entry(Items.f_42398_, Blocks.f_50705_), Map.entry(Items.f_42417_, Blocks.f_50074_), Map.entry(Items.f_42416_, Blocks.f_50075_), Map.entry(Items.f_42415_, Blocks.f_50090_), Map.entry(Items.f_42418_, Blocks.f_50721_), Map.entry(Items.f_42206_, Blocks.f_50098_), Map.entry(Items.f_42207_, Blocks.f_50096_), Map.entry(Items.f_42208_, Blocks.f_50108_), Map.entry(Items.f_42209_, Blocks.f_50100_), Map.entry(Items.f_42619_, Blocks.f_50042_), Map.entry(Items.f_42410_, Blocks.f_50108_), Map.entry(Items.f_42405_, Blocks.f_50335_), Map.entry(Items.f_42485_, Blocks.f_50100_), Map.entry(Items.f_42697_, Blocks.f_50100_), Map.entry(Items.f_42581_, Blocks.f_50287_), Map.entry(Items.f_42579_, Blocks.f_50134_), Map.entry(Items.f_42437_, Blocks.f_50074_), Map.entry(Items.f_42526_, Blocks.f_50287_), Map.entry(Items.f_42527_, Blocks.f_50744_), Map.entry(Items.f_42583_, Blocks.f_50106_), Map.entry(Items.f_42529_, Blocks.f_50291_), Map.entry(Items.f_42528_, Blocks.f_50042_), Map.entry(Items.f_42620_, Blocks.f_50287_), Map.entry(Items.f_42658_, Blocks.f_50108_), Map.entry(Items.f_42732_, Blocks.f_50134_), Map.entry(Items.f_42575_, Blocks.f_50186_), Map.entry(Items.f_42675_, Blocks.f_50374_), Map.entry(Items.f_42591_, Blocks.f_50134_), Map.entry(Items.f_42403_, Blocks.f_50101_), Map.entry(Items.f_42355_, Blocks.f_50099_), Map.entry(Items.f_42402_, Blocks.f_50041_), Map.entry(Items.f_42484_, Blocks.f_50109_), Map.entry(Items.f_42454_, Blocks.f_50741_), Map.entry(Items.f_42525_, Blocks.f_50141_), Map.entry(Items.f_42516_, Blocks.f_50041_), Map.entry(Items.f_42460_, Blocks.f_50076_), Map.entry(Items.f_42532_, Blocks.f_50109_), Map.entry(Items.f_42452_, Blocks.f_50127_), Map.entry(Items.f_42447_, Blocks.f_49990_), Map.entry(Items.f_42448_, Blocks.f_49991_), Map.entry(Items.f_42455_, Blocks.f_50041_), Map.entry(Items.f_42461_, Blocks.f_50129_), Map.entry(Items.f_42533_, Blocks.f_50262_), Map.entry(Items.f_42500_, Blocks.f_50453_), Map.entry(Items.f_42458_, Blocks.f_50299_), Map.entry(Items.f_42456_, Blocks.f_50291_), Map.entry(Items.f_42457_, Blocks.f_50293_), Map.entry(Items.f_42459_, Blocks.f_50288_), Map.entry(Items.f_42501_, Blocks.f_50041_), Map.entry(Items.f_42593_, Blocks.f_50074_), Map.entry(Items.f_42584_, Blocks.f_50656_), Map.entry(Items.f_42686_, Blocks.f_50090_), Map.entry(Items.f_42696_, Blocks.f_50386_), Map.entry(Items.f_42695_, Blocks.f_50377_), Map.entry(Items.f_42649_, Blocks.f_50705_), Map.entry(Items.f_42730_, Blocks.f_50492_), Map.entry(Items.f_42748_, Blocks.f_50456_), Map.entry(Items.f_42715_, Blocks.f_50453_), Map.entry(Items.f_42716_, Blocks.f_50569_), Map.entry(Items.f_42784_, Blocks.f_50720_), Map.entry(Items.f_42656_, Blocks.f_50453_), Map.entry(Items.f_42747_, Blocks.f_50291_), Map.entry(Items.f_42713_, Blocks.f_50377_), Map.entry(Items.f_42586_, Blocks.f_50041_), Map.entry(Items.f_42714_, Blocks.f_50453_), Map.entry(Items.f_42521_, Blocks.f_50453_), Map.entry(Items.f_151052_, Blocks.f_152504_), Map.entry(Items.f_151049_, Blocks.f_152490_));
    }
}

