/*
 * Decompiled with CFR 0.152.
 */
package carpet.logging.logHelpers;

import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import carpet.utils.Messenger;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;

public class TrajectoryLogHelper {
    private static final int MAX_TICKS_PER_LINE = 20;
    private boolean doLog;
    private final Logger logger;
    private final ArrayList<Vec3> positions = new ArrayList();
    private final ArrayList<Vec3> motions = new ArrayList();

    public TrajectoryLogHelper(String logName) {
        this.logger = LoggerRegistry.getLogger(logName);
        this.doLog = this.logger.hasOnlineSubscribers();
    }

    public void onTick(double x, double y, double z, Vec3 velocity) {
        if (!this.doLog) {
            return;
        }
        this.positions.add(new Vec3(x, y, z));
        this.motions.add(velocity);
    }

    public void onFinish() {
        if (!this.doLog) {
            return;
        }
        this.logger.log(option -> {
            ArrayList<Component> comp = new ArrayList<Component>();
            switch (option) {
                case "brief": {
                    comp.add(Messenger.s(""));
                    ArrayList<String> line = new ArrayList<String>();
                    for (int i = 0; i < this.positions.size(); ++i) {
                        Vec3 pos = this.positions.get(i);
                        Vec3 mot = this.motions.get(i);
                        line.add("w  x");
                        line.add(String.format("^w Tick: %d\nx: %f\ny: %f\nz: %f\n------------\nmx: %f\nmy: %f\nmz: %f", i, pos.f_82479_, pos.f_82480_, pos.f_82481_, mot.f_82479_, mot.f_82480_, mot.f_82481_));
                        if ((i + 1) % 20 != 0 && i != this.positions.size() - 1) continue;
                        comp.add(Messenger.c(line.toArray(new Object[0])));
                        line.clear();
                    }
                    break;
                }
                case "full": {
                    comp.add(Messenger.c("w ---------"));
                    for (int i = 0; i < this.positions.size(); ++i) {
                        Vec3 pos = this.positions.get(i);
                        Vec3 mot = this.motions.get(i);
                        comp.add(Messenger.c(String.format("w tick: %3d pos", i), Messenger.dblt("w", pos.f_82479_, pos.f_82480_, pos.f_82481_), "w   mot", Messenger.dblt("w", mot.f_82479_, mot.f_82480_, mot.f_82481_)));
                    }
                    break;
                }
            }
            return comp.toArray(new Component[0]);
        });
        this.doLog = false;
    }
}

