/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.MinecraftServerInterface;
import carpet.helpers.ServerTickRateManager;
import carpet.patches.CopyProfilerResult;
import carpet.utils.CarpetProfiler;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.EmptyProfileResults;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class}, priority=0x7FFFFFF5)
public abstract class MinecraftServer_tickspeedMixin
extends ReentrantBlockableEventLoop<TickTask>
implements MinecraftServerInterface {
    @Shadow
    private volatile boolean f_129764_;
    @Shadow
    private long f_129726_;
    @Shadow
    @Final
    private static Logger f_129750_;
    @Shadow
    private ProfilerFiller f_129754_;
    @Shadow
    private long f_129727_;
    @Shadow
    private volatile boolean f_129717_;
    @Shadow
    private long f_129718_;
    @Shadow
    private boolean f_129728_;
    @Shadow
    private int f_129766_;
    @Shadow
    private boolean f_177877_;
    CarpetProfiler.ProfilerToken currentSection;
    private float carpetMsptAccum = 0.0f;
    private ServerTickRateManager serverTickRateManager;
    Pair<Long, Integer> profilerTimings = null;

    public MinecraftServer_tickspeedMixin(String name) {
        super(name);
    }

    @Shadow
    protected abstract void m_5705_(BooleanSupplier var1);

    @Shadow
    protected abstract boolean m_129960_();

    @Shadow
    public abstract Iterable<ServerLevel> m_129785_();

    @Shadow
    protected abstract void m_130012_();

    @Shadow
    protected abstract void m_177945_();

    @Shadow
    protected abstract void m_177946_();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        this.serverTickRateManager = new ServerTickRateManager((MinecraftServer)this);
    }

    @Override
    public ServerTickRateManager getTickRateManager() {
        return this.serverTickRateManager;
    }

    @Redirect(method={"runServer"}, at=@At(value="FIELD", target="Lnet/minecraft/server/MinecraftServer;running:Z"))
    private boolean cancelRunLoop(MinecraftServer server) {
        return false;
    }

    @Inject(method={"runServer"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/MinecraftServer;buildServerStatus()Lnet/minecraft/network/protocol/status/ServerStatus;")})
    private void modifiedRunLoop(CallbackInfo ci) {
        while (this.f_129764_) {
            if ((long)CarpetProfiler.tick_health_requested != 0L) {
                CarpetProfiler.start_tick_profiling();
            }
            long msThisTick = 0L;
            long long_1 = 0L;
            float mspt = this.serverTickRateManager.mspt();
            if (this.serverTickRateManager.isInWarpSpeed() && this.serverTickRateManager.continueWarp()) {
                this.f_129726_ = this.f_129718_ = Util.m_137550_();
                this.carpetMsptAccum = mspt;
            } else {
                if (Math.abs(this.carpetMsptAccum - mspt) > 1.0f) {
                    this.carpetMsptAccum = mspt;
                }
                msThisTick = (long)this.carpetMsptAccum;
                this.carpetMsptAccum += mspt - (float)msThisTick;
                long_1 = Util.m_137550_() - this.f_129726_;
            }
            if ((float)long_1 > 1000.0f + 20.0f * mspt && (float)(this.f_129726_ - this.f_129718_) >= 10000.0f + 100.0f * mspt) {
                long long_2 = (long)((float)long_1 / mspt);
                f_129750_.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)long_1, (Object)long_2);
                this.f_129726_ += (long)((float)long_2 * mspt);
                this.f_129718_ = this.f_129726_;
            }
            if (this.f_177877_) {
                this.f_177877_ = false;
                this.profilerTimings = Pair.of((Object)Util.m_137569_(), (Object)this.f_129766_);
            }
            this.f_129726_ += msThisTick;
            this.m_177945_();
            this.f_129754_.m_6180_("tick");
            this.m_5705_(this.serverTickRateManager.isInWarpSpeed() ? () -> true : this::m_129960_);
            this.f_129754_.m_6182_("nextTickWait");
            if (this.serverTickRateManager.isInWarpSpeed()) {
                while (this.runEveryTask()) {
                    Thread.yield();
                }
            }
            this.f_129728_ = true;
            this.f_129727_ = Math.max(Util.m_137550_() + msThisTick, this.f_129726_);
            this.m_130012_();
            this.f_129754_.m_7238_();
            this.m_177946_();
            this.f_129717_ = true;
        }
    }

    @Inject(method={"isTimeProfilerRunning"}, at={@At(value="HEAD")}, cancellable=true)
    public void isCMDebugRunning(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(this.f_177877_ || this.profilerTimings != null ? 1 : 0));
    }

    @Inject(method={"stopTimeProfiler"}, at={@At(value="HEAD")}, cancellable=true)
    public void stopCMDebug(CallbackInfoReturnable<ProfileResults> cir) {
        if (this.profilerTimings == null) {
            cir.setReturnValue((Object)EmptyProfileResults.f_18441_);
        } else {
            CopyProfilerResult profileResult = new CopyProfilerResult((Integer)this.profilerTimings.getRight(), (Long)this.profilerTimings.getLeft(), this.f_129766_, Util.m_137569_());
            this.profilerTimings = null;
            cir.setReturnValue((Object)profileResult);
        }
    }

    private boolean runEveryTask() {
        if (super.m_7245_()) {
            return true;
        }
        for (ServerLevel serverlevel : this.m_129785_()) {
            if (!serverlevel.m_7726_().m_8466_()) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"tickServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;saveEverything(ZZZ)Z", shift=At.Shift.BEFORE)})
    private void startAutosave(BooleanSupplier booleanSupplier_1, CallbackInfo ci) {
        this.currentSection = CarpetProfiler.start_section(null, "Autosave", CarpetProfiler.TYPE.GENERAL);
    }

    @Inject(method={"tickServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;saveEverything(ZZZ)Z", shift=At.Shift.AFTER)})
    private void finishAutosave(BooleanSupplier booleanSupplier_1, CallbackInfo ci) {
        CarpetProfiler.end_current_section(this.currentSection);
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getConnection()Lnet/minecraft/server/network/ServerConnectionListener;", shift=At.Shift.BEFORE)})
    private void startNetwork(BooleanSupplier booleanSupplier_1, CallbackInfo ci) {
        this.currentSection = CarpetProfiler.start_section(null, "Network", CarpetProfiler.TYPE.GENERAL);
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;tick()V", shift=At.Shift.AFTER)})
    private void finishNetwork(BooleanSupplier booleanSupplier_1, CallbackInfo ci) {
        CarpetProfiler.end_current_section(this.currentSection);
    }

    @Inject(method={"waitUntilNextTick"}, at={@At(value="HEAD")})
    private void startAsync(CallbackInfo ci) {
        this.currentSection = CarpetProfiler.start_section(null, "Async Tasks", CarpetProfiler.TYPE.GENERAL);
    }

    @Inject(method={"waitUntilNextTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;managedBlock(Ljava/util/function/BooleanSupplier;)V", shift=At.Shift.BEFORE)})
    private void stopAsync(CallbackInfo ci) {
        if ((long)CarpetProfiler.tick_health_requested != 0L) {
            CarpetProfiler.end_current_section(this.currentSection);
            CarpetProfiler.end_tick_profiling((MinecraftServer)this);
        }
    }
}

