/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.EntityInterface;
import carpet.script.CarpetEventServer;
import carpet.script.EntityEventsGroup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Player.class})
public abstract class Player_scarpetEventsMixin
extends LivingEntity {
    protected Player_scarpetEventsMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"actuallyHurt"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F")})
    private void playerTakingDamage(DamageSource source, float amount, CallbackInfo ci) {
        ((EntityInterface)((Object)this)).getEventContainer().onEvent(EntityEventsGroup.Event.ON_DAMAGE, Float.valueOf(amount), source);
        if (CarpetEventServer.Event.PLAYER_TAKES_DAMAGE.isNeeded() && CarpetEventServer.Event.PLAYER_TAKES_DAMAGE.onDamage((Entity)this, amount, source)) {
            ci.cancel();
        }
        if (source.m_7639_() instanceof ServerPlayer && CarpetEventServer.Event.PLAYER_DEALS_DAMAGE.isNeeded() && CarpetEventServer.Event.PLAYER_DEALS_DAMAGE.onDamage((Entity)this, amount, source)) {
            ci.cancel();
        }
    }

    @Inject(method={"touch"}, at={@At(value="HEAD")})
    private void onEntityCollision(Entity entity, CallbackInfo ci) {
        if (CarpetEventServer.Event.PLAYER_COLLIDES_WITH_ENTITY.isNeeded() && !this.m_9236_().f_46443_) {
            CarpetEventServer.Event.PLAYER_COLLIDES_WITH_ENTITY.onEntityHandAction((ServerPlayer)this, entity, null);
        }
    }

    @Inject(method={"interactOn"}, cancellable=true, at={@At(value="HEAD")})
    private void doInteract(Entity entity, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (!this.m_9236_().f_46443_ && CarpetEventServer.Event.PLAYER_INTERACTS_WITH_ENTITY.isNeeded() && CarpetEventServer.Event.PLAYER_INTERACTS_WITH_ENTITY.onEntityHandAction((ServerPlayer)this, entity, hand)) {
            cir.setReturnValue((Object)InteractionResult.PASS);
            cir.cancel();
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAttack(Entity target, CallbackInfo ci) {
        if (!this.m_9236_().f_46443_ && CarpetEventServer.Event.PLAYER_ATTACKS_ENTITY.isNeeded() && target.m_6097_() && CarpetEventServer.Event.PLAYER_ATTACKS_ENTITY.onEntityHandAction((ServerPlayer)this, target, null)) {
            ci.cancel();
        }
    }
}

