/*
 * Decompiled with CFR 0.152.
 */
package carpet.patches;

import carpet.CarpetServer;
import carpet.fakes.MinecraftServerInterface;
import carpet.helpers.ServerTickRateManager;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TickSyncedBorderExtent
implements WorldBorder.BorderExtent {
    private final WorldBorder border;
    private final long realDuration;
    private final double tickDuration;
    private final double from;
    private final double to;
    private int ticks;

    public TickSyncedBorderExtent(WorldBorder border, long realDuration, double from, double to) {
        this.border = border;
        this.realDuration = realDuration;
        this.tickDuration = (double)realDuration / 50.0;
        this.from = from;
        this.to = to;
        this.ticks = 0;
    }

    public double m_6613_() {
        int maxSize = this.border.m_61963_();
        return Mth.m_14008_((double)(this.border.m_6347_() - this.m_6618_() / 2.0), (double)(-maxSize), (double)maxSize);
    }

    public double m_6608_() {
        int maxSize = this.border.m_61963_();
        return Mth.m_14008_((double)(this.border.m_6347_() + this.m_6618_() / 2.0), (double)(-maxSize), (double)maxSize);
    }

    public double m_6606_() {
        int maxSize = this.border.m_61963_();
        return Mth.m_14008_((double)(this.border.m_6345_() - this.m_6618_() / 2.0), (double)(-maxSize), (double)maxSize);
    }

    public double m_6619_() {
        int maxSize = this.border.m_61963_();
        return Mth.m_14008_((double)(this.border.m_6345_() + this.m_6618_() / 2.0), (double)(-maxSize), (double)maxSize);
    }

    public double m_6618_() {
        double progress = (double)this.ticks / this.tickDuration;
        return progress < 1.0 ? Mth.m_14139_((double)progress, (double)this.from, (double)this.to) : this.to;
    }

    public double m_6611_() {
        return Math.abs(this.from - this.to) / (double)this.realDuration;
    }

    public long m_6738_() {
        double ms;
        MinecraftServer server = CarpetServer.minecraft_server;
        if (server == null) {
            ms = 50.0;
        } else {
            ms = Arrays.stream(server.f_129748_).average().orElseThrow(IllegalStateException::new) * 1.0E-6;
            ServerTickRateManager trm = ((MinecraftServerInterface)server).getTickRateManager();
            if (!trm.isInWarpSpeed()) {
                ms = Math.max(ms, (double)trm.mspt());
            }
        }
        double tps = 1000.0 / ms;
        return (long)((this.tickDuration - (double)this.ticks) / tps * 1000.0);
    }

    public double m_6605_() {
        return this.to;
    }

    @NotNull
    public BorderStatus m_5570_() {
        return this.to < this.from ? BorderStatus.SHRINKING : BorderStatus.GROWING;
    }

    public void m_6623_() {
    }

    public void m_6622_() {
    }

    @NotNull
    public WorldBorder.BorderExtent m_5794_() {
        TickSyncedBorderExtent tickSyncedBorderExtent;
        if (this.ticks++ % 20 == 0) {
            for (BorderChangeListener listener : this.border.m_61962_()) {
                if (listener instanceof BorderChangeListener.DelegateBorderChangeListener) continue;
                listener.m_6689_(this.border, this.from, this.to, this.realDuration);
            }
        }
        if ((double)this.ticks >= this.tickDuration) {
            WorldBorder worldBorder = this.border;
            Objects.requireNonNull(worldBorder);
            tickSyncedBorderExtent = new WorldBorder.StaticBorderExtent(worldBorder, this.to);
        } else {
            tickSyncedBorderExtent = this;
        }
        return tickSyncedBorderExtent;
    }

    @NotNull
    public VoxelShape m_6186_() {
        return Shapes.m_83113_((VoxelShape)Shapes.f_83036_, (VoxelShape)Shapes.m_83048_((double)Math.floor(this.m_6613_()), (double)Double.NEGATIVE_INFINITY, (double)Math.floor(this.m_6606_()), (double)Math.ceil(this.m_6608_()), (double)Double.POSITIVE_INFINITY, (double)Math.ceil(this.m_6619_())), (BooleanOp)BooleanOp.f_82685_);
    }
}

