/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.LazyValue;
import carpet.script.ScriptHost;
import carpet.script.ScriptServer;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.ThreadValue;
import carpet.script.value.Value;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Context {
    public static final Type NONE = Type.NONE;
    public static final Type VOID = Type.VOID;
    public static final Type BOOLEAN = Type.BOOLEAN;
    public static final Type NUMBER = Type.NUMBER;
    public static final Type STRING = Type.STRING;
    public static final Type LIST = Type.LIST;
    public static final Type ITERATOR = Type.ITERATOR;
    public static final Type SIGNATURE = Type.SIGNATURE;
    public static final Type LOCALIZATION = Type.LOCALIZATION;
    public static final Type LVALUE = Type.LVALUE;
    public static final Type MAPDEF = Type.MAPDEF;
    public Map<String, LazyValue> variables = new HashMap<String, LazyValue>();
    public final ScriptHost host;
    private ThreadValue threadContext = null;

    public Context(ScriptHost host) {
        this.host = host;
    }

    public LazyValue getVariable(String name) {
        return this.variables.get(name);
    }

    public void setVariable(String name, LazyValue lv) {
        this.variables.put(name, lv);
    }

    public void delVariable(String variable) {
        this.variables.remove(variable);
    }

    public void removeVariablesMatching(String varname) {
        this.variables.entrySet().removeIf(e -> ((String)e.getKey()).startsWith(varname));
    }

    public Context with(String variable, LazyValue lv) {
        this.variables.put(variable, lv);
        return this;
    }

    public Set<String> getAllVariableNames() {
        return this.variables.keySet();
    }

    public Context recreate() {
        Context ctx = this.duplicate();
        ctx.threadContext = this.threadContext;
        ctx.initialize();
        return ctx;
    }

    public void setThreadContext(ThreadValue callingThread) {
        this.threadContext = callingThread;
    }

    public ThreadValue getThreadContext() {
        return this.threadContext;
    }

    protected void initialize() {
        this.variables.put("_", (c, t) -> Value.ZERO);
        this.variables.put("_i", (c, t) -> Value.ZERO);
        this.variables.put("_a", (c, t) -> Value.ZERO);
    }

    public Context duplicate() {
        return new Context(this.host);
    }

    public ScriptHost.ErrorSnooper getErrorSnooper() {
        return this.host.errorSnooper;
    }

    public ScriptServer scriptServer() {
        return this.host.scriptServer();
    }

    public static enum Type {
        NONE,
        VOID,
        BOOLEAN,
        NUMBER,
        STRING,
        LIST,
        ITERATOR,
        SIGNATURE,
        LOCALIZATION,
        LVALUE,
        MAPDEF;

    }

    public static class ContextForErrorReporting
    extends Context {
        public ScriptHost.ErrorSnooper optmizerEerrorSnooper;

        public ContextForErrorReporting(Context parent) {
            super(null);
            this.optmizerEerrorSnooper = parent.host.errorSnooper;
        }

        @Override
        public ScriptHost.ErrorSnooper getErrorSnooper() {
            return this.optmizerEerrorSnooper;
        }

        public void badProgrammer() {
            throw new InternalExpressionException("Attempting to access the execution context while optimizing the code; This is not the problem with your code, but the error cause by improper use of code compile optimizationsof scarpet authors. Please report this issue directly to the scarpet issue tracker");
        }

        @Override
        public LazyValue getVariable(String name) {
            this.badProgrammer();
            return null;
        }

        @Override
        public void setVariable(String name, LazyValue lv) {
            this.badProgrammer();
        }

        @Override
        public void delVariable(String variable) {
            this.badProgrammer();
        }

        @Override
        public void removeVariablesMatching(String varname) {
            this.badProgrammer();
        }

        @Override
        public Context with(String variable, LazyValue lv) {
            this.badProgrammer();
            return this;
        }

        @Override
        public Set<String> getAllVariableNames() {
            this.badProgrammer();
            return null;
        }

        @Override
        public Context recreate() {
            this.badProgrammer();
            return null;
        }

        @Override
        protected void initialize() {
            this.badProgrammer();
        }

        @Override
        public Context duplicate() {
            this.badProgrammer();
            return null;
        }
    }
}

